/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.workbench.card;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.AuditBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.BrewBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ExamineBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.IssueBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.bussiness.application.service.PublicityBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ReleaseBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ReviewBillApplicationService;
import kd.tdc.cadm.bussiness.domain.appointaudit.enums.AppointAuditStatusEnum;
import kd.tdc.cadm.bussiness.domain.brew.enums.BrewStatusEnum;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamineStatusEnum;
import kd.tdc.cadm.bussiness.domain.issue.enums.IssueStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.publicity.enums.PublicityStatusEnum;
import kd.tdc.cadm.bussiness.domain.release.enums.ReleaseStatusEnum;
import kd.tdc.cadm.bussiness.domain.review.enmus.ReviewStatusEnum;
import kd.tdc.cadm.bussiness.util.DateUtil;
import kd.tdc.cadm.common.enums.PositionTypeEnum;
import kd.tdc.cadm.formplugin.web.workbench.pojo.TodoCard;

public class TodoList
extends HRDynamicFormBasePlugin
implements HyperLinkClickListener {
    private static final Log LOG = LogFactory.getLog(TodoList.class);
    private static final BrewBillApplicationService brewBillApplicationService = (BrewBillApplicationService)ServiceFactory.getService(BrewBillApplicationService.class);
    private static final NominateApplicationService nominateApplicationService = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);
    private static final AuditBillApplicationService auditBillApplicationService = (AuditBillApplicationService)ServiceFactory.getService(AuditBillApplicationService.class);
    private static final ExamineBillApplicationService examineBillApplicationService = (ExamineBillApplicationService)ServiceFactory.getService(ExamineBillApplicationService.class);
    private static final ReviewBillApplicationService reviewBillApplicationService = (ReviewBillApplicationService)ServiceFactory.getService(ReviewBillApplicationService.class);
    private static final PublicityBillApplicationService publicityBillApplicationService = (PublicityBillApplicationService)ServiceFactory.getService(PublicityBillApplicationService.class);
    private static final IssueBillApplicationService issueBillApplicationService = (IssueBillApplicationService)ServiceFactory.getService(IssueBillApplicationService.class);
    private static final ReleaseBillApplicationService releaseBillApplicationService = (ReleaseBillApplicationService)ServiceFactory.getService(ReleaseBillApplicationService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadData();
    }

    private void loadData() {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        List<TodoCard> needNominateData = this.getNeedNominateData();
        DynamicObject[] auditArr = auditBillApplicationService.queryByPermission("id,person.name,handler.fbasedataid_id,createtime,deadline", currentUserId, Collections.singletonList(AppointAuditStatusEnum.TO_BE_AUDIT.getNumber()), "4715a0df000000ac");
        DynamicObject[] examArr = examineBillApplicationService.queryByPermission("id,person.name,handler.fbasedataid_id,createtime,deadline", currentUserId, Arrays.asList(ExamineStatusEnum.TO_BE_EXAMINE.getNumber(), ExamineStatusEnum.IN_EXAMINE.getNumber()), "4715a0df000000ac");
        DynamicObject[] reviewArr = reviewBillApplicationService.queryByPermission("id,person.name,handler.fbasedataid_id,createtime,deadline", currentUserId, Arrays.asList(ReviewStatusEnum.BE_REVIEW.getReviewStatus(), ReviewStatusEnum.IN_REVIEW.getReviewStatus()), "4715a0df000000ac");
        DynamicObject[] pubArr = publicityBillApplicationService.queryByPermission("id,person.name,handler.fbasedataid_id,createtime,deadline", currentUserId, Arrays.asList(PublicityStatusEnum.BE_PUBLIC.getPubStatus(), PublicityStatusEnum.RE_PUBLICIZED.getPubStatus(), PublicityStatusEnum.BE_EFFECTIVE.getPubStatus(), PublicityStatusEnum.IN_PUBLIC.getPubStatus(), PublicityStatusEnum.BE_SUBMIT.getPubStatus()), "4715a0df000000ac");
        DynamicObject[] issueArr = issueBillApplicationService.queryByPermission("id,person.name,handler.fbasedataid_id,createtime,deadline", currentUserId, Collections.singletonList(IssueStatusEnum.TOBE_ISSUE.getNumber()), "4715a0df000000ac");
        DynamicObject[] releaseArr = releaseBillApplicationService.queryByPermission("id,person.name,handler.fbasedataid_id,createtime,deadline", currentUserId, Arrays.asList(ReleaseStatusEnum.BE_RELEASE.getNum(), ReleaseStatusEnum.RE_PUBLICIZED.getNum(), ReleaseStatusEnum.BE_EFFECTIVE.getNum()), "4715a0df000000ac");
        Arrays.stream(auditArr);
        ArrayList<TodoCard> list = new ArrayList<TodoCard>();
        list.addAll(needNominateData);
        Arrays.stream(auditArr).forEach(p -> list.add(new TodoCard(p.getLong("id"), p.getString("person.name"), "cadm_appointaudit", ResManager.loadKDString((String)"\u8d44\u683c\u5ba1\u67e5", (String)"WorkBench_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), p.getDate("createtime"), p.getDate("deadline"))));
        Arrays.stream(examArr).forEach(p -> list.add(new TodoCard(p.getLong("id"), p.getString("person.name"), "cadm_examinebill", ResManager.loadKDString((String)"\u8003\u5bdf\u8bb0\u5f55", (String)"WorkBench_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), p.getDate("createtime"), p.getDate("deadline"))));
        Arrays.stream(reviewArr).forEach(p -> list.add(new TodoCard(p.getLong("id"), p.getString("person.name"), "cadm_reviewbill", ResManager.loadKDString((String)"\u8bc4\u8bae\u8bb0\u5f55", (String)"WorkBench_7", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), p.getDate("createtime"), p.getDate("deadline"))));
        Arrays.stream(pubArr).forEach(p -> list.add(new TodoCard(p.getLong("id"), p.getString("person.name"), "cadm_publicity", ResManager.loadKDString((String)"\u516c\u793a", (String)"WorkBench_8", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), p.getDate("createtime"), p.getDate("deadline"))));
        Arrays.stream(issueArr).forEach(p -> list.add(new TodoCard(p.getLong("id"), p.getString("person.name"), "cadm_appointissue", ResManager.loadKDString((String)"\u7b7e\u53d1", (String)"WorkBench_9", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), p.getDate("createtime"), p.getDate("deadline"))));
        Arrays.stream(releaseArr).forEach(p -> list.add(new TodoCard(p.getLong("id"), p.getString("person.name"), "cadm_appointrelease", ResManager.loadKDString((String)"\u53d1\u5e03", (String)"WorkBench_10", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), p.getDate("createtime"), p.getDate("deadline"))));
        List sortedList = list.stream().sorted(Comparator.comparing(TodoCard::getLatestFinishTime, Comparator.nullsFirst(Date::compareTo)).thenComparing(TodoCard::getCreateTime, Comparator.nullsFirst(Date::compareTo)).reversed()).collect(Collectors.toList());
        this.getView().setVisible(Boolean.TRUE, new String[]{"datapanel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"defaultpanel"});
        this.getModel().deleteEntryData("entryentity");
        this.getModel().setValue("size", (Object)("\uff08" + sortedList.size() + "\uff09"));
        if (sortedList.size() > 0) {
            int[] indexArr = this.getModel().batchCreateNewEntryRow("entryentity", sortedList.size());
            CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
            for (int i = 0; i < indexArr.length; ++i) {
                TodoCard todoCard = (TodoCard)sortedList.get(i);
                String activityId = todoCard.getActivityId();
                String activityName = todoCard.getActivityName();
                String title = "cadm_nominatebill".equals(activityId) ? ResManager.loadKDString((String)"\u8bf7\u5904\u7406\u201c{0}\u201d\u7684\u201c{1}\u201d\u4efb\u52a1", (String)"WorkBench_11", (String)"tdc-cadm-formplugin", (Object[])new Object[]{todoCard.getUsername(), activityName}) : ResManager.loadKDString((String)"\u8bf7\u5904\u7406\u201c{0}\u201d\u7684\u201c{1}\u201d\u6d3b\u52a8\u4efb\u52a1", (String)"WorkBench_12", (String)"tdc-cadm-formplugin", (Object[])new Object[]{todoCard.getUsername(), activityName});
                this.getModel().setValue("billid", (Object)todoCard.getBillId(), indexArr[i]);
                this.getModel().setValue("depempid", (Object)todoCard.getDepempId(), indexArr[i]);
                this.getModel().setValue("activityid", (Object)activityId, indexArr[i]);
                this.getModel().setValue("activitytitle", (Object)title, indexArr[i]);
                this.getModel().setValue("createtime", (Object)todoCard.getCreateTime(), indexArr[i]);
                Date latestFinishTime = todoCard.getLatestFinishTime();
                this.getModel().setValue("lasttime", (Object)latestFinishTime, indexArr[i]);
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"duetoday"});
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"overdue"});
                if (latestFinishTime != null) {
                    long timeSpan = latestFinishTime.getTime() - System.currentTimeMillis();
                    if (timeSpan < 0L) {
                        cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), i, new String[]{"overdue"});
                        cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"duetoday"});
                    }
                    if (!DateUtil.isToday((Date)latestFinishTime) || timeSpan < 0L) continue;
                    cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), i, new String[]{"duetoday"});
                    cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"overdue"});
                    continue;
                }
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"deadlinepanel"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"datapanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"defaultpanel"});
        }
        this.getView().updateView("entryentity");
        this.getModel().setDataChanged(false);
    }

    private List<TodoCard> getNeedNominateData() {
        ArrayList<TodoCard> list = new ArrayList<TodoCard>(10);
        long currentUserId = UserServiceHelper.getCurrentUserId();
        boolean hasNominatePerm = PermissionServiceHelper.checkPermission((Long)currentUserId, (String)"cadm", (String)"cadm_nominatebill", (String)"4715a0df000000ac");
        if (!hasNominatePerm) {
            return list;
        }
        DynamicObject[] brewArr = brewBillApplicationService.queryBrewByStatus("id", Collections.singletonList(BrewStatusEnum.BREWOVER.getNumber()));
        List brewIds = Arrays.stream(brewArr).map(p -> p.getLong("id")).collect(Collectors.toList());
        DynamicObject[] candidateArr = brewBillApplicationService.queryBrewCandidateByBrewIds("depemp,nomhandler,brewbillid,person", brewIds);
        List ownBrewCandidateArr = Arrays.stream(candidateArr).filter(p -> p.getLong("nomhandler_id") == currentUserId).filter(p -> p.get("brewbillid_id") != null && p.getDynamicObject("depemp") != null).collect(Collectors.toList());
        HashMap<Long, ArrayList<DynamicObject>> candidateMap = new HashMap<Long, ArrayList<DynamicObject>>(16);
        for (DynamicObject candidate : ownBrewCandidateArr) {
            long brewBillId = candidate.getLong("brewbillid_id");
            DynamicObject depemp = candidate.getDynamicObject("depemp");
            ArrayList<DynamicObject> candidateList = (ArrayList<DynamicObject>)candidateMap.get(brewBillId);
            if (CollectionUtils.isEmpty((Collection)candidateList)) {
                candidateList = new ArrayList<DynamicObject>();
            }
            candidateList.add(depemp);
            candidateMap.put(brewBillId, candidateList);
        }
        DynamicObject[] nominateArr = nominateApplicationService.queryNominateByPermission("person_id", currentUserId, Arrays.asList(AppointStatusEnum.WAIT_APPOINT.getVal(), AppointStatusEnum.ING_APPOINT.getVal()), "4715a0df000000ac");
        List nominatingPersonIds = Arrays.stream(nominateArr).map(p -> p.getLong("person_id")).collect(Collectors.toList());
        List noNominateBrewIds = ownBrewCandidateArr.stream().filter(p -> !nominatingPersonIds.contains(p.getLong("person_id"))).collect(Collectors.toList()).stream().map(p -> p.getLong("brewbillid_id")).collect(Collectors.toList());
        DynamicObject[] needNominateBrewData = brewBillApplicationService.queryByIds("id,brewdate,depemp,positiontype,brewstandardposition,brewjob,brewposition", noNominateBrewIds);
        List needNominateBrewIds = Arrays.stream(needNominateBrewData).map(p -> p.getLong("id")).collect(Collectors.toList());
        Map terminationDepempMap = nominateApplicationService.queryTerminationDepemp(needNominateBrewIds);
        for (DynamicObject brewBill : needNominateBrewData) {
            Long brewId = brewBill.getLong("id");
            String positionType = brewBill.getString("positiontype");
            long brewObjId = 0L;
            String brewObjName = "";
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                brewObjId = brewBill.getLong("brewposition.id");
                brewObjName = "brewposition";
            } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                brewObjId = HRDyObjectPropUtil.getId((DynamicObject)brewBill.getDynamicObject("brewjob"));
                brewObjName = "brewjob";
            } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                brewObjId = HRDyObjectPropUtil.getId((DynamicObject)brewBill.getDynamicObject("brewstandardposition"));
                brewObjName = "brewstandardposition";
            }
            Date brewDate = brewBill.getDate("brewdate");
            List candidateList = (List)candidateMap.get(brewId);
            candidateList = candidateList.stream().filter(p -> !nominatingPersonIds.contains(p.getLong("person_id"))).collect(Collectors.toList());
            for (DynamicObject candidate : candidateList) {
                List terminationDepempIds;
                long candidateId = 0L;
                String candidateName = "";
                if (candidate != null) {
                    candidateId = candidate.getLong("id");
                    candidateName = candidate.getString("person.name");
                }
                if ((terminationDepempIds = (List)terminationDepempMap.get(brewId)) != null && terminationDepempIds.contains(candidateId)) continue;
                HashMap<String, Object> customParams = new HashMap<String, Object>(4);
                customParams.put("positionType", positionType);
                customParams.put("brewObjId", brewObjId);
                customParams.put("brewObjName", brewObjName);
                customParams.put("candidateId", candidateId);
                String value = SerializationUtils.serializeToBase64(customParams);
                this.getPageCache().put("brew-candidateId:" + brewId + "-" + candidateId, value);
                TodoCard todoCard = new TodoCard();
                todoCard.setDepempId(candidateId);
                todoCard.setActivityId("cadm_nominatebill");
                todoCard.setActivityName(ResManager.loadKDString((String)"\u4efb\u547d\u63d0\u540d", (String)"WorkBench_13", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                todoCard.setBillId(brewId);
                todoCard.setUsername(candidateName);
                todoCard.setCreateTime(brewDate);
                todoCard.setLatestFinishTime(null);
                list.add(todoCard);
            }
        }
        return list;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("activitytitle".equals(fieldName)) {
            DynamicObject entryRow = this.getModel().getEntryRowEntity("entryentity", evt.getRowIndex());
            BillShowParameter billShowParameter = new BillShowParameter();
            String activityId = entryRow.getString("activityid");
            billShowParameter.setFormId(activityId);
            long billId = entryRow.getLong("billid");
            if ("cadm_nominatebill".equals(activityId)) {
                long depempid = entryRow.getLong("depempid");
                String value = this.getPageCache().get("brew-candidateId:" + billId + "-" + depempid);
                if (StringUtils.isNotEmpty((String)value)) {
                    Map customParams = (Map)SerializationUtils.deSerializeFromBase64((String)value);
                    Long brewObjId = (Long)customParams.get("brewObjId");
                    String positionType = (String)customParams.get("positionType");
                    String brewObjName = (String)customParams.get("brewObjName");
                    Long candidateId = (Long)customParams.get("candidateId");
                    customParams.put("depemp", String.valueOf(candidateId));
                    customParams.put("positiontype", positionType);
                    customParams.put(brewObjName, String.valueOf(brewObjId));
                    customParams.put("cadm_brewbill", String.valueOf(billId));
                    billShowParameter.setCustomParams(customParams);
                }
            } else {
                billShowParameter.setPkId((Object)billId);
                billShowParameter.setStatus(OperationStatus.EDIT);
            }
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "aaa"));
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }
}

