/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;

public class ServiceFactory {
    private static final Map<String, String> SERVICE_MAP = new HashMap<String, String>(16);

    public static <T> T getService(Class<T> clazz) {
        String className = clazz.getName();
        try {
            Class<?> clz = Class.forName(className);
            return (T)clz.newInstance();
        }
        catch (Exception exp) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"tdc-cadm-business", (Object[])new Object[0]), clazz.getSimpleName()), exp);
        }
    }

    public static Object getService(String serviceName) {
        String className = SERVICE_MAP.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"tdc-cadm-business", (Object[])new Object[0]), serviceName));
        }
        try {
            Class<?> clz = Class.forName(className);
            return clz.newInstance();
        }
        catch (Exception exp) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"tdc-cadm-business", (Object[])new Object[0]), serviceName), exp);
        }
    }

    static {
        SERVICE_MAP.put("cadm_examinebill", "kd.tdc.cadm.bussiness.domain.examine.service.ExamineBillDomainService");
        SERVICE_MAP.put("cadm_publicity", "kd.tdc.cadm.bussiness.domain.publicity.service.PublicityBillDomainService");
        SERVICE_MAP.put("cadm_appointrelease", "kd.tdc.cadm.bussiness.domain.release.service.ReleaseBillDomainService");
        SERVICE_MAP.put("cadm_reviewbill", "kd.tdc.cadm.bussiness.domain.review.service.ReviewBillDomainService");
        SERVICE_MAP.put("cadm_appointaudit", "kd.tdc.cadm.bussiness.domain.appointaudit.service.AppointAuditDomainService");
        SERVICE_MAP.put("cadm_appointissue", "kd.tdc.cadm.bussiness.domain.issue.service.IssueBillDomainService");
        SERVICE_MAP.put("cadm_brewbill", "kd.tdc.cadm.bussiness.domain.brew.service.BrewBillDomainService");
        SERVICE_MAP.put("cadm_nominatebill", "kd.tdc.cadm.bussiness.application.service.NominateApplicationService");
    }
}

