/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.actv;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;

public class ActivityConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(ActivityConsumer.class);
    private static final NominateApplicationService nominateApplicationService = ServiceFactory.getService(NominateApplicationService.class);
    private static final ActvGenerateExtService ACTV_SERVICE = ServiceFactory.getService(ActvGenerateExtService.class);
    private static final String ACTIVITY_ID = "activityId";
    private static final String INSTANCE_ID = "instanceId";
    private static final String BIZ_BILL_ID = "bizBillId";
    private static final String BIND_BIZ_KEY = "bindBizKey";

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker messageAcker) {
        logger.info(MessageFormat.format("ActivityConsumer.onMessage---start---message:{0}", message));
        Map messageObj = HRJSONUtils.convertJSONObjectToMap((Object)message);
        Long activityId = HRJSONUtils.getLongValOfCustomParam(messageObj.get(ACTIVITY_ID));
        Long instanceId = HRJSONUtils.getLongValOfCustomParam(messageObj.get(INSTANCE_ID));
        Long bizBillId = HRJSONUtils.getLongValOfCustomParam(messageObj.get(BIZ_BILL_ID));
        String bindBizKey = String.valueOf(messageObj.get(BIND_BIZ_KEY));
        Object bindBizId = null;
        List approverIds = WorkflowServiceHelper.getApproverByBusinessKey((String)String.valueOf(bizBillId));
        if (approverIds.isEmpty()) {
            logger.info("approverIds is empty, deny message {}", (Object)messageId);
            messageAcker.deny(messageId);
            return;
        }
        logger.info("trigger activity, form {}, activityId {}, instanceId {}", new Object[]{bindBizKey, activityId, instanceId});
        logger.info("ActivityConsumer onMessage lang:{}", (Object)RequestContext.get().getLang().getLangTag());
        DynamicObject bill = nominateApplicationService.triggerActivity(bizBillId, activityId, bindBizKey, instanceId, approverIds);
        if (HRObjectUtils.isEmpty((Object)bill)) {
            messageAcker.deny(messageId);
            return;
        }
        long billId = bill.getLong("id");
        logger.info("updateTaskBindBillInfo, instanceId {}, billId {}", (Object)instanceId, (Object)billId);
        ACTV_SERVICE.updateTaskBindBillInfo(instanceId, billId, " ");
        logger.info(MessageFormat.format("cadm ActivityConsumer.onMessage---end---bindBizId:{0}", bindBizId));
        messageAcker.ack(messageId);
    }
}

