/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.actv;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public class ActvGenerateExtService {
    private static final Log logger = LogFactory.getLog(ActvGenerateExtService.class);

    public Map<String, Object> getActivitySchemeMapFromWorkflow(DynamicObject bill) {
        logger.info("call hrcs getActivitySchemeFromWorkflow\uff0c bill: {}", (Object)bill);
        Map resultMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"getActivitySchemeFromWorkflow", (Object[])new Object[]{bill, "id,actschemeentry.activity,actinfo.actbizobj,actinfo.sla"});
        logger.info("getActivitySchemeByNumberAndVersion result, {}", (Object)resultMap);
        return resultMap;
    }

    public DynamicObject getActivitySchemeFromWorkflow(DynamicObject bill) {
        Map<String, Object> resultMap = this.getActivitySchemeMapFromWorkflow(bill);
        boolean success = (Boolean)resultMap.get("success");
        if (!success) {
            return null;
        }
        return (DynamicObject)resultMap.get("data");
    }

    public void batchTerminateTask(List<Long> taskIds, String msg) {
        logger.info("call hrcs getActivitySchemeByID\uff0c taskIds: {}\uff0c msg: {}", taskIds, (Object)msg);
        OperationResult result = (OperationResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"batchTerminateTask", (Object[])new Object[]{taskIds, msg});
        logger.info("batchTerminateTask, result: {}", (Object)result.isSuccess());
    }

    public void updateTaskBindBillInfo(Long taskId, Long bindBizBillId, String bindBizNum) {
        logger.info("call hrcs updateTaskBindBillInfo\uff0c taskId: {}\uff0c bindBizBillId: {}, bindBizNum: {}", new Object[]{taskId, bindBizBillId, bindBizNum});
        HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"updateTaskBindBillInfo", (Object[])new Object[]{taskId, bindBizBillId, bindBizNum});
    }

    public void batchRejectTask(List<Long> taskIds, String msg) {
        logger.info("call hrcs batchRejectTask, taskIds: {}, msg: {}", taskIds, (Object)msg);
        long startTime = System.currentTimeMillis();
        OperationResult result = (OperationResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"batchRejectTask", (Object[])new Object[]{taskIds, msg});
        logger.info("batchRejectTask result: {},costTime============:{}", (Object)result.isSuccess(), (Object)(System.currentTimeMillis() - startTime));
    }

    public void batchConsentTask(List<Long> taskIds, String msg) {
        logger.info("call hrcs batchConsentTask, taskIds: {}, msg: {}", taskIds, (Object)msg);
        OperationResult result = (OperationResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"batchConsentTask", (Object[])new Object[]{taskIds, msg});
        logger.info("batchConsentTask result: {}", (Object)result.isSuccess());
    }

    public Map<String, String> getActivitySchemeDomainParams(long activitySchemeId, long activityId) {
        logger.info("call hrcs getActivitySchemeDomainParams, activitySchemeId: {}, activityId: {}", (Object)activitySchemeId, (Object)activityId);
        List result = (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"getActivitySchemeDomainParams", (Object[])new Object[]{activitySchemeId, activityId});
        logger.info("batchConsentTask result: {}", (Object)result);
        Map<String, String> scenePolicyMap = result.stream().collect(Collectors.toMap(item -> item.getString("paramnumber"), item -> item.getString("paramvalue")));
        return scenePolicyMap;
    }

    public DynamicObject[] getActivityByAppointBillId(long appointBillId) {
        logger.info("call hrcs getActivityInsByBizBillId, BizBillId: {}", (Object)appointBillId);
        DynamicObject[] activityInstances = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"getActivityInsByBizBillId", (Object[])new Object[]{"", String.valueOf(appointBillId)});
        logger.info("getActivityInsByBizBillId result.size: {}", (Object)activityInstances.length);
        return activityInstances;
    }
}

