/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.external;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ReleaseBillApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyKindEnum;
import kd.tdc.cadm.common.enums.PositionTypeEnum;

public class AppointRecordService {
    private static final Log LOG = LogFactory.getLog(AppointRecordService.class);
    private static final HRBaseServiceHelper APPOINT_RECORD_HELPER = new HRBaseServiceHelper("tdcs_appointrecord");
    private static final HRBaseServiceHelper RELATIONAL_SERVICE = new HRBaseServiceHelper("tdcs_relational");
    private static final ReleaseBillApplicationService releaseBillApplicationService = ServiceFactory.getService(ReleaseBillApplicationService.class);

    public void maintainAppointRecord(DynamicObject nominateBill) {
        if (ApplyKindEnum.APPOINT.getNumber().equals(nominateBill.getString("applykind"))) {
            this.invalidAppointRecord(nominateBill);
            this.saveAppointRecord(nominateBill);
        } else {
            this.invalidAppointRecord(nominateBill);
        }
    }

    private void saveAppointRecord(DynamicObject nominateBill) {
        long employeeId = nominateBill.getLong("employee.id");
        long nominateBillId = nominateBill.getLong("id");
        DynamicObject emptyRecord = APPOINT_RECORD_HELPER.generateEmptyDynamicObject();
        emptyRecord.set("person", (Object)nominateBill.getLong("person.id"));
        emptyRecord.set("employee", (Object)employeeId);
        emptyRecord.set("company", (Object)HRDyObjectPropUtil.getId((DynamicObject)nominateBill.getDynamicObject("acompany")));
        emptyRecord.set("adminorg", (Object)HRDyObjectPropUtil.getId((DynamicObject)nominateBill.getDynamicObject("aadminorg")));
        emptyRecord.set("position", (Object)HRDyObjectPropUtil.getId((DynamicObject)nominateBill.getDynamicObject("aposition")));
        emptyRecord.set("job", (Object)HRDyObjectPropUtil.getId((DynamicObject)nominateBill.getDynamicObject("ajob")));
        emptyRecord.set("standardposition", (Object)HRDyObjectPropUtil.getId((DynamicObject)nominateBill.getDynamicObject("astandardposition")));
        emptyRecord.set("positiontype", (Object)nominateBill.getString("positiontype"));
        emptyRecord.set("appointdate", (Object)nominateBill.getDate("appointdate"));
        emptyRecord.set("appointtype", (Object)this.getDynObjField(nominateBill, "appointtype", "id"));
        emptyRecord.set("appointreason", (Object)nominateBill.getString("appointreason"));
        emptyRecord.set("isprimappoint", (Object)nominateBill.getBoolean("isprimappoint"));
        emptyRecord.set("appointid", (Object)nominateBillId);
        emptyRecord.set("prepositivedate", (Object)nominateBill.getDate("prepositivedate"));
        emptyRecord.set("cadrecat", nominateBill.get("cadrecat"));
        emptyRecord.set("planenddate", (Object)nominateBill.getDate("planenddate"));
        emptyRecord.set("creator", (Object)RequestContext.get().getCurrUserId());
        emptyRecord.set("createtime", (Object)new Date());
        emptyRecord.set("bizstatus", (Object)"1");
        emptyRecord.set("apptreasongroup", (Object)nominateBill.getDynamicObject("apptreasongroup"));
        emptyRecord.set("apostype", (Object)nominateBill.getDynamicObject("apostype"));
        emptyRecord.set("empposrel", (Object)nominateBill.getDynamicObject("empposrel"));
        APPOINT_RECORD_HELPER.save(new DynamicObject[]{emptyRecord});
        LOG.info("maintainAppointRecord#saveAppointRecord#success , billNo:{}", (Object)nominateBill.getString("billno"));
    }

    private void invalidAppointRecord(DynamicObject nominateBill) {
        String billNo = nominateBill.getString("billno");
        DynamicObject[] appointRecords = this.queryEffectiveAppointRecordByEmployee(nominateBill.getLong("employee.id"));
        if (appointRecords == null || appointRecords.length == 0) {
            LOG.info("maintainAppointRecord#invalidAppointRecord#queryEffectiveAppointRecordByEmployee result is empty, billNo:{}", (Object)billNo);
            return;
        }
        DynamicObject dPosition = nominateBill.getDynamicObject("dposition");
        DynamicObject dJob = nominateBill.getDynamicObject("djob");
        DynamicObject dStandardPosition = nominateBill.getDynamicObject("dstandardposition");
        if (dPosition == null && dJob == null && dStandardPosition == null) {
            LOG.info("maintainAppointRecord#invalidAppointRecord#dPosition,dJob,dStandardPosition is null, billNo:{}", (Object)billNo);
            return;
        }
        Date modifyTime = new Date();
        long dPositionBoId = 0L;
        if (null != dPosition) {
            dPositionBoId = dPosition.getLong("boid");
        }
        long dJobBoId = 0L;
        if (null != dJob) {
            dJobBoId = dJob.getLong("boid");
        }
        long dStandardPositionBoId = 0L;
        if (null != dStandardPosition) {
            dStandardPositionBoId = dStandardPosition.getLong("boid");
        }
        String nominatePositionType = "";
        DynamicObject dismissTenure = nominateBill.getDynamicObject("dismisstenure");
        if (dismissTenure != null) {
            nominatePositionType = dismissTenure.getString("apositiontype");
        }
        for (DynamicObject appointRecord : appointRecords) {
            DynamicObject standardPosition;
            DynamicObject job;
            DynamicObject position;
            String positionType = appointRecord.getString("positiontype");
            if (HRStringUtils.isEmpty((String)positionType)) {
                positionType = PositionTypeEnum.POSITION.getNumber();
            }
            if (HRStringUtils.isEmpty((String)nominatePositionType) || !nominatePositionType.equals(positionType)) continue;
            if (dPositionBoId != 0L && PositionTypeEnum.POSITION.getNumber().equals(positionType) && (position = appointRecord.getDynamicObject("position")) != null && dPositionBoId == position.getLong("boid")) {
                this.invalidAppointRecord(appointRecord, nominateBill, modifyTime, billNo);
                return;
            }
            if (dJobBoId != 0L && PositionTypeEnum.JOB.getNumber().equals(positionType) && null != (job = appointRecord.getDynamicObject("job")) && dJobBoId == job.getLong("boid")) {
                this.invalidAppointRecord(appointRecord, nominateBill, modifyTime, billNo);
                return;
            }
            if (dStandardPositionBoId == 0L || !PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType) || (standardPosition = appointRecord.getDynamicObject("standardposition")) == null || dStandardPositionBoId != standardPosition.getLong("boid")) continue;
            this.invalidAppointRecord(appointRecord, nominateBill, modifyTime, billNo);
            return;
        }
    }

    private void invalidAppointRecord(DynamicObject appointRecord, DynamicObject nominateBill, Date modifyTime, String billNo) {
        appointRecord.set("bizstatus", (Object)"0");
        long nominateBillId = nominateBill.getLong("id");
        appointRecord.set("dismissbillid", (Object)nominateBillId);
        appointRecord.set("modifier", (Object)RequestContext.get().getCurrUserId());
        appointRecord.set("modifytime", (Object)modifyTime);
        appointRecord.set("dismissreasongroup", (Object)nominateBill.getDynamicObject("apptreasongroup"));
        appointRecord.set("dismissreason", (Object)nominateBill.getString("appointreason"));
        appointRecord.set("dismisstype", (Object)nominateBill.getDynamicObject("appointtype"));
        appointRecord.set("dpostype", (Object)nominateBill.getDynamicObject("dpostype"));
        APPOINT_RECORD_HELPER.updateDataOne(appointRecord);
        LOG.info("maintainAppointRecord#invalidAppointRecord#invalid appointRecord(id:{},dismissBillId:{}), billNo:{}", new Object[]{appointRecord.getLong("id"), nominateBillId, billNo});
    }

    private DynamicObject[] queryEffectiveAppointRecordByEmployee(long employeeId) {
        QFilter employeeFilter = new QFilter("employee", "=", (Object)employeeId);
        QFilter bizStatusFilter = new QFilter("bizstatus", "=", (Object)"1");
        return APPOINT_RECORD_HELPER.query("employee,bizstatus,dismissbillid,position,modifier,modifytime,positiontype,job,standardposition,dismissreasongroup,person,adminorg,appointtype,cadrecat_id,appointreason,isprimappoint,apptreasongroup_id,apostype,dismisstype,dismissreason,dpostype", new QFilter[]{employeeFilter, bizStatusFilter});
    }

    public DynamicObject[] queryEffectiveAppointRecordByEmployee(List<Long> employeeList) {
        QFilter employeeFilter = new QFilter("employee", "in", employeeList);
        QFilter bizStatusFilter = new QFilter("bizstatus", "=", (Object)"1");
        return APPOINT_RECORD_HELPER.query("person,company,employee,position,appointdate,planenddate,appointid,prepositivedate,cadrecat,positiontype,job,standardposition,createtime", new QFilter[]{employeeFilter, bizStatusFilter});
    }

    private long getDynObjField(DynamicObject dynObj, String fieldKey, String mapKey) {
        return Optional.ofNullable(dynObj.getDynamicObject(fieldKey)).map(item -> item.getLong(mapKey)).orElse(0L);
    }

    public DynamicObject[] getDataForPersonResumeEntry(String pageCode, QFilter[] qFilters, String orderBy) {
        if (pageCode.equals("tdcs_appointrecord")) {
            return APPOINT_RECORD_HELPER.query(qFilters, orderBy);
        }
        return new DynamicObject[0];
    }

    public DynamicObject getTenureInfoByAppointId(long appointId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("appointid", "=", (Object)appointId)};
        String selectField = "appointdate,planenddate";
        return APPOINT_RECORD_HELPER.queryOne(selectField, qFilters);
    }

    public void save(DynamicObject[] toArray) {
        APPOINT_RECORD_HELPER.save(toArray);
    }

    public DynamicObject[] queryRelationByEmpPosIds(List<Object> empPosIds) {
        return RELATIONAL_SERVICE.query("id,empposrel,ispull,pulltime", new QFilter[]{new QFilter("empposrel", "in", empPosIds), new QFilter("ispull", "=", (Object)Boolean.FALSE)});
    }

    public void updateRelation(DynamicObject[] relations) {
        RELATIONAL_SERVICE.save(relations);
    }

    public DynamicObject queryAppointRecordByDismissId(String selectProperties, long dismissBillId) {
        QFilter bizStatusFilter = new QFilter("bizstatus", "=", (Object)"0");
        QFilter dismissBillIdFilter = new QFilter("dismissbillid", "=", (Object)dismissBillId);
        return APPOINT_RECORD_HELPER.queryOne(selectProperties, new QFilter[]{bizStatusFilter, dismissBillIdFilter});
    }

    public DynamicObject queryAppointRecordByAppointId(String selectProperties, long nominateBillId) {
        QFilter bizStatusFilter = new QFilter("bizstatus", "=", (Object)"1");
        QFilter dismissBillIdFilter = new QFilter("appointid", "=", (Object)nominateBillId);
        return APPOINT_RECORD_HELPER.queryOne(selectProperties, new QFilter[]{bizStatusFilter, dismissBillIdFilter});
    }

    public DynamicObject[] queryAppointRecordByAppointIds(String selectProperties, List<Long> nominateBillIds) {
        QFilter dismissBillIdFilter = new QFilter("appointid", "in", nominateBillIds);
        return APPOINT_RECORD_HELPER.query(selectProperties, new QFilter[]{dismissBillIdFilter});
    }

    public DynamicObject[] queryAllAppointRecordData(String selectProperties) {
        return APPOINT_RECORD_HELPER.query(selectProperties, null);
    }
}

