/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.external;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.MsgMaintainApplicationService;

public class BosMessageService {
    private static final MsgMaintainApplicationService msgMaintainApplicationService = ServiceFactory.getService(MsgMaintainApplicationService.class);
    private static final Log logger = LogFactory.getLog(BosMessageService.class);

    public static long sendMessage(String title, String content, String contentUrl, List<Long> userIds, String tag, Long bizDataId, String entityNumber) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setBizDataId(bizDataId);
        messageInfo.setEntityNumber(entityNumber);
        messageInfo.setType("message");
        messageInfo.setTitle(title);
        messageInfo.setContent(content);
        messageInfo.setContentUrl(contentUrl);
        messageInfo.setUserIds(userIds);
        messageInfo.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
        messageInfo.setSendTime(new Date());
        messageInfo.setTag(tag);
        return MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    public static long sendTemplateMessage(String contentUrl, List<Long> userIds, Long nominateId, String entityNumber, String tempNumber, Long bizDataId) {
        return BosMessageService.sendTemplateMessage(contentUrl, userIds, nominateId, entityNumber, tempNumber, bizDataId, RequestContext.get().getCurrUserId());
    }

    public static long sendTemplateMessage(String contentUrl, List<Long> userIds, Long nominateId, String entityNumber, String tempNumber, Long bizDataId, long senderId) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setTitle("title");
        messageInfo.setBizDataId(nominateId);
        messageInfo.setEntityNumber("cadm_nominatebill");
        if (HRStringUtils.equals((String)entityNumber, (String)"cadm_expedcooperate")) {
            messageInfo.setEntityNumber("cadm_expedcooperate");
        }
        if (HRStringUtils.equals((String)entityNumber, (String)"cadm_expedbill")) {
            messageInfo.setEntityNumber("cadm_expedbill");
        }
        messageInfo.setTemplateNumber(tempNumber);
        messageInfo.setType("message");
        messageInfo.setContentUrl(contentUrl);
        messageInfo.setUserIds(userIds);
        messageInfo.setSenderId(Long.valueOf(senderId));
        messageInfo.setSendTime(new Date());
        BosMessageService bosMessageService = new BosMessageService();
        LocaleString tag = bosMessageService.getTagByEntityNumber(entityNumber);
        logger.info("sendTemplateMessage tag:{}", (Object)tag);
        messageInfo.setMessageTag((ILocaleString)tag);
        logger.info("sendTemplateMessage lang:{}", (Object)RequestContext.get().getLang().getLangTag());
        long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        msgMaintainApplicationService.addNewAfterSendMessage(msgId, senderId, entityNumber, tempNumber, bizDataId);
        return msgId;
    }

    public LocaleString getTagByEntityNumber(String entityNumber) {
        HashMap billInfoNames = Maps.newHashMap();
        billInfoNames.put("cadm_publicity", ResManager.getLocaleString((String)"\u516c\u793a", (String)"BosMessageService_0", (String)"tdc-cadm-business"));
        billInfoNames.put("cadm_reviewbill", ResManager.getLocaleString((String)"\u8bc4\u8bae\u8bb0\u5f55", (String)"BosMessageService_1", (String)"tdc-cadm-business"));
        billInfoNames.put("cadm_examinebill", ResManager.getLocaleString((String)"\u8003\u5bdf\u8bb0\u5f55", (String)"BosMessageService_2", (String)"tdc-cadm-business"));
        billInfoNames.put("cadm_appointrelease", ResManager.getLocaleString((String)"\u53d1\u5e03", (String)"BosMessageService_3", (String)"tdc-cadm-business"));
        billInfoNames.put("cadm_appointaudit", ResManager.getLocaleString((String)"\u8d44\u683c\u5ba1\u67e5", (String)"BosMessageService_4", (String)"tdc-cadm-business"));
        billInfoNames.put("cadm_appointissue", ResManager.getLocaleString((String)"\u7b7e\u53d1", (String)"BosMessageService_5", (String)"tdc-cadm-business"));
        billInfoNames.put("cadm_reviewhelpbill", ResManager.getLocaleString((String)"\u8bc4\u8bae\u534f\u4f5c", (String)"BosMessageService_6", (String)"tdc-cadm-business"));
        billInfoNames.put("cadm_examinecooperate", ResManager.getLocaleString((String)"\u8003\u5bdf\u534f\u4f5c", (String)"BosMessageService_7", (String)"tdc-cadm-business"));
        billInfoNames.put("cadm_dismissbill", ResManager.getLocaleString((String)"\u514d\u804c\u7533\u8bf7", (String)"BosMessageService_8", (String)"tdc-cadm-business"));
        billInfoNames.put("cadm_nominatebill", ResManager.getLocaleString((String)"\u4efb\u547d\u63d0\u540d", (String)"BosMessageService_9", (String)"tdc-cadm-business"));
        billInfoNames.put("cadm_nominatedata", ResManager.getLocaleString((String)"\u5e72\u90e8\u4efb\u514d", (String)"BosMessageService_10", (String)"tdc-cadm-business"));
        billInfoNames.put("cadm_expedcooperate", ResManager.getLocaleString((String)"\u8f6c\u6b63\u8003\u5bdf\u534f\u4f5c", (String)"BosMessageService_11", (String)"tdc-cadm-business"));
        billInfoNames.put("cadm_expedbill", ResManager.getLocaleString((String)"\u8f6c\u6b63\u8003\u5bdf\u8bb0\u5f55", (String)"BosMessageService_12", (String)"tdc-cadm-business"));
        return (LocaleString)billInfoNames.get(entityNumber);
    }

    public static long sendAndRecordMessage(String contentUrl, List<Long> userIds, Long bizDataId, String entityNumber, String tempNumber) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setTitle("title");
        messageInfo.setBizDataId(bizDataId);
        messageInfo.setEntityNumber(entityNumber);
        messageInfo.setTemplateNumber(tempNumber);
        messageInfo.setType("message");
        messageInfo.setContentUrl(contentUrl);
        messageInfo.setUserIds(userIds);
        Long senderId = RequestContext.get().getCurrUserId();
        messageInfo.setSenderId(senderId);
        messageInfo.setSendTime(new Date());
        long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        msgMaintainApplicationService.addNewAfterSendMessage(msgId, senderId, entityNumber, tempNumber, bizDataId);
        return msgId;
    }

    public static void retractMessage(Long messageId) {
        MessageCenterServiceHelper.retractMessage((Long)messageId);
    }

    public static void sendDepartMessage(String formId, Map<String, String> params, List<Long> receivers, Long billId, String tempNumber) {
        BosMessageService.sendTemplateMessage(null, receivers, billId, formId, tempNumber, billId, 0L);
    }
}

