/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.external;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.ruleengine.RuleEngineResponseUtils;
import kd.hr.hbp.common.model.ruleengine.SceneResult;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosAdminorgService;

public class CallRuleEngineService {
    private static final Log LOGGER = LogFactory.getLog(CallRuleEngineService.class);
    private static final String LONG_NUMBER = "longnumber";
    private static final BosAdminorgService ADMINORG_HELPER = ServiceFactory.getService(BosAdminorgService.class);
    private static final String SUCCESS = "200";
    private static final HRBaseServiceHelper RULE_ENGINE_HELPER = new HRBaseServiceHelper("brm_policy_edit");

    public List<Long> matchPlan(String handlerRuleNum, String strategyNum, DynamicObject nominateBill) {
        Map<String, Object> constructParams = this.constructParams(handlerRuleNum, strategyNum, nominateBill);
        List<Map<String, Object>> matchResults = this.planCallRuleEngine(constructParams, strategyNum);
        return this.parseResultPlanList(matchResults);
    }

    public Map<String, Object> matchCoopHandler(DynamicObject examPlan, DynamicObject billDy) {
        DynamicObjectCollection examPlanEntry = examPlan.getDynamicObjectCollection("examplanentry");
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        for (DynamicObject examPlanEntryRow : examPlanEntry) {
            String policyNumber;
            String id = examPlanEntryRow.getString("id");
            String addMode = examPlanEntryRow.getString("addmode");
            if ("20".equals(addMode)) {
                DynamicObjectCollection groupMemberCollect = examPlanEntryRow.getDynamicObjectCollection("groupmember");
                if (CollectionUtils.isEmpty((Collection)groupMemberCollect)) continue;
                DynamicObjectCollection userCollect = new DynamicObjectCollection();
                groupMemberCollect.forEach(item -> userCollect.add((Object)((DynamicObject)item.get("fbasedataid"))));
                resultMap.put(id, userCollect);
                continue;
            }
            String sceneNumber = examPlanEntryRow.getDynamicObject("handlerscene").getString("number");
            Map<String, Object> requestMap = this.constructParams(sceneNumber, policyNumber = HRDyObjectPropUtil.getString((DynamicObject)examPlanEntryRow.getDynamicObject("handlerpolicy"), (String)"number"), billDy);
            List<Map<String, Object>> matchResults = this.callRuleEngineReturnAll(requestMap);
            if (CollectionUtils.isEmpty(matchResults)) continue;
            matchResults.forEach(value -> resultMap.put(id, value.get("cadm_handler")));
        }
        return resultMap;
    }

    private List<Map<String, Object>> planCallRuleEngine(Map<String, Object> requestMap, String strategyNum) {
        LOGGER.info("plan requestMap == {}", requestMap);
        ArrayList matchResults = Lists.newArrayListWithExpectedSize((int)10);
        try {
            Map responseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"callRuleEngine", (Object[])new Object[]{requestMap});
            LOGGER.info("plan responseMap == {}", (Object)responseMap);
            SceneResult sceneResult = RuleEngineResponseUtils.transferToSceneResult((Map)responseMap);
            if (!SUCCESS.equals(sceneResult.getResponseCode())) {
                LOGGER.error((String)responseMap.get("responseDesc"));
                return matchResults;
            }
            List policyResults = sceneResult.getPolicyResults();
            LOGGER.info("sceneResult==:{},policyResults==:{}", (Object)sceneResult, (Object)policyResults);
            policyResults.forEach(value -> {
                List ruleResults = value.getRuleResults();
                if (CollectionUtils.isEmpty((Collection)ruleResults)) {
                    Map defaultResults = value.getDefaultResults();
                    if (!CollectionUtils.isEmpty((Map)defaultResults) && HRStringUtils.equals((String)value.getPolicyNumber(), (String)strategyNum)) {
                        matchResults.add(defaultResults);
                    }
                    return;
                }
                if (HRStringUtils.equals((String)value.getPolicyNumber(), (String)strategyNum)) {
                    ruleResults.forEach(element -> matchResults.add(element.getMatchResults()));
                }
            });
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
        LOGGER.info("matchResults==:{}", (Object)matchResults);
        return matchResults;
    }

    private List<Map<String, Object>> callRuleEngineReturnAll(Map<String, Object> requestMap) {
        LOGGER.info("plan requestMap == {}", requestMap);
        ArrayList matchResults = Lists.newArrayListWithExpectedSize((int)10);
        try {
            Map responseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"callRuleEngine", (Object[])new Object[]{requestMap});
            LOGGER.info("plan responseMap == {}", (Object)responseMap);
            SceneResult sceneResult = RuleEngineResponseUtils.transferToSceneResult((Map)responseMap);
            if (!SUCCESS.equals(sceneResult.getResponseCode())) {
                LOGGER.error((String)responseMap.get("responseDesc"));
                return matchResults;
            }
            List policyResults = sceneResult.getPolicyResults();
            LOGGER.info("sceneResult==:{},policyResults==:{}", (Object)sceneResult, (Object)policyResults);
            policyResults.forEach(value -> {
                List ruleResults = value.getRuleResults();
                String policyNumber = value.getPolicyNumber();
                if (CollectionUtils.isEmpty((Collection)ruleResults)) {
                    Map defaultResults = value.getDefaultResults();
                    if (!CollectionUtils.isEmpty((Map)defaultResults)) {
                        defaultResults.put("handlerpolicy", policyNumber);
                        matchResults.add(defaultResults);
                    }
                    return;
                }
                ruleResults.forEach(element -> {
                    Map matchResult = element.getMatchResults();
                    matchResult.put("handlerpolicy", policyNumber);
                    matchResults.add(matchResult);
                });
            });
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
        LOGGER.info("matchResults==:{}", (Object)matchResults);
        return matchResults;
    }

    private Map<String, Object> constructParams(String sceneNumber, String policyNumber, DynamicObject billDy) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        try {
            requestMap.put("bizApp", "cadm");
            requestMap.put("sceneNumber", sceneNumber);
            requestMap.put("buNumber", billDy.getString("org.number"));
            DynamicObject dy = RULE_ENGINE_HELPER.queryOriginalOne("id", new QFilter[]{new QFilter("number", "=", (Object)policyNumber)});
            if (!Objects.isNull(dy)) {
                requestMap.put("executePolicyIds", Lists.newArrayList((Object[])new Long[]{dy.getLong("id")}));
            }
            HashMap<String, DynamicObject> paramMap = new HashMap<String, DynamicObject>(16);
            paramMap.put("cadm_base", billDy);
            requestMap.put("inputParams", paramMap);
        }
        catch (Exception e) {
            LOGGER.info("constructParams exception: {}", (Object)e.getMessage());
            return requestMap;
        }
        return requestMap;
    }

    public List<Long> matchExpedPlan(DynamicObject billDy) {
        Map<String, Object> requestMap = this.constructParams(billDy);
        List<Map<String, Object>> matchResults = this.callRuleEngineReturnAll(requestMap);
        return this.parseResultPlanList(matchResults);
    }

    private List<Long> parseResultPlanList(List<Map<String, Object>> matchResults) {
        ArrayList resultList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(matchResults)) {
            try {
                matchResults.forEach(value -> {
                    Object plan_code = value.get("plan_code");
                    if (plan_code instanceof DynamicObjectCollection) {
                        ((DynamicObjectCollection)plan_code).forEach(element -> resultList.add(element.getLong("id")));
                    } else if (plan_code instanceof DynamicObject) {
                        resultList.add(((DynamicObject)plan_code).getLong("id"));
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.error((Throwable)exception);
            }
        }
        return resultList;
    }

    private Map<String, Object> constructParams(DynamicObject billDy) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        try {
            requestMap.put("bizApp", "cadm");
            requestMap.put("sceneNumber", "cadm_expedplan");
            requestMap.put("buNumber", billDy.getString("org.number"));
            HashMap<String, DynamicObject> paramMap = new HashMap<String, DynamicObject>(16);
            paramMap.put("cadm_base", billDy);
            requestMap.put("inputParams", paramMap);
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
        return requestMap;
    }
}

