/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.external;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.common.bo.CommissionPersonBo;
import kd.tdc.cadm.common.enums.PositionTypeEnum;

public class ExternalDataService {
    private static final Log logger = LogFactory.getLog(ExternalDataService.class);
    private static final HRBaseServiceHelper POSITION_HELPER = new HRBaseServiceHelper("hbpm_positionhr");
    private static final HRBaseServiceHelper JOB_HELPER = new HRBaseServiceHelper("hbjm_jobhr");
    private static final HRBaseServiceHelper PERSON_HELPER = new HRBaseServiceHelper("hrpi_person");
    private static final HRBaseServiceHelper PERNONTSPROP_HELPER = new HRBaseServiceHelper("hrpi_pernontsprop");
    private static final HRBaseServiceHelper DEPEMP_HELPER = new HRBaseServiceHelper("hrpi_depemp");
    private static final HRBaseServiceHelper HRPI_EMPPOSORGREL = new HRBaseServiceHelper("hrpi_empposorgrel");
    private static final HRBaseServiceHelper HRPI_PEROCPQUAL = new HRBaseServiceHelper("hrpi_perocpqual");
    private static final HRBaseServiceHelper HRPI_PERRPRECORD = new HRBaseServiceHelper("hrpi_perrprecord");
    private static final HRBaseServiceHelper HRPI_FAMILYMEMB = new HRBaseServiceHelper("hrpi_familymemb");
    private static final HRBaseServiceHelper HRPI_PEREDUEXP = new HRBaseServiceHelper("hrpi_pereduexp");
    private static final HRBaseServiceHelper BASE_LOCATION_HELPER = new HRBaseServiceHelper("hrpi_baselocation");
    private static final HRBaseServiceHelper EMP_ENTREL_HELPER = new HRBaseServiceHelper("hrpi_empentrel");
    private static final HRBaseServiceHelper PER_REGION_HELPER = new HRBaseServiceHelper("hrpi_perregion");
    private static final HRBaseServiceHelper HRPI_EMPJOBREL = new HRBaseServiceHelper("hrpi_empjobrel");
    private static final HRBaseServiceHelper BOS_ORG = new HRBaseServiceHelper("bos_org");
    private static final HRBaseServiceHelper HRPI_EMPLOYEE = new HRBaseServiceHelper("hrpi_employee");
    private static final HRBaseServiceHelper HPFS_CHGCATEGORY = new HRBaseServiceHelper("hpfs_chgcategory");
    private static final HRBaseServiceHelper JOB_MANAGER_HELPER = new HRBaseServiceHelper("hbjm_standardjobseqhr");
    private static final HRBaseServiceHelper JOB_SEQ_HELPER = new HRBaseServiceHelper("hbjm_jobseqhr");
    private static final HRBaseServiceHelper STD_POSITION_HELPER = new HRBaseServiceHelper("hbpm_stposition");
    private static final HRBaseServiceHelper TYPE_HELPER = new HRBaseServiceHelper("hbpm_positiontype");
    private static final String PERSON = "person";
    private static final QFilter IS_CURRENT_VERSION = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
    private static final QFilter EFFECTIVE_DATA_STATUS = new QFilter("datastatus", "=", (Object)"1");
    private static final QFilter BUSINESS_STATUS_FILTER = new QFilter("businessstatus", "=", (Object)"1");
    private static final String HRPI = "hrpi";
    private static final String IS_HIGHEST_DEGREE = "ishighestdegree";
    private static final String EDUCATION = "education";

    private static String getDynamicObjectField(DynamicObject dynObj, String field) {
        return Optional.ofNullable(dynObj).map(item -> item.getString(field)).orElse("");
    }

    public static List<Map<String, Object>> getEmpPosOrgRel(Long employeeId) {
        if (employeeId == null || employeeId == 0L) {
            return Collections.emptyList();
        }
        QFilter employeeIdFilter = new QFilter("employee", "=", (Object)employeeId);
        DynamicObject[] dynObjs = HRPI_EMPPOSORGREL.query("startdate,enddate,adminorg,position,isprimary,postype,depemp,company,stdposition,job,apositiontype", new QFilter[]{employeeIdFilter, IS_CURRENT_VERSION, EFFECTIVE_DATA_STATUS}, "startdate DESC");
        if (Objects.isNull(dynObjs) || dynObjs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)dynObjs.length);
        for (DynamicObject dynObj : dynObjs) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("startdate", dynObj.get("startdate"));
            map.put("sysenddate", dynObj.get("enddate"));
            map.put("adminorg_id", dynObj.get("adminorg_id"));
            map.put("adminorgname", ExternalDataService.getDynamicObjectField(dynObj.getDynamicObject("adminorg"), "name"));
            map.put("position_id", dynObj.get("position_id"));
            map.put("positionname", ExternalDataService.getDynamicObjectField(dynObj.getDynamicObject("position"), "name"));
            map.put("isprimary", dynObj.get("isprimary"));
            map.put("postypename", ExternalDataService.getDynamicObjectField(dynObj.getDynamicObject("postype"), "name"));
            map.put("apositiontype", dynObj.get("apositiontype"));
            map.put("stdposition_id", dynObj.get("stdposition_id"));
            map.put("stdpositionname", ExternalDataService.getDynamicObjectField(dynObj.getDynamicObject("stdposition"), "name"));
            map.put("job_id", dynObj.get("job_id"));
            map.put("jobname", ExternalDataService.getDynamicObjectField(dynObj.getDynamicObject("job"), "name"));
            map.put("depemp_id", dynObj.get("depemp_id"));
            map.put("company_id", dynObj.get("company_id"));
            map.put("companyname", ExternalDataService.getDynamicObjectField(dynObj.getDynamicObject("company"), "name"));
            list.add(map);
        }
        return list;
    }

    public static Map<String, Object> queryPrimaryEmpposorgrelUnlimited(Long employeeId) {
        HashMap<String, Object> primaryEmpposorgrel = new HashMap(16);
        List<Map<String, Object>> empPosOrgRel = ExternalDataService.getEmpPosOrgRel(employeeId);
        primaryEmpposorgrel = empPosOrgRel.stream().filter(p -> "1".equals(p.get("isprimary"))).reduce((p1, p2) -> p2).orElse(primaryEmpposorgrel);
        return primaryEmpposorgrel;
    }

    public static Map<Long, DynamicObject> getEmpPosOrgRel(String selectProperties, List<Long> pkIds) {
        if (CollectionUtils.isEmpty(pkIds)) {
            return Collections.emptyMap();
        }
        QFilter idFilter = new QFilter("id", "in", pkIds);
        DynamicObject[] empPosArr = HRPI_EMPPOSORGREL.query(selectProperties, new QFilter[]{idFilter});
        if (Objects.isNull(empPosArr) || empPosArr.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(empPosArr).collect(Collectors.toMap(value -> value.getLong("id"), value -> value, (v1, v2) -> v1));
    }

    public static DynamicObject getEmpPosOrgRelByDepEmpId(long depEmpId) {
        return HRPI_EMPPOSORGREL.queryOriginalOne("startdate", new QFilter[]{new QFilter("depemp", "=", (Object)depEmpId), new QFilter("iscurrentversion", "=", (Object)"1")});
    }

    public static DynamicObject[] getChgCategory(long id) {
        return HPFS_CHGCATEGORY.queryOriginalArray("id,actiontype", new QFilter[]{new QFilter("chgevent", "=", (Object)id)});
    }

    public static String getEmpPosPosTypeName(long employeeId, long stdPositionId, long jobId, long positionId) {
        QFilter filter;
        QFilter versionFilter;
        QFilter employeeQFilter = new QFilter("employee", "=", (Object)employeeId);
        DynamicObject dynamicObject = HRPI_EMPPOSORGREL.queryOne("postype", new QFilter[]{employeeQFilter, versionFilter = new QFilter("iscurrentversion", "=", (Object)"1"), filter = 0L != stdPositionId ? new QFilter("stdposition", "=", (Object)stdPositionId) : (0L != positionId ? new QFilter("position", "=", (Object)positionId) : new QFilter("job", "=", (Object)jobId))});
        if (null == dynamicObject) {
            return null;
        }
        return dynamicObject.getString("postype.name");
    }

    public static DynamicObject[] getCurrentVersionEmpPosOrgRelByEmpId(long employeeId, String selectProperties) {
        QFilter employeeFilter = new QFilter("employee", "=", (Object)employeeId);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return HRPI_EMPPOSORGREL.query(selectProperties, new QFilter[]{employeeFilter, currentVersionFilter});
    }

    public static List<Map<String, Object>> getPerocpqual(Long personId) {
        if (personId == null || personId == 0L) {
            return Collections.emptyList();
        }
        String selectProperties = "qualification,qualevel,gettime,expirationdate,registratedate,grantunit,registrationunit,name";
        QFilter personFilter = new QFilter(PERSON, "=", (Object)personId);
        DynamicObject[] dynObjs = HRPI_PEROCPQUAL.query(selectProperties, new QFilter[]{personFilter, IS_CURRENT_VERSION, EFFECTIVE_DATA_STATUS}, "gettime DESC");
        if (Objects.isNull(dynObjs) || dynObjs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)dynObjs.length);
        for (DynamicObject dynObj : dynObjs) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("qualificationname", ExternalDataService.getDynamicObjectField(dynObj.getDynamicObject("qualification"), "name"));
            map.put("qualevelname", ExternalDataService.getDynamicObjectField(dynObj.getDynamicObject("qualevel"), "name"));
            map.put("gettime", dynObj.get("gettime"));
            map.put("expirationdate", dynObj.get("expirationdate"));
            map.put("registratedate", dynObj.get("registratedate"));
            map.put("grantunit", dynObj.get("grantunit"));
            map.put("registrationunit", dynObj.get("registrationunit"));
            map.put("perocpqualname", dynObj.get("name"));
            list.add(map);
        }
        return list;
    }

    public static List<Map<String, Object>> getPerrprecord(Long personId) {
        if (personId == null || personId == 0L) {
            return Collections.emptyList();
        }
        String selectProperties = "type,level,flag,rewarddate,content,unit";
        QFilter personFilter = new QFilter(PERSON, "=", (Object)personId);
        DynamicObject[] dynObjs = HRPI_PERRPRECORD.query(selectProperties, new QFilter[]{personFilter, IS_CURRENT_VERSION, EFFECTIVE_DATA_STATUS}, "rewarddate DESC");
        if (Objects.isNull(dynObjs) || dynObjs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)dynObjs.length);
        for (DynamicObject dynObj : dynObjs) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("typename", ExternalDataService.getDynamicObjectField(dynObj.getDynamicObject("type"), "name"));
            map.put("levelname", ExternalDataService.getDynamicObjectField(dynObj.getDynamicObject("level"), "name"));
            map.put("flag", dynObj.get("flag"));
            map.put("rewarddate", dynObj.get("rewarddate"));
            map.put("content", dynObj.get("content"));
            map.put("unit", dynObj.get("unit"));
            list.add(map);
        }
        return list;
    }

    public static List<Map<String, Object>> getFamilyMemb(Long personId) {
        if (personId == null || personId == 0L) {
            return Collections.emptyList();
        }
        String selectProperties = "name,familymembship,workunit,mobilephone";
        QFilter personFilter = new QFilter(PERSON, "=", (Object)personId);
        DynamicObject[] dynObjs = HRPI_FAMILYMEMB.query(selectProperties, new QFilter[]{personFilter, IS_CURRENT_VERSION, EFFECTIVE_DATA_STATUS});
        if (Objects.isNull(dynObjs) || dynObjs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)dynObjs.length);
        for (DynamicObject dynObj : dynObjs) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("name", dynObj.get("name"));
            map.put("familymembshipname", ExternalDataService.getDynamicObjectField(dynObj.getDynamicObject("familymembship"), "name"));
            map.put("workunit", dynObj.get("workunit"));
            map.put("mobilephone", dynObj.get("mobilephone"));
            list.add(map);
        }
        return list;
    }

    public static List<Map<String, Object>> getPerEduExp(Long personId) {
        if (personId == null || personId == 0L) {
            return Collections.emptyList();
        }
        String selectProperties = "admissiondate,gradutiondate,graduateschool,major,education,degree,ishighestdegree,isfulltime";
        QFilter personFilter = new QFilter(PERSON, "=", (Object)personId);
        DynamicObject[] dynObjs = HRPI_PEREDUEXP.query(selectProperties, new QFilter[]{personFilter, IS_CURRENT_VERSION, EFFECTIVE_DATA_STATUS});
        if (Objects.isNull(dynObjs) || dynObjs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)dynObjs.length);
        for (DynamicObject dynObj : dynObjs) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("admissiondate", dynObj.get("admissiondate"));
            map.put("gradutiondate", dynObj.get("gradutiondate"));
            map.put("graduateschoolname", ExternalDataService.getDynamicObjectField(dynObj.getDynamicObject("graduateschool"), "name"));
            map.put("major", dynObj.get("major"));
            map.put("educationname", ExternalDataService.getDynamicObjectField(dynObj.getDynamicObject(EDUCATION), "name"));
            map.put("degreename", ExternalDataService.getDynamicObjectField(dynObj.getDynamicObject("degree"), "name"));
            map.put(IS_HIGHEST_DEGREE, dynObj.get(IS_HIGHEST_DEGREE));
            map.put("isfulltime", dynObj.get("isfulltime"));
            list.add(map);
        }
        return list;
    }

    public static String getHighestEdu(long personId) {
        logger.info("getHighestEdu-->IHRPIPersonService-->listPersonAttachs-->hrpi_pereduexp:personId:{}", (Object)personId);
        List perEduExpList = (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"listPersonAttachs", (Object[])new Object[]{personId, "hrpi_pereduexp"});
        logger.info("getHighestEdu-->IHRPIPersonService-->listPersonAttachs-->hrpi_pereduexp:return:{}", (Object)perEduExpList);
        Optional<Map> highestDegree = perEduExpList.stream().filter(eduExp -> eduExp.get(IS_HIGHEST_DEGREE).equals("1")).findFirst();
        if (highestDegree.isPresent()) {
            Map eduExpObj = highestDegree.get();
            return (String)eduExpObj.get(EDUCATION);
        }
        return "";
    }

    public static Map<String, Object> getBaseLocation(Long employeeId) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        QFilter employeeIdFilter = new QFilter("employee", "=", (Object)employeeId);
        DynamicObject dynObj = BASE_LOCATION_HELPER.queryOne("location", new QFilter[]{employeeIdFilter, IS_CURRENT_VERSION, BUSINESS_STATUS_FILTER});
        String baseLocation = Optional.ofNullable(dynObj).map(item -> ExternalDataService.getDynamicObjectField(item.getDynamicObject("location"), "name")).orElse("");
        result.put("baselocation", baseLocation);
        return result;
    }

    public static Map<String, Object> getEmpEntrel(Long employeeId) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        QFilter employeeIdFilter = new QFilter(PERSON, "=", (Object)employeeId);
        DynamicObject dynObj = EMP_ENTREL_HELPER.queryOne("firststartdate", new QFilter[]{employeeIdFilter, IS_CURRENT_VERSION, BUSINESS_STATUS_FILTER});
        Date firstStartDate = Optional.ofNullable(dynObj).map(item -> item.getDate("firststartdate")).orElse(null);
        result.put("firststartdate", firstStartDate);
        return result;
    }

    public static Map<String, Object> getPerRegion(Long personId) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        DynamicObject dynObj = PER_REGION_HELPER.queryOne("nativeplace,birthplace,politicalstatus,party,joinpartydate,religion", new QFilter[]{new QFilter(PERSON, "=", (Object)personId)});
        if (Objects.isNull(dynObj)) {
            return result;
        }
        result.put("nativeplace", dynObj.get("nativeplace"));
        result.put("birthplace", dynObj.get("birthplace"));
        result.put("politicalstatus", ExternalDataService.getDynamicObjectField(dynObj.getDynamicObject("politicalstatus"), "name"));
        result.put("politicalstatusid", HRDyObjectPropUtil.getId((DynamicObject)dynObj.getDynamicObject("politicalstatus")));
        result.put("party", ExternalDataService.getDynamicObjectField(dynObj.getDynamicObject("party"), "name"));
        result.put("joinpartydate", dynObj.get("joinpartydate"));
        result.put("religion", HRDyObjectPropUtil.getName((DynamicObject)dynObj.getDynamicObject("religion")));
        return result;
    }

    public static DynamicObject getDepempByPkVal(Long pkVal) {
        return DEPEMP_HELPER.queryOne("employee", (Object)pkVal);
    }

    public static DynamicObject getEmpJobRelByEmployee(Long employeeId, String fields) {
        return HRPI_EMPJOBREL.queryOne(fields, new QFilter("employee", "=", (Object)employeeId));
    }

    public static DynamicObject getBosOrg(Long bosOrgId, String fields) {
        if (bosOrgId == null || bosOrgId == 0L) {
            return BOS_ORG.generateEmptyDynamicObject();
        }
        return BOS_ORG.queryOne(fields, (Object)bosOrgId);
    }

    public static Map<String, Object> getPersonInfo(Long personId) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"getPersonInfo", (Object[])new Object[]{personId});
    }

    public static List<Map<String, Object>> listPersonInfos(List<Long> personIds) {
        return (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"listPersonInfos", (Object[])new Object[]{personIds});
    }

    public static Map<String, Object> getPersonBaseInfo(Long personId) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"getPersonBaseInfo", (Object[])new Object[]{personId});
    }

    public static DynamicObject getPersonBaseInfoByNumber(String number) {
        return HRPI_EMPLOYEE.queryOne("id,person", new QFilter[]{new QFilter("empnumber", "=", (Object)number), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("datastatus", "=", (Object)"1")});
    }

    public static Map<String, Object> getEmpentrel(Long employeeId) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIEmployeeService", (String)"getEmpentrel", (Object[])new Object[]{employeeId});
    }

    public static Map<Long, List<Map<String, Object>>> queryEmpposorgrels(List<Long> personIds) {
        HashMap<Long, List<Map<String, Object>>> personEmpposorgrels = new HashMap<Long, List<Map<String, Object>>>(16);
        for (Long personId : personIds) {
            List empposorgrels = (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"listEmpposorgrels", (Object[])new Object[]{personId});
            personEmpposorgrels.put(personId, empposorgrels);
        }
        return personEmpposorgrels;
    }

    public static Map<Long, List<Map<String, Object>>> queryEmpposorgrels(List<Long> personId, String posttypeId) {
        List mapList = (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"listEmpposorgrels", (Object[])new Object[]{posttypeId, personId});
        return mapList.stream().collect(Collectors.groupingBy(map -> Long.valueOf(map.get("person_id").toString())));
    }

    public static Map<String, Object> queryPrimaryEmpposorgrel(Long personId) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"getPrimaryEmpposorgrel", (Object[])new Object[]{personId});
    }

    public static Map<Long, List<Map<String, Object>>> getDirectSuperiorByDepEmpId(List<Long> depEmpIdList) {
        long startTime = System.currentTimeMillis();
        Map directSuperiorList = (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIWorkRoleService", (String)"getDirectSuperiorByDepempId", (Object[])new Object[]{depEmpIdList});
        return directSuperiorList;
    }

    public static DynamicObject[] queryManagePosition(List<Object> positionIds) {
        QFilter idFilter = new QFilter("id", "in", positionIds);
        QFilter manageFilter = new QFilter("positiontype.ismanagetype", "=", (Object)"1");
        return POSITION_HELPER.queryOriginalArray("id", new QFilter[]{idFilter, manageFilter});
    }

    public static List<Object> queryManageJob(List<Object> jobIdList) {
        ArrayList managerJobIdList = Lists.newArrayList();
        QFilter idFilter = new QFilter("id", "in", jobIdList);
        DynamicObject[] jobSeqDynamic = JOB_HELPER.queryOriginalArray("id,jobseq", new QFilter[]{idFilter});
        if (null == jobSeqDynamic || jobSeqDynamic.length == 0) {
            return managerJobIdList;
        }
        Map<Long, List<DynamicObject>> jobSeqMap = Arrays.stream(jobSeqDynamic).collect(Collectors.groupingBy(dynamic -> dynamic.getLong("jobseq")));
        Set jobSeqIdSet = Arrays.stream(jobSeqDynamic).map(dynamic -> dynamic.getLong("jobseq")).collect(Collectors.toSet());
        QFilter jobSeqFilter = new QFilter("id", "in", jobSeqIdSet);
        jobSeqFilter.and(new QFilter("standardjobseq", "=", (Object)1010L));
        DynamicObject[] dynamicObjects = JOB_SEQ_HELPER.queryOriginalArray("id", new QFilter[]{jobSeqFilter});
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            return managerJobIdList;
        }
        List<Long> managerSeqIdList = Arrays.stream(dynamicObjects).map(dynamic -> dynamic.getLong("id")).collect(Collectors.toList());
        managerSeqIdList.forEach(managerSeqId -> {
            List dynamicObjectList = (List)jobSeqMap.get(managerSeqId);
            if (CollectionUtils.isEmpty((Collection)dynamicObjectList)) {
                return;
            }
            managerJobIdList.addAll(dynamicObjectList.stream().map(dynamic -> dynamic.getLong("id")).collect(Collectors.toList()));
        });
        return managerJobIdList;
    }

    public static List<Object> queryManageStandardPosition(List<Object> standardPositionIdList) {
        QFilter idFilter = new QFilter("id", "in", standardPositionIdList);
        QFilter manageFilter = new QFilter("positiontype.ismanagetype", "=", (Object)"1");
        DynamicObject[] dynamicObjects = STD_POSITION_HELPER.queryOriginalArray("id", new QFilter[]{idFilter, manageFilter});
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            return Lists.newArrayList();
        }
        return Arrays.stream(dynamicObjects).map(dynamic -> dynamic.getLong("id")).collect(Collectors.toList());
    }

    public static List<Map<String, Object>> filterManagerEmpPos(List<Map<String, Object>> inUsingEmpPosList) {
        ArrayList managerEmpPosResultMap = Lists.newArrayList();
        Map<String, List<Map>> groupByPositionTypeMap = inUsingEmpPosList.stream().filter(map -> null != map.get("apositiontype") && HRStringUtils.isNotEmpty((String)map.get("apositiontype").toString())).collect(Collectors.groupingBy(map -> map.get("apositiontype").toString()));
        List<Map<String, Object>> positionEmpPosList = groupByPositionTypeMap.get(PositionTypeEnum.POSITION.getNumber());
        ExternalDataService.getManagerEmpPos(positionEmpPosList, managerEmpPosResultMap, PositionTypeEnum.POSITION);
        List<Map<String, Object>> jobEmpPosList = groupByPositionTypeMap.get(PositionTypeEnum.JOB.getNumber());
        ExternalDataService.getManagerEmpPos(jobEmpPosList, managerEmpPosResultMap, PositionTypeEnum.JOB);
        List<Map<String, Object>> standardPositionEmpPosList = groupByPositionTypeMap.get(PositionTypeEnum.STANDER_POSITION.getNumber());
        ExternalDataService.getManagerEmpPos(standardPositionEmpPosList, managerEmpPosResultMap, PositionTypeEnum.STANDER_POSITION);
        return managerEmpPosResultMap;
    }

    private static void getManagerEmpPos(List<Map<String, Object>> empPosList, List<Map<String, Object>> managerEmpPosResultMap, PositionTypeEnum positionTypeEnum) {
        if (CollectionUtils.isEmpty(empPosList)) {
            return;
        }
        switch (positionTypeEnum.getNumber()) {
            case "0": {
                Map<Object, List<Map>> standardPositionEmpPosMap = empPosList.stream().filter(map -> map.get("stdposition_id") != null).collect(Collectors.groupingBy(map -> map.get("stdposition_id")));
                List<Object> standardPositionIdList = empPosList.stream().map(map -> map.get("stdposition_id")).collect(Collectors.toList());
                List<Object> managerStandardPositionIdList = ExternalDataService.queryManageStandardPosition(standardPositionIdList);
                managerStandardPositionIdList.forEach(managerStandardPositionId -> {
                    List managerEmpPosMap = (List)standardPositionEmpPosMap.get(managerStandardPositionId);
                    if (CollectionUtils.isEmpty((Collection)managerEmpPosMap)) {
                        return;
                    }
                    managerEmpPosResultMap.addAll(managerEmpPosMap);
                });
                break;
            }
            case "1": {
                ExternalDataService.getPositionManager(empPosList, managerEmpPosResultMap);
                break;
            }
            case "2": {
                Map<Object, List<Map>> jobEmpPosMap = empPosList.stream().filter(map -> map.get("job_id") != null).collect(Collectors.groupingBy(map -> map.get("job_id")));
                List<Object> jobIdList = empPosList.stream().map(map -> map.get("job_id")).collect(Collectors.toList());
                List<Object> managerJobIdList = ExternalDataService.queryManageJob(jobIdList);
                managerJobIdList.forEach(managerJobId -> {
                    List managerEmpPosMap = (List)jobEmpPosMap.get(managerJobId);
                    if (CollectionUtils.isEmpty((Collection)managerEmpPosMap)) {
                        return;
                    }
                    managerEmpPosResultMap.addAll(managerEmpPosMap);
                });
                break;
            }
        }
    }

    private static void getPositionManager(List<Map<String, Object>> positionEmpPosList, List<Map<String, Object>> managerEmpPosResultMap) {
        if (CollectionUtils.isEmpty(positionEmpPosList)) {
            return;
        }
        Map<Long, List<Map>> positionEmpPosMap = positionEmpPosList.stream().filter(map -> map.get("position_id") != null).collect(Collectors.groupingBy(map -> (Long)map.get("position_id")));
        List<Object> positionIdList = positionEmpPosList.stream().filter(map -> map.get("position_id") != null).map(map -> map.get("position_id")).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = ExternalDataService.queryManagePosition(positionIdList);
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            return;
        }
        List<Long> managerPositionList = Arrays.stream(dynamicObjects).map(dynamic -> dynamic.getLong("id")).collect(Collectors.toList());
        managerPositionList.forEach(managerPositionId -> {
            List managerEmpPosMap = (List)positionEmpPosMap.get(managerPositionId);
            if (CollectionUtils.isEmpty((Collection)managerEmpPosMap)) {
                return;
            }
            managerEmpPosResultMap.addAll(managerEmpPosMap);
        });
    }

    public static Map<String, Object> listEmpOrgRelByPos(Map<String, Object> param) {
        logger.info("ExternalDataService.listEmpOrgRelByPos params is: {}", param);
        return (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIDepempService", (String)"listEmpOrgRelByPos", (Object[])new Object[]{param});
    }

    public static DynamicObject[] queryPersonServiceAge(List<Long> personIds) {
        logger.info("ExternalDataService.listPersonServiceAge params is: {}", personIds);
        QFilter qFilter = new QFilter(PERSON, "in", personIds);
        return (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{"person,socialworkage", qFilter, "hrpi_perserlen"});
    }

    public static DynamicObject[] queryPersonServiceLength(List<Long> personIds) {
        logger.info("ExternalDataService.queryPersonServiceLength params is: {}", personIds);
        QFilter qFilter = new QFilter(PERSON, "in", personIds);
        return (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{"person,servicelength", qFilter, "hrpi_empentrel"});
    }

    public static List<Map<String, Object>> getEmpJobRelObj(List<Long> employeeIds) {
        return (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIEmployeeService", (String)"listBatchPropEmployeeAttachs", (Object[])new Object[]{employeeIds, "employee,person,jobseq.name,joblevel.name,jobgrade.name,joblevel.id,jobgrade.id", "hrpi_empjobrel"});
    }

    public static List<Map<String, Object>> getHrpiCommonInfoByFilter(String selectProperties, QFilter qFilter, String entityName) {
        DynamicObject[] dynamicObjects = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{selectProperties, qFilter, entityName});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return Lists.newArrayList();
        }
        return CastUtils.castDynamicToMap(dynamicObjects);
    }

    public static Object getSystemParam(String appKey, String paramKey) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appKey);
        String appId = appInfo != null ? appInfo.getId() : null;
        Long orgPk = RequestContext.get().getOrgId();
        AppParam appParam = new AppParam(appId, orgPk);
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)paramKey);
    }

    public static Map<Long, CommissionPersonBo> getPersonBaseInfo(Set<Long> personIdSet) {
        HashMap<Long, CommissionPersonBo> resultMap = new HashMap<Long, CommissionPersonBo>(16);
        ArrayList<Long> list = new ArrayList<Long>(personIdSet);
        List personInfoMap = (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"listPersonInfos", (Object[])new Object[]{list});
        if (CollectionUtils.isEmpty((Collection)personInfoMap)) {
            return resultMap;
        }
        personInfoMap.forEach(map -> {
            Object personId = map.get("id");
            long longPersonId = Long.parseLong(personId.toString());
            CommissionPersonBo commissionPersonBo = (CommissionPersonBo)resultMap.get(longPersonId);
            if (null == commissionPersonBo) {
                commissionPersonBo = new CommissionPersonBo();
            }
            String name = map.get("name") == null ? "" : map.get("name");
            String gender = map.get("gender") == null ? "" : map.get("gender");
            String number = map.get("number") == null ? "" : map.get("number");
            String folk = map.get("folk") == null ? "" : map.get("folk");
            Object birthday = map.get("birthday");
            if (null != name) {
                commissionPersonBo.setPersonName(name.toString());
            }
            if (null != gender) {
                commissionPersonBo.setPersonGender(gender.toString());
            }
            if (null != folk) {
                commissionPersonBo.setNation(folk.toString());
            }
            if (null != number) {
                commissionPersonBo.setNumber(number.toString());
            }
            if (null != birthday) {
                Date birth = (Date)birthday;
                String strBirthDay = ExternalDataService.getCommonDate(birth);
                commissionPersonBo.setBirthDay(strBirthDay);
            }
            resultMap.put(longPersonId, commissionPersonBo);
        });
        return resultMap;
    }

    public static String getCommonDate(Date date) {
        String publishDateStr = DateUtils.formatDate((Date)date, (Object[])new Object[0]);
        String[] split = publishDateStr.split("-");
        return ResManager.loadKDString((String)"{0}\u5e74{1}\u6708", (String)"ExternalDataService_1", (String)"tdc-cadm-opplugin", (Object[])new Object[]{split[0], split[1]});
    }

    public static Map<Long, CommissionPersonBo> getEducationInfoList(Set<Long> personIdSet) {
        HashMap<Long, CommissionPersonBo> resultMap = new HashMap<Long, CommissionPersonBo>(16);
        ArrayList<Long> list = new ArrayList<Long>(personIdSet);
        List<Map<String, Object>> maps = ExternalDataService.getAttachInfoFromHrpi("hrpi_pereduexp", list);
        maps.forEach(map -> {
            if ("1".equals(map.get(IS_HIGHEST_DEGREE))) {
                String education = map.get(EDUCATION) == null ? "" : map.get(EDUCATION).toString();
                long personId = map.get("person_id") == null ? 0L : Long.parseLong(map.get("person_id").toString());
                CommissionPersonBo commissionPersonBo = (CommissionPersonBo)resultMap.get(personId);
                if (null == commissionPersonBo) {
                    commissionPersonBo = new CommissionPersonBo();
                }
                commissionPersonBo.setHighLeve(education);
                resultMap.put(personId, commissionPersonBo);
            }
        });
        return resultMap;
    }

    public static Map<Long, CommissionPersonBo> getPoliticInfoList(Set<Long> personIdSet) {
        HashMap<Long, CommissionPersonBo> resultMap = new HashMap<Long, CommissionPersonBo>(16);
        ArrayList<Long> list = new ArrayList<Long>(personIdSet);
        List<Map<String, Object>> maps = ExternalDataService.getAttachInfoFromHrpi("hrpi_perregion", list);
        maps.forEach(map -> {
            String politicalStatus = map.get("politicalstatus") == null ? "" : map.get("politicalstatus").toString();
            long personId = map.get("person_id") == null ? 0L : Long.parseLong(map.get("person_id").toString());
            CommissionPersonBo commissionPersonBo = (CommissionPersonBo)resultMap.get(personId);
            if (null == commissionPersonBo) {
                commissionPersonBo = new CommissionPersonBo();
            }
            commissionPersonBo.setPolitic(politicalStatus);
            resultMap.put(personId, commissionPersonBo);
        });
        return resultMap;
    }

    public static List<Map<String, Object>> getAttachInfoFromHrpi(String attachmentMark, List<Long> personIdList) {
        return (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"listBatchPersonAttachs", (Object[])new Object[]{personIdList, QFilter.of((String)"1=1", (Object[])new Object[0]), attachmentMark});
    }

    public static List<Map<String, Object>> getAttachInfoFromHrpiByFilter(String attachmentMark, List<Long> personIdList, QFilter qFilter) {
        return (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"listBatchPersonAttachs", (Object[])new Object[]{personIdList, qFilter, attachmentMark});
    }

    public static List<Map<String, Object>> getEducationalInfo(Long personId) {
        return (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"listPersonAttachs", (Object[])new Object[]{personId, "hrpi_pereduexp"});
    }

    public static List<Map<String, Object>> getFamilyMember(Long personId) {
        return (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"listPersonAttachs", (Object[])new Object[]{personId, "hrpi_familymemb"});
    }

    public static List<Map<String, Object>> getPerCre(Long personId) {
        return (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"listPersonAttachs", (Object[])new Object[]{personId, "hrpi_percre"});
    }

    public static List<Map<String, Object>> getPerProTitle(Long personId) {
        return (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"listPersonAttachs", (Object[])new Object[]{personId, "hrpi_perprotitle"});
    }

    public static DynamicObject getPositionInfo(long employeeId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_empjobrel");
        QFilter qFilterPersonId = new QFilter("employee", "=", (Object)employeeId);
        QFilter qFilterIsCurrentVersion = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter qFilterDataStatus = new QFilter("datastatus", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{qFilterPersonId, qFilterIsCurrentVersion, qFilterDataStatus};
        String selectFiled = "job,joblevel,jobgrade,jobclass,jobfamily,jobseq";
        DynamicObject result = helper.queryOne(selectFiled, qFilters);
        logger.info("cadm hrpi-->getPositionInfo-->result:{}", (Object)result);
        return result;
    }

    public static List<Map<String, Object>> getPerRegionList(Long personId) {
        return (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"listPersonAttachs", (Object[])new Object[]{personId, "hrpi_perregion"});
    }

    public static List<Map<String, Object>> getPerRecord(Long personId) {
        return (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"listPersonAttachs", (Object[])new Object[]{personId, "hrpi_perrprecord"});
    }

    public static List<Map<String, Object>> listEmpPosOrgRel(Long personId) {
        return (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIPersonService", (String)"listEmpposorgrels", (Object[])new Object[]{personId});
    }

    public static void completeWorkFlowTask(Long actInsId, Long userId, String decOptionNumber, String auditMessage, Map<String, Object> variables) {
        DynamicObject actInsInfo = ExternalDataService.getActivityInsById("wfcurtaskid", actInsId);
        Long taskId = null != actInsInfo ? actInsInfo.getLong("wfcurtaskid") : 0L;
        if (userId == null || userId.compareTo(0L) == 0) {
            userId = RequestContext.get().getCurrUserId();
        }
        try {
            TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)taskId);
            logger.info(MessageFormat.format("find taskInfo ? {0} ,actInsId is {1},taskId is {2}", taskInfo, actInsId, taskId));
            if (taskInfo != null) {
                WorkflowServiceHelper.completeTask((Long)taskId, (Long)userId, (String)decOptionNumber, (String)auditMessage, variables);
            }
        }
        catch (Exception exp) {
            logger.error(String.format("taskId : %d actInsId: %d", taskId, actInsId), (Throwable)exp);
        }
    }

    private static DynamicObject getActivityInsById(String selectProperties, Long activityInsId) {
        String selector = "applier,bizbillid,biznum,bizkey,bindbizbillid,bindbiznum,bindbizkey,bindinglayoutid,actthemestr,taskstatus,createtime,wfcurtaskid,wfprocessinsid,wfprocessdefinitionid,actscheme,schemenumber,schemeversion,activity,handletime,handlers,wfnode";
        if (HRStringUtils.isNotEmpty((String)selectProperties)) {
            selector = selectProperties;
        }
        HRBaseServiceHelper insHelper = new HRBaseServiceHelper("hrcs_activityins");
        return insHelper.queryOne(selector, new QFilter[]{new QFilter("id", "=", (Object)activityInsId)});
    }

    public static DynamicObject queryPositionById(String selectProperties, Object pkValue) {
        return POSITION_HELPER.queryOne(selectProperties, new QFilter[]{new QFilter("id", "=", pkValue)});
    }

    public static DynamicObject queryJobById(String selectProperties, Object pkId) {
        return JOB_HELPER.queryOne(selectProperties, new QFilter[]{new QFilter("id", "=", pkId)});
    }

    public static boolean isJobManager(Object pkId) {
        DynamicObject seqDynamic = JOB_SEQ_HELPER.queryOne("standardjobseq", new QFilter[]{new QFilter("id", "=", pkId)});
        if (null == seqDynamic) {
            return false;
        }
        return 1010L == seqDynamic.getLong("standardjobseq.id");
    }

    public static DynamicObject queryStdPositionById(String selectProperties, Object pkId) {
        return STD_POSITION_HELPER.queryOne(selectProperties, new QFilter[]{new QFilter("id", "=", pkId)});
    }

    public static boolean isManager(Object pkId) {
        DynamicObject dynamicObject = TYPE_HELPER.queryOne("ismanagetype", new QFilter[]{new QFilter("id", "=", pkId)});
        if (null == dynamicObject) {
            return false;
        }
        return "1".equals(dynamicObject.getString("ismanagetype"));
    }

    public static boolean validateIdNumber(String idNumber) {
        Object resultObj = DispatchServiceHelper.invokeBOSService((String)"bos", (String)"IIdentityService", (String)"validIdentityCardNo", (Object[])new Object[]{null, "CN01", idNumber});
        Map result = (Map)SerializationUtils.deSerializeFromBase64((String)SerializationUtils.serializeToBase64((Object)resultObj));
        return Boolean.parseBoolean(result.get("isSuccess").toString());
    }

    public static Map<String, Object> insertOrUpdateAppointRemoveRel(Map<String, Object> param) {
        logger.info("insertOrUpdateAppointRemoveRel param:{}", param);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIEmployeeService", (String)"insertOrUpdateAppointRemoveRel", (Object[])new Object[]{param});
        logger.info("insertOrUpdateAppointRemoveRel result:{}", (Object)result);
        return result;
    }

    public static Object getCadreParam(String appKey, String viewType, String paramKey) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appKey);
        String appId = appInfo.getId();
        AppParam appParam = new AppParam(appId, viewType, Long.valueOf(OrgUnitServiceHelper.getRootOrgId()), Long.valueOf(0L));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)paramKey);
    }

    public static Map<String, Object> queryEmpPosOrgRelByDepEmpId(long depEmpId) {
        QFilter depEmpFilter = new QFilter("depemp", "=", (Object)depEmpId);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        DynamicObject dynamicObject = HRPI_EMPPOSORGREL.queryOne(new QFilter[]{depEmpFilter, currentVersionFilter, dataStatusFilter});
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        if (dynamicObject != null) {
            result.put("id", dynamicObject.getLong("id"));
        }
        logger.info("queryEmpPosOrgRelByDepEmpId:dynamicObject{},result:{}", (Object)dynamicObject, result);
        return result;
    }
}

