/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.domain.appointaudit.service.AppointAuditDomainService;

public class AuditBillApplicationService {
    private static final AppointAuditDomainService auditDomainService = ServiceFactory.getService(AppointAuditDomainService.class);
    private static final ActvGenerateExtService ACTV_SERVICE = ServiceFactory.getService(ActvGenerateExtService.class);

    public void rejectToPreviousBill(DynamicObject[] auditBills, String opinion) {
        List<Long> insIds = Arrays.stream(auditBills).map(item -> item.getLong("instanceid")).collect(Collectors.toList());
        ACTV_SERVICE.batchRejectTask(insIds, opinion);
        auditDomainService.rejectBill(auditBills);
    }

    public DynamicObject[] queryAuditBillById(String selectProperties, List<Object> pkIds) {
        return auditDomainService.queryAuditBillById(selectProperties, pkIds);
    }

    public DynamicObject queryOne(String selectProperties, Object pkId) {
        return auditDomainService.queryOne(selectProperties, pkId);
    }

    public DynamicObject[] queryByPermission(String selectProperties, long userId, List<String> statusList, String permItemId) {
        return auditDomainService.queryByPermission(selectProperties, userId, statusList, permItemId);
    }

    public DynamicObject queryAuditByAppointId(String selectProperties, Long appointId) {
        return auditDomainService.queryAuditByAppointId(selectProperties, appointId);
    }
}

