/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.service;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.domain.brew.entity.BrewMatchBo;
import kd.tdc.cadm.bussiness.domain.brew.service.BrewBillDomainService;
import kd.tdc.cadm.bussiness.util.UrlBuilder;
import kd.tdc.cadm.common.enums.PositionTypeEnum;

public class BrewBillApplicationService {
    private static final Log LOG = LogFactory.getLog(BrewBillApplicationService.class);
    private static final BrewBillDomainService brewBillDomainService = ServiceFactory.getService(BrewBillDomainService.class);
    private static final HRBaseServiceHelper cerProService = new HRBaseServiceHelper("tdcs_cerprocessrecord");

    public DynamicObject getBrewBillById(String selectedProperties, long pkId) {
        return brewBillDomainService.getBrewBillById(selectedProperties, pkId);
    }

    public DynamicObject[] getBrewBillByIds(String selectedProperties, List<Long> pkIds) {
        return brewBillDomainService.getBrewBillByIds(selectedProperties, pkIds);
    }

    public String getCerProService(long personId) {
        DynamicObject[] dynamicObjects = cerProService.query("cerstandtxt", new QFilter[]{new QFilter("person", "=", (Object)personId)});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return "";
        }
        ArrayList<String> currCerStandList = new ArrayList<String>(dynamicObjects.length);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            currCerStandList.add(dynamicObjects[i].getString("cerstandtxt"));
        }
        return String.join((CharSequence)",", currCerStandList);
    }

    public DynamicObject getBrewBillByList(String selectedProperties, List<String> enumList, long positionId, long selfId, String positionType) {
        return brewBillDomainService.getBrewBillByList(selectedProperties, enumList, positionId, selfId, positionType);
    }

    public void sendAddNominateMessage(DynamicObject[] brewBills) {
        for (DynamicObject brewBill : brewBills) {
            long brewId = brewBill.getLong("id");
            String positionType = brewBill.getString("positiontype");
            long id = 0L;
            String name = "";
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                id = brewBill.getLong("brewposition.id");
                name = "brewposition";
            } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                id = HRDyObjectPropUtil.getId((DynamicObject)brewBill.getDynamicObject("brewjob"));
                name = "brewjob";
            } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                id = HRDyObjectPropUtil.getId((DynamicObject)brewBill.getDynamicObject("brewstandardposition"));
                name = "brewstandardposition";
            }
            DynamicObjectCollection entryEntity = brewBillDomainService.getBrewEntryEntity(brewId);
            String finalName = name;
            long finalId = id;
            entryEntity.forEach(entryRow -> {
                Long rowPkId = (Long)entryRow.getPkValue();
                long nominateUserId = entryRow.getLong("nomhandler.id");
                long depempId = HRDyObjectPropUtil.getId((DynamicObject)entryRow.getDynamicObject("depemp"));
                ArrayList<Long> userIds = new ArrayList<Long>();
                userIds.add(nominateUserId);
                String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_nominatebill").setParameter("depemp", String.valueOf(depempId)).setParameter("positiontype", positionType).setParameter(finalName, String.valueOf(finalId)).setParameter("cadm_brewbill", String.valueOf(brewId)).builder();
                BosMessageService.sendAndRecordMessage(contentUrl, userIds, rowPkId, "cadm_brewcandidateentry", "cadm_addNominate");
            });
        }
    }

    public Tuple<Boolean, Tuple<String, String>> judgeEnableRevocation(Long brewId, String operationKey) {
        return brewBillDomainService.judgeEnableRevocation(brewId, operationKey);
    }

    public void revokeUpdateBrewBill(List<Long> brewSucIds, String revokeReason) {
        brewBillDomainService.revokeUpdateBrewBill(brewSucIds, revokeReason);
    }

    public List<Long> queryManagePosition(List<Object> positionIds) {
        DynamicObject[] managePosition = ExternalDataService.queryManagePosition(positionIds);
        return Arrays.stream(managePosition).map(p -> p.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> queryManageStandardPosition(List<Object> standardPositionIdList) {
        List<Object> manageStandardPositionPosition = ExternalDataService.queryManageStandardPosition(standardPositionIdList);
        return manageStandardPositionPosition.stream().map(p -> Long.valueOf(String.valueOf(p))).collect(Collectors.toList());
    }

    public List<Long> queryManageJob(List<Object> jobIdList) {
        List<Object> manageJob = ExternalDataService.queryManageJob(jobIdList);
        return manageJob.stream().map(p -> Long.valueOf(String.valueOf(p))).collect(Collectors.toList());
    }

    public Map<String, Object> queryEmpOrgRelByPos(String sign, Long posId) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("sign", sign);
        param.put("signList", Collections.singletonList(posId));
        param.put("qTimeModel", "-1");
        try {
            Date dateOne = HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
            param.put("dateOne", dateOne);
        }
        catch (ParseException e) {
            LOG.error("parse date error", (Throwable)e);
        }
        return ExternalDataService.listEmpOrgRelByPos(param);
    }

    public Map<Long, Object> queryPersonSocialWorkAge(List<Long> personIds) {
        DynamicObject[] personServiceAge = ExternalDataService.queryPersonServiceAge(personIds);
        HashMap<Long, Object> map = new HashMap<Long, Object>(personServiceAge.length);
        for (DynamicObject obj : personServiceAge) {
            long personId = obj.getLong("person.id");
            Object socialWorkAge = obj.get("socialworkage");
            map.put(personId, socialWorkAge);
        }
        return map;
    }

    public Map<Long, Object> queryPersonServiceLength(List<Long> personIds) {
        DynamicObject[] personServiceLength = ExternalDataService.queryPersonServiceLength(personIds);
        HashMap<Long, Object> map = new HashMap<Long, Object>(personServiceLength.length);
        for (DynamicObject obj : personServiceLength) {
            long personId = obj.getLong("person.id");
            Object socialWorkAge = obj.get("servicelength");
            map.put(personId, socialWorkAge);
        }
        return map;
    }

    public Map<Long, List<Map<String, Object>>> queryEmpposorgrels(List<Long> personIds) {
        return ExternalDataService.queryEmpposorgrels(personIds, "1");
    }

    public Map<Long, Map<String, Object>> getEmpJobRelGroupByPersonId(List<Long> employeeIds) {
        List<Map<String, Object>> empJobRelObjs = ExternalDataService.getEmpJobRelObj(employeeIds);
        return empJobRelObjs.stream().collect(Collectors.toMap(empJobRelObj -> (Long)empJobRelObj.get("person"), empJobRelObj -> empJobRelObj, (v1, v2) -> v2));
    }

    public Map<Long, Map<String, Object>> getPersonBaseInfo(List<Long> personIds) {
        HashMap<Long, Map<String, Object>> personBaseInfoMap = new HashMap<Long, Map<String, Object>>(personIds.size());
        for (Long personId : personIds) {
            Map<String, Object> personInfo = ExternalDataService.getPersonBaseInfo(personId);
            personBaseInfoMap.put(personId, personInfo);
        }
        return personBaseInfoMap;
    }

    public DynamicObject getPersonBaseInfoByNumber(String number) {
        DynamicObject dynamicObject = ExternalDataService.getPersonBaseInfoByNumber(number);
        return dynamicObject;
    }

    public DynamicObject[] queryBrewMatchResult(Long brewBillId) {
        return brewBillDomainService.queryBrewMatchResult(brewBillId);
    }

    public DynamicObject[] queryBrewMatchResult(Long brewBillId, Long employeeId) {
        return brewBillDomainService.queryBrewMatchResult(brewBillId, employeeId);
    }

    public void saveBrewMatchData(Long brewBillId, Map<Long, List<BrewMatchBo>> matchData) {
        brewBillDomainService.saveBrewMatchData(brewBillId, matchData);
    }

    public DynamicObject getBrewInfo(long brewingBillId) {
        String brewField = "id,brewdate,brewfollowupper,entryentity.person,entryentity.brewcomment";
        return brewBillDomainService.getBrewBillById(brewField, brewingBillId);
    }

    public DynamicObject[] queryByIds(String selectProperties, List<Long> ids) {
        return brewBillDomainService.queryByIds(selectProperties, ids);
    }

    public DynamicObject[] queryBrewCandidateByBrewIds(String selectProperties, List<Long> brewIds) {
        return brewBillDomainService.queryBrewCandidateByBrewIds(selectProperties, brewIds);
    }

    public DynamicObject[] queryBrewByStatus(String selectProperties, List<String> statusList) {
        return brewBillDomainService.queryBrewByStatus(selectProperties, statusList);
    }

    public void updateBrewHandleInfo() {
        brewBillDomainService.updateBrewHandleTimeTask();
        brewBillDomainService.updateBrewHandlerTask();
    }
}

