/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.service;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.domain.resume.service.CadreResumeDomainService;

public class CadreResumeApplicationService {
    private static final Log LOG = LogFactory.getLog(CadreResumeApplicationService.class);
    private static final CadreResumeDomainService CADRE_RESUME_DOMAIN_SERVICE = ServiceFactory.getService(CadreResumeDomainService.class);

    public DynamicObject newDynamic() {
        return CADRE_RESUME_DOMAIN_SERVICE.newDynamic();
    }

    public DynamicObjectCollection newEducationEntry(DynamicObject resume) {
        return CADRE_RESUME_DOMAIN_SERVICE.emptyEducationEntry(resume);
    }

    public DynamicObjectCollection newWorkEntry(DynamicObject resume) {
        return CADRE_RESUME_DOMAIN_SERVICE.emptyWorkEntry(resume);
    }

    public DynamicObjectCollection newFamilyEntry(DynamicObject resume) {
        return CADRE_RESUME_DOMAIN_SERVICE.emptyFamilyEntry(resume);
    }

    public DynamicObjectCollection emptyEntry(DynamicObject resume, String entryEntity) {
        return CADRE_RESUME_DOMAIN_SERVICE.emptyEntry(resume, entryEntity);
    }

    public DynamicObject[] queryByPersonId(Long personId) {
        return CADRE_RESUME_DOMAIN_SERVICE.queryByPersonId(personId);
    }

    public void batchSave(DynamicObject[] dynamicObject) {
        ArrayList addList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        Arrays.stream(dynamicObject).forEach(dynamic -> {
            long id = dynamic.getLong("id");
            if (0L == id) {
                addList.add(dynamic);
            } else {
                updateList.add(dynamic);
            }
            this.setSeq((DynamicObject)dynamic, "learnentryentity", true);
            this.setSeq((DynamicObject)dynamic, "workentryentity", true);
            this.setSeq((DynamicObject)dynamic, "familyentryentity", true);
            this.setSeq((DynamicObject)dynamic, "adminorgrightentity", false);
        });
        CADRE_RESUME_DOMAIN_SERVICE.batchSave(addList.toArray(new DynamicObject[0]));
        CADRE_RESUME_DOMAIN_SERVICE.batchSave(updateList.toArray(new DynamicObject[0]));
    }

    public void commonBatchSave(DynamicObject[] dynamicObject) {
        CADRE_RESUME_DOMAIN_SERVICE.batchSave(dynamicObject);
    }

    private void setSeq(DynamicObject dynamic, String entryName, boolean ifCareSave) {
        DynamicObjectCollection entryEntity = dynamic.getDynamicObjectCollection(entryName);
        if (ifCareSave && dynamic.getBoolean("usersaved")) {
            return;
        }
        LocaleString toNow = ResManager.getLocaleString((String)"\u81f3\u4eca", (String)"CadreResumeApplicationService_0", (String)"tdc-cadm-business");
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            AtomicInteger index = new AtomicInteger(1);
            entryEntity.forEach(obj -> {
                obj.set("seq", (Object)index.get());
                index.addAndGet(1);
                if ("learnentryentity".equals(entryName)) {
                    Date gradutionDate = obj.getDate("gradutiondate");
                    try {
                        if (null == gradutionDate || HRDateTimeUtils.dayEquals((Date)gradutionDate, (Date)HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd"))) {
                            obj.set("learnchangevalue", (Object)toNow);
                        } else {
                            obj.set("learnchangevalue", (Object)HRDateTimeUtils.format((Date)gradutionDate, (String)"yyyy-MM-dd"));
                        }
                    }
                    catch (ParseException e) {
                        LOG.error("learnentryentity parse max date error ", (Throwable)e);
                    }
                }
                if ("workentryentity".equals(entryName)) {
                    Date endDate = obj.getDate("enddate");
                    try {
                        if (null == endDate || HRDateTimeUtils.dayEquals((Date)endDate, (Date)HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd"))) {
                            obj.set("workchangevalue", (Object)toNow);
                        } else {
                            obj.set("workchangevalue", (Object)HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd"));
                        }
                    }
                    catch (ParseException e) {
                        LOG.error("workentryentity parse max date error ", (Throwable)e);
                    }
                }
            });
        }
    }

    public DynamicObject[] getNeedUpdateManagerLenData() {
        return CADRE_RESUME_DOMAIN_SERVICE.getNeedUpdateManagerLenData();
    }

    public DynamicObject queryEntryEntityById(String selectProperties, Object pkId) {
        return CADRE_RESUME_DOMAIN_SERVICE.queryEntryEntityById(selectProperties, pkId);
    }

    public DynamicObject[] queryBills(String selectProperties, List<Object> pkIds) {
        return CADRE_RESUME_DOMAIN_SERVICE.queryBills(selectProperties, pkIds);
    }

    public DynamicObject queryMarryStatus(Object pkId) {
        return CADRE_RESUME_DOMAIN_SERVICE.queryMarryStatus(pkId);
    }

    public DynamicObject getWriteAndApproveInfo(Object pkId) {
        return CADRE_RESUME_DOMAIN_SERVICE.getWriteAndApproveInfo(pkId);
    }

    public DynamicObject[] queryByPersonIds(List<Long> personIdList) {
        return CADRE_RESUME_DOMAIN_SERVICE.queryByPersonIds(personIdList);
    }
}

