/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.url.UrlService;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamCoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.examine.service.ExamineBillDomainService;
import kd.tdc.cadm.bussiness.domain.examine.service.ExamineCoopDomainService;
import kd.tdc.cadm.bussiness.domain.nominate.service.ActivityBillCommonDomainService;
import kd.tdc.cadm.bussiness.util.UrlBuilder;

public class ExamCoopBillApplicationService {
    private static final ExamineCoopDomainService examineCoopDomainService = ServiceFactory.getService(ExamineCoopDomainService.class);
    private static final ExamineBillDomainService examineBillDomainService = ServiceFactory.getService(ExamineBillDomainService.class);
    private static final ActivityBillCommonDomainService billCommonDomainService = ServiceFactory.getService(ActivityBillCommonDomainService.class);

    public DynamicObject queryExamCoopBillById(String selectedProperties, Long id) {
        return examineCoopDomainService.queryExamCoopById(selectedProperties, id);
    }

    public DynamicObject queryExamResultPlanByExamResultPlanId(Long examResultPlanId) {
        String selectProperties = "name,number,entryentity.result,entryentity.resultdesc";
        return examineBillDomainService.queryExamResultPlanByExamResultPlanId(selectProperties, examResultPlanId);
    }

    public void urge(Long examCoopId) {
        DynamicObject examCoop = examineCoopDomainService.urge(examCoopId);
        Long nominateId = examCoop.getLong("nominatebill.id");
        List<Long> handlerIds = billCommonDomainService.getActivityHandlerIds(examCoop, "coophandler");
        String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_examinecooperate").setParameter("formPkId", String.valueOf(examCoopId)).builder();
        BosMessageService.sendTemplateMessage(contentUrl, handlerIds, nominateId, "cadm_examinecooperate", "cadm_urgeexam", examCoopId);
    }

    public DynamicObject startCoop(String coopType, Long coopId) {
        DynamicObject examCoop = examineCoopDomainService.startCoop(coopType, coopId);
        return examCoop;
    }

    public DynamicObject[] queryExamCoopByArrangeRecordId(Long recordId) {
        return examineCoopDomainService.queryExamCoopByArrangeRecordId(recordId);
    }

    public DynamicObject queryExamCoopById(Long id) {
        return examineCoopDomainService.queryExamCoopById(id);
    }

    public void updateExamCoop(DynamicObject examCoop) {
        examineCoopDomainService.updateExamCoop(examCoop);
    }

    public void terminationUnHandledExamCoop(List<Long> examineIds, ExamCoopStatusEnum examCoopStatusEnum, String msgTempNumber) {
        examineCoopDomainService.terminationUnHandledExamCoop(examineIds, examCoopStatusEnum, msgTempNumber);
    }

    public DynamicObject[] adjustCoopsBySeq(DynamicObject[] coops) {
        if (coops == null || coops.length == 0) {
            return coops;
        }
        DynamicObject[] coopsSeq = new DynamicObject[coops.length];
        long examPlanId = coops[0].getLong("examplan.id");
        String selectProperties = "examplanentry.itemgroup,examplanentry.seq";
        DynamicObject[] planEntry = examineBillDomainService.queryExamPlanEntryById(selectProperties, examPlanId);
        Map<Integer, Long> seqMap = Arrays.stream(planEntry).collect(Collectors.toMap(item -> item.getInt("examplanentry.seq"), item -> item.getLong("examplanentry.itemgroup")));
        int i = 0;
        block0: for (Long value : seqMap.values()) {
            for (DynamicObject coop : coops) {
                long itemgroupId = coop.getLong("itemgroup.boid");
                if (itemgroupId != value) continue;
                coopsSeq[i++] = coop;
                continue block0;
            }
        }
        coops = coopsSeq;
        return coops;
    }
}

