/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.application.external.CallRuleEngineService;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.bussiness.domain.basedata.service.AppointBaseDataDomainService;
import kd.tdc.cadm.bussiness.domain.examine.entityservice.ExamArrangeHisEntityService;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamCoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.examine.service.ExamineBillDomainService;
import kd.tdc.cadm.bussiness.domain.examine.service.ExamineCoopDomainService;

public class ExamineBillApplicationService {
    private static final Log logger = LogFactory.getLog(ExamineBillApplicationService.class);
    private static final NominateApplicationService nominateApplicationService = ServiceFactory.getService(NominateApplicationService.class);
    private static final ExamineBillDomainService examineBillDomainService = ServiceFactory.getService(ExamineBillDomainService.class);
    private static final ExamineCoopDomainService examineCoopDomainService = ServiceFactory.getService(ExamineCoopDomainService.class);
    private static final CallRuleEngineService ruleEngineService = ServiceFactory.getService(CallRuleEngineService.class);
    private static final AppointBaseDataDomainService baseDataDomainService = ServiceFactory.getService(AppointBaseDataDomainService.class);
    private static final ActvGenerateExtService ACTV_SERVICE = ServiceFactory.getService(ActvGenerateExtService.class);
    private static final ExamArrangeHisEntityService examArrangeHisEntityService = ServiceFactory.getService(ExamArrangeHisEntityService.class);

    public void rejectToPreviousBill(DynamicObject[] examineBills, String opinion) {
        List<Long> insIds = Arrays.stream(examineBills).map(item -> item.getLong("instanceid")).collect(Collectors.toList());
        ACTV_SERVICE.batchRejectTask(insIds, opinion);
        examineBillDomainService.rejectBill(examineBills);
        List<Long> examineIds = Arrays.stream(examineBills).map(item -> item.getLong("id")).collect(Collectors.toList());
        examineCoopDomainService.terminationUnHandledExamCoop(examineIds, ExamCoopStatusEnum.TERMINATED, "cadm_stopexam");
    }

    public DynamicObject[] queryExamineBillById(String selectProperties, List<Object> pkIds) {
        return examineBillDomainService.queryExamineBillById(selectProperties, pkIds);
    }

    public DynamicObject queryOne(String selectProperties, Object pkId) {
        return examineBillDomainService.queryOne(selectProperties, pkId);
    }

    public List<Long> queryExamPlanIds(Long id) {
        DynamicObject bill = examineBillDomainService.queryOriginalOneById("matchactv,nominatebill", id);
        long activityId = bill.getLong("matchactv");
        long nominateBillId = bill.getLong("nominatebill");
        DynamicObject nominateBill = nominateApplicationService.loadSingle(nominateBillId);
        long activitySchemeId = nominateBill.getLong("actvplanhis_id");
        Map<String, String> domainParams = ACTV_SERVICE.getActivitySchemeDomainParams(activitySchemeId, activityId);
        logger.info("activitySchemeId:{},activityId:{},domainParams:{}", new Object[]{activitySchemeId, activityId, domainParams});
        String scene = domainParams.get("scene");
        String policy = domainParams.get("policy");
        return ruleEngineService.matchPlan(scene, policy, nominateBill);
    }

    public DynamicObject[] queryExamineCoopById(String selectProperties, Long examineId) {
        DynamicObject examine = examineBillDomainService.queryOriginalOneById("latestarrangerecord", examineId);
        long latestArrangeRecord = examine.getLong("latestarrangerecord");
        return this.queryExamineCoopByArrangeRecordId(selectProperties, latestArrangeRecord);
    }

    public DynamicObject[] queryExamineCoopByArrangeRecordId(String selectProperties, Long arrangeRecordId) {
        return examineCoopDomainService.queryExamineCoopByArrangeRecordId(selectProperties, arrangeRecordId);
    }

    public void startExam(DynamicObject examineBill, Map<String, List<Long>> intervieweeMap) {
        long examineId = examineBill.getLong("id");
        DynamicObject nominateBill = examineBill.getDynamicObject("nominatebill");
        DynamicObject examPlan = examineBill.getDynamicObject("examplan");
        String selectProperties = "examplanentry.itemgroup,examplanentry.planexamitem,examplanentry.planexamway,examplanentry.handlerpolicy,examplanentry.handlerscene,examplanentry.examsla,examplanentry.addmode,examplanentry.groupmember,itemremarkentry.groupname,itemremarkentry.examitem,itemremarkentry.itemremark,examresultplan.sourcevid";
        examPlan = examineBillDomainService.queryExamPlanByExamPlanId(selectProperties, examPlan.getLong("id"));
        Map<String, List<Long>> handlerMap = this.getExamCoopHandlerMap(examPlan, nominateBill);
        DynamicObject examineHis = (DynamicObject)examArrangeHisEntityService.saveByExamineBill(examineBill.getLong("id"), examPlan.getLong("id"));
        examineCoopDomainService.terminationUnHandledExamCoop(Lists.newArrayList((Object[])new Long[]{examineId}), ExamCoopStatusEnum.DISCARD, "cadm_closeexam");
        long examineArrangeRecordId = examineHis.getLong("id");
        examArrangeHisEntityService.terminationExamHis(examineId, examineArrangeRecordId);
        examineCoopDomainService.initData(examineBill, examPlan, handlerMap, intervieweeMap, examineArrangeRecordId);
        examineBill.set("latestarrangerecord", (Object)examineArrangeRecordId);
        examineBillDomainService.updateData(new DynamicObject[]{examineBill});
    }

    public Map<String, List<Long>> getExamCoopHandlerMap(DynamicObject examPlan, DynamicObject nominateBill) {
        Map<String, Object> resultMap = ruleEngineService.matchCoopHandler(examPlan, nominateBill);
        HashMap<String, List<Long>> handlerMap = new HashMap<String, List<Long>>(resultMap.size());
        for (Map.Entry<String, Object> entrySet : resultMap.entrySet()) {
            ArrayList handlers;
            String id = entrySet.getKey();
            Object handlerDys = entrySet.getValue();
            if (handlerDys instanceof DynamicObjectCollection) {
                handlers = ((DynamicObjectCollection)handlerDys).stream().map(value -> value.getLong("id")).collect(Collectors.toList());
                handlerMap.put(id, handlers);
            }
            if (!(handlerDys instanceof DynamicObject)) continue;
            handlers = Lists.newArrayList((Object[])new Long[]{((DynamicObject)handlerDys).getLong("id")});
            handlerMap.put(id, handlers);
        }
        return handlerMap;
    }

    public DynamicObject queryExamPlanByExamPlanId(Long examPlanId) {
        String selectProperties = "examplanentry.itemgroup,examplanentry.seq,examplanentry.planexamitem,examplanentry.handlerpolicy,examplanentry.handlerscene,examplanentry.addmode,examplanentry.groupmember";
        return examineBillDomainService.queryExamPlanByExamPlanId(selectProperties, examPlanId);
    }

    public void updateExamCoopRatio(Long examineId) {
        Long latestArrangeId = this.getLatestArrangeId(examineId);
        DynamicObject[] examCoops = examineCoopDomainService.queryExamineCoopByArrangeRecordId("handler", latestArrangeId);
        examineBillDomainService.updateExamCoopRatio(examineId, examCoops);
    }

    public DynamicObject[] getExamItem() {
        return baseDataDomainService.getExamItemData();
    }

    public DynamicObject getExamInfo(long appointId) {
        DynamicObject[] dynamicObjects = examineBillDomainService.queryOriginalOneByNominateId("id,examplan.id,examplan.name,examcomment", appointId);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            return dynamicObjects[0];
        }
        return null;
    }

    public long getExamPlanResultByExamPlanId(Long examPlanId) {
        String selectProperties = "examresultplan.id";
        DynamicObject dynamicObject = examineBillDomainService.queryExamPlanByExamPlanId(selectProperties, examPlanId);
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            return 0L;
        }
        return dynamicObject.getLong("examresultplan.id");
    }

    public void updateData(DynamicObject[] examineBills) {
        examineBillDomainService.updateData(examineBills);
    }

    public DynamicObject getExamArrangeHisById(String selectProperties, long id) {
        return examArrangeHisEntityService.getExamArrangeHisById(selectProperties, id);
    }

    public Long getLatestArrangeId(Long examId) {
        DynamicObject latestArrange = examArrangeHisEntityService.getLatestArrange(examId);
        if (null == latestArrange) {
            return 0L;
        }
        return latestArrange.getLong("id");
    }

    public DynamicObject[] queryByPermission(String selectProperties, long userId, List<String> statusList, String permItemId) {
        return examineBillDomainService.queryByPermission(selectProperties, userId, statusList, permItemId);
    }
}

