/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.application.external.CallRuleEngineService;
import kd.tdc.cadm.bussiness.application.service.ExpedCoopBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.domain.exped.entityservice.ExpedArrangeHisEntityService;
import kd.tdc.cadm.bussiness.domain.exped.enums.ExpedCoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.exped.enums.ExpedStatusEnum;
import kd.tdc.cadm.bussiness.domain.exped.service.ExpedBillDomainService;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.bussiness.util.UrlBuilder;

public class ExpedBillApplicationService {
    private static final Log LOG = LogFactory.getLog(ExpedBillApplicationService.class);
    private static final HRBaseServiceHelper EXPLORE = new HRBaseServiceHelper("cadm_expedbill");
    private static final HRBaseServiceHelper EXPLORE_PLAN = new HRBaseServiceHelper("cadm_examplan");
    private static final CallRuleEngineService ruleEngineService = ServiceFactory.getService(CallRuleEngineService.class);
    private static final ExpedCoopBillApplicationService expedCoopService = ServiceFactory.getService(ExpedCoopBillApplicationService.class);
    private TenureApplicationService tenureService = new TenureApplicationService();
    private static final ExpedArrangeHisEntityService expedArrangeHisEntityService = ServiceFactory.getService(ExpedArrangeHisEntityService.class);
    private static final ExpedBillDomainService expedBillDomainService = ServiceFactory.getService(ExpedBillDomainService.class);
    private static final CadmFormService cadmFormService = ServiceFactory.getService(CadmFormService.class);

    public DynamicObject queryExpedOneById(String selectFields, Object expedId) {
        return EXPLORE.queryOne(selectFields, expedId);
    }

    public DynamicObject[] queryExpedBillByIds(String selectProperties, List<Long> pkIds) {
        return expedBillDomainService.queryExpedBillByIds(selectProperties, pkIds);
    }

    public DynamicObject[] queryExpedByTenure(long tenureId) {
        return EXPLORE.queryOriginalArray("id", new QFilter[]{new QFilter("tenure", "=", (Object)tenureId)}, "createtime desc");
    }

    public DynamicObject queryNewestExpedOneByTenureId(String selectFields, Object tenureId) {
        QFilter tenureIdFilter = new QFilter("tenure", "=", tenureId);
        return EXPLORE.queryOne(selectFields, new QFilter[]{tenureIdFilter}, "createtime desc");
    }

    public DynamicObject queryExpedOriOneById(String selectFields, Object expedId) {
        return EXPLORE.queryOriginalOne(selectFields, expedId);
    }

    public void update(DynamicObject expedDy) {
        EXPLORE.updateDataOne(expedDy);
    }

    public DynamicObject queryExamPlanByExamPlanId(Long examPlanId) {
        String selectProperties = "examplanentry.itemgroup,examplanentry.planexamitem,examplanentry.handlerpolicy,examplanentry.handlerscene,examplanentry.addmode,examplanentry.groupmember";
        return EXPLORE_PLAN.queryOne(selectProperties, (Object)examPlanId);
    }

    public Map<String, List<Long>> getExpedCoopHandlerMap(DynamicObject examPlan, DynamicObject tenureDy) {
        Map<String, Object> resultMap = ruleEngineService.matchCoopHandler(examPlan, tenureDy);
        HashMap<String, List<Long>> handlerMap = new HashMap<String, List<Long>>(resultMap.size());
        for (Map.Entry<String, Object> entrySet : resultMap.entrySet()) {
            ArrayList handlers;
            String id = entrySet.getKey();
            Object handlerDys = entrySet.getValue();
            if (handlerDys instanceof DynamicObjectCollection) {
                handlers = ((DynamicObjectCollection)handlerDys).stream().map(value -> value.getLong("id")).collect(Collectors.toList());
                handlerMap.put(id, handlers);
            }
            if (!(handlerDys instanceof DynamicObject)) continue;
            handlers = Lists.newArrayList((Object[])new Long[]{((DynamicObject)handlerDys).getLong("id")});
            handlerMap.put(id, handlers);
        }
        return handlerMap;
    }

    public void startExam(DynamicObject expedBill, Map<String, List<Long>> intervieweeMap) {
        long expedId = expedBill.getLong("id");
        DynamicObject tenureBill = this.tenureService.loadSingler(expedBill.get("tenure.id"));
        DynamicObject expedPlan = expedBill.getDynamicObject("expedplan");
        String selectProperties = "examplanentry.itemgroup,examplanentry.planexamitem,examplanentry.planexamway,examplanentry.handlerpolicy,examplanentry.handlerscene,examplanentry.examsla,examplanentry.addmode,examplanentry.groupmember,itemremarkentry.groupname,itemremarkentry.examitem,itemremarkentry.itemremark,examresultplan.sourcevid";
        expedPlan = EXPLORE_PLAN.queryOne(selectProperties, (Object)expedPlan.getLong("id"));
        tenureBill.set("creator", expedBill.get("creator"));
        Map<String, List<Long>> handlerMap = this.getExpedCoopHandlerMap(expedPlan, tenureBill);
        DynamicObject expedHis = (DynamicObject)expedArrangeHisEntityService.saveByExpedBill(expedBill.getLong("id"), expedPlan.getLong("id"));
        expedCoopService.terminateCoopBIll(expedBill.getLong("id"));
        long expedArrangeRecordId = expedHis.getLong("id");
        expedArrangeHisEntityService.terminationExpedHis(expedId, expedArrangeRecordId);
        expedCoopService.initData(expedBill, expedPlan, handlerMap, intervieweeMap, expedArrangeRecordId);
        expedBill.set("latestarrangerecord", (Object)expedArrangeRecordId);
        SaveServiceHelper.update((DynamicObject)expedBill);
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("expedstatus", ExpedStatusEnum.IN_EXAMINE.getNumber());
        paramMap.put("expedcoopratio", " ");
        paramMap.put("expedresult", " ");
        this.tenureService.updateExpedBillInfo(tenureBill.getLong("id"), expedBill.getLong("id"), paramMap);
    }

    public void updateExamCoopRatio(Long expedId) {
        Long arrangeId = this.getLatestArrangeId(expedId);
        DynamicObject[] expedCoops = expedCoopService.queryExpedCoopByArrangeRecordId("coopstatus", arrangeId);
        long handlerNum = Stream.of(expedCoops).filter(expedCoop -> ExpedCoopStatusEnum.COMPLETED.getNumber().equals(expedCoop.getString("coopstatus"))).count() * 100L;
        BigDecimal ratio = new BigDecimal(handlerNum).divide(new BigDecimal(expedCoops.length), 1, 4);
        String ratioStr = ratio.toString() + "%";
        DynamicObject expedBill = this.queryExpedOneById("expedcoopratio,tenure.id", expedId);
        String expedCoopRatio = ratioStr.replace(".0", "");
        expedBill.set("expedcoopratio", (Object)expedCoopRatio);
        this.update(expedBill);
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("expedcoopratio", expedCoopRatio);
        this.tenureService.updateExpedBillInfo(expedBill.get("tenure.id"), expedId, paramMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeOrTerminateExpedBill(ExpedStatusEnum expedStatusEnum, Object terminationReason, Object tenureBillId, Long expedId, long handlerUserId) {
        DynamicObject expedDy;
        DynamicObject tenureDy = this.tenureService.queryTenureOneById("id,expedstatus,expedresult,modifier,modifytime", tenureBillId);
        Date currDate = new Date();
        String selectFields = "id,creator,expedstatus,expedcoopratio,expedresult,modifier,modifytime,handler,handlertime,terminator,terminatedate,terminatereason";
        DynamicObject newestExpedDy = this.queryNewestExpedOneByTenureId(selectFields, tenureDy.getLong("id"));
        boolean isUpdateTenure = expedId == 0L || newestExpedDy.getLong("id") == expedId.longValue();
        DynamicObject dynamicObject = expedDy = isUpdateTenure ? newestExpedDy : this.queryExpedOneById(selectFields, expedId);
        if (expedStatusEnum == ExpedStatusEnum.COMPLETE) {
            expedDy.set("handler", (Object)handlerUserId);
            expedDy.set("handlertime", (Object)currDate);
            tenureDy.set("expedresult", (Object)expedDy.getString("expedresult"));
        } else if (expedStatusEnum == ExpedStatusEnum.TERMINATED) {
            expedDy.set("terminator", (Object)handlerUserId);
            expedDy.set("terminatedate", (Object)currDate);
            expedDy.set("terminatereason", terminationReason);
        }
        tenureDy.set("expedstatus", (Object)expedStatusEnum.getNumber());
        tenureDy.set("modifier", (Object)handlerUserId);
        tenureDy.set("modifytime", (Object)currDate);
        expedDy.set("expedstatus", (Object)expedStatusEnum.getNumber());
        expedDy.set("modifier", (Object)handlerUserId);
        expedDy.set("modifytime", (Object)currDate);
        String coopRatio = expedDy.getString("expedcoopratio");
        if (HRStringUtils.isNotEmpty((String)coopRatio) && coopRatio.equals("-")) {
            expedDy.set("expedcoopratio", (Object)" ");
        }
        DynamicObject[] expedCoopData = expedCoopService.queryNotAbandonedDataByExpedId("id,coopstatus,coophandler,modifier,modifytime", expedDy.getLong("id"));
        DynamicObjectCollection expedCoopColl = new DynamicObjectCollection();
        Arrays.stream(expedCoopData).forEach(expedCoopDy -> {
            if (ExpedCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(expedCoopDy.getString("coopstatus"))) {
                expedCoopDy.set("coopstatus", (Object)ExpedCoopStatusEnum.TERMINATED.getNumber());
                expedCoopDy.set("modifier", (Object)handlerUserId);
                expedCoopDy.set("modifytime", (Object)currDate);
                expedCoopColl.add(expedCoopDy);
            }
        });
        try (TXHandle txhandle = TX.required();){
            if (isUpdateTenure) {
                this.tenureService.update(tenureDy);
            }
            this.update(expedDy);
            if (!CollectionUtils.isEmpty((Collection)expedCoopColl)) {
                expedCoopService.update((DynamicObject[])expedCoopColl.toArray((Object[])new DynamicObject[0]));
            }
        }
        if (expedStatusEnum == ExpedStatusEnum.TERMINATED) {
            List<Long> creatorId = Collections.singletonList(expedDy.getLong("creator.id"));
            String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_expedbill").setParameter("formPkId", String.valueOf(expedId)).builder();
            String messageTemplateNumber = "cadm_stopexped";
            BosMessageService.sendTemplateMessage(contentUrl, creatorId, expedId, "cadm_expedbill", messageTemplateNumber, expedId);
        }
        expedCoopColl.forEach(expedCoopDy -> {
            long expedCoopId = expedCoopDy.getLong("id");
            List<Long> handlerIds = expedCoopDy.getDynamicObjectCollection("coophandler").stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toList());
            String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_expedcooperate").setParameter("formPkId", String.valueOf(expedCoopId)).builder();
            String messageTemplateNumber = expedStatusEnum == ExpedStatusEnum.COMPLETE ? "cadm_finishexplore" : "cadm_stopexplore";
            BosMessageService.sendTemplateMessage(contentUrl, handlerIds, expedCoopId, "cadm_expedcooperate", messageTemplateNumber, expedCoopId);
        });
    }

    public DynamicObject[] queryOriByTenureIdOrderByTime(String selectFields, Object pkValue) {
        return EXPLORE.queryOriginalArray(selectFields, new QFilter[]{new QFilter("tenure", "=", pkValue)}, "createtime desc");
    }

    public DynamicObject getExpedArrangeHisById(String selectProperties, long id) {
        return expedArrangeHisEntityService.getExpedArrangeHisById(selectProperties, id);
    }

    public DynamicObject queryOne(String selectProperties, long id) {
        return expedBillDomainService.queryOne(selectProperties, id);
    }

    public Long getLatestArrangeId(Long expedId) {
        DynamicObject latestArrange = expedArrangeHisEntityService.getLatestArrange(expedId);
        if (null == latestArrange) {
            return 0L;
        }
        return latestArrange.getLong("id");
    }

    public DynamicObject[] queryByExpedStatus(String selectProperties, List<String> statusList, Long personId) {
        return expedBillDomainService.queryByExpedStatus(selectProperties, statusList, personId);
    }

    public DynamicObject[] queryByPersonId(String selectProperties, Long personId) {
        return expedBillDomainService.queryByPersonId(selectProperties, personId);
    }

    public DynamicObject[] queryByPersonIds(String selectProperties, List<Long> personIds) {
        return expedBillDomainService.queryByPersonIds(selectProperties, personIds);
    }

    public void handleDepartCadresExpedBill(Long personId, String terminationParam) {
        DynamicObject[] expedBills = this.queryByExpedStatus("id,tenure,creator,person,departpersonid", Collections.singletonList(ExpedStatusEnum.IN_EXAMINE.getNumber()), personId);
        if (expedBills.length == 0) {
            return;
        }
        Arrays.stream(expedBills).forEach(p -> p.set("departpersonid", (Object)personId));
        expedBillDomainService.updateData(expedBills);
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("type", "list");
        params.put("dataSource", "departMsg");
        params.put("personId", String.valueOf(personId));
        if ("2".equals(terminationParam)) {
            List<Long> creatorIds = Arrays.stream(expedBills).map(p -> p.getLong("creator.id")).collect(Collectors.toList());
            DynamicObject expedBill = expedBills[0];
            long expedId = expedBill.getLong("id");
            String personNumber = expedBill.getString("person.number");
            params.put("personNumber", personNumber);
            String personName = expedBill.getString("person.name");
            params.put("personName", personName);
            BosMessageService.sendDepartMessage("cadm_expedbill", params, creatorIds, expedId, "cadm_zzlzyj");
        } else if ("1".equals(terminationParam)) {
            LocaleString terminationReason = ResManager.getLocaleString((String)"\u5458\u5de5\u5df2\u79bb\u804c", (String)"NominateApplicationService_1", (String)"tdc-cadm-business");
            for (DynamicObject expedBill : expedBills) {
                Long tenureBillId = expedBill.getLong("tenure.id");
                if (tenureBillId == 0L) continue;
                Long expedBillId = expedBill.getLong("id");
                this.completeOrTerminateExpedBill(ExpedStatusEnum.TERMINATED, String.valueOf(terminationReason), tenureBillId, expedBillId, 1L);
            }
            LOG.info("Automatically complete the cadre termination process.");
        }
    }

    public void handleWithdrawDepartCadresExpedBill(Long personId) {
        DynamicObject[] expedBills = this.queryByPersonId("id,tenure,creator,person,departpersonid", personId);
        if (expedBills.length == 0) {
            return;
        }
        List<Long> creatorIds = Arrays.stream(expedBills).filter(p -> p.get("departpersonid") != null && p.getLong("departpersonid.id") != 0L).map(p -> p.getLong("creator.id")).distinct().collect(Collectors.toList());
        Arrays.stream(expedBills).forEach(p -> p.set("departpersonid", (Object)0L));
        expedBillDomainService.updateData(expedBills);
        if (creatorIds.size() > 0) {
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("type", "list");
            params.put("dataSource", "withdrawDepartMsg");
            params.put("personId", String.valueOf(personId));
            DynamicObject expedBill = expedBills[0];
            long expedId = expedBill.getLong("id");
            String personNumber = expedBill.getString("person.number");
            params.put("personNumber", personNumber);
            String personName = expedBill.getString("person.name");
            params.put("personName", personName);
            BosMessageService.sendDepartMessage("cadm_expedbill", params, creatorIds, expedId, "cadm_zzkclzch");
        }
    }

    public void setDefaultReasonByDepart(AbstractFormPlugin plugin) {
        ListSelectedRowCollection selectedRows;
        if (plugin == null) {
            return;
        }
        IFormView view = plugin.getView();
        List<Long> personIdList = new ArrayList<Long>(10);
        if (view instanceof ListView && (selectedRows = ((ListView)view).getSelectedRows()).size() > 0) {
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            List<Long> ids = Arrays.stream(primaryKeyValues).filter(obj -> obj instanceof Long).map(obj -> (Long)obj).collect(Collectors.toList());
            DynamicObject[] bills = this.queryExpedBillByIds("person", ids);
            personIdList = Arrays.stream(bills).map(p -> p.getLong("person.id")).collect(Collectors.toList());
        }
        if (view instanceof BillView) {
            IDataModel model = view.getModel();
            Long personId = (Long)model.getValue("person_id");
            personIdList = Collections.singletonList(personId);
        }
        cadmFormService.setTerminationReasonParam(plugin, personIdList);
    }
}

