/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.service;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.domain.exped.enums.ExpedCoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.exped.service.ExpedBillDomainService;
import kd.tdc.cadm.bussiness.domain.exped.service.ExpedCoopDomainService;
import kd.tdc.cadm.bussiness.util.UrlBuilder;

public class ExpedCoopBillApplicationService {
    private static final ExpedCoopDomainService EXPED_COOP_DOMAIN_SERVICE = ServiceFactory.getService(ExpedCoopDomainService.class);
    private static final ExpedBillDomainService expedBillDomainService = ServiceFactory.getService(ExpedBillDomainService.class);
    private static final HRBaseServiceHelper EXPLORE_COOP = new HRBaseServiceHelper("cadm_expedcooperate");

    public DynamicObject queryExpedCoopBillById(String selectedProperties, Long id) {
        return EXPED_COOP_DOMAIN_SERVICE.queryExpedCoopById(selectedProperties, id);
    }

    public DynamicObject[] queryNotAbandonedDataByExpedId(String selectedProperties, Object expedId) {
        DynamicObject exped = expedBillDomainService.queryOne("latestarrangerecord", Long.parseLong(expedId.toString()));
        if (exped == null) {
            return new DynamicObject[0];
        }
        long latestArrangeRecord = exped.getLong("latestarrangerecord");
        return this.queryExpedCoopByArrangeRecordId(selectedProperties, latestArrangeRecord);
    }

    public DynamicObject[] queryExpedCoopByArrangeRecordId(String selectProperties, Long arrangeRecordId) {
        return EXPED_COOP_DOMAIN_SERVICE.queryExpedCoopByArrangeRecordId(selectProperties, arrangeRecordId);
    }

    public void update(DynamicObject[] dynamicObjects) {
        EXPLORE_COOP.updateDatas(dynamicObjects);
    }

    public DynamicObject queryExamResultPlanByExamResultPlanId(Long examResultPlanId) {
        String selectProperties = "name,number,entryentity.result,entryentity.resultdesc";
        return expedBillDomainService.queryExamResultPlanByExamResultPlanId(selectProperties, examResultPlanId);
    }

    public void urge(Long expedCoopId) {
        DynamicObject expedCoopDy = EXPED_COOP_DOMAIN_SERVICE.urge(expedCoopId);
        List<Long> handlerIds = expedCoopDy.getDynamicObjectCollection("coophandler").stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toList());
        String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_expedcooperate").setParameter("formPkId", String.valueOf(expedCoopId)).builder();
        BosMessageService.sendTemplateMessage(contentUrl, handlerIds, expedCoopId, "cadm_expedcooperate", "cadm_urgeexplore", expedCoopId);
    }

    public List<DynamicObject> initData(DynamicObject expedBill, DynamicObject examPlan, Map<String, List<Long>> handlerMap, Map<String, List<Long>> intervieweeMap, long expedArrangeRecordId) {
        return EXPED_COOP_DOMAIN_SERVICE.initData(expedBill, examPlan, handlerMap, intervieweeMap, expedArrangeRecordId);
    }

    public void terminateCoopBIll(long expedId) {
        DynamicObject[] expedCoopData = this.queryNotAbandonedDataByExpedId("id,coopstatus,coophandler,modifier,modifytime", expedId);
        long currUserId = RequestContext.get().getCurrUserId();
        Date currDate = new Date();
        for (DynamicObject expedCoopDy : expedCoopData) {
            String coopStatus = expedCoopDy.getString("coopstatus");
            if (ExpedCoopStatusEnum.ABANDONED.getNumber().equals(coopStatus) || ExpedCoopStatusEnum.NOT_START.getNumber().equals(coopStatus)) continue;
            expedCoopDy.set("coopstatus", (Object)ExpedCoopStatusEnum.ABANDONED.getNumber());
            expedCoopDy.set("modifier", (Object)currUserId);
            expedCoopDy.set("modifytime", (Object)currDate);
            List<Long> userIds = expedCoopDy.getDynamicObjectCollection("coophandler").stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toList());
            Long expedCoopId = expedCoopDy.getLong("id");
            String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_expedcooperate").setParameter("formPkId", String.valueOf(expedCoopId)).builder();
            BosMessageService.sendTemplateMessage(contentUrl, userIds, expedCoopId, "cadm_expedcooperate", "cadm_discardexplore", expedCoopId);
        }
        this.update(expedCoopData);
    }

    public DynamicObject startCoop(String coopType, Long expedCoopId) {
        DynamicObject expedCoop = EXPED_COOP_DOMAIN_SERVICE.startCoop(coopType, expedCoopId);
        return expedCoop;
    }

    public DynamicObject queryExpedCoopById(Long id) {
        return EXPED_COOP_DOMAIN_SERVICE.queryExpedCoopById(id);
    }

    public DynamicObject[] adjustCoopsBySeq(DynamicObject[] coops) {
        if (coops == null || coops.length == 0) {
            return coops;
        }
        DynamicObject[] coopsSeq = new DynamicObject[coops.length];
        long examPlanId = coops[0].getLong("expedplan.id");
        String selectProperties = "examplanentry.itemgroup,examplanentry.seq";
        DynamicObject[] examPlan = EXPED_COOP_DOMAIN_SERVICE.queryExamPlanEntryById(selectProperties, examPlanId);
        Map<Integer, Long> seqMap = Arrays.stream(examPlan).collect(Collectors.toMap(item -> item.getInt("examplanentry.seq"), item -> item.getLong("examplanentry.itemgroup")));
        int i = 0;
        block0: for (Long value : seqMap.values()) {
            for (DynamicObject coop : coops) {
                long itemgroupId = coop.getLong("itemgroup.boid");
                if (itemgroupId != value) continue;
                coopsSeq[i++] = coop;
                continue block0;
            }
        }
        coops = coopsSeq;
        return coops;
    }

    public void updateExpedCoop(DynamicObject examCoop) {
        EXPED_COOP_DOMAIN_SERVICE.updateExpedCoop(examCoop);
    }
}

