/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.domain.issue.service.IssueBillDomainService;

public class IssueBillApplicationService {
    private static final IssueBillDomainService issueBillDomainService = ServiceFactory.getService(IssueBillDomainService.class);
    private static final ActvGenerateExtService ACTV_SERVICE = ServiceFactory.getService(ActvGenerateExtService.class);

    public void rejectToPreviousBill(DynamicObject[] issueBills, String opinion) {
        List<Long> insIds = Arrays.stream(issueBills).map(item -> item.getLong("instanceid")).collect(Collectors.toList());
        ACTV_SERVICE.batchRejectTask(insIds, opinion);
        issueBillDomainService.rejectBill(issueBills);
    }

    public DynamicObject[] queryIssueBillById(String selectProperties, List<Object> pkIds) {
        return issueBillDomainService.queryIssueBillById(selectProperties, pkIds);
    }

    public DynamicObject[] queryOriginalIssueBillById(String selectProperties, List<Long> pkIds) {
        return issueBillDomainService.queryOriginalIssueBillById(selectProperties, pkIds);
    }

    public DynamicObject queryOneByNominateId(String selectProperties, long nominateId) {
        return issueBillDomainService.queryOneByNominateId(selectProperties, nominateId);
    }

    public DynamicObject getEffectiveIssueBillByNominateId(Long nominateId) {
        return issueBillDomainService.getEffectiveIssueBillByNominateId(nominateId);
    }

    public DynamicObject[] getByIssueBatchNum(String selectProperties, String batchNum) {
        return issueBillDomainService.getByIssueBatchNum(selectProperties, batchNum);
    }

    public DynamicObject[] queryByPermission(String selectProperties, long userId, List<String> statusList, String permItemId) {
        return issueBillDomainService.queryByPermission(selectProperties, userId, statusList, permItemId);
    }
}

