/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.application.external.AppointRecordService;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.application.external.CallRuleEngineService;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.service.ReleaseBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.domain.appointaudit.service.AppointAuditDomainService;
import kd.tdc.cadm.bussiness.domain.brew.service.BrewBillDomainService;
import kd.tdc.cadm.bussiness.domain.dismiss.service.DismissBillDomainService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyKindEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.NominateStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.service.ActivityBillCommonDomainService;
import kd.tdc.cadm.bussiness.domain.nominate.service.IActivityBillCommonService;
import kd.tdc.cadm.bussiness.domain.nominate.service.NominateBillDomainService;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.bussiness.helper.CadreParamHelper;
import kd.tdc.cadm.bussiness.util.DateUtil;
import kd.tdc.cadm.bussiness.util.UrlBuilder;
import kd.tdc.cadm.common.enums.PositionTypeEnum;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;

public class NominateApplicationService {
    private static final Log LOGGER = LogFactory.getLog(NominateApplicationService.class);
    private static final ThreadPool NOMINATE_SUBMIT_INIT_THREAD_POOL = ThreadPools.newCachedThreadPool((String)"nominateSubmitInit", (int)2, (int)10);
    private static final CallRuleEngineService RULE_ENGINE_SERVICE = ServiceFactory.getService(CallRuleEngineService.class);
    private static final NominateBillDomainService NOMINATE_DOMAIN_SERVICE = ServiceFactory.getService(NominateBillDomainService.class);
    private static final DismissBillDomainService DISMISS_DOMAIN_SERVICE = ServiceFactory.getService(DismissBillDomainService.class);
    private static final AppointRecordService APPOINT_RECORD_SERVICE = ServiceFactory.getService(AppointRecordService.class);
    private static final BrewBillDomainService BREW_BILL_DOMAIN_SERVICE = ServiceFactory.getService(BrewBillDomainService.class);
    private static final ActvGenerateExtService ACTV_SERVICE = ServiceFactory.getService(ActvGenerateExtService.class);
    private static final AppointAuditDomainService AUDIT_DOMAIN_SERVICE = ServiceFactory.getService(AppointAuditDomainService.class);
    private final kd.tdc.tdcs.bussiness.application.TenureApplicationService TDCS_TENURE_SERVICE = new kd.tdc.tdcs.bussiness.application.TenureApplicationService();
    private static final ActivityBillCommonDomainService BILL_COMMON_DOMAIN_SERVICE = ServiceFactory.getService(ActivityBillCommonDomainService.class);
    private TenureApplicationService TENURE_APPLICATION_SERVICE = new TenureApplicationService();
    private static final ReleaseBillApplicationService releaseBillApplicationService = ServiceFactory.getService(ReleaseBillApplicationService.class);
    private static final CadmFormService cadmFormService = ServiceFactory.getService(CadmFormService.class);
    private static final String BOID = "boid";
    private static final String PERSON_ID = "person_id";

    public Map<String, Object> batchUnSubmitAppointBill(DynamicObject[] appointBills) {
        ArrayList<Long> successBillIs = new ArrayList<Long>(appointBills.length);
        ArrayList failList = new ArrayList(appointBills.length);
        for (DynamicObject appointBill : appointBills) {
            Long billId = appointBill.getLong("id");
            DynamicObject actvScheme = null;
            try {
                actvScheme = ACTV_SERVICE.getActivitySchemeFromWorkflow(appointBill);
            }
            catch (Exception exception) {
                String message = MessageFormat.format("getActivitySchemeByID error:{0}", billId);
                LOGGER.error(message, (Throwable)exception);
            }
            if (actvScheme == null) {
                LOGGER.error("getActivitySchemeByID, activityPlan is null, {}", (Object)billId);
                continue;
            }
            ArrayList<Long> taskIds = new ArrayList<Long>();
            DynamicObjectCollection entityCol = actvScheme.getDynamicObjectCollection("actschemeentry");
            for (DynamicObject dy : entityCol) {
                this.handleActivityAfterUnSubmitNominate(billId, taskIds, dy);
            }
            ACTV_SERVICE.batchTerminateTask(taskIds, null);
            successBillIs.add(billId);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("allSize", appointBills.length);
        result.put("successSize", successBillIs.size());
        result.put("failList", failList);
        return result;
    }

    private void handleActivityAfterUnSubmitNominate(Long nominateId, List<Long> taskIds, DynamicObject dy) {
        Long activityId = dy.getLong("activity.id");
        DynamicObject row = (DynamicObject)dy.getDynamicObjectCollection("actinfo").get(0);
        String actvFromId = row.getDynamicObject("actbizobj").getString("number");
        IActivityBillCommonService activityService = (IActivityBillCommonService)ServiceFactory.getService(actvFromId);
        Tuple<DynamicObject, Boolean> result = activityService.updateAfterUnSubmitNominate(nominateId, activityId);
        DynamicObject dynObj = (DynamicObject)result.item1;
        if (dynObj != null && dynObj.getLong("instanceid") != 0L) {
            long instanceId = dynObj.getLong("instanceid");
            taskIds.add(instanceId);
            Boolean needSendMsg = (Boolean)result.item2;
            if (!needSendMsg.booleanValue()) {
                return;
            }
            List<Long> userIds = BILL_COMMON_DOMAIN_SERVICE.getActivityHandlerIds(dynObj, "handler");
            if (userIds.isEmpty()) {
                String billNo = dynObj.getString("billno");
                LOGGER.info(MessageFormat.format("NominateApplicationService.unSubmitNominateBill: {0}, send msg fail\uff0chandler is empty", billNo));
                return;
            }
            Long billId = dynObj.getLong("id");
            String formId = dynObj.getDataEntityType().getName();
            BosMessageService.sendTemplateMessage("", userIds, nominateId, formId, "cadm_cx", billId);
        }
    }

    public Tuple<Boolean, Tuple<String, String>> judgeEnableUnSubmit(Long nominateId) {
        return NOMINATE_DOMAIN_SERVICE.judgeEnableUnSubmit(nominateId);
    }

    public void initActivityBillsByActivityService(DynamicObject[] nominateBills) {
        LOGGER.info("initActivityBillsByActivityService lang:{}", (Object)RequestContext.get().getLang().getLangTag());
        NOMINATE_SUBMIT_INIT_THREAD_POOL.execute(() -> {
            LOGGER.info("initActivityBillsByActivityService POOL lang:{}", (Object)RequestContext.get().getLang().getLangTag());
            for (DynamicObject nominateBill : nominateBills) {
                String billNo = nominateBill.getString("billno");
                long actvSchemeId = nominateBill.getLong("actvplanhis");
                if (actvSchemeId == 0L) {
                    LOGGER.error("actvSchemeId is null\uff0c billno: {}", (Object)billNo);
                    continue;
                }
                DynamicObject activityPlan = null;
                try {
                    activityPlan = ACTV_SERVICE.getActivitySchemeFromWorkflow(nominateBill);
                }
                catch (Exception exception) {
                    String message = MessageFormat.format("getActivitySchemeFromWorkflow error:{0}", billNo);
                    LOGGER.error(message, (Throwable)exception);
                }
                if (activityPlan == null) {
                    LOGGER.error("getActivitySchemeFromWorkflow error, activityPlan is null, billno:{}", (Object)billNo);
                    continue;
                }
                DynamicObjectCollection entityCol = activityPlan.getDynamicObjectCollection("actschemeentry");
                for (DynamicObject dy : entityCol) {
                    String policy;
                    long activityId = dy.getLong("activity.id");
                    DynamicObject row = (DynamicObject)dy.getDynamicObjectCollection("actinfo").get(0);
                    String number = row.getDynamicObject("actbizobj").getString("number");
                    int sla = row.getInt("sla");
                    DynamicObject bill = NOMINATE_DOMAIN_SERVICE.initPlanActivity(nominateBill, number, activityId, new ArrayList<Long>(), sla);
                    if (!"cadm_appointaudit".equals(number)) continue;
                    Map<String, String> scenePolicyMap = ACTV_SERVICE.getActivitySchemeDomainParams(actvSchemeId, activityId);
                    String scene = scenePolicyMap.get("scene");
                    List<Long> planIds = RULE_ENGINE_SERVICE.matchPlan(scene, policy = scenePolicyMap.get("policy"), NOMINATE_DOMAIN_SERVICE.queryNominateBillById(nominateBill.getLong("id")));
                    Long auditSchemeId = planIds == null || planIds.isEmpty() ? Long.valueOf(1447677052990784512L) : planIds.get(0);
                    AUDIT_DOMAIN_SERVICE.initByAuditScheme(bill, auditSchemeId);
                }
            }
        });
    }

    public DynamicObject triggerActivity(Long nominateId, Long activityId, String currentFormId, Long instanceId, List<Long> approverIds) {
        IActivityBillCommonService activityBillService = (IActivityBillCommonService)ServiceFactory.getService(currentFormId);
        LOGGER.info(MessageFormat.format("#triggerNextActivity trigger, currentFormId: {0}", currentFormId));
        DynamicObject bill = activityBillService.triggerBill(nominateId, activityId, instanceId, approverIds);
        if (bill == null) {
            return null;
        }
        List<Long> userIds = BILL_COMMON_DOMAIN_SERVICE.getActivityHandlerIds(bill, "handler");
        if (userIds.isEmpty()) {
            String billNo = bill.getString("billno");
            LOGGER.info(MessageFormat.format("NominateApplicationService.triggerActivity: {0}, send msg fail\uff0chandler is empty", billNo));
            return bill;
        }
        Long billId = bill.getLong("id");
        String formId = bill.getDataEntityType().getName();
        String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), formId).setParameter("formPkId", String.valueOf(billId)).builder();
        BosMessageService.sendTemplateMessage(contentUrl, userIds, nominateId, formId, "cadm_db", billId);
        LOGGER.info("triggerActivity# sendTemplateMessage end");
        return bill;
    }

    public DynamicObject getOriginalNominateBillById(String selectedProperties, long pkId) {
        return NOMINATE_DOMAIN_SERVICE.queryNominateBillOriginalOne(selectedProperties, pkId);
    }

    public DynamicObject queryNominateBillById(String selectedProperties, long pkId) {
        return NOMINATE_DOMAIN_SERVICE.queryNominateBillById(selectedProperties, pkId);
    }

    public DynamicObject queryNominateBillById(long pkId) {
        return NOMINATE_DOMAIN_SERVICE.queryNominateBillById(pkId);
    }

    public DynamicObject queryNominateBillAppointDateByPKId(long pkId) {
        return NOMINATE_DOMAIN_SERVICE.queryNominateBillOriginalOne("appointdate", pkId);
    }

    public boolean isExistBillById(long pkId) {
        return NOMINATE_DOMAIN_SERVICE.isExistBillById(pkId);
    }

    public DynamicObject[] queryBrewBills(long personId, long positionId, long nomHandler) {
        String selectProperties = "billno,brewdate,brewfollowupper,entryentity.brewcomment,entryentity.person,positiontype,brewposition";
        return BREW_BILL_DOMAIN_SERVICE.queryByPersonAndPosition(selectProperties, personId, positionId, nomHandler);
    }

    public void beRejected(List<Long> nominateIds) {
        NOMINATE_DOMAIN_SERVICE.beRejected(nominateIds);
    }

    public void completeAppoint(Long nominateId) {
        try {
            DynamicObject nominateBill = NOMINATE_DOMAIN_SERVICE.completeAppoint(nominateId);
            APPOINT_RECORD_SERVICE.maintainAppointRecord(nominateBill);
            this.updateTenure(nominateBill);
            long appointTypeId = nominateBill.getDynamicObject("appointtype").getLong("id");
            if (1472625044948646912L == appointTypeId) {
                return;
            }
            DynamicObject employee = nominateBill.getDynamicObject("employee");
            Long employeeBoId = employee.getLong("id");
            this.updateRelationalData(nominateBill, nominateId, employeeBoId);
            this.updateDismissRelationalData(nominateBill, nominateId, employeeBoId);
        }
        catch (Exception exception) {
            LOGGER.error("completeAppoint error {}:", (Object)exception.getMessage(), (Object)exception);
        }
    }

    private void updateTenure(DynamicObject nominateBill) {
        long dismissTenureId;
        DynamicObject dismissTenure;
        if (ApplyKindEnum.DISMISS.getNumber().equals(nominateBill.getString("applykind")) && (dismissTenure = this.TENURE_APPLICATION_SERVICE.queryTenureOneById("id,planenddate", dismissTenureId = nominateBill.getLong("dismisstenure_id"))) != null) {
            Object appointEndDate = nominateBill.get("appointenddate");
            dismissTenure.set("planenddate", appointEndDate);
            this.TENURE_APPLICATION_SERVICE.update(dismissTenure);
            LOGGER.info("updateTenure, update appointEndDate:{}", appointEndDate);
        }
    }

    private void updateRelationalData(DynamicObject nominateBill, Long nominateId, Long employeeBoId) {
        DynamicObject aPosition = nominateBill.getDynamicObject("aposition");
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("appointid", nominateId);
        paramMap.put("employee", employeeBoId);
        paramMap.put("person", nominateBill.getLong(PERSON_ID));
        paramMap.put("adminorg", nominateBill.getLong("aadminorg.boid"));
        paramMap.put("empposrel", nominateBill.getLong("empposrel_id"));
        if (aPosition != null) {
            Long aPositionBoId = aPosition.getLong(BOID);
            paramMap.put("position", aPositionBoId);
            paramMap.put("positiontype", PositionTypeEnum.POSITION.getNumber());
            ApiResult apiResult = this.TDCS_TENURE_SERVICE.updateRelationalConfig4Nominate((Map)paramMap);
            if (!apiResult.getSuccess()) {
                LOGGER.error("updateRelationalConfig4Nominate fail :{}", apiResult.getData());
            }
            return;
        }
        DynamicObject aJob = nominateBill.getDynamicObject("ajob");
        if (aJob != null) {
            long aJobBoId = aJob.getLong(BOID);
            paramMap.put("job", aJobBoId);
            paramMap.put("positiontype", PositionTypeEnum.JOB.getNumber());
            ApiResult apiResult = this.TDCS_TENURE_SERVICE.updateRelationalConfig4Nominate((Map)paramMap);
            if (!apiResult.getSuccess()) {
                LOGGER.error("updateRelationalConfig4Nominate fail :{}", apiResult.getData());
            }
            return;
        }
        DynamicObject aStandardPosition = nominateBill.getDynamicObject("astandardposition");
        if (null != aStandardPosition) {
            long aStandardPositionBoId = aStandardPosition.getLong(BOID);
            paramMap.put("standardposition", aStandardPositionBoId);
            paramMap.put("positiontype", PositionTypeEnum.STANDER_POSITION.getNumber());
            ApiResult apiResult = this.TDCS_TENURE_SERVICE.updateRelationalConfig4Nominate((Map)paramMap);
            if (!apiResult.getSuccess()) {
                LOGGER.error("updateRelationalConfig4Nominate fail :{}", apiResult.getData());
            }
        }
    }

    private void updateDismissRelationalData(DynamicObject nominateBill, Long nominateId, Long employeeBoId) {
        DynamicObject dPosition = nominateBill.getDynamicObject("dposition");
        HashMap dismissParamMap = Maps.newHashMap();
        dismissParamMap.put("dismissbillid", nominateId);
        dismissParamMap.put("employee", employeeBoId);
        dismissParamMap.put("adminorg", nominateBill.getLong("aadminorg.boid"));
        if (dPosition != null) {
            Long dPositionBoId = dPosition.getLong(BOID);
            dismissParamMap.put("position", dPositionBoId);
            dismissParamMap.put("positiontype", PositionTypeEnum.POSITION.getNumber());
            long empPosOrgRelId = this.getEmpPosOrgRelIdByTenureId(nominateBill.getLong("dismisstenure_id"));
            dismissParamMap.put("empposrel", empPosOrgRelId);
            ApiResult apiResult = this.TDCS_TENURE_SERVICE.updateDismissRelationalConfig4Dismiss((Map)dismissParamMap);
            if (!apiResult.getSuccess()) {
                LOGGER.error("updateDismissRelationalConfig4Dismiss fail :{}", apiResult.getData());
            }
            return;
        }
        DynamicObject dJob = nominateBill.getDynamicObject("djob");
        if (dJob != null) {
            long dJobBoId = dJob.getLong(BOID);
            dismissParamMap.put("job", dJobBoId);
            dismissParamMap.put("positiontype", PositionTypeEnum.JOB.getNumber());
            long empPosOrgRelId = this.getEmpPosOrgRelIdByTenureId(nominateBill.getLong("dismisstenure_id"));
            dismissParamMap.put("empposrel", empPosOrgRelId);
            ApiResult apiResult = this.TDCS_TENURE_SERVICE.updateDismissRelationalConfig4Dismiss((Map)dismissParamMap);
            if (!apiResult.getSuccess()) {
                LOGGER.error("updateDismissRelationalConfig4Dismiss fail :{}", apiResult.getData());
            }
            return;
        }
        DynamicObject dStandardPosition = nominateBill.getDynamicObject("dstandardposition");
        if (dStandardPosition != null) {
            long dStandardPositionBoId = dStandardPosition.getLong(BOID);
            dismissParamMap.put("positiontype", PositionTypeEnum.STANDER_POSITION.getNumber());
            dismissParamMap.put("standardposition", dStandardPositionBoId);
            long empPosOrgRelId = this.getEmpPosOrgRelIdByTenureId(nominateBill.getLong("dismisstenure_id"));
            dismissParamMap.put("empposrel", empPosOrgRelId);
            ApiResult apiResult = this.TDCS_TENURE_SERVICE.updateDismissRelationalConfig4Dismiss((Map)dismissParamMap);
            if (!apiResult.getSuccess()) {
                LOGGER.error("updateDismissRelationalConfig4Dismiss fail :{}", apiResult.getData());
            }
        }
    }

    private long getEmpPosOrgRelIdByTenureId(long tenureId) {
        DynamicObject tenureDy = this.TENURE_APPLICATION_SERVICE.queryTenureOneById("depemp", tenureId);
        if (tenureDy == null) {
            return 0L;
        }
        long depempId = tenureDy.getLong("depemp_id");
        Map<String, Object> map = ExternalDataService.queryEmpPosOrgRelByDepEmpId(depempId);
        if (map == null || map.get("id") == null) {
            return 0L;
        }
        return (Long)map.get("id");
    }

    public void sendMessageByEndAppoint(Long nominateId) {
        DynamicObject[] activityDys = ACTV_SERVICE.getActivityByAppointBillId(nominateId);
        List actFormIds = Arrays.stream(activityDys).map(activityObj -> activityObj.getString("bindbizkey")).collect(Collectors.toList());
        for (String actFormId : actFormIds) {
            IActivityBillCommonService activityService = (IActivityBillCommonService)ServiceFactory.getService(actFormId);
            DynamicObject actBill = activityService.queryActHandlerByNominateId(nominateId);
            if (Objects.isNull(actBill)) continue;
            Long actId = actBill.getLong("id");
            List<Long> userIds = actBill.getDynamicObjectCollection("handler").stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(userIds)) continue;
            String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), actFormId).setParameter("formPkId", String.valueOf(actId)).builder();
            BosMessageService.sendTemplateMessage(contentUrl, userIds, nominateId, actFormId, "cadm_rmwc", actId);
        }
    }

    public DynamicObject[] getAllWaitEffectBills(String selectProperties) {
        return NOMINATE_DOMAIN_SERVICE.queryAllWaitEffectBills(selectProperties);
    }

    public void continueAppointEffect(DynamicObject nominateBill, long employeeId) {
        boolean validTenure;
        Date date = nominateBill.getDate("appointenddate");
        Date planAppointDate = nominateBill.getDate("appointdate");
        Date now = new Date();
        if (DateUtil.dayAfter(now, date)) {
            DynamicObject[] dynamicObjects = this.TENURE_APPLICATION_SERVICE.directInvalidTenure(employeeId, nominateBill);
            this.TENURE_APPLICATION_SERVICE.updateData(dynamicObjects);
        }
        boolean bl = validTenure = DateUtil.dayAfter(now, planAppointDate) || DateUtil.ifEqualsOneDate(now, planAppointDate);
        if (validTenure) {
            DynamicObject tenureNew = this.TENURE_APPLICATION_SERVICE.directEffectiveTenure(nominateBill);
            if (null == tenureNew) {
                return;
            }
            this.TENURE_APPLICATION_SERVICE.batchSave(new DynamicObject[]{tenureNew});
        }
    }

    public DynamicObject loadSingle(long pkId) {
        return NOMINATE_DOMAIN_SERVICE.queryNominateBillById(pkId);
    }

    public void batchTerminateAppointBill(DynamicObject[] appointBills) {
        this.terminateActivityAndWorkflow(appointBills);
        this.sendTerminateMessageToSubmitter(appointBills);
    }

    private void terminateMainBillWorkflow(DynamicObject[] appointBills, Boolean ignoreCheckRight) {
        try {
            OperationResult operationResult;
            List billNos = Arrays.stream(appointBills).map(dynObj -> dynObj.getString("billno")).collect(Collectors.toList());
            LOGGER.info("terminate , bills: {}", billNos);
            String formId = appointBills[0].getDataEntityType().getName();
            OperateOption operateOption = OperateOption.create();
            LocaleString terminationReason = ResManager.getLocaleString((String)"\u5458\u5de5\u5df2\u79bb\u804c", (String)"NominateApplicationService_1", (String)"tdc-cadm-business");
            operateOption.setVariableValue("terminationidea", String.valueOf(terminationReason));
            operateOption.setVariableValue("terminatorId", "1");
            if (ignoreCheckRight.booleanValue()) {
                operateOption.setVariableValue("ishasright", "true");
            }
            if ((operationResult = OperationServiceHelper.executeOperate((String)"terminate", (String)formId, (DynamicObject[])appointBills, (OperateOption)operateOption)).isSuccess()) {
                LOGGER.error("terminate success");
            } else {
                LOGGER.error("terminate fail: {}", (Object)operationResult.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("terminate error, {}", (Object)e.getMessage());
        }
    }

    private void sendTerminateMessageToSubmitter(DynamicObject[] appointBills) {
        for (DynamicObject appointBill : appointBills) {
            long submitterId = HRDyObjectPropUtil.getId((DynamicObject)appointBill.getDynamicObject("nominateper"));
            long appointBillId = appointBill.getLong("id");
            String formId = appointBill.getDataEntityType().getName();
            String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), formId).setParameter("formPkId", String.valueOf(appointBillId)).builder();
            BosMessageService.sendTemplateMessage(contentUrl, Lists.newArrayList((Object[])new Long[]{submitterId}), appointBillId, formId, "cadm_stop", appointBillId);
        }
    }

    private void terminateActivityAndWorkflow(DynamicObject[] appointBills) {
        List<Long> appointBillIds = Arrays.stream(appointBills).map(dataEntity -> Long.valueOf(dataEntity.getPkValue().toString())).collect(Collectors.toList());
        ArrayList<DynamicObject> terminateTaskActivityBills = new ArrayList<DynamicObject>();
        HashSet allTerminateActvFormIds = new HashSet();
        for (Long appointBillId : appointBillIds) {
            DynamicObject[] activityObjs = ACTV_SERVICE.getActivityByAppointBillId(appointBillId);
            List actvFormIds = Arrays.stream(activityObjs).map(activityObj -> activityObj.getString("bindbizkey")).collect(Collectors.toList());
            allTerminateActvFormIds.addAll(actvFormIds);
        }
        for (String actvFormId : allTerminateActvFormIds) {
            IActivityBillCommonService activityService = (IActivityBillCommonService)ServiceFactory.getService(actvFormId);
            List<DynamicObject> terminateSuccessActivityBills = activityService.fireTerminateActivity(appointBillIds);
            terminateTaskActivityBills.addAll(terminateSuccessActivityBills);
        }
        try {
            List<Long> instanceTaskIds = terminateTaskActivityBills.stream().map(terminateTaskActivityBill -> terminateTaskActivityBill.getLong("instanceid")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(instanceTaskIds)) {
                String terminateReason = appointBills[0].getString("terminationidea");
                ACTV_SERVICE.batchTerminateTask(instanceTaskIds, terminateReason);
            }
        }
        catch (Exception e) {
            List billIds = terminateTaskActivityBills.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            LOGGER.error("batchTerminateTask error, bill : {}, msg : {}", billIds, (Object)e.getMessage());
        }
    }

    public void terminateAppoint(DynamicObject[] nominateBills, String terminationReason, long terminatorId) {
        Date nowDay = new Date();
        for (DynamicObject nominateBill : nominateBills) {
            nominateBill.set("appointstatus", (Object)AppointStatusEnum.TERMINATE_APPOINT.getVal());
            nominateBill.set("nominatestatus", (Object)NominateStatusEnum.TERMINATE_NOMINATE.getVal());
            if (!HRStringUtils.isEmpty((String)terminationReason)) {
                nominateBill.set("terminationidea", (Object)terminationReason);
            }
            nominateBill.set("terminater", (Object)terminatorId);
            nominateBill.set("terminatedate", (Object)nowDay);
            nominateBill.set("appointfinishedtime", (Object)nowDay);
            nominateBill.set("billstatus", (Object)"F");
            nominateBill.set("auditstatus", (Object)"F");
            this.setFieldValueToSourceVid(nominateBill, "acompany", "aposition", "aadminorg", "ajob", "astandardposition", "dposition", "dadminorg", "djob", "dstandardposition", "dcompany", "bpositionhis", "bjobhis", "badminorghis", "bcompanyhis");
        }
        this.updateData(nominateBills);
    }

    public DynamicObject[] queryNominateByEmployee(String selectProperties, Long employeeId) {
        return NOMINATE_DOMAIN_SERVICE.queryNominateByEmployee(selectProperties, employeeId);
    }

    public DynamicObject[] queryNominateBillsByIds(String selectProperties, List<Long> pkIds) {
        return NOMINATE_DOMAIN_SERVICE.queryNominateBillsByIds(selectProperties, pkIds);
    }

    public DynamicObject[] queryOriginalNominateBillsByIds(String selectProperties, List<Long> pkIds) {
        return NOMINATE_DOMAIN_SERVICE.queryOriginalNominateBillsByIds(selectProperties, pkIds);
    }

    public void setFieldValueToSourceVid(DynamicObject nominate, String ... fieldKeys) {
        NOMINATE_DOMAIN_SERVICE.setFieldValueToSourceVid(nominate, fieldKeys);
    }

    public void updateData(DynamicObject[] dataEntities) {
        NOMINATE_DOMAIN_SERVICE.updateData(dataEntities);
    }

    public DynamicObject[] queryBrewBillsByJob(long personId, long jobId, long currUserId) {
        String selectProperties = "billno,brewdate,brewfollowupper,entryentity.brewcomment,entryentity.person,positiontype,brewjob";
        return BREW_BILL_DOMAIN_SERVICE.queryByPersonAndJob(selectProperties, personId, jobId, currUserId);
    }

    public DynamicObject[] queryBrewBillsByStandardPositon(long personId, long standardPositionId, long currUserId) {
        String selectProperties = "billno,brewdate,brewfollowupper,entryentity.brewcomment,entryentity.person,positiontype,brewstandardposition";
        return BREW_BILL_DOMAIN_SERVICE.queryByPersonAndStandardPosition(selectProperties, personId, standardPositionId, currUserId);
    }

    public void setOpBoId(DynamicObject dataEntity) {
        if (null != dataEntity.getDynamicObject("aposition")) {
            DynamicObject aPosition = dataEntity.getDynamicObject("aposition");
            dataEntity.set("aposition_id", (Object)aPosition.getLong(BOID));
        }
        if (null != dataEntity.getDynamicObject("ajob")) {
            DynamicObject aJob = dataEntity.getDynamicObject("ajob");
            dataEntity.set("ajob_id", (Object)aJob.getLong(BOID));
        }
        if (null != dataEntity.getDynamicObject("astandardposition")) {
            DynamicObject aStandardPosition = dataEntity.getDynamicObject("astandardposition");
            dataEntity.set("astandardposition_id", (Object)aStandardPosition.getLong(BOID));
        }
        if (null != dataEntity.getDynamicObject("acompany")) {
            DynamicObject aCompany = dataEntity.getDynamicObject("acompany");
            dataEntity.set("acompany_id", (Object)aCompany.getLong(BOID));
        }
        if (null != dataEntity.getDynamicObject("aadminorg")) {
            DynamicObject aAdminOrg = dataEntity.getDynamicObject("aadminorg");
            dataEntity.set("aadminorg_id", (Object)aAdminOrg.getLong(BOID));
        }
        if (null != dataEntity.getDynamicObject("dposition")) {
            DynamicObject dPosition = dataEntity.getDynamicObject("dposition");
            dataEntity.set("dposition_id", (Object)dPosition.getLong(BOID));
        }
        if (null != dataEntity.getDynamicObject("djob")) {
            DynamicObject dJob = dataEntity.getDynamicObject("djob");
            dataEntity.set("djob_id", (Object)dJob.getLong(BOID));
        }
        if (null != dataEntity.getDynamicObject("dstandardposition")) {
            DynamicObject dStandardPosition = dataEntity.getDynamicObject("dstandardposition");
            dataEntity.set("dstandardposition_id", (Object)dStandardPosition.getLong(BOID));
        }
        if (null != dataEntity.getDynamicObject("dcompany")) {
            DynamicObject dCompany = dataEntity.getDynamicObject("dcompany");
            dataEntity.set("dcompany_id", (Object)dCompany.getLong(BOID));
        }
        if (null != dataEntity.getDynamicObject("dadminorg")) {
            DynamicObject dAdminOrg = dataEntity.getDynamicObject("dadminorg");
            dataEntity.set("dadminorg_id", (Object)dAdminOrg.getLong(BOID));
        }
        if (null != dataEntity.getDynamicObject("bpositionhis")) {
            DynamicObject bPosition = dataEntity.getDynamicObject("bpositionhis");
            dataEntity.set("bpositionhis_id", (Object)bPosition.getLong(BOID));
        }
        if (null != dataEntity.getDynamicObject("bjobhis")) {
            DynamicObject bJob = dataEntity.getDynamicObject("bjobhis");
            dataEntity.set("bjobhis_id", (Object)bJob.getLong(BOID));
        }
        if (null != dataEntity.getDynamicObject("bstandardpositionhis")) {
            DynamicObject bStandardPosition = dataEntity.getDynamicObject("bstandardpositionhis");
            dataEntity.set("bstandardpositionhis_id", (Object)bStandardPosition.getLong(BOID));
        }
        if (null != dataEntity.getDynamicObject("bcompanyhis")) {
            DynamicObject bCompany = dataEntity.getDynamicObject("bcompanyhis");
            dataEntity.set("bcompanyhis_id", (Object)bCompany.getLong(BOID));
        }
        if (null != dataEntity.getDynamicObject("badminorghis")) {
            DynamicObject bAdminOrg = dataEntity.getDynamicObject("badminorghis");
            dataEntity.set("badminorghis_id", (Object)bAdminOrg.getLong(BOID));
        }
    }

    public DynamicObject queryBrewById(long brewId, long personId, long currUserId) {
        String selectProperties = "billno,brewdate,brewfollowupper,entryentity.brewcomment,entryentity.person,positiontype,brewstandardposition,brewjob,brewposition";
        return BREW_BILL_DOMAIN_SERVICE.queryByPersonAndId(selectProperties, personId, brewId, currUserId);
    }

    public DynamicObject[] queryNominateByPermission(String selectProperties, long userId, List<String> statusList, String permItemId) {
        return NOMINATE_DOMAIN_SERVICE.queryNominateByPermission(selectProperties, userId, statusList, permItemId);
    }

    public List<Map<String, Object>> getNominateRecord(Map<String, Object> params) {
        List<Map<String, Object>> result = NOMINATE_DOMAIN_SERVICE.getNominateRecord(params);
        return result;
    }

    public void updateAppointFinishedTime() {
        NOMINATE_DOMAIN_SERVICE.updateAppointFinishedTime();
    }

    public Map<Long, List<Long>> queryTerminationDepemp(List<Long> brewIds) {
        Map<Long, List<Long>> result = new HashMap<Long, List<Long>>(16);
        String selectProperties = "brewingbill_id,depemp_id";
        DynamicObject[] nominateBills = NOMINATE_DOMAIN_SERVICE.queryTerminationNominateByBrewIds(selectProperties, brewIds);
        if (nominateBills.length > 0) {
            result = Arrays.stream(nominateBills).collect(Collectors.groupingBy(p -> p.getLong("brewingbill_id"), Collectors.mapping(p -> p.getLong("depemp_id"), Collectors.toList())));
        }
        return result;
    }

    public void maintainAppointRemoveRel(long nominateId) {
        LOGGER.info("maintainAppointRemoveRel, nominateId:{}", (Object)nominateId);
        if (!new CadreParamHelper().getOpenCadm()) {
            LOGGER.info("maintainAppointRemoveRel isOpencadm is close or not tdc");
            return;
        }
        DynamicObject nominateBill = NOMINATE_DOMAIN_SERVICE.queryNominateBillById("person_id,employee_id,appointenddate,appointtype_id,applykind,dismisstenure", nominateId);
        String selectProperties = "id,person_id,employee_id,appointid,dismissbillid,positiontype,standardposition_id,position_id,job_id,cadrecat_id,adminorg_id,appointdate,appointreason,isprimappoint,pptreasongroup_id,appointtype_id,apptreasongroup_id,dismissreasongroup,dismissreason,dismisstype_id";
        DynamicObject dismissRecord = APPOINT_RECORD_SERVICE.queryAppointRecordByDismissId(selectProperties, nominateId);
        DynamicObject appointRecord = APPOINT_RECORD_SERVICE.queryAppointRecordByAppointId(selectProperties, nominateId);
        if (ApplyKindEnum.APPOINT.getNumber().equals(nominateBill.getString("applykind"))) {
            long appointTypeId = nominateBill.getLong("appointtype_id");
            if (1472625044948646912L == appointTypeId) {
                if (dismissRecord == null && appointRecord == null) {
                    LOGGER.info("dismissRecord && appointRecord is null");
                    return;
                }
                if (dismissRecord == null) {
                    Map<String, Object> newRecordParam = this.buildCommonAppointRemoveRelParam("1", appointRecord);
                    newRecordParam.put("datatype", "insert");
                    newRecordParam.put("appointrecordid", appointRecord.getLong("id"));
                    Map<String, Object> result = ExternalDataService.insertOrUpdateAppointRemoveRel(newRecordParam);
                    LOGGER.info("Insert new record by reappointment, result:{}", result);
                    return;
                }
                Map<String, Object> newRecordParam = this.buildCommonAppointRemoveRelParam("1", appointRecord);
                newRecordParam.put("datatype", "reappointment");
                newRecordParam.put("appointrecordid", dismissRecord.getLong("id"));
                newRecordParam.put("newappointrecordid", appointRecord.getLong("id"));
                newRecordParam.put("dismissdate", nominateBill.getDate("appointenddate"));
                newRecordParam.put("dismisstypeid", nominateBill.getLong("appointtype_id"));
                if (newRecordParam.containsKey("appointdispatchdate")) {
                    Object appointDispatchDate = newRecordParam.get("appointdispatchdate");
                    newRecordParam.put("dismissdispatchdate", appointDispatchDate);
                }
                if (newRecordParam.containsKey("appointdispatchnymber")) {
                    Object appointDispatchnymber = newRecordParam.get("appointdispatchnymber");
                    newRecordParam.put("dismissdispatchnymber", appointDispatchnymber);
                }
                Map<String, Object> result = ExternalDataService.insertOrUpdateAppointRemoveRel(newRecordParam);
                LOGGER.info("Insert new record, result:{}", result);
            } else {
                DynamicObject dismissTenure = nominateBill.getDynamicObject("dismisstenure");
                if (dismissTenure != null && dismissRecord != null) {
                    this.handleDismiss(nominateBill, dismissRecord);
                }
                this.handleAppoint(appointRecord);
            }
        } else {
            if (dismissRecord == null) {
                LOGGER.info("dismissRecord is null");
                return;
            }
            this.handleDismiss(nominateBill, dismissRecord);
        }
    }

    private void handleAppoint(DynamicObject appointRecord) {
        Map<String, Object> newRecordParam = this.buildCommonAppointRemoveRelParam("1", appointRecord);
        newRecordParam.put("datatype", "insert");
        newRecordParam.put("appointrecordid", appointRecord.getLong("id"));
        Map<String, Object> result = ExternalDataService.insertOrUpdateAppointRemoveRel(newRecordParam);
        LOGGER.info("Insert new record, result:{}", result);
    }

    private void handleDismiss(DynamicObject nominateBill, DynamicObject dismissRecord) {
        Map<String, Object> oldRecordParam = this.buildCommonAppointRemoveRelParam("2", dismissRecord);
        oldRecordParam.put("datatype", "update");
        oldRecordParam.put("appointrecordid", dismissRecord.getLong("id"));
        oldRecordParam.put("dismissdate", nominateBill.getDate("appointenddate"));
        oldRecordParam.put("dismisstypeid", nominateBill.getLong("appointtype_id"));
        Map<String, Object> result = ExternalDataService.insertOrUpdateAppointRemoveRel(oldRecordParam);
        LOGGER.info("Update old record, result:{}", result);
    }

    public Map<String, Object> buildCommonAppointRemoveRelParam(String appointTypeStatus, DynamicObject appointRecord) {
        long dismissBillId;
        DynamicObject releaseBill;
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        if (appointRecord == null) {
            return param;
        }
        param.put("personid", appointRecord.getLong(PERSON_ID));
        param.put("employeeid", appointRecord.getLong("employee_id"));
        param.put("stdpositionvid", appointRecord.getLong("standardposition_id"));
        param.put("positionvid", appointRecord.getLong("position_id"));
        param.put("jobvid", appointRecord.getLong("job_id"));
        param.put("apositiontype", appointRecord.getString("positiontype"));
        param.put("cadrecatid", appointRecord.getLong("cadrecat_id"));
        param.put("adminorgvid", appointRecord.getLong("adminorg_id"));
        param.put("appointtypeid", appointRecord.getLong("appointtype_id"));
        param.put("appointdate", appointRecord.getDate("appointdate"));
        param.put("apptreasonggroupid", appointRecord.getLong("apptreasongroup_id"));
        param.put("appointreason", appointRecord.getString("appointreason"));
        param.put("isprimappoint", appointRecord.getBoolean("isprimappoint"));
        param.put("dismissreason", appointRecord.getLong("dismissreasongroup_id"));
        param.put("dismissreasondetail", appointRecord.getString("dismissreason"));
        param.put("appointtypestatus", appointTypeStatus);
        if ("1".equals(appointTypeStatus)) {
            long appointId = appointRecord.getLong("appointid");
            DynamicObject releaseBill2 = releaseBillApplicationService.getEffectiveReleaseBillByNominateId(appointId);
            if (releaseBill2 != null) {
                param.put("appointdispatchdate", releaseBill2.getDate("releasetime"));
                param.put("appointdispatchnymber", releaseBill2.getString("relsfilenum"));
            }
        } else if ("2".equals(appointTypeStatus) && (releaseBill = releaseBillApplicationService.getEffectiveReleaseBillByNominateId(dismissBillId = appointRecord.getLong("dismissbillid"))) != null) {
            param.put("dismissdispatchdate", releaseBill.getDate("releasetime"));
            param.put("dismissdispatchnymber", releaseBill.getString("relsfilenum"));
        }
        return param;
    }

    public void handleDepartCadresAppointBill(Long personId, String terminationParam) {
        String selectProperties = "applykind,billno,appointstatus,nominatestatus,terminationidea,terminater,terminatedate,appointfinishedtime,billstatus,auditstatus,acompany,aposition,aadminorg,ajob,astandardposition,dposition,dadminorg,djob,dstandardposition,dcompany,bpositionhis,bjobhis,badminorghis,bcompanyhis,nominateper,person,departpersonid";
        DynamicObject[] nominateBills = NOMINATE_DOMAIN_SERVICE.queryNominateBillsByStatus(selectProperties, Collections.singletonList(AppointStatusEnum.ING_APPOINT.getVal()), personId);
        List<String> dismissStatusList = Arrays.asList(AppointStatusEnum.SUCCESS_APPOINT.getVal(), AppointStatusEnum.TERMINATE_APPOINT.getVal());
        DynamicObject[] dismissBills = DISMISS_DOMAIN_SERVICE.queryDismissBillsByStatus(selectProperties, dismissStatusList, personId);
        if (nominateBills.length == 0 && dismissBills.length == 0) {
            return;
        }
        if (nominateBills.length > 0) {
            Arrays.stream(nominateBills).forEach(p -> p.set("departpersonid", (Object)personId));
            NOMINATE_DOMAIN_SERVICE.updateData(nominateBills);
        }
        if (dismissBills.length > 0) {
            Arrays.stream(dismissBills).forEach(p -> p.set("departpersonid", (Object)personId));
            DISMISS_DOMAIN_SERVICE.updateData(dismissBills);
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("type", "list");
        params.put("dataSource", "departMsg");
        params.put("personId", String.valueOf(personId));
        if ("2".equals(terminationParam)) {
            if (nominateBills.length > 0) {
                List<Long> nominateSubmitUserIds = Arrays.stream(nominateBills).map(p -> p.getLong("nominateper.id")).distinct().collect(Collectors.toList());
                long billId = nominateBills[0].getLong("id");
                String personNumber = nominateBills[0].getString("person.number");
                params.put("personNumber", personNumber);
                String personName = nominateBills[0].getString("person.name");
                params.put("personName", personName);
                BosMessageService.sendDepartMessage("cadm_nominatebill", params, nominateSubmitUserIds, billId, "cadm_rmlzyj");
            }
        } else if ("1".equals(terminationParam)) {
            if (nominateBills.length > 0) {
                this.terminateMainBillWorkflow(nominateBills, Boolean.TRUE);
            }
            LOGGER.info("Automatically complete the cadre termination process.");
        }
    }

    public void handleWithdrawDepartCadresAppointBill(Long personId) {
        String personName;
        String personNumber;
        long billId;
        String selectProperties = "applykind,nominateper,person,departpersonid,nominatedate,appointstatus";
        DynamicObject[] nominateBills = NOMINATE_DOMAIN_SERVICE.queryNominateBillsByPersonId(selectProperties, personId);
        if (nominateBills.length == 0) {
            return;
        }
        List nominateList = Arrays.stream(nominateBills).filter(p -> ApplyKindEnum.APPOINT.getNumber().equals(p.getString("applykind"))).collect(Collectors.toList());
        List dismissList = Arrays.stream(nominateBills).filter(p -> ApplyKindEnum.DISMISS.getNumber().equals(p.getString("applykind"))).collect(Collectors.toList());
        List<Object> nominateSubmitUserIds = new ArrayList(10);
        List<Object> dismissSubmitUserIds = new ArrayList(10);
        if (nominateList.size() > 0) {
            nominateSubmitUserIds = nominateList.stream().filter(p -> p.get("departpersonid") != null && p.getLong("departpersonid.id") != 0L && p.getLong("departpersonid.id") == p.getLong("person.id")).map(p -> p.getLong("nominateper.id")).distinct().collect(Collectors.toList());
        }
        if (dismissList.size() > 0) {
            List list = dismissList.stream().filter(p -> p.get("departpersonid") == null || p.getLong("departpersonid_id") == 0L).filter(p -> AppointStatusEnum.ING_APPOINT.getVal().equals(p.getString("appointstatus")) || AppointStatusEnum.SUCCESS_APPOINT.getVal().equals(p.getString("appointstatus"))).collect(Collectors.toList());
            dismissSubmitUserIds = list.stream().map(p -> p.getLong("nominateper.id")).distinct().collect(Collectors.toList());
        }
        Arrays.stream(nominateBills).forEach(p -> p.set("departpersonid", (Object)0L));
        NOMINATE_DOMAIN_SERVICE.updateData(nominateBills);
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("type", "list");
        params.put("dataSource", "withdrawDepartMsg");
        params.put("personId", String.valueOf(personId));
        if (nominateList.size() > 0 && nominateSubmitUserIds.size() > 0) {
            billId = ((DynamicObject)nominateList.get(0)).getLong("id");
            personNumber = nominateBills[0].getString("person.number");
            params.put("personNumber", personNumber);
            personName = nominateBills[0].getString("person.name");
            params.put("personName", personName);
            BosMessageService.sendDepartMessage("cadm_nominatebill", params, nominateSubmitUserIds, billId, "cadm_rmlzch");
        }
        if (dismissList.size() > 0 && dismissSubmitUserIds.size() > 0) {
            billId = ((DynamicObject)dismissList.get(0)).getLong("id");
            personNumber = ((DynamicObject)dismissList.get(0)).getString("person.number");
            params.put("personNumber", personNumber);
            personName = ((DynamicObject)dismissList.get(0)).getString("person.name");
            params.put("personName", personName);
            BosMessageService.sendDepartMessage("cadm_dismissbill", params, dismissSubmitUserIds, billId, "cadm_mzlzch");
        }
    }

    public void setDefaultReasonByDepart(AbstractFormPlugin plugin) {
        ListSelectedRowCollection selectedRows;
        if (plugin == null) {
            return;
        }
        IFormView view = plugin.getView();
        List<Long> personIdList = new ArrayList<Long>(10);
        if (view instanceof ListView && (selectedRows = ((ListView)view).getSelectedRows()).size() > 0) {
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            List<Long> ids = Arrays.stream(primaryKeyValues).filter(obj -> obj instanceof Long).map(obj -> (Long)obj).collect(Collectors.toList());
            DynamicObject[] bills = this.queryNominateBillsByIds("person", ids);
            personIdList = Arrays.stream(bills).map(p -> p.getLong("person.id")).collect(Collectors.toList());
        }
        if (view instanceof BillView) {
            IDataModel model = view.getModel();
            Long personId = (Long)model.getValue(PERSON_ID);
            personIdList = Collections.singletonList(personId);
        }
        cadmFormService.setTerminationReasonParam(plugin, personIdList);
    }

    public void updateAppointRecordData() {
        String selectProperties = "appointid,apostype,dismissbillid,appointtype,apptreasongroup,appointreason,dismisstype,dismissreasongroup,dismissreason,dpostype";
        DynamicObject[] appointRecordData = APPOINT_RECORD_SERVICE.queryAllAppointRecordData(selectProperties);
        if (appointRecordData.length == 0) {
            return;
        }
        List appointIdList = Arrays.stream(appointRecordData).map(p -> p.getLong("appointid")).filter(p -> p != null && p != 0L).collect(Collectors.toList());
        List dismissIdList = Arrays.stream(appointRecordData).map(p -> p.getLong("dismissbillid")).filter(p -> p != null && p != 0L).collect(Collectors.toList());
        List<Long> appointIds = Stream.concat(appointIdList.stream(), dismissIdList.stream()).distinct().collect(Collectors.toList());
        DynamicObject[] nominateBills = this.queryNominateBillsByIds("id,apostype,appointtype,apptreasongroup,appointreason,dpostype,dismisstenure", appointIds);
        List depempIds = Arrays.stream(nominateBills).filter(p -> p.get("dismisstenure") != null).map(p -> p.getLong("dismisstenure.depemp.id")).collect(Collectors.toList());
        List empOrgrels = ExternalService.listDataEmpOrgrels(depempIds);
        Map<Long, DynamicObject> nominateMap = Arrays.stream(nominateBills).collect(Collectors.toMap(value -> value.getLong("id"), value -> value, (v1, v2) -> v1));
        Arrays.stream(appointRecordData).forEach(record -> {
            DynamicObject dismissBill;
            long appointId = record.get("appointid") == null ? 0L : record.getLong("appointid");
            long dismissId = record.get("dismissbillid") == null ? 0L : record.getLong("dismissbillid");
            DynamicObject appointBill = (DynamicObject)nominateMap.get(appointId);
            if (appointBill != null) {
                record.set("appointtype", appointBill.get("appointtype"));
                record.set("apostype", appointBill.get("apostype"));
                record.set("apptreasongroup", appointBill.get("apptreasongroup"));
                record.set("appointreason", appointBill.get("appointreason"));
            }
            if ((dismissBill = (DynamicObject)nominateMap.get(dismissId)) != null) {
                record.set("dismisstype", dismissBill.get("appointtype"));
                record.set("dismissreasongroup", dismissBill.get("apptreasongroup"));
                record.set("dismissreason", dismissBill.get("appointreason"));
                if (dismissBill.get("dismisstenure") != null) {
                    long depempId = dismissBill.getLong("dismisstenure.depemp.id");
                    Optional<Map> depempOptional = empOrgrels.stream().filter(p -> p.get("depemp") != null && (Long)p.get("depemp") == depempId).findFirst();
                    if (depempOptional.isPresent()) {
                        Map map = depempOptional.get();
                        long posTypeId = map.get("postype") == null ? 0L : Long.parseLong(String.valueOf(map.get("postype")));
                        record.set("dpostype", (Object)posTypeId);
                    }
                }
            }
        });
        APPOINT_RECORD_SERVICE.save(appointRecordData);
    }

    public void updateNominateDPosType() {
        QFilter dPosTypeFilter = new QFilter("dpostype", "=", (Object)0L).or("dpostype", "=", null);
        QFilter tenureFilter = new QFilter("dismisstenure", "!=", (Object)0L).and("dismisstenure", "!=", null);
        DynamicObject[] bills = NOMINATE_DOMAIN_SERVICE.query("id,dismisstenure,dpostype", new QFilter[]{dPosTypeFilter, tenureFilter});
        if (bills.length == 0) {
            return;
        }
        List depempIds = Arrays.stream(bills).filter(p -> p.get("dismisstenure.depemp") != null).map(p -> p.getLong("dismisstenure.depemp.id")).distinct().collect(Collectors.toList());
        List empOrgrelsList = ExternalService.listDataEmpOrgrels(depempIds);
        if (empOrgrelsList.size() == 0) {
            return;
        }
        Map<Long, Map> depempMap = empOrgrelsList.stream().collect(Collectors.toMap(p -> Long.parseLong(String.valueOf(p.get("depemp"))), p -> p, (v1, v2) -> v1));
        for (DynamicObject bill : bills) {
            long depempId = bill.getLong("dismisstenure.depemp.id");
            Map depemp = depempMap.get(depempId);
            if (depemp == null) continue;
            bill.set("dpostype", depemp.get("postype"));
        }
        NOMINATE_DOMAIN_SERVICE.updateData(bills);
    }
}

