/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.AttDto;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tdc.cadm.common.bo.PdfAttachmentBo;

public class NominateAttachmentApplicationService {
    private static final Log LOG = LogFactory.getLog(NominateAttachmentApplicationService.class);
    private static final String PUBLIC_START_TIME = "pubstartdate";
    private static final String PUBLIC_END_TIME = "pubenddate";
    private static final String HTTP = "http";
    private static final HRBaseServiceHelper BD_ATTACHMENT_HELPER = new HRBaseServiceHelper("bd_attachment");

    public void createAttachmentCommon(DynamicObject dataEntity, List<Object> pkIdList, String targetEntityName, String pdfTemplateNumber) {
        PdfAttachmentBo bo = new PdfAttachmentBo();
        Object currentPkId = dataEntity.getPkValue();
        bo.setTargetEntityName(targetEntityName);
        bo.setCurrentPkId(currentPkId);
        bo.setExtParam(NominateAttachmentApplicationService.createPdfExtParam(dataEntity, pkIdList, targetEntityName));
        bo.setPdfTemplateNumber(pdfTemplateNumber);
        bo.setTargetAttachmentPanel("attachmentpanel");
        bo.setTargetPkIdList(pkIdList);
        this.createPdfAttachment(bo);
    }

    public static Map<String, Object> createPdfExtParam(DynamicObject dataEntity, List<Object> selectList, String targetEntityName) {
        HashMap<String, Object> extParam = new HashMap<String, Object>(16);
        extParam.put("ids", selectList);
        extParam.put("entity", targetEntityName);
        if ("cadm_appointrelease".equals(targetEntityName)) {
            Date date = dataEntity.getDate("releasetime");
            extParam.put("releasetime", date);
        } else if ("cadm_publicity".equals(targetEntityName)) {
            Date publicStartTime = dataEntity.getDate(PUBLIC_START_TIME);
            Date publicEndTime = dataEntity.getDate(PUBLIC_END_TIME);
            extParam.put(PUBLIC_START_TIME, publicStartTime);
            extParam.put(PUBLIC_END_TIME, publicEndTime);
        } else if ("cadm_appointissue".equals(targetEntityName)) {
            Date date = dataEntity.getDate("issuetime");
            extParam.put("issuetime", date);
        }
        return extParam;
    }

    public void createPdfAttachment(PdfAttachmentBo bo) {
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"bos_print_meta", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bo.getPdfTemplateNumber())});
        String tplId = queryOne.getString("id");
        String pdfName = queryOne.getString("name");
        PrintWork work = new PrintWork();
        work.setPrintLang(RequestContext.get().getLang().toString());
        work.setExpType("1");
        work.setExtParam(bo.getExtParam());
        ArrayList<PrintTask> printTasks = new ArrayList<PrintTask>();
        PrintTask printTask = new PrintTask();
        printTask.setTplId(tplId);
        printTask.setPkIds(new ArrayList<Object>(Collections.singletonList(bo.getCurrentPkId())));
        printTasks.add(printTask);
        work.setTaskList(printTasks);
        PrtAttach prtAttach = BosPrintServiceHelper.execPrint((PrintWork)work);
        String path = ((PrtAttach.AttachDetail)prtAttach.getAttachDetail().get(0)).getFilePath();
        InputStream fileInputStream = BosPrintServiceHelper.getFileInputStream((String)path);
        try {
            String fileName = pdfName + "-" + this.getCommonDate(new Date()) + ".pdf";
            String tenantId = RequestContext.get().getTenantId();
            String accountId = RequestContext.get().getAccountId();
            String date = HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
            String relativePath = String.format("/%s/%s/%s/%s", tenantId, accountId, date, fileName);
            FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
            attachmentFileService.upload(new FileItem(fileName, relativePath, fileInputStream));
            ArrayList<AttDto> attDtoList = new ArrayList<AttDto>();
            AttDto attDto = new AttDto();
            attDto.setPath(relativePath);
            attDto.setFileName(fileName);
            attDto.setAttKey(bo.getTargetAttachmentPanel());
            attDto.setSize(Long.valueOf(AttachmentServiceHelper.getFileSizeByPath((String)relativePath)));
            attDtoList.add(attDto);
            Map bindingParam = AttachmentServiceHelper.genBindingParam((String)bo.getTargetEntityName(), (String)String.valueOf(bo.getCurrentPkId()), attDtoList);
            AttachmentServiceHelper.bindingAttachment((Map)bindingParam);
        }
        catch (Exception e) {
            LOG.error("NominateAttachmentApplicationService error ", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public String getCommonDate(Date date) {
        String publishDateStr = DateUtils.formatDate((Date)date, (Object[])new Object[0]);
        String[] split = publishDateStr.split("-");
        return ResManager.loadKDString((String)"{0}\u5e74{1}\u6708{2}\u65e5", (String)"NominateAttachmentApplicationService_0", (String)"tdc-cadm-business", (Object[])new Object[]{split[0], split[1], split[2]});
    }
}

