/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.domain.publicity.service.PublicityBillDomainService;

public class PublicityBillApplicationService {
    private static final PublicityBillDomainService publicityBillDomainService = ServiceFactory.getService(PublicityBillDomainService.class);
    private static final ActvGenerateExtService ACTV_SERVICE = ServiceFactory.getService(ActvGenerateExtService.class);

    public void rejectToPreviousBill(DynamicObject[] publicityBills, String rejectComment) {
        List<Long> insIds = Arrays.stream(publicityBills).map(item -> item.getLong("instanceid")).collect(Collectors.toList());
        ACTV_SERVICE.batchRejectTask(insIds, rejectComment);
        publicityBillDomainService.update(publicityBills);
    }

    public DynamicObject queryOriginalOneById(String selectProperties, Object pkId) {
        return publicityBillDomainService.queryOriginalOneById(selectProperties, pkId);
    }

    public DynamicObject[] queryOriginalById(String selectProperties, Object pkId) {
        return publicityBillDomainService.queryOriginalById(selectProperties, pkId);
    }

    public DynamicObject[] queryByPubStatus(String selectProperties, String pubStatus) {
        return publicityBillDomainService.queryByPubStatus(selectProperties, pubStatus);
    }

    public DynamicObject[] queryPublicityBillById(String selectProperties, List<Object> pkIds) {
        return publicityBillDomainService.queryPublicityBillById(selectProperties, pkIds);
    }

    public DynamicObject[] getByPubBatchNum(String selectProperties, String pubBatchNum) {
        return publicityBillDomainService.queryByPubBatchNum(selectProperties, pubBatchNum);
    }

    public void updatePublicityBillByStatus(DynamicObject publicityBill, String publicityStatus) {
        publicityBillDomainService.updatePublicityBillByStatus(publicityBill, publicityStatus);
    }

    public void update(DynamicObject[] publicityBills) {
        publicityBillDomainService.update(publicityBills);
    }

    public Set<String> doPublicAfterConfirmOp(Map<String, Object> infoMap, List<Long> pkIds) {
        return publicityBillDomainService.doPublicAfterConfirmOp(infoMap, pkIds);
    }

    public DynamicObject queryPublicityBillByAppointId(String selectProperties, Long appointId) {
        return publicityBillDomainService.queryPublicityBillByAppointId(selectProperties, appointId);
    }

    public DynamicObject getEffectivePublicityBillByNominateId(Long nominateId) {
        return publicityBillDomainService.getEffectivePublicityBillByNominateId(nominateId);
    }

    public DynamicObject[] getByPubBatchNumList(String selectProperties, List<String> batchNumList) {
        return publicityBillDomainService.getByPubBatchNumList(selectProperties, batchNumList);
    }

    public DynamicObject[] getAllByPubBatchNumList(String selectProperties, List<String> batchNumList) {
        return publicityBillDomainService.getAllByPubBatchNumList(selectProperties, batchNumList);
    }

    public DynamicObject[] queryByPermission(String selectProperties, long userId, List<String> statusList, String permItemId) {
        return publicityBillDomainService.queryByPermission(selectProperties, userId, statusList, permItemId);
    }
}

