/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.domain.release.service.ReleaseBillDomainService;

public class ReleaseBillApplicationService {
    private static final ReleaseBillDomainService releaseBillDomainService = ServiceFactory.getService(ReleaseBillDomainService.class);
    private static final ActvGenerateExtService ACTV_SERVICE = ServiceFactory.getService(ActvGenerateExtService.class);

    public void rejectToPreviousBill(DynamicObject[] releaseBills, String rejectComment) {
        List<Long> insIds = Arrays.stream(releaseBills).map(item -> item.getLong("instanceid")).collect(Collectors.toList());
        ACTV_SERVICE.batchRejectTask(insIds, rejectComment);
        releaseBillDomainService.update(releaseBills);
    }

    public void withdrawReleaseBill(DynamicObject[] releaseBills) {
        releaseBillDomainService.update(releaseBills);
    }

    public DynamicObject[] getOriginalReleaseBillById(String selectProperties, List<Long> pkIds) {
        return releaseBillDomainService.queryOriginalReleaseBillById(selectProperties, pkIds);
    }

    public DynamicObject[] queryReleaseBills(String selectProperties, List<Object> pkIds) {
        return releaseBillDomainService.queryReleaseBillById(selectProperties, pkIds);
    }

    public void doReleaseForBatchBill(DynamicObject[] releaseBills, Map<String, Object> returnData) {
        List<DynamicObject> cantoNext = releaseBillDomainService.doReleaseForBatchBill(releaseBills, returnData);
        if (CollectionUtils.isEmpty(cantoNext)) {
            return;
        }
        List<Long> insIds = cantoNext.stream().map(item -> item.getLong("instanceid")).collect(Collectors.toList());
        ACTV_SERVICE.batchConsentTask(insIds, " ");
    }

    public boolean doReleaseForSingleBill(DynamicObject releaseBill) {
        boolean ifToNext = releaseBillDomainService.doReleaseForSingleBill(releaseBill);
        return ifToNext;
    }

    public DynamicObject[] getByPubBatchNum(String selectProperties, String pubBatchNum) {
        return releaseBillDomainService.queryByPubBatchNum(selectProperties, pubBatchNum);
    }

    public void initIssueFile(DynamicObject[] issueBills) {
        releaseBillDomainService.initIssueFile(issueBills);
    }

    public DynamicObject getEffectiveReleaseBillByNominateId(Long nominateId) {
        return releaseBillDomainService.getEffectiveReleaseBillByNominateId(nominateId);
    }

    public void update(DynamicObject[] dynamicObjects) {
        releaseBillDomainService.update(dynamicObjects);
    }

    public DynamicObject[] queryByPermission(String selectProperties, long userId, List<String> statusList, String permItemId) {
        return releaseBillDomainService.queryByPermission(selectProperties, userId, statusList, permItemId);
    }
}

