/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamHisStatusEnum;
import kd.tdc.cadm.bussiness.domain.review.enmus.CoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.review.enmus.ReviewStatusEnum;
import kd.tdc.cadm.bussiness.domain.review.entityservice.ReviewHelpBillEntityService;
import kd.tdc.cadm.bussiness.domain.review.service.ReviewBillDomainService;
import kd.tdc.cadm.bussiness.domain.review.service.ReviewHisDomainService;
import kd.tdc.cadm.bussiness.util.UrlBuilder;

public class ReviewBillApplicationService {
    private static final Log LOG = LogFactory.getLog(ReviewBillApplicationService.class);
    private static final ReviewBillDomainService reviewBillDomainService = ServiceFactory.getService(ReviewBillDomainService.class);
    private static final ReviewHelpBillEntityService reviewHelpService = ServiceFactory.getService(ReviewHelpBillEntityService.class);
    private static final ActvGenerateExtService ACTV_SERVICE = ServiceFactory.getService(ActvGenerateExtService.class);
    private static final ReviewHisDomainService reviewHisService = ServiceFactory.getService(ReviewHisDomainService.class);
    private static final ExecutorService EXECUTOR_SERVICE = ThreadPools.newCachedExecutorService((String)"ReviewBillApplicationServiceSendMsgPool", (int)2, (int)20);

    public void rejectToPreviousBill(DynamicObject[] reviewBills, String rejectComment) {
        List<Long> insIds = Arrays.stream(reviewBills).map(item -> item.getLong("instanceid")).collect(Collectors.toList());
        ACTV_SERVICE.batchRejectTask(insIds, rejectComment);
        reviewBillDomainService.update(reviewBills);
        List<Long> reviewIds = Arrays.stream(reviewBills).map(item -> item.getLong("id")).collect(Collectors.toList());
        this.terminateUnHandledReviewCoop(reviewIds, CoopStatusEnum.TERMINATE, "cadm_pyzz");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> doReview(List<Long> pkIds, DynamicObjectCollection reviewers, String reviewPoints, String reviewTopic, Date reviewTime, String reviewPlace) {
        TXHandle txhandle = TX.required();
        ArrayList sendMessageIds = Lists.newArrayList();
        DynamicObjectCollection sendDiscardCoops = new DynamicObjectCollection();
        Set<String> failedBillNos = null;
        try {
            DynamicObject[] reviewBills = reviewBillDomainService.queryReviewBillById("id,billno,reviewstatus,coopcomprate,reviewpassrate,cooperateentry.coopstatus,cooperateentry.coopcreatetime,cooperateentry.cooperater,cooperateentry.entryperson,cooperateentry.revresult,cooperateentry.entrynominatebill,cooperateentry.entrycreator,cooperateentry.coopsla,modifier,modifytime,reviewtopic,reviewpoints,person,nominatebill,reviewtime,reviewplace,cooperateentry.hisrevrecord", pkIds);
            List<DynamicObject> canReviewBills = Arrays.stream(reviewBills).filter(reviewBill -> ReviewStatusEnum.canReview(reviewBill.getString("reviewstatus"))).collect(Collectors.toList());
            failedBillNos = Arrays.stream(reviewBills).filter(reviewBill -> !ReviewStatusEnum.canReview(reviewBill.getString("reviewstatus"))).map(reviewBill -> reviewBill.getString("billno")).collect(Collectors.toSet());
            Date currDate = new Date();
            long currUserId = RequestContext.get().getCurrUserId();
            if (CollectionUtils.isEmpty(canReviewBills)) {
                Set<String> set = failedBillNos;
                return set;
            }
            List<Object> pkIdList = canReviewBills.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(pkIdList)) {
                reviewHisService.updateStatusByReviewIds(pkIdList);
            }
            canReviewBills.forEach(canReviewBill -> {
                DynamicObjectCollection entry = canReviewBill.getDynamicObjectCollection("cooperateentry");
                entry.forEach(entryRow -> {
                    if (!CoopStatusEnum.DISCARD.getVal().equals(entryRow.getString("coopstatus"))) {
                        sendDiscardCoops.add(entryRow);
                        entryRow.set("coopstatus", (Object)CoopStatusEnum.DISCARD.getVal());
                    }
                });
                DynamicObject emptyDynamic = reviewHisService.createEmptyDynamic();
                emptyDynamic.set("review", canReviewBill.getPkValue());
                emptyDynamic.set("reviewtopic", (Object)reviewTopic);
                emptyDynamic.set("reviewpoints", (Object)reviewPoints);
                emptyDynamic.set("reviewtime", (Object)reviewTime);
                emptyDynamic.set("reviewplace", (Object)reviewPlace);
                emptyDynamic.set("status", (Object)ExamHisStatusEnum.VALID.getNumber());
                emptyDynamic.set("createtime", (Object)new Date());
                Object[] hisObj = reviewHisService.add(new DynamicObject[]{emptyDynamic});
                Object hisPk = ((DynamicObject)hisObj[0]).getPkValue();
                reviewers.forEach(reviewer -> {
                    DynamicObject entryDy = entry.addNew();
                    entryDy.set("hisrevrecord", (Object)Long.parseLong(hisPk.toString()));
                    entryDy.set("coopstatus", (Object)CoopStatusEnum.WAIT.getVal());
                    entryDy.set("coopcreatetime", (Object)currDate);
                    entryDy.set("cooperater", (Object)reviewer.getDynamicObject("fbasedataid"));
                    entryDy.set("entryperson", canReviewBill.get("person"));
                    entryDy.set("entrynominatebill", canReviewBill.get("nominatebill"));
                    entryDy.set("entrycreator", (Object)currUserId);
                });
                canReviewBill.set("modifier", (Object)currUserId);
                canReviewBill.set("modifytime", (Object)currDate);
                canReviewBill.set("reviewtopic", (Object)reviewTopic);
                canReviewBill.set("reviewpoints", (Object)reviewPoints);
                canReviewBill.set("reviewtime", (Object)reviewTime);
                canReviewBill.set("reviewplace", (Object)reviewPlace);
                canReviewBill.set("coopcomprate", (Object)"0%");
                canReviewBill.set("reviewstatus", (Object)ReviewStatusEnum.IN_REVIEW.getReviewStatus());
                sendMessageIds.add(canReviewBill.getLong("id"));
            });
            reviewBillDomainService.update(canReviewBills.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            LOG.error("ReviewBillApplicationService  error  ", (Throwable)e);
            txhandle.markRollback();
        }
        finally {
            txhandle.close();
        }
        EXECUTOR_SERVICE.submit(() -> sendDiscardCoops.stream().forEach(coopBill -> this.sendMessage((DynamicObject)coopBill, "entrynominatebill.id", "cadm_bh")));
        EXECUTOR_SERVICE.submit(() -> {
            DynamicObject[] sendMessageBills = reviewHelpService.query("id,billno,nominatebill,cooperater", new QFilter[]{new QFilter("review", "in", (Object)sendMessageIds), new QFilter("coopstatus", "=", (Object)CoopStatusEnum.WAIT.getVal())});
            Arrays.stream(sendMessageBills).forEach(sendMessageBill -> this.sendMessage((DynamicObject)sendMessageBill, "nominatebill.id", "cadm_xz"));
        });
        return failedBillNos;
    }

    private void sendMessage(DynamicObject reviewHelpBill, String nominateKey, String msgTempNumber) {
        Long nominateId = reviewHelpBill.getLong(nominateKey);
        Long reviewHelpBillId = reviewHelpBill.getLong("id");
        Long cooPerterId = reviewHelpBill.getLong("cooperater.id");
        String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_reviewhelpbill").setParameter("formPkId", String.valueOf(reviewHelpBillId)).builder();
        BosMessageService.sendTemplateMessage(contentUrl, Lists.newArrayList((Object[])new Long[]{cooPerterId}), nominateId, "cadm_reviewhelpbill", msgTempNumber, reviewHelpBillId);
    }

    public DynamicObject[] getOriginalReviewBillById(String selectProperties, List<Long> pkIds) {
        return reviewBillDomainService.queryOriginalReviewBillById(selectProperties, pkIds);
    }

    public DynamicObject[] queryReviewBillById(String selectProperties, List<Long> pkIds) {
        return reviewBillDomainService.queryReviewBillById(selectProperties, pkIds);
    }

    public DynamicObject[] queryReviewBillByIdAndStatus(List<ReviewStatusEnum> reviewStatusEnumList, List<Long> pkIds) {
        return reviewBillDomainService.queryReviewBillByIdAndStatus(reviewStatusEnumList, pkIds);
    }

    public DynamicObject[] getOriginalReviewHelpBillById(String selectProperties, List<Long> pkIds) {
        return reviewBillDomainService.queryOriginalReviewHelpBillById(selectProperties, pkIds);
    }

    public DynamicObject queryOne(String selectProperties, Object pkId) {
        return reviewBillDomainService.queryOne(selectProperties, pkId);
    }

    public DynamicObject getCompleteOneByNominateId(String selectProperties, long nominateId) {
        return reviewBillDomainService.getCompleteOneByNominateId(selectProperties, nominateId);
    }

    public void updateReviewStatusAndRate(Long reviewId) {
        reviewBillDomainService.updateReviewStatusAndRate(reviewId);
    }

    public void updateSendMsgTime(Long entryId) {
        reviewBillDomainService.updateSendMsgTime(entryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateUnHandledReviewCoop(List<Long> reviewIds, CoopStatusEnum coopStatusEnum, String msgTempNumber) {
        try (TXHandle required = TX.required();){
            reviewBillDomainService.terminateUnHandledReviewCoop(reviewIds, coopStatusEnum, msgTempNumber);
        }
    }

    public DynamicObject[] getReviewHelpByReviewId(String selectProperties, Object reviewId) {
        return reviewHelpService.query(selectProperties, new QFilter[]{new QFilter("review", "=", reviewId)});
    }

    public DynamicObject[] getReviewHelpListByHisRevRecord(String selectProperties, Object hisRevRecordPkId) {
        return reviewHelpService.query(selectProperties, new QFilter[]{new QFilter("hisrevrecord", "=", hisRevRecordPkId)});
    }

    public boolean ifExistReviewHelp(QFilter[] qFilters) {
        return reviewHelpService.ifExistReviewHelp(qFilters);
    }

    public DynamicObject getReviewHisByRecordId(String selectProperties, Object recordId) {
        return reviewHisService.getReviewHisByRecordId(selectProperties, recordId);
    }

    public DynamicObject[] queryByPermission(String selectProperties, long userId, List<String> statusList, String permItemId) {
        return reviewBillDomainService.queryByPermission(selectProperties, userId, statusList, permItemId);
    }
}

