/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.application.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.AppointRecordService;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.service.DismissBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ExpedBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.bussiness.domain.exped.enums.ExpedStatusEnum;
import kd.tdc.cadm.bussiness.domain.tenure.enums.PositiveStatusEnum;
import kd.tdc.cadm.bussiness.domain.tenure.enums.TenureStatusEnum;
import kd.tdc.cadm.bussiness.domain.tenure.service.ProbationDomainService;
import kd.tdc.cadm.bussiness.domain.tenure.service.TenureDomainService;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.bussiness.helper.CadreParamHelper;
import kd.tdc.cadm.bussiness.license.CertHandleService;
import kd.tdc.cadm.common.enums.PositionTypeEnum;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;
import kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper;
import kd.tdc.tdcs.common.perchange.ChangeTypeEnum;

public class TenureApplicationService {
    private static final Log LOG = LogFactory.getLog(TenureApplicationService.class);
    private static final HRBaseServiceHelper TENURE = new HRBaseServiceHelper("cadm_tenure");
    private static final TenureDomainService TENURE_DOMAIN_SERVICE = ServiceFactory.getService(TenureDomainService.class);
    private static final ProbationDomainService PROBATION_DOMAIN_SERVICE = ServiceFactory.getService(ProbationDomainService.class);
    private static final HRBaseServiceHelper RELATIONAL_SERVICE = new HRBaseServiceHelper("tdcs_relational");
    private static final HRBaseServiceHelper APPOINT_RESULT_SERVICE = new HRBaseServiceHelper("tdcs_appointrecord");
    private static final HRBaseServiceHelper DISMISS_RELATION_REPOSITORY = new HRBaseServiceHelper("tdcs_dismissrelation");
    private static final DismissBillApplicationService DISMISS_BILL_APPLICATION_SERVICE = ServiceFactory.getService(DismissBillApplicationService.class);
    private static final AppointRecordService APPOINT_RECORD_SERVICE = ServiceFactory.getService(AppointRecordService.class);
    private static final long LEAVE_ID = ChangeTypeEnum.TURNOVER.getNumber();
    private static final long RETIRE_ID = ChangeTypeEnum.RETIRED.getNumber();
    private static final String IS_EXIST_DISMISS = "isexistdismiss";
    private final ExternalService EXTERNAL_SERVICE = new ExternalService();
    private final DynamicObjectCollection dyColl = new DynamicObjectCollection();
    private final Map<Long, Map<Long, Long>> buIdMap = new HashMap<Long, Map<Long, Long>>();
    private Map<Long, DynamicObject> empJobDyMap;
    private static final CadmFormService cadmFormService = ServiceFactory.getService(CadmFormService.class);

    public void saveOne(DynamicObject dynamicObject) {
        TENURE_DOMAIN_SERVICE.saveOne(dynamicObject);
    }

    public DynamicObject newEmptyDynamic() {
        return TENURE_DOMAIN_SERVICE.generateEmptyDynamicObject();
    }

    public DynamicObject queryTenureOneById(String selectFields, Object tenureId) {
        return TENURE.queryOne(selectFields, tenureId);
    }

    private DynamicObject[] queryTenureDataByIds(String selectProperties, List<Long> pkIds) {
        return TENURE_DOMAIN_SERVICE.queryTenureDataByIds(selectProperties, pkIds);
    }

    public DynamicObject queryTenureOriginalOneById(String selectFields, Object tenureId) {
        return TENURE.queryOriginalOne(selectFields, tenureId);
    }

    public void update(DynamicObject tenureDy) {
        TENURE.updateDataOne(tenureDy);
    }

    public void updateSupervisory(DynamicObject tenureDy) {
        TENURE.updateOne(tenureDy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateTenure() {
        if (!new CadreParamHelper().getOpenCadm()) {
            LOG.info("generateTenure isOpencadm is close or not tdc");
            return;
        }
        Date currDate = new Date();
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)Boolean.FALSE);
        QFilter empPosRelQFilter = new QFilter("empposrel", "!=", (Object)0L);
        long currUserId = RequestContext.get().getCurrUserId();
        Object[] relationalArr = RELATIONAL_SERVICE.query("id,modifier,modifytime,employee,position,job,standardposition,empposrel,appointid,pulltime,ispull,positiontype", new QFilter[]{isPullQFilter, empPosRelQFilter});
        if (HRArrayUtils.isEmpty((Object[])relationalArr)) {
            LOG.info("generateTenure relationalArr1 is null");
            return;
        }
        relationalArr = (DynamicObject[])Arrays.stream(relationalArr).filter(dynObj -> dynObj.getDynamicObject("employee") != null).toArray(DynamicObject[]::new);
        List personIds = Arrays.stream(relationalArr).map(dynObj -> dynObj.getDynamicObject("employee").getLong("person_id")).collect(Collectors.toList());
        Map certRstMap = TDCSCertCommonHelper.verifyCertByPersonId((String)"1W6FQ9DP=KX3", (String)"cadm_tenure", personIds);
        CertHandleService.handleForbidden(certRstMap);
        Set<Long> nPermSet = CertHandleService.getNoCertPersonSet(certRstMap);
        LOG.info("generateTenure nPermSet:{}", nPermSet);
        relationalArr = Arrays.stream(relationalArr).filter(val -> {
            long personId = val.getDynamicObject("employee").getLong("person_id");
            return !nPermSet.contains(personId);
        }).collect(Collectors.toList()).toArray(new DynamicObject[0]);
        Boolean isTenure = (Boolean)new CadreParamHelper().getCadmParam("istenure");
        LOG.info("generateTenure isTenure:{}", (Object)isTenure);
        Object[] nominateDynamicArray = null;
        DynamicObject[] needUpdateAppointRemoveRelArr = null;
        try {
            if (Boolean.TRUE.equals(isTenure)) {
                relationalArr = Arrays.stream(relationalArr).filter(value -> value.getLong("empposrel.id") != 0L).collect(Collectors.toList()).toArray(new DynamicObject[0]);
                Object[] relationalArrCopy = (DynamicObject[])Arrays.copyOf(relationalArr, relationalArr.length);
                Boolean isCreateTenure = (Boolean)new CadreParamHelper().getCadmParam("iscreatetenure");
                relationalArr = (DynamicObject[])Arrays.stream(relationalArr).filter(value -> value.getLong("appointid") != 0L).toArray(DynamicObject[]::new);
                if (Boolean.TRUE.equals(isCreateTenure)) {
                    relationalArrCopy = this.filterVariationtype((DynamicObject[])relationalArrCopy);
                    relationalArr = (DynamicObject[])ArrayUtils.addAll((Object[])relationalArr, (Object[])relationalArrCopy);
                }
                boolean isCreateTenureFlag = isCreateTenure != false && relationalArrCopy.length > 0;
                LOG.info("generateTenure isCreateTenure: {},ids:{}", (Object)isCreateTenure, Arrays.stream(relationalArr).map(o -> o.getLong("id")).collect(Collectors.toList()));
                relationalArr = this.filterRelationalArr((DynamicObject[])relationalArr);
                if (HRArrayUtils.isEmpty((Object[])relationalArr) && !isCreateTenureFlag) {
                    LOG.info("generateTenure relationalArr2 is null");
                    return;
                }
                List<Long> appointIds = Arrays.stream(relationalArr).filter(value -> value.getLong("appointid") != 0L).map(value -> value.getLong("appointid")).collect(Collectors.toList());
                nominateDynamicArray = this.getBatchUpdateAppointBill(appointIds);
                if (HRArrayUtils.isEmpty((Object[])nominateDynamicArray) && !isCreateTenureFlag) {
                    LOG.info("generateTenure relationalArr3 is null");
                    return;
                }
                Map empPosOrgRel = this.EXTERNAL_SERVICE.getEmpPosOrgRel("id,org,person,cmpemp,employee,job,position,isexistprobation,isprimary,depemp,company,adminorg,stdposition,startdate,enddate,endprobation,apositiontype,variationtype", Arrays.stream(relationalArr).map(value -> value.getLong("empposrel.id")).collect(Collectors.toList()));
                this.buildEmpExpMap(empPosOrgRel);
                DynamicObject[] appointResult = APPOINT_RESULT_SERVICE.queryOriginalArray("id,cadrecat,prepositivedate,appointid,appointdate,planenddate,appointtype,positiontype", new QFilter[]{new QFilter("appointid", "in", appointIds)});
                Map<Long, DynamicObject> idAppointResultMap = Arrays.stream(appointResult).collect(Collectors.toMap(value -> value.getLong("appointid"), value -> value, (v1, v2) -> v1));
                LOG.info("generateTenure idAppointResultMap is {},relationalArr size;{}", idAppointResultMap, (Object)relationalArr.length);
                Arrays.stream(relationalArr).forEach(element -> {
                    DynamicObject empPosDy = (DynamicObject)empPosOrgRel.get(element.getLong("empposrel.id"));
                    if (Objects.isNull(empPosDy)) {
                        return;
                    }
                    this.buildTenureDy(empPosDy, (DynamicObject)idAppointResultMap.get(element.getLong("appointid")), currUserId, currDate);
                    element.set("pulltime", (Object)currDate);
                    element.set("modifier", (Object)currUserId);
                    element.set("modifytime", (Object)currDate);
                    element.set("ispull", (Object)"1");
                });
                needUpdateAppointRemoveRelArr = (DynamicObject[])Arrays.copyOf(relationalArr, relationalArr.length);
            } else {
                relationalArr = this.filterRelationalArr((DynamicObject[])relationalArr);
                Map empPosOrgRel = this.EXTERNAL_SERVICE.getEmpPosOrgRel("id,org,person,cmpemp,employee,job,position,isexistprobation,isprimary,depemp,company,adminorg,stdposition,startdate,enddate,endprobation,apositiontype", Arrays.stream(relationalArr).map(value -> value.getLong("empposrel.id")).collect(Collectors.toList()));
                this.buildEmpExpMap(empPosOrgRel);
                Arrays.stream(relationalArr).forEach(element -> {
                    DynamicObject empPosDy = (DynamicObject)empPosOrgRel.get(element.getLong("empposrel.id"));
                    if (Objects.isNull(empPosDy)) {
                        return;
                    }
                    this.buildTenureDy(empPosDy, null, currUserId, currDate);
                    element.set("pulltime", (Object)currDate);
                    element.set("modifier", (Object)currUserId);
                    element.set("modifytime", (Object)currDate);
                    element.set("ispull", (Object)"1");
                });
            }
            LOG.info("generateTenure Data, ids:{}", Arrays.stream(relationalArr).map(o -> o.getLong("id")).collect(Collectors.toList()));
            if (CollectionUtils.isEmpty((Collection)this.dyColl)) {
                LOG.info("generateTenure dyColl is null");
                return;
            }
            try (TXHandle txhandle = TX.required();){
                RELATIONAL_SERVICE.updateDatas((DynamicObject[])relationalArr);
                TENURE_DOMAIN_SERVICE.save((DynamicObject[])this.dyColl.toArray((Object[])new DynamicObject[0]));
                if (ArrayUtils.isNotEmpty(nominateDynamicArray)) {
                    Arrays.stream(nominateDynamicArray).forEach(nominateDynamic -> {
                        nominateDynamic.set("appointeffectstatus", (Object)"1");
                        nominateDynamic.set("dismisseffectstatus", (Object)"1");
                    });
                    NominateApplicationService NOMINATE_APPLICATION_SERVICE = new NominateApplicationService();
                    NOMINATE_APPLICATION_SERVICE.updateData((DynamicObject[])nominateDynamicArray);
                }
            }
            if (!txhandle.isRollback()) {
                this.updateAppointRemoveRel(needUpdateAppointRemoveRelArr);
            }
        }
        catch (Exception exc) {
            LOG.error("generateTenure error:{}", (Object)exc.getMessage());
        }
        finally {
            CertHandleService.handleFail(certRstMap);
        }
    }

    private DynamicObject[] filterVariationtype(DynamicObject[] relationalArr) {
        relationalArr = (DynamicObject[])Arrays.stream(relationalArr).filter(value -> value.getLong("appointid") == 0L).toArray(DynamicObject[]::new);
        DynamicObject[] dys = ExternalDataService.getChgCategory(ChangeTypeEnum.HIRE_PEOPLE_ON_BOARD.getNumber());
        List numberList = Arrays.stream(dys).map(o -> o.getLong("actiontype")).collect(Collectors.toList());
        Map empPosOrgRel = this.EXTERNAL_SERVICE.getEmpPosOrgRel("id,org,person,cmpemp,employee,job,position,isexistprobation,isprimary,depemp,company,adminorg,stdposition,startdate,enddate,endprobation,apositiontype,variationtype", Arrays.stream(relationalArr).map(value -> value.getLong("empposrel.id")).collect(Collectors.toList()));
        return Arrays.stream(relationalArr).filter(element -> {
            long empPosOrgRelId = element.getLong("empposrel.id");
            DynamicObject empPosOrgRelDy = (DynamicObject)empPosOrgRel.get(empPosOrgRelId);
            if (Objects.isNull(empPosOrgRelDy)) {
                return true;
            }
            return numberList.contains(empPosOrgRelDy.getLong("variationtype.id"));
        }).collect(Collectors.toList()).toArray(new DynamicObject[0]);
    }

    private void updateAppointRemoveRel(DynamicObject[] relationalArr) {
        if (relationalArr == null || relationalArr.length == 0) {
            return;
        }
        Map<Long, Long> map = Arrays.stream(relationalArr).filter(p -> p.getLong("appointid") != 0L).collect(Collectors.toMap(p -> p.getLong("appointid"), p -> p.getLong("empposrel_id"), (v1, v2) -> v1));
        if (map.isEmpty()) {
            return;
        }
        String selectProperties = "id,person_id,employee_id,appointid,dismissbillid,positiontype,standardposition_id,position_id,job_id,cadrecat_id,adminorg_id,appointdate,appointreason,isprimappoint,pptreasongroup_id,appointtype_id,apptreasongroup_id,dismissreasongroup,dismissreason,dismisstype_id";
        Set<Long> appointIds = map.keySet();
        DynamicObject[] appointRecords = APPOINT_RECORD_SERVICE.queryAppointRecordByAppointIds(selectProperties, new ArrayList<Long>(appointIds));
        Map<Long, DynamicObject> appointRecordMap = Arrays.stream(appointRecords).collect(Collectors.toMap(p -> p.getLong("appointid"), p -> p, (v1, v2) -> v1));
        map.forEach((appointId, empposrelId) -> {
            DynamicObject appointRecord = (DynamicObject)appointRecordMap.get(appointId);
            NominateApplicationService NOMINATE_APPLICATION_SERVICE = new NominateApplicationService();
            Map<String, Object> param = NOMINATE_APPLICATION_SERVICE.buildCommonAppointRemoveRelParam("1", appointRecord);
            param.put("datatype", "update");
            param.put("appointrecordid", appointRecord.getLong("id"));
            param.put("empposorgrelid", empposrelId);
            Map<String, Object> result = ExternalDataService.insertOrUpdateAppointRemoveRel(param);
            LOG.info("updateAppointRemoveRel result:{}", result);
        });
    }

    public void updateAppointRemoveRelByReAppointment(List<DynamicObject> nominateList) {
        if (nominateList.size() == 0) {
            return;
        }
        List depempIds = nominateList.stream().filter(p -> p.getDynamicObject("atenure") != null).map(p -> p.getLong("atenure.depemp.id")).collect(Collectors.toList());
        List empOrgrelsList = ExternalService.listDataEmpOrgrels(depempIds);
        Map<Long, Long> depempMap = empOrgrelsList.stream().filter(p -> p.get("depemp") != null).collect(Collectors.toMap(p -> Long.parseLong(String.valueOf(p.get("depemp"))), p -> Long.parseLong(String.valueOf(p.get("id"))), (v1, v2) -> v1));
        List appointIds = nominateList.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        String selectProperties = "id,person_id,employee_id,appointid,dismissbillid,positiontype,standardposition_id,position_id,job_id,cadrecat_id,adminorg_id,appointdate,appointreason,isprimappoint,pptreasongroup_id,appointtype_id,apptreasongroup_id,dismissreasongroup,dismissreason,dismisstype_id";
        DynamicObject[] appointRecords = APPOINT_RECORD_SERVICE.queryAppointRecordByAppointIds(selectProperties, new ArrayList<Long>(appointIds));
        Map<Long, DynamicObject> appointRecordMap = Arrays.stream(appointRecords).collect(Collectors.toMap(p -> p.getLong("appointid"), p -> p, (v1, v2) -> v1));
        nominateList.forEach(nominate -> {
            long appointId = nominate.getLong("id");
            DynamicObject appointRecord = (DynamicObject)appointRecordMap.get(appointId);
            NominateApplicationService NOMINATE_APPLICATION_SERVICE = new NominateApplicationService();
            Map<String, Object> param = NOMINATE_APPLICATION_SERVICE.buildCommonAppointRemoveRelParam("1", appointRecord);
            param.put("datatype", "update");
            param.put("appointrecordid", appointRecord.getLong("id"));
            DynamicObject aTenure = nominate.getDynamicObject("atenure");
            if (aTenure != null) {
                long depempId = aTenure.getLong("depemp.id");
                Long empposrelId = (Long)depempMap.get(depempId);
                param.put("empposorgrelid", empposrelId);
            }
            Map<String, Object> result = ExternalDataService.insertOrUpdateAppointRemoveRel(param);
            LOG.info("updateAppointRemoveRelByReAppointment result:{}", result);
        });
    }

    private DynamicObject[] getBatchUpdateAppointBill(List<Long> appointIds) {
        NominateApplicationService NOMINATE_APPLICATION_SERVICE = new NominateApplicationService();
        Object[] nominateDynamicArray = NOMINATE_APPLICATION_SERVICE.queryNominateBillsByIds("id,appointeffectstatus,dismisseffectstatus,appointdate", appointIds);
        if (ArrayUtils.isNotEmpty((Object[])nominateDynamicArray)) {
            List<DynamicObject> collect = Arrays.stream(nominateDynamicArray).filter(nominate -> System.currentTimeMillis() >= (nominate.getDate("appointdate") == null ? 0L : nominate.getDate("appointdate").getTime())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                nominateDynamicArray = new DynamicObject[]{};
            } else {
                DynamicObject[] filterDynamicObjects = new DynamicObject[collect.size()];
                nominateDynamicArray = collect.toArray(filterDynamicObjects);
            }
        }
        return nominateDynamicArray;
    }

    private DynamicObject[] filterRelationalArr(DynamicObject[] relationalArr) {
        List empIds = Arrays.stream(relationalArr).map(relational -> relational.getLong("employee.id")).collect(Collectors.toList());
        DynamicObject[] notLeaveData = TENURE.queryOriginalArray("id,employee,position,job,standardpost,apositiontype", new QFilter[]{new QFilter("employee", "in", empIds), new QFilter("tenurestatus", "!=", (Object)TenureStatusEnum.LEAVE.getNumber())});
        Map<Long, List<DynamicObject>> empTenure = Arrays.stream(notLeaveData).collect(Collectors.groupingBy(value -> value.getLong("employee.id")));
        return Arrays.stream(relationalArr).filter(element -> {
            List tenure = (List)empTenure.get(element.getLong("employee.id"));
            if (CollectionUtils.isEmpty((Collection)tenure)) {
                return true;
            }
            return tenure.stream().noneMatch(value -> element.getLong("position.id") == value.getLong("position") && element.getString("positiontype").equals(value.getString("apositiontype")) && PositionTypeEnum.POSITION.getNumber().equals(element.getString("positiontype")) || element.getLong("job.id") == value.getLong("job") && element.getString("positiontype").equals(value.getString("apositiontype")) && PositionTypeEnum.JOB.getNumber().equals(element.getString("positiontype")) || element.getLong("standardposition.id") == value.getLong("standardpost") && element.getString("positiontype").equals(value.getString("apositiontype")) && PositionTypeEnum.STANDER_POSITION.getNumber().equals(element.getString("positiontype")));
        }).collect(Collectors.toList()).toArray(new DynamicObject[0]);
    }

    private void buildEmpExpMap(Map<Long, DynamicObject> empPosOrgRel) {
        HashSet idSet = Sets.newHashSet();
        empPosOrgRel.forEach((key, value) -> idSet.add(value.getLong("employee_id")));
        DynamicObject[] empJobDy = this.EXTERNAL_SERVICE.queryEmpJobLevelByEmpIds((Set)idSet);
        this.empJobDyMap = Arrays.stream(empJobDy).collect(Collectors.toMap(value -> value.getLong("employee"), value -> value, (v1, v2) -> v1));
        this.buildBuIdMap(empPosOrgRel);
    }

    private void buildTenureDy(DynamicObject empPosDy, DynamicObject appointResult, long currUserId, Date currDate) {
        DynamicObject empJobDy;
        DynamicObject tenureDy = TENURE.generateEmptyDynamicObject();
        tenureDy.set("modifier", (Object)currUserId);
        tenureDy.set("modifytime", (Object)currDate);
        tenureDy.set("creator", (Object)currUserId);
        tenureDy.set("createtime", (Object)currDate);
        tenureDy.set("expedstatus", (Object)ExpedStatusEnum.NOT.getNumber());
        Date startDate = empPosDy.getDate("startdate");
        Date endDate = empPosDy.getDate("enddate");
        tenureDy.set("realstartdate", (Object)startDate);
        if (null != endDate && HRDateTimeUtils.getYear((Date)endDate) < 2099) {
            tenureDy.set("realenddate", (Object)endDate);
        }
        tenureDy.set("apositiontype", (Object)empPosDy.getString("apositiontype"));
        if (appointResult == null) {
            if (HRDateTimeUtils.dayAfter((Date)currDate, (Date)endDate)) {
                tenureDy.set("tenurestatus", (Object)TenureStatusEnum.LEAVE.getNumber());
            } else {
                tenureDy.set("tenurestatus", (Object)TenureStatusEnum.ASSUME.getNumber());
            }
        } else {
            Date prePositiveDate = appointResult.getDate("prepositivedate");
            if (HRDateTimeUtils.dayAfter((Date)currDate, (Date)endDate)) {
                tenureDy.set("tenurestatus", (Object)TenureStatusEnum.LEAVE.getNumber());
            } else if (Objects.isNull(prePositiveDate)) {
                tenureDy.set("tenurestatus", (Object)TenureStatusEnum.ASSUME.getNumber());
            } else {
                tenureDy.set("positivestatus", (Object)PositiveStatusEnum.TODO.getNumber());
                tenureDy.set("tenurestatus", (Object)TenureStatusEnum.PROBATION.getNumber());
                tenureDy.set("prepositivedate", (Object)prePositiveDate);
            }
            tenureDy.set("appoint", (Object)appointResult.getLong("appointid"));
            Date appointDate = appointResult.getDate("appointdate");
            tenureDy.set("planstartdate", (Object)appointDate);
            tenureDy.set("cadrecat", appointResult.get("cadrecat"));
            tenureDy.set("planenddate", appointResult.get("planenddate"));
            if (1472625044948646912L == appointResult.getLong("appointtype")) {
                tenureDy.set("realstartdate", (Object)appointDate);
            }
        }
        Long perId = empPosDy.getLong("person.id");
        Long adminOrgId = empPosDy.getLong("adminorg.id");
        Long buId = this.buIdMap.get(perId).get(adminOrgId);
        tenureDy.set("org", (Object)buId);
        tenureDy.set("affiliateadminorg", (Object)adminOrgId);
        tenureDy.set("company", empPosDy.get("company"));
        tenureDy.set("adminorg", (Object)adminOrgId);
        tenureDy.set("empgroup", (Object)1050L);
        Long employeeId = empPosDy.getLong("employee.id");
        tenureDy.set("employee", (Object)employeeId);
        tenureDy.set("cmpemp", empPosDy.get("cmpemp"));
        tenureDy.set("depemp", empPosDy.get("depemp"));
        tenureDy.set("person", (Object)perId);
        tenureDy.set("isprimappoint", (Object)empPosDy.getString("isprimary"));
        if (null != empPosDy.get("position")) {
            tenureDy.set("position", empPosDy.get("position"));
        }
        if (null != empPosDy.get("job")) {
            tenureDy.set("job", empPosDy.get("job"));
        }
        if (null != empPosDy.get("stdposition")) {
            tenureDy.set("standardpost", empPosDy.get("stdposition"));
        }
        if (!HRObjectUtils.isEmpty((Object)(empJobDy = this.empJobDyMap.get(employeeId)))) {
            tenureDy.set("jobgrade", (Object)empJobDy.getLong("joblevel"));
        }
        this.dyColl.add((Object)tenureDy);
    }

    public void buildBuIdMap(Map<Long, DynamicObject> empPosOrgRel) {
        empPosOrgRel.forEach((id, empDy) -> {
            long adminOrgId = empDy.getLong("adminorg.id");
            long perId = empDy.getLong("person.id");
            Map<Long, Long> idMapping = this.buIdMap.get(perId);
            if (idMapping == null) {
                long buId = this.EXTERNAL_SERVICE.getBuIdByAdminOrgId(adminOrgId, perId, 1050L);
                LOG.info("adminOrgId:{},perId:{},buId:{}", new Object[]{adminOrgId, perId, buId});
                idMapping = new HashMap<Long, Long>(16);
                idMapping.put(adminOrgId, buId);
                this.buIdMap.put(perId, idMapping);
            } else {
                Long buId = idMapping.get(adminOrgId);
                if (buId == null) {
                    buId = this.EXTERNAL_SERVICE.getBuIdByAdminOrgId(adminOrgId, perId, 1050L);
                    idMapping.put(adminOrgId, buId);
                }
            }
        });
    }

    public long getAppointIdById(long tenureId) {
        DynamicObject tenureDO = TENURE.queryOne("appoint.id", new QFilter[]{new QFilter("id", "=", (Object)tenureId)});
        if (HRObjectUtils.isEmpty((Object)tenureDO)) {
            return 0L;
        }
        return tenureDO.getLong("appoint_id");
    }

    public void updateExpedBillInfo(Object tenureId, Long expedId, Map<String, Object> param) {
        ExpedBillApplicationService EXPED_SERVICE = new ExpedBillApplicationService();
        DynamicObject expedDy = EXPED_SERVICE.queryNewestExpedOneByTenureId("id", tenureId);
        if (expedDy.getLong("id") == expedId.longValue()) {
            DynamicObject beUpdateTenure = TENURE.queryOne("id,modifier,modifytime,expedstatus,expedcoopratio,expedresult", tenureId);
            param.forEach((arg_0, arg_1) -> ((DynamicObject)beUpdateTenure).set(arg_0, arg_1));
            beUpdateTenure.set("modifytime", (Object)new Date());
            beUpdateTenure.set("modifier", (Object)RequestContext.get().getCurrUserId());
            TENURE.updateDataOne(beUpdateTenure);
        }
    }

    public DynamicObject loadSingler(Object pkValue) {
        return TENURE.loadSingle(pkValue);
    }

    public DynamicObject[] queryBeEffectiveData() {
        return TENURE_DOMAIN_SERVICE.queryBeEffectiveData();
    }

    public void updateData(DynamicObject[] beUpdateData) {
        TENURE_DOMAIN_SERVICE.updateData(beUpdateData);
    }

    public DynamicObject[] queryNonLeaveDataByEmployee(String selectProperties, long employeeId) {
        return TENURE_DOMAIN_SERVICE.queryNonLeaveDataByEmployee(selectProperties, employeeId);
    }

    public DynamicObject[] queryNonLeaveDataByEmployeeAndPosition(String selectProperties, long employeeId, long positionId) {
        return TENURE_DOMAIN_SERVICE.queryNonLeaveDataByEmployeeAndPosition(selectProperties, employeeId, positionId);
    }

    public DynamicObject[] queryNonLeaveDataByEmployeeAndJob(String selectProperties, long employeeId, long jobId) {
        return TENURE_DOMAIN_SERVICE.queryNonLeaveDataByEmployeeAndJobId(selectProperties, employeeId, jobId);
    }

    public DynamicObject[] queryNonLeaveDataByEmployeeAndStandardPosition(String selectProperties, long employeeId, long standardPositionId) {
        return TENURE_DOMAIN_SERVICE.queryNonLeaveDataByEmployeeAndStandardPositionId(selectProperties, employeeId, standardPositionId);
    }

    public DynamicObject[] directInvalidTenure(long employeeId, DynamicObject nominateBill) {
        return this.getToBeLeavedTenureData(employeeId, null, nominateBill, 0L);
    }

    public DynamicObject[] getToBeLeavedTenureData(long employeeId, DynamicObject dynamicObject, DynamicObject nominateBill, long empPosRelId) {
        long positionBoId = null == dynamicObject ? 0L : HRDyObjectPropUtil.getId((DynamicObject)dynamicObject.getDynamicObject("position"));
        long jobBoId = null == dynamicObject ? 0L : HRDyObjectPropUtil.getId((DynamicObject)dynamicObject.getDynamicObject("job"));
        long standardPositionBoId = null == dynamicObject ? 0L : HRDyObjectPropUtil.getId((DynamicObject)dynamicObject.getDynamicObject("standardposition"));
        LOG.info("getToBeLeavedTenureData, employeeId: {}, dPositionBoId: {},dJobBoId: {}, dStandardPositionBoId: {}", new Object[]{employeeId, positionBoId, jobBoId, standardPositionBoId});
        long currUserId = RequestContext.get().getCurrUserId();
        Date modifyTime = new Date();
        DynamicObject[] tenures = null;
        if (nominateBill != null && 1472625044948646912L == nominateBill.getDynamicObject("appointtype").getLong("id")) {
            Date appointEndDate = nominateBill.getDate("appointenddate");
            DynamicObject dismissTenure = nominateBill.getDynamicObject("dismisstenure");
            if (dismissTenure != null) {
                DynamicObject dismiss = TENURE.queryOne(dismissTenure.getPkValue());
                dismiss.set("realenddate", (Object)appointEndDate);
                dismiss.set("tenurestatus", (Object)TenureStatusEnum.LEAVE.getNumber());
                dismiss.set("modifier", (Object)currUserId);
                dismiss.set("modifytime", (Object)modifyTime);
                tenures = new DynamicObject[]{dismiss};
            }
        } else {
            Map<Long, DynamicObject> empPosOrgRelMap = ExternalDataService.getEmpPosOrgRel("enddate,apositiontype", Lists.newArrayList((Object[])new Long[]{empPosRelId}));
            DynamicObject empPosRel = empPosOrgRelMap.get(empPosRelId);
            if (empPosRel == null) {
                LOG.info(">>> getEmpPosOrgRel, no empPosRel data, empPosRelId: {}", (Object)empPosRelId);
                return new DynamicObject[0];
            }
            String positionType = empPosRel.getString("apositiontype");
            String selectProperties = "realenddate,tenurestatus,modifier,modifytime,position,job,standardposition,depemp";
            if (0L != positionBoId && PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                tenures = TENURE_DOMAIN_SERVICE.queryNonLeaveDataByEmployeeAndPosition(selectProperties, employeeId, positionBoId);
            }
            if (0L != jobBoId && PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                tenures = TENURE_DOMAIN_SERVICE.queryNonLeaveDataByEmployeeAndJobId(selectProperties, employeeId, jobBoId);
            }
            if (0L != standardPositionBoId && PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                tenures = TENURE_DOMAIN_SERVICE.queryNonLeaveDataByEmployeeAndStandardPositionId(selectProperties, employeeId, standardPositionBoId);
            }
            if (tenures == null || tenures.length == 0) {
                LOG.info("getToBeLeavedTenureData, no tenure data");
                return new DynamicObject[0];
            }
            for (DynamicObject tenure : tenures) {
                Date endDate = empPosRel.getDate("enddate");
                LOG.info("set tenure.realenddate = {}, empPosRelId: {}", (Object)endDate, (Object)empPosRelId);
                tenure.set("realenddate", (Object)endDate);
                tenure.set("tenurestatus", (Object)TenureStatusEnum.LEAVE.getNumber());
                tenure.set("modifier", (Object)currUserId);
                tenure.set("modifytime", (Object)modifyTime);
            }
        }
        return tenures;
    }

    public DynamicObject[] getToBeLeavedTenureData(long employeeId) {
        LOG.info("getToBeLeavedTenureData, employeeId: {}", (Object)employeeId);
        DynamicObject[] tenures = TENURE_DOMAIN_SERVICE.queryNonLeaveDataByEmployeeAndPosition("realenddate,tenurestatus,modifier,modifytime,position,job,standardposition,depemp", employeeId, 0L);
        if (tenures == null || tenures.length == 0) {
            LOG.info("getToBeLeavedTenureData, no tenure data");
            return new DynamicObject[0];
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Date modifyTime = new Date();
        DynamicObject[] empPosRel = ExternalDataService.getCurrentVersionEmpPosOrgRelByEmpId(employeeId, "depemp,enddate");
        Map<Long, Date> depEmpEndDateMap = Arrays.stream(empPosRel).collect(Collectors.toMap(item -> HRDyObjectPropUtil.getId((DynamicObject)item.getDynamicObject("depemp")), item -> item.getDate("enddate"), (v1, v2) -> v2));
        LOG.info("depEmpEndDateMap, {}", depEmpEndDateMap);
        for (DynamicObject tenure : tenures) {
            long depEmpId = HRDyObjectPropUtil.getId((DynamicObject)tenure.getDynamicObject("depemp"));
            Date endDate = depEmpEndDateMap.get(depEmpId);
            LOG.info("set tenure.realenddate = {}, depEmpId: {}", (Object)endDate, (Object)depEmpId);
            tenure.set("realenddate", (Object)endDate);
            tenure.set("tenurestatus", (Object)TenureStatusEnum.LEAVE.getNumber());
            tenure.set("modifier", (Object)currUserId);
            tenure.set("modifytime", (Object)modifyTime);
        }
        return tenures;
    }

    public DynamicObject directEffectiveTenure(DynamicObject nominateBill) {
        long appointTypeId = nominateBill.getDynamicObject("appointtype").getLong("id");
        if (1472625044948646912L != appointTypeId) {
            return null;
        }
        DynamicObject aTenure = nominateBill.getDynamicObject("atenure");
        String selectProperties = "id,company,adminorg,empgroup,employee,depemp,person,cmpemp,affiliateadminorg,jobgrade,cadrecat,org,apositiontype,job,position,standardpost";
        if (aTenure == null) {
            LOG.error("directEffectiveTenure aTenure is null, nominominateBill id: {}", (Object)nominateBill.getLong("id"));
            return null;
        }
        DynamicObject[] query = TENURE.query(selectProperties, new QFilter[]{new QFilter("id", "=", aTenure.getPkValue())});
        if (null == query || query.length == 0) {
            LOG.error("directEffectiveTenure fail by {} getDynamic is empty");
            return null;
        }
        DynamicObject dynamicObject = TENURE.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)query[0], (DynamicObject)dynamicObject);
        dynamicObject.set("id", (Object)0L);
        Date currDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        dynamicObject.set("modifier", (Object)currUserId);
        dynamicObject.set("modifytime", (Object)currDate);
        dynamicObject.set("creator", (Object)currUserId);
        dynamicObject.set("createtime", (Object)currDate);
        dynamicObject.set("expedstatus", (Object)ExpedStatusEnum.NOT.getNumber());
        dynamicObject.set("cadrecat_id", (Object)nominateBill.getLong("cadrecat.id"));
        Date prePositiveDate = nominateBill.getDate("prepositivedate");
        if (null != prePositiveDate) {
            dynamicObject.set("tenurestatus", (Object)TenureStatusEnum.PROBATION.getNumber());
            dynamicObject.set("positivestatus", (Object)PositiveStatusEnum.TODO.getNumber());
            dynamicObject.set("prepositivedate", (Object)prePositiveDate);
        } else {
            dynamicObject.set("tenurestatus", (Object)TenureStatusEnum.ASSUME.getNumber());
        }
        Date appointDate = nominateBill.getDate("appointdate");
        Date planEndDate = nominateBill.getDate("planenddate");
        dynamicObject.set("realstartdate", (Object)appointDate);
        dynamicObject.set("planstartdate", (Object)appointDate);
        dynamicObject.set("planenddate", (Object)planEndDate);
        dynamicObject.set("isprimappoint", (Object)nominateBill.getString("isprimappoint"));
        String positionType = dynamicObject.getString("apositiontype");
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType) && null != nominateBill.get("aposition")) {
            dynamicObject.set("position_id", (Object)nominateBill.getDynamicObject("aposition").getLong("boid"));
        } else if (PositionTypeEnum.JOB.getNumber().equals(positionType) && null != nominateBill.get("ajob")) {
            dynamicObject.set("job_id", (Object)nominateBill.getDynamicObject("ajob").getLong("boid"));
        } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType) && null != nominateBill.get("astandardposition")) {
            dynamicObject.set("standardpost_id", (Object)nominateBill.getDynamicObject("astandardposition").getLong("boid"));
        }
        dynamicObject.set("appoint", (Object)nominateBill.getLong("id"));
        return dynamicObject;
    }

    public void batchSave(DynamicObject[] dynamicObjects) {
        TENURE_DOMAIN_SERVICE.save(dynamicObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullDismissRelationDataToInvalidTenure() {
        if (!new CadreParamHelper().getOpenCadm()) {
            LOG.info("dismissRelations isOpencadm is close or not tdc");
            return;
        }
        Date currDate = new Date();
        QFilter isPullQFilter = new QFilter("ispull", "=", (Object)Boolean.FALSE);
        QFilter empPosRelQFilter = new QFilter("empposrel", "!=", (Object)0L);
        Object[] dismissRelations = DISMISS_RELATION_REPOSITORY.query("id,modifier,modifytime,empposrel,dismissbillid,pulltime,ispull,employee,position,job,standardposition,variationtypeid", new QFilter[]{isPullQFilter, empPosRelQFilter});
        if (HRArrayUtils.isEmpty((Object[])dismissRelations)) {
            LOG.info("dismissRelations is empty");
            return;
        }
        DynamicObjectCollection tenureColl = new DynamicObjectCollection();
        ArrayList needValidBillList = Lists.newArrayList();
        Boolean isTenure = (Boolean)new CadreParamHelper().getCadmParam("istenure");
        LOG.info("dismissRelations isTenure:{}", (Object)isTenure);
        boolean isExpireTenureFlag = false;
        if (Boolean.TRUE.equals(isTenure)) {
            Object[] dismissRelationsCopy = (DynamicObject[])Arrays.copyOf(dismissRelations, dismissRelations.length);
            dismissRelations = (DynamicObject[])Arrays.stream(dismissRelations).filter(value -> value.getLong("dismissbillid") != 0L).toArray(DynamicObject[]::new);
            Boolean isExpireTenure = (Boolean)new CadreParamHelper().getCadmParam("isexpiretenure");
            if (Boolean.TRUE.equals(isExpireTenure)) {
                dismissRelationsCopy = (DynamicObject[])Arrays.stream(dismissRelationsCopy).filter(value -> value.getLong("dismissbillid") == 0L && value.getLong("variationtypeid") == LEAVE_ID).toArray(DynamicObject[]::new);
                dismissRelations = (DynamicObject[])ArrayUtils.addAll((Object[])dismissRelations, (Object[])dismissRelationsCopy);
            }
            isExpireTenureFlag = isExpireTenure != false && dismissRelationsCopy.length > 0;
            LOG.info("dismissRelations isExpireTenure: {},ids:{}", (Object)isExpireTenure, Arrays.stream(dismissRelations).map(o -> o.getLong("id")).collect(Collectors.toList()));
            List ids = Arrays.stream(dismissRelations).map(item -> item.getLong("id")).collect(Collectors.toList());
            LOG.info("dismissRelations:{}", (Object)ids.toString());
            List<Long> dismissBillIdList = Arrays.stream(dismissRelations).filter(value -> value.getLong("dismissbillid") != 0L).map(dismissDynamic -> dismissDynamic.getLong("dismissbillid")).collect(Collectors.toList());
            Object[] dynamicObjects = DISMISS_BILL_APPLICATION_SERVICE.getDismissBillById("appointenddate,dismisseffectstatus,appointeffectstatus", dismissBillIdList);
            if (ArrayUtils.isEmpty((Object[])dynamicObjects) && !isExpireTenureFlag) {
                LOG.info(" from dismissRelations by dismissBillId: {} get NominateBill is empty", (Object)dismissBillIdList.toString());
                return;
            }
            Map<Long, DynamicObject> map = Arrays.stream(dynamicObjects).filter(dynamicObject -> null != dynamicObject.getDate("appointenddate") && System.currentTimeMillis() > dynamicObject.getDate("appointenddate").getTime()).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject));
            if (CollectionUtils.isEmpty(map) && !isExpireTenureFlag) {
                LOG.info("dismissRelations by dismissBillId: {}  is not arrived time ", (Object)dismissBillIdList.toString());
                return;
            }
            for (Object dismissRelation : dismissRelations) {
                long variationTypeId;
                long dismissBillId = dismissRelation.getLong("dismissbillid");
                DynamicObject dismissBillDynamic = map.get(dismissBillId);
                if (null != dismissBillDynamic) {
                    dismissBillDynamic.set("dismisseffectstatus", (Object)"1");
                    dismissBillDynamic.set("appointeffectstatus", (Object)"1");
                    needValidBillList.add(dismissBillDynamic);
                }
                boolean leaveOrRetire = LEAVE_ID == (variationTypeId = dismissRelation.getLong("variationtypeid")) || RETIRE_ID == variationTypeId;
                DynamicObject[] tenures = this.handleDismissRelation((DynamicObject)dismissRelation, !leaveOrRetire, currDate);
                tenureColl.addAll(Arrays.asList(tenures));
            }
        } else {
            for (Object dismissRelation : dismissRelations) {
                DynamicObject[] tenures = this.handleDismissRelation((DynamicObject)dismissRelation, false, currDate);
                tenureColl.addAll(Arrays.asList(tenures));
            }
        }
        LOG.info("dismissRelations Data, ids:{}", Arrays.stream(dismissRelations).map(o -> o.getLong("id")).collect(Collectors.toList()));
        if (tenureColl.isEmpty() && !isExpireTenureFlag) {
            LOG.info("dismissRelations tenureColl is empty");
            return;
        }
        try (TXHandle txhandle = TX.required();){
            RELATIONAL_SERVICE.updateDatas((DynamicObject[])dismissRelations);
            TENURE_DOMAIN_SERVICE.updateData((DynamicObject[])tenureColl.toArray((Object[])new DynamicObject[0]));
            if (!CollectionUtils.isEmpty((Collection)needValidBillList)) {
                DISMISS_BILL_APPLICATION_SERVICE.updateBatch(needValidBillList);
            }
        }
    }

    private DynamicObject[] handleDismissRelation(DynamicObject dismissRelation, boolean afterDismissCanHandle, Date currDate) {
        long dismissBillId;
        LOG.info("handleDismissRelation, dismissRelation: {}, afterDismissCanHandle: {}", (Object)dismissRelation, (Object)afterDismissCanHandle);
        if (afterDismissCanHandle && (dismissBillId = dismissRelation.getLong("dismissbillid")) == 0L) {
            return new DynamicObject[0];
        }
        long currUserId = RequestContext.get().getCurrUserId();
        long employeeId = dismissRelation.getDynamicObject("employee") == null ? 0L : dismissRelation.getDynamicObject("employee").getLong("id");
        long empPosRelId = dismissRelation.getDynamicObject("empposrel") == null ? 0L : dismissRelation.getDynamicObject("empposrel").getLong("id");
        dismissRelation.set("ispull", (Object)"1");
        dismissRelation.set("pulltime", (Object)currDate);
        dismissRelation.set("modifier", (Object)currUserId);
        dismissRelation.set("modifytime", (Object)currDate);
        long variationTypeId = dismissRelation.getLong("variationtypeid");
        boolean leaveOrRetire = LEAVE_ID == variationTypeId || RETIRE_ID == variationTypeId;
        LOG.info("variationTypeId: {}, leaveOrRetire: {}", (Object)variationTypeId, (Object)leaveOrRetire);
        if (leaveOrRetire) {
            return this.getToBeLeavedTenureData(employeeId);
        }
        return this.getToBeLeavedTenureData(employeeId, dismissRelation, null, empPosRelId);
    }

    public DynamicObject[] queryTenureData(QFilter[] filters, String orderBy) {
        return TENURE_DOMAIN_SERVICE.queryTenureData(filters, orderBy);
    }

    public DynamicObject[] queryEmployeeTenureData(String selectProperties, QFilter[] filters, String orderBy) {
        return TENURE_DOMAIN_SERVICE.queryEmployeeTenureData(selectProperties, filters, orderBy);
    }

    public DynamicObject[] query(String selectProperties, QFilter[] filters) {
        return TENURE_DOMAIN_SERVICE.query(selectProperties, filters);
    }

    public DynamicObject[] queryAllOriginalTenure() {
        return TENURE_DOMAIN_SERVICE.queryAllOriginalTenure();
    }

    public DynamicObject[] queryByPermission(String selectProperties, long userId, List<String> statusList, String permItemId) {
        return TENURE_DOMAIN_SERVICE.queryByPermission(selectProperties, userId, statusList, permItemId);
    }

    public DynamicObject[] queryByPermissionAndQFilters(String selectProperties, long userId, List<QFilter> qFilterList, String permItemId) {
        return TENURE_DOMAIN_SERVICE.queryByPermissionAndQFilters(selectProperties, userId, qFilterList, permItemId);
    }

    public DynamicObject[] queryProbationByPermission(String selectProperties, long userId, List<QFilter> qFilterList, String permItemId) {
        return PROBATION_DOMAIN_SERVICE.queryProbationByPermission(selectProperties, userId, qFilterList, permItemId);
    }

    public DynamicObject[] queryOriginalTenuresByDepEmpIds(String selectProperties, List<Object> depEmpIds) {
        return TENURE_DOMAIN_SERVICE.queryOriginalTenuresByDepEmpIds(selectProperties, depEmpIds);
    }

    public List<Map<String, Object>> getTenureRecord(Map<String, Object> params) {
        List<Map<String, Object>> result = TENURE_DOMAIN_SERVICE.getTenureRecord(params);
        return result;
    }

    public void setDefaultReasonByDepart(AbstractFormPlugin plugin) {
        ListSelectedRowCollection selectedRows;
        if (plugin == null) {
            return;
        }
        IFormView view = plugin.getView();
        List<Long> personIdList = new ArrayList<Long>(10);
        if (view instanceof ListView && (selectedRows = ((ListView)view).getSelectedRows()).size() > 0) {
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            List<Long> ids = Arrays.stream(primaryKeyValues).filter(obj -> obj instanceof Long).map(obj -> (Long)obj).collect(Collectors.toList());
            DynamicObject[] tenureBills = this.queryTenureDataByIds("person", ids);
            personIdList = Arrays.stream(tenureBills).map(p -> p.getLong("person.id")).collect(Collectors.toList());
        }
        if (view instanceof BillView) {
            IDataModel model = view.getModel();
            Long personId = (Long)model.getValue("person_id");
            personIdList = Collections.singletonList(personId);
        }
        cadmFormService.setTerminationReasonParam(plugin, personIdList);
    }
}

