/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.appointaudit.enums;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.tdc.cadm.bussiness.util.MultiLangEnumBridge;
import kd.tdc.cadm.common.enums.StatusTypeEnum;

public enum AppointAuditStatusEnum {
    DEL("-1", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u5df2\u5220\u9664", "AppointAuditStatusEnum_4", "tdc-cadm-business")),
    NOT_TRIGGER("0", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u672a\u89e6\u53d1", "AppointAuditStatusEnum_0", "tdc-cadm-business")),
    TO_BE_AUDIT("1", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u5f85\u5ba1\u67e5", "AppointAuditStatusEnum_1", "tdc-cadm-business")),
    COMPLETE("2", StatusTypeEnum.COMPLETED, new MultiLangEnumBridge("\u5ba1\u67e5\u5b8c\u6210", "AppointAuditStatusEnum_2", "tdc-cadm-business")),
    TERMINATED("3", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u5df2\u7ec8\u6b62", "AppointAuditStatusEnum_3", "tdc-cadm-business"));

    private final String number;
    private final StatusTypeEnum statusType;
    private final MultiLangEnumBridge bridge;
    private static final Map<String, AppointAuditStatusEnum> AUDIT_STATUS_ENUM_MAP;

    private AppointAuditStatusEnum(String number, StatusTypeEnum statusType, MultiLangEnumBridge bridge) {
        this.number = number;
        this.statusType = statusType;
        this.bridge = bridge;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public StatusTypeEnum getStatusType() {
        return this.statusType;
    }

    public static AppointAuditStatusEnum getEnumByVal(String number) {
        return AUDIT_STATUS_ENUM_MAP.get(number);
    }

    public static boolean canBeRejected(String number) {
        return AppointAuditStatusEnum.TO_BE_AUDIT.number.equals(number);
    }

    static {
        AUDIT_STATUS_ENUM_MAP = Maps.newHashMapWithExpectedSize((int)AppointAuditStatusEnum.values().length);
        for (AppointAuditStatusEnum item : AppointAuditStatusEnum.values()) {
            AUDIT_STATUS_ENUM_MAP.put(item.getNumber(), item);
        }
    }

    private static class Constants {
        public static final String TDC_CADM_BUSINESS = "tdc-cadm-business";

        private Constants() {
        }
    }
}

