/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.appointaudit.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.domain.appointaudit.entityservice.AuditSchemeEntityService;
import kd.tdc.cadm.bussiness.domain.appointaudit.enums.AppointAuditStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.service.ActivityBillCommonDomainService;
import kd.tdc.cadm.bussiness.domain.nominate.service.IActivityBillCommonService;
import kd.tdc.cadm.bussiness.util.PermissionUtil;
import kd.tdc.cadm.bussiness.util.UrlBuilder;

public class AppointAuditDomainService
implements IActivityBillCommonService {
    private static final Log LOG = LogFactory.getLog(AppointAuditDomainService.class);
    private static final HRBaseServiceHelper APPOINT_AUDIT_REPOSITORY = new HRBaseServiceHelper("cadm_appointaudit");
    private static final ActivityBillCommonDomainService billCommonDomainService = ServiceFactory.getService(ActivityBillCommonDomainService.class);
    private static final AuditSchemeEntityService auditSchemeEntityService = ServiceFactory.getService(AuditSchemeEntityService.class);

    @Override
    public DynamicObject initAfterSubmitNominateBill(DynamicObject nominateBill, long matchActivityId, List<Long> handlers, int sla) {
        long nominateId = nominateBill.getLong("id");
        QFilter nominateFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter matchActvFilter = new QFilter("matchactv", "=", (Object)matchActivityId);
        QFilter nonDelFilter = new QFilter("appoauditstatus", "!=", (Object)AppointAuditStatusEnum.DEL.getNumber());
        LOG.info("init# query appointaudit start");
        DynamicObject appointAudit = APPOINT_AUDIT_REPOSITORY.queryOne("appoauditstatus,nominatebill,matchactv,billno,createtime,org,creator,person,handler,auditscheme,auditentry.audititem,auditentry.require,sla", new QFilter[]{nominateFilter, matchActvFilter, nonDelFilter});
        if (Objects.isNull(appointAudit)) {
            appointAudit = APPOINT_AUDIT_REPOSITORY.generateEmptyDynamicObject();
        }
        appointAudit.set("appoauditstatus", (Object)AppointAuditStatusEnum.NOT_TRIGGER.getNumber());
        appointAudit.set("nominatebill", (Object)nominateId);
        appointAudit.set("matchactv", (Object)matchActivityId);
        appointAudit.set("billno", (Object)nominateBill.getString("billno"));
        appointAudit.set("createtime", (Object)new Date());
        appointAudit.set("org", (Object)nominateBill.getLong("org.id"));
        appointAudit.set("creator", (Object)RequestContext.get().getCurrUserId());
        appointAudit.set("sla", (Object)sla);
        appointAudit.set("person", (Object)nominateBill.getLong("person.id"));
        billCommonDomainService.setActivityBillHandler(appointAudit, handlers);
        APPOINT_AUDIT_REPOSITORY.save(new DynamicObject[]{appointAudit});
        LOG.info("init# save appointAudit end");
        return appointAudit;
    }

    public void initByAuditScheme(DynamicObject appointAudit, Long auditSchemeId) {
        LOG.info("initByAuditScheme start, auditSchemeId is {}, billno {}", (Object)auditSchemeId, (Object)appointAudit.getString("billno"));
        DynamicObject auditScheme = auditSchemeEntityService.queryAuditScheme("number,sourcevid,audititementry.audititem,audititementry.require", auditSchemeId, String.valueOf('1'));
        if (HRObjectUtils.isEmpty((Object)auditScheme)) {
            LOG.error("initByAuditScheme error, auditScheme is empty, auditSchemeNumber is {}, billno {}", (Object)auditScheme.getString("number"), (Object)appointAudit.getString("billno"));
            return;
        }
        appointAudit.set("auditscheme", (Object)auditScheme.getLong("sourcevid"));
        DynamicObjectCollection auditEntry = appointAudit.getDynamicObjectCollection("auditentry");
        auditEntry.clear();
        DynamicObjectCollection auditItems = auditScheme.getDynamicObjectCollection("audititementry");
        for (DynamicObject auditItem : auditItems) {
            DynamicObject item = auditEntry.addNew();
            item.set("audititem", (Object)auditItem.getLong("audititem.sourcevid"));
            item.set("require", (Object)auditItem.getString("require"));
        }
        APPOINT_AUDIT_REPOSITORY.updateDataOne(appointAudit);
        LOG.info("initByAuditScheme end");
    }

    @Override
    public DynamicObject triggerBill(Long nominateId, Long activityId, Long instanceId, List<Long> approverIds) {
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter actvIdFilter = new QFilter("matchactv", "=", (Object)activityId);
        QFilter notDelFilter = new QFilter("appoauditstatus", "!=", (Object)AppointAuditStatusEnum.DEL.getNumber());
        LOG.info("trigger# query appointaudit start");
        DynamicObject appointAudit = APPOINT_AUDIT_REPOSITORY.queryOne("billno,billstatus,auditstatus,appoauditstatus,createtime,handler,instanceid,deadline,sla", new QFilter[]{nominateIdFilter, actvIdFilter, notDelFilter});
        LOG.info("trigger# query appointaudit end");
        if (Objects.isNull(appointAudit)) {
            LOG.error("trigger# non appointaudit to be trigger,  nominateId is {}, activityId is {}", (Object)nominateId, (Object)activityId);
            return null;
        }
        appointAudit.set("auditstatus", (Object)"A");
        appointAudit.set("billstatus", (Object)"A");
        billCommonDomainService.setActivityBillHandler(appointAudit, approverIds);
        appointAudit.set("appoauditstatus", (Object)AppointAuditStatusEnum.TO_BE_AUDIT.getNumber());
        Date nowDate = new Date();
        appointAudit.set("createtime", (Object)nowDate);
        int sla = appointAudit.getInt("sla");
        if (sla != 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(nowDate);
            cal.add(10, sla);
            appointAudit.set("deadline", (Object)cal.getTime());
        }
        appointAudit.set("instanceid", (Object)instanceId);
        APPOINT_AUDIT_REPOSITORY.save(new DynamicObject[]{appointAudit});
        LOG.info("trigger# save appointAudit end");
        return appointAudit;
    }

    @Override
    public DynamicObject updatedToNotTrigger(Long nominateId) {
        QFilter[] filters = new QFilter[]{new QFilter("nominatebill", "=", (Object)nominateId)};
        DynamicObject nextBill = APPOINT_AUDIT_REPOSITORY.queryOne("appoauditstatus, id", filters);
        if (!HRObjectUtils.isEmpty((Object)nextBill)) {
            nextBill.set("appoauditstatus", (Object)AppointAuditStatusEnum.NOT_TRIGGER.getNumber());
            APPOINT_AUDIT_REPOSITORY.saveOne(nextBill);
        }
        return nextBill;
    }

    @Override
    public Tuple<Boolean, String> judgeEnableUnSubmit(Long nominateId) {
        String status;
        QFilter[] filters = new QFilter[]{new QFilter("nominatebill", "=", (Object)nominateId)};
        DynamicObject nextBill = APPOINT_AUDIT_REPOSITORY.queryOriginalOne("id,appoauditstatus", filters);
        String string = status = HRObjectUtils.isEmpty((Object)nextBill) ? "" : nextBill.getString("appoauditstatus");
        if (!HRStringUtils.equals((String)status, (String)AppointAuditStatusEnum.TO_BE_AUDIT.getNumber())) {
            return Tuple.create((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64a4\u9500\u5ba1\u67e5\u72b6\u6001\u4e3a\u201c\u5f85\u5ba1\u67e5\u201d\u7684\u6570\u636e\u3002", (String)"AppointAuditDomainService_0", (String)"tdc-cadm-business", (Object[])new Object[0]));
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)"");
    }

    public void rejectBill(DynamicObject[] auditBills) {
        Arrays.stream(auditBills).forEach(auditBill -> auditBill.set("appoauditstatus", (Object)AppointAuditStatusEnum.NOT_TRIGGER.getNumber()));
        APPOINT_AUDIT_REPOSITORY.update(auditBills);
    }

    public DynamicObject[] queryAuditBillById(String selectProperties, List<Object> pkIds) {
        QFilter idFilter = new QFilter("id", "in", pkIds);
        return APPOINT_AUDIT_REPOSITORY.query(selectProperties, new QFilter[]{idFilter});
    }

    public DynamicObject queryOne(String selectProperties, Object pkId) {
        return APPOINT_AUDIT_REPOSITORY.queryOne(selectProperties, pkId);
    }

    @Override
    public Tuple<DynamicObject, Boolean> updateAfterUnSubmitNominate(Long nominateId, Long activityId) {
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter matchActvIdFilter = new QFilter("matchactv", "=", (Object)activityId);
        QFilter notDeleteFilter = new QFilter("appoauditstatus", "!=", (Object)AppointAuditStatusEnum.DEL.getNumber());
        DynamicObject appointAudit = APPOINT_AUDIT_REPOSITORY.queryOne("billno,appoauditstatus,instanceid,handler", new QFilter[]{nominateIdFilter, matchActvIdFilter, notDeleteFilter});
        Boolean needSendMsg = Boolean.FALSE;
        if (appointAudit != null && !AppointAuditStatusEnum.NOT_TRIGGER.getNumber().equals(appointAudit.getString("appoauditstatus"))) {
            needSendMsg = Boolean.TRUE;
            appointAudit.set("appoauditstatus", (Object)AppointAuditStatusEnum.DEL.getNumber());
            APPOINT_AUDIT_REPOSITORY.updateDataOne(appointAudit);
        }
        return Tuple.create((Object)appointAudit, (Object)needSendMsg);
    }

    @Override
    public List<DynamicObject> fireTerminateActivity(List<Long> appointBillIds) {
        ArrayList<DynamicObject> terminateSuccessActivityBills = new ArrayList<DynamicObject>(10);
        QFilter nominateIdQFilters = new QFilter("nominatebill", "in", appointBillIds);
        Object[] auditBills = APPOINT_AUDIT_REPOSITORY.query("id,billstatus,auditstatus,appoauditstatus,modifier,modifytime,nominatebill,handler,instanceid", new QFilter[]{nominateIdQFilters});
        ArrayList canTerminatedStatusList = Lists.newArrayList((Object[])new String[]{AppointAuditStatusEnum.TO_BE_AUDIT.getNumber()});
        if (!HRArrayUtils.isEmpty((Object[])auditBills)) {
            Date date = new Date();
            long currUserId = RequestContext.get().getCurrUserId();
            Arrays.stream(auditBills).forEach(auditBill -> {
                String auditStatus = auditBill.getString("appoauditstatus");
                if (!canTerminatedStatusList.contains(auditStatus)) {
                    return;
                }
                auditBill.set("billstatus", (Object)"F");
                auditBill.set("auditstatus", (Object)"F");
                auditBill.set("appoauditstatus", (Object)AppointAuditStatusEnum.TERMINATED.getNumber());
                auditBill.set("modifytime", (Object)date);
                auditBill.set("modifier", (Object)currUserId);
                Long auditBillId = auditBill.getLong("id");
                List<Long> handlerIds = billCommonDomainService.getActivityHandlerIds((DynamicObject)auditBill, "handler");
                if (CollectionUtils.isEmpty(handlerIds)) {
                    return;
                }
                String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_appointaudit").setParameter("formPkId", String.valueOf(auditBillId)).builder();
                BosMessageService.sendTemplateMessage(contentUrl, handlerIds, auditBill.getLong("nominatebill.id"), "cadm_appointaudit", "cadm_stop", auditBillId);
                terminateSuccessActivityBills.add((DynamicObject)auditBill);
            });
            APPOINT_AUDIT_REPOSITORY.update((DynamicObject[])auditBills);
        }
        return terminateSuccessActivityBills;
    }

    @Override
    public DynamicObject queryActHandlerByNominateId(Long nominateId) {
        QFilter nominateQFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter notDelFilter = new QFilter("appoauditstatus", "!=", (Object)AppointAuditStatusEnum.DEL.getNumber());
        return APPOINT_AUDIT_REPOSITORY.queryOne("handler", new QFilter[]{nominateQFilter, notDelFilter});
    }

    public DynamicObject queryAuditByAppointId(String selectProperties, Long appointId) {
        QFilter nominateFilter = new QFilter("nominatebill", "=", (Object)appointId);
        QFilter completeFilter = new QFilter("appoauditstatus", "=", (Object)AppointAuditStatusEnum.COMPLETE.getNumber());
        return APPOINT_AUDIT_REPOSITORY.queryOne(selectProperties, new QFilter[]{nominateFilter, completeFilter});
    }

    public DynamicObject[] queryByPermission(String selectProperties, long userId, List<String> statusList, String permItemId) {
        List<QFilter> qFilters = PermissionUtil.getPermissionQFilter("cadm_appointaudit", userId, permItemId);
        QFilter userFilter = new QFilter("handler.fbasedataid_id", "in", (Object)userId);
        qFilters.add(userFilter);
        QFilter appointStatusQFilter = new QFilter("nominatebill.appointstatus", "!=", (Object)AppointStatusEnum.WAIT_APPOINT.getVal());
        qFilters.add(appointStatusQFilter);
        if (!CollectionUtils.isEmpty(statusList)) {
            QFilter qFilter = new QFilter("appoauditstatus", "in", statusList);
            qFilters.add(qFilter);
        }
        return APPOINT_AUDIT_REPOSITORY.queryOriginalArray(selectProperties, qFilters.toArray(new QFilter[0]));
    }
}

