/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.brew.entityservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tdc.cadm.bussiness.domain.brew.entity.BrewMatchBo;

public class BrewMatchEntityService {
    private static final HRBaseServiceHelper MATCH_RESULT_REPOSITORY = new HRBaseServiceHelper("cadm_brewmatch");

    public DynamicObject[] queryBrewMatchResult(Long brewBillId) {
        QFilter billFilter = new QFilter("brewbill", "=", (Object)brewBillId);
        return MATCH_RESULT_REPOSITORY.query("id,candemployee,brewbill,personposition,matchposition,matchitemnumber,personinfo,positionreq,matchresult", new QFilter[]{billFilter});
    }

    public DynamicObject[] queryBrewMatchResult(Long brewBillId, Long employeeId) {
        QFilter billFilter = new QFilter("brewbill", "=", (Object)brewBillId);
        QFilter employeeIdFilter = new QFilter("candemployee", "=", (Object)employeeId);
        return MATCH_RESULT_REPOSITORY.query("id,candemployee,brewbill,personposition,matchposition,matchitemnumber,personinfo,positionreq,matchresult,positiontype", new QFilter[]{billFilter, employeeIdFilter});
    }

    public void deleteBrewMatchData(Long brewBillId, List<Long> employeeIds) {
        QFilter billFilter = new QFilter("brewbill", "=", (Object)brewBillId);
        QFilter employeeFilter = new QFilter("candemployee", "in", employeeIds);
        MATCH_RESULT_REPOSITORY.deleteByFilter(new QFilter[]{billFilter, employeeFilter});
    }

    public void saveBrewMatchData(Long brewBillId, Map<Long, List<BrewMatchBo>> matchData) {
        QFilter billFilter = new QFilter("brewbill", "=", (Object)brewBillId);
        DynamicObject[] matchDataFromDB = MATCH_RESULT_REPOSITORY.query("id,candemployee,brewbill,personposition,matchposition,matchitemnumber,personinfo,positionreq,matchresult,positiontype", new QFilter[]{billFilter});
        Map<Long, List<DynamicObject>> employeeMatchDataMap = Arrays.stream(matchDataFromDB).collect(Collectors.groupingBy(matchDy -> matchDy.getLong("candemployee.id")));
        ArrayList<DynamicObject> resultDataUpdate = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> resultDataAddNew = new ArrayList<DynamicObject>();
        for (Map.Entry<Long, List<BrewMatchBo>> dataEntry : matchData.entrySet()) {
            Long employeeId = dataEntry.getKey();
            List<BrewMatchBo> brewMatchBoList = dataEntry.getValue();
            List<DynamicObject> employeeMatchDataFromDB = employeeMatchDataMap.get(employeeId);
            if (employeeMatchDataFromDB == null) {
                List<DynamicObject> newMatchData = this.addNewMatchData(brewMatchBoList);
                resultDataAddNew.addAll(newMatchData);
                continue;
            }
            List<DynamicObject> updateMatchData = this.updateMatchData(employeeMatchDataFromDB, brewMatchBoList);
            resultDataUpdate.addAll(updateMatchData);
        }
        MATCH_RESULT_REPOSITORY.save(resultDataAddNew.toArray(new DynamicObject[0]));
        MATCH_RESULT_REPOSITORY.update(resultDataUpdate.toArray(new DynamicObject[0]));
        Set<Long> newDataEmployeeIds = matchData.keySet();
        Set<Long> oldDataEmployeeIds = employeeMatchDataMap.keySet();
        oldDataEmployeeIds.removeAll(newDataEmployeeIds);
        QFilter deleteEmployeeIdFilter = new QFilter("candemployee", "in", oldDataEmployeeIds);
        MATCH_RESULT_REPOSITORY.deleteByFilter(new QFilter[]{billFilter, deleteEmployeeIdFilter});
    }

    private List<DynamicObject> updateMatchData(List<DynamicObject> oldMatchData, List<BrewMatchBo> newMatchData) {
        Map<String, BrewMatchBo> brewMatchBoMap = newMatchData.stream().collect(Collectors.toMap(BrewMatchBo::getMatchItemNumber, matchDy -> matchDy, (v1, v2) -> v2));
        for (DynamicObject matchData : oldMatchData) {
            BrewMatchBo brewMatchBo = brewMatchBoMap.get(matchData.getString("matchitemnumber"));
            matchData.set("personinfo", (Object)brewMatchBo.getPersonInfo());
            matchData.set("positionreq", (Object)brewMatchBo.getPositionReq());
            matchData.set("matchresult", (Object)brewMatchBo.getMatchResult());
            matchData.set("positiontype", (Object)brewMatchBo.getPositionType());
        }
        return oldMatchData;
    }

    private List<DynamicObject> addNewMatchData(List<BrewMatchBo> brewMatchBoList) {
        ArrayList<DynamicObject> newDataList = new ArrayList<DynamicObject>(brewMatchBoList.size());
        for (BrewMatchBo brewMatchBo : brewMatchBoList) {
            DynamicObject newMatchData = MATCH_RESULT_REPOSITORY.generateEmptyDynamicObject();
            newMatchData.set("candemployee", (Object)brewMatchBo.getCandEmployeeId());
            newMatchData.set("brewbill", (Object)brewMatchBo.getBrewBillId());
            newMatchData.set("personposition", (Object)brewMatchBo.getPersonPositionId());
            newMatchData.set("matchposition", (Object)brewMatchBo.getMatchPositionId());
            newMatchData.set("matchitemnumber", (Object)brewMatchBo.getMatchItemNumber());
            newMatchData.set("personinfo", (Object)brewMatchBo.getPersonInfo());
            newMatchData.set("positionreq", (Object)brewMatchBo.getPositionReq());
            newMatchData.set("matchresult", (Object)brewMatchBo.getMatchResult());
            newMatchData.set("positiontype", (Object)brewMatchBo.getPositionType());
            newDataList.add(newMatchData);
        }
        return newDataList;
    }
}

