/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.brew.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.domain.brew.entity.BrewMatchBo;
import kd.tdc.cadm.bussiness.domain.brew.entityservice.BrewEntryEntityService;
import kd.tdc.cadm.bussiness.domain.brew.entityservice.BrewMatchEntityService;
import kd.tdc.cadm.bussiness.domain.brew.enums.BrewStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.NominateStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.service.NominateBillDomainService;
import kd.tdc.cadm.common.enums.PositionTypeEnum;

public class BrewBillDomainService {
    private static final HRBaseServiceHelper BREW_BILL_REPOSITORY = new HRBaseServiceHelper("cadm_brewbill");
    private static final NominateBillDomainService NOMINATE_DOMAIN_SERVICE = ServiceFactory.getService(NominateBillDomainService.class);
    private static final BrewEntryEntityService BREW_ENTRY_ENTITY_SERVICE = ServiceFactory.getService(BrewEntryEntityService.class);
    private static final BrewMatchEntityService BREW_MATCH_ENTITY_SERVICE = ServiceFactory.getService(BrewMatchEntityService.class);
    private static final HRBaseServiceHelper brewCandidateHelper = new HRBaseServiceHelper("cadm_brewcandidateentry");

    public DynamicObject getBrewBillById(String selectedProperties, long pkId) {
        return BREW_BILL_REPOSITORY.queryOne(selectedProperties, (Object)pkId);
    }

    public DynamicObject[] getBrewBillByIds(String selectedProperties, List<Long> pkIds) {
        return BREW_BILL_REPOSITORY.query(selectedProperties, new QFilter[]{new QFilter("id", "in", pkIds)});
    }

    public DynamicObject getBrewBillByList(String selectedProperties, List<String> enumList, long positionId, long selfId, String positionType) {
        String col = "";
        if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
            col = "brewstandardposition";
        }
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
            col = "brewposition";
        }
        if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
            col = "brewjob";
        }
        QFilter[] filters = selfId == 0L ? new QFilter[]{new QFilter("brewstatus", "in", enumList), new QFilter(col, "in", (Object)positionId)} : new QFilter[]{new QFilter("brewstatus", "in", enumList), new QFilter(col, "in", (Object)positionId), new QFilter("id", "!=", (Object)selfId)};
        return BREW_BILL_REPOSITORY.queryOne(selectedProperties, filters);
    }

    public DynamicObjectCollection getBrewEntryEntity(long brewId) {
        return BREW_ENTRY_ENTITY_SERVICE.getBrewEntry(brewId);
    }

    public Tuple<Boolean, Tuple<String, String>> judgeEnableRevocation(Long brewId, String operationKey) {
        String statusTips;
        DynamicObject bill = BREW_BILL_REPOSITORY.queryOriginalOne("billno,brewstatus", (Object)brewId);
        String billno = bill.getString("billno");
        String brewStatus = bill.getString("brewstatus");
        DynamicObject[] nominateData = NOMINATE_DOMAIN_SERVICE.queryNominateByBrewId("id,nominatestatus", brewId);
        String nomiTips = "";
        if (HRStringUtils.equals((String)"revocation", (String)operationKey) || HRStringUtils.equals((String)"revocationlist", (String)operationKey)) {
            statusTips = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64a4\u9500\u915d\u917f\u72b6\u6001\u4e3a\u201c\u915d\u917f\u5b8c\u6210\u201d\u7684\u6570\u636e\u3002", (String)"BrewBillDomainService_0", (String)"tdc-cadm-business", (Object[])new Object[0]);
            nomiTips = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u5f53\u524d\u9009\u4e2d\u7684\u915d\u917f\u52a8\u8bae\u5355\u5df2\u5728\u4efb\u547d\u6d41\u7a0b\u4e2d\u3002", (String)"BrewBillDomainService_4", (String)"tdc-cadm-business", (Object[])new Object[0]);
            if (!BrewStatusEnum.BREWOVER.getNumber().equals(brewStatus)) {
                return Tuple.create((Object)Boolean.FALSE, (Object)Tuple.create((Object)billno, (Object)statusTips));
            }
        }
        if (HRStringUtils.equals((String)"delete", (String)operationKey)) {
            statusTips = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u5220\u9664\u915d\u917f\u72b6\u6001\u4e3a\u201d\u5f85\u915d\u917f/\u915d\u917f\u4e2d\u201c\u7684\u6570\u636e\u3002", (String)"BrewBillDomainService_1", (String)"tdc-cadm-business", (Object[])new Object[0]);
            nomiTips = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u5f53\u524d\u9009\u4e2d\u7684\u915d\u917f\u52a8\u8bae\u5355\u5df2\u5728\u4efb\u547d\u6d41\u7a0b\u4e2d\u3002", (String)"BrewBillDomainService_3", (String)"tdc-cadm-business", (Object[])new Object[0]);
            if (BrewStatusEnum.BREWOVER.getNumber().equals(brewStatus)) {
                return Tuple.create((Object)Boolean.FALSE, (Object)Tuple.create((Object)billno, (Object)statusTips));
            }
        }
        if (nominateData != null && nominateData.length > 0) {
            ArrayList<String> status = new ArrayList<String>(10);
            status.add(NominateStatusEnum.WAIT_NOMINATE.getVal());
            status.add(NominateStatusEnum.RESUBMIT_NOMINATE.getVal());
            status.add(NominateStatusEnum.SUCCESS_NOMINATE.getVal());
            Optional<DynamicObject> nominateOptional = Arrays.stream(nominateData).filter(nominateBill -> status.contains(nominateBill.getString("nominatestatus"))).findFirst();
            if (nominateOptional.isPresent()) {
                return Tuple.create((Object)Boolean.FALSE, (Object)Tuple.create((Object)billno, (Object)nomiTips));
            }
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)Tuple.create((Object)billno, (Object)"success"));
    }

    public void revokeUpdateBrewBill(List<Long> brewSucIds, String revokeReason) {
        DynamicObject[] bills;
        QFilter idFilter = new QFilter("id", "in", brewSucIds);
        for (DynamicObject bill : bills = BREW_BILL_REPOSITORY.query("billstatus,auditstatus,brewstatus,withdrawreason", new QFilter[]{idFilter})) {
            bill.set("brewstatus", (Object)BrewStatusEnum.BREWING.getNumber());
            bill.set("billstatus", (Object)"A");
            bill.set("auditstatus", (Object)"G");
            bill.set("withdrawreason", (Object)revokeReason);
        }
        BREW_BILL_REPOSITORY.update(bills);
    }

    public DynamicObject[] queryByPersonAndPosition(String selectProperties, long personId, long positionId, long nomHandler) {
        QFilter personFilter = new QFilter("entryentity.person", "=", (Object)personId);
        QFilter nomHandlerFilter = new QFilter("entryentity.nomhandler", "=", (Object)nomHandler);
        QFilter positionFilter = new QFilter("brewposition", "=", (Object)positionId);
        QFilter statusFilter = new QFilter("brewstatus", "=", (Object)BrewStatusEnum.BREWOVER.getNumber());
        return BREW_BILL_REPOSITORY.query(selectProperties, new QFilter[]{personFilter, positionFilter, nomHandlerFilter, statusFilter}, "createtime desc");
    }

    public DynamicObject[] queryBrewMatchResult(Long brewBillId) {
        return BREW_MATCH_ENTITY_SERVICE.queryBrewMatchResult(brewBillId);
    }

    public DynamicObject[] queryBrewMatchResult(Long brewBillId, Long employeeId) {
        return BREW_MATCH_ENTITY_SERVICE.queryBrewMatchResult(brewBillId, employeeId);
    }

    public void saveBrewMatchData(Long brewBillId, Map<Long, List<BrewMatchBo>> matchData) {
        BREW_MATCH_ENTITY_SERVICE.saveBrewMatchData(brewBillId, matchData);
    }

    public DynamicObject[] queryByPersonAndJob(String selectProperties, long personId, long jobId, long currUserId) {
        QFilter personFilter = new QFilter("entryentity.person", "=", (Object)personId);
        QFilter nomHandlerFilter = new QFilter("entryentity.nomhandler", "=", (Object)currUserId);
        QFilter positionFilter = new QFilter("brewjob", "=", (Object)jobId);
        QFilter statusFilter = new QFilter("brewstatus", "=", (Object)BrewStatusEnum.BREWOVER.getNumber());
        return BREW_BILL_REPOSITORY.query(selectProperties, new QFilter[]{personFilter, positionFilter, nomHandlerFilter, statusFilter}, "createtime desc");
    }

    public DynamicObject[] queryByPersonAndStandardPosition(String selectProperties, long personId, long standardPositionId, long currUserId) {
        QFilter personFilter = new QFilter("entryentity.person", "=", (Object)personId);
        QFilter positionFilter = new QFilter("brewstandardposition", "=", (Object)standardPositionId);
        QFilter nomHandlerFilter = new QFilter("entryentity.nomhandler", "=", (Object)currUserId);
        QFilter statusFilter = new QFilter("brewstatus", "=", (Object)BrewStatusEnum.BREWOVER.getNumber());
        return BREW_BILL_REPOSITORY.query(selectProperties, new QFilter[]{personFilter, positionFilter, nomHandlerFilter, statusFilter}, "createtime desc");
    }

    public DynamicObject queryByPersonAndId(String selectProperties, long personId, long brewId, long currUserId) {
        QFilter personFilter = new QFilter("entryentity.person", "=", (Object)personId);
        QFilter idFilter = new QFilter("id", "=", (Object)brewId);
        QFilter nomHandlerFilter = new QFilter("entryentity.nomhandler", "=", (Object)currUserId);
        QFilter statusFilter = new QFilter("brewstatus", "=", (Object)BrewStatusEnum.BREWOVER.getNumber());
        return BREW_BILL_REPOSITORY.queryOne(selectProperties, new QFilter[]{personFilter, idFilter, nomHandlerFilter, statusFilter}, "createtime desc");
    }

    public DynamicObject[] queryByBrewStatus(String selectProperties, List<String> statusList) {
        QFilter qFilter = new QFilter("brewstatus", "in", statusList);
        return BREW_BILL_REPOSITORY.query(selectProperties, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryByIds(String selectProperties, List<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        return BREW_BILL_REPOSITORY.query(selectProperties, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryBrewCandidateByBrewIds(String selectProperties, List<Long> brewIds) {
        QFilter idFilter = new QFilter("brewbillid", "in", brewIds);
        return brewCandidateHelper.query(selectProperties, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryBrewByStatus(String selectProperties, List<String> statusList) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (!CollectionUtils.isEmpty(statusList)) {
            QFilter statusFilter = new QFilter("brewstatus", "in", statusList);
            qFilters.add(statusFilter);
        }
        return BREW_BILL_REPOSITORY.queryOriginalArray(selectProperties, qFilters.toArray(new QFilter[0]));
    }

    public void updateBrewHandleTimeTask() {
        QFilter statusFilter = new QFilter("brewstatus", "=", (Object)BrewStatusEnum.BREWOVER.getNumber());
        QFilter handleTimeFilter = new QFilter("handletime", "=", null);
        DynamicObject[] queryBills = BREW_BILL_REPOSITORY.queryOriginalArray("id,modifytime", new QFilter[]{statusFilter, handleTimeFilter});
        if (queryBills.length == 0) {
            return;
        }
        Map<Long, Date> map = Arrays.stream(queryBills).collect(Collectors.toMap(p -> p.getLong("id"), p -> p.getDate("modifytime"), (v1, v2) -> v1));
        DynamicObject[] updateBills = BREW_BILL_REPOSITORY.query("id,handletime", new QFilter[]{statusFilter, handleTimeFilter});
        Arrays.stream(updateBills).forEach(p -> {
            long id = p.getLong("id");
            p.set("handletime", map.get(id));
        });
        BREW_BILL_REPOSITORY.update(updateBills);
    }

    public void updateBrewHandlerTask() {
        QFilter statusFilter = new QFilter("brewstatus", "=", (Object)BrewStatusEnum.BREWOVER.getNumber());
        QFilter handlerFilter = new QFilter("handler", "=", (Object)0L).or(new QFilter("handler", "=", null));
        DynamicObject[] queryBills = BREW_BILL_REPOSITORY.queryOriginalArray("id,modifier", new QFilter[]{statusFilter, handlerFilter});
        if (queryBills.length == 0) {
            return;
        }
        Map<Long, Long> map = Arrays.stream(queryBills).collect(Collectors.toMap(p -> p.getLong("id"), p -> p.getLong("modifier"), (v1, v2) -> v1));
        DynamicObject[] updateBills = BREW_BILL_REPOSITORY.query("id,handler", new QFilter[]{statusFilter, handlerFilter});
        Arrays.stream(updateBills).forEach(p -> {
            long id = p.getLong("id");
            p.set("handler", map.get(id));
        });
        BREW_BILL_REPOSITORY.update(updateBills);
    }
}

