/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.dismiss.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyKindEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;

public class DismissBillDomainService {
    private static final HRBaseServiceHelper DISMISS_BILL_REPOSITORY = new HRBaseServiceHelper("cadm_dismissbill");

    public DynamicObject[] getDismissBillById(String selectedProperties, List<Long> pkIds) {
        QFilter idFilter = new QFilter("id", "in", pkIds);
        return DISMISS_BILL_REPOSITORY.query(selectedProperties, new QFilter[]{idFilter});
    }

    public DynamicObject[] getDismissBillInAppointByEmployee(List<Long> employeeIds) {
        QFilter statusFilter = new QFilter("appointstatus", "=", (Object)AppointStatusEnum.ING_APPOINT.getVal());
        QFilter positionFilter = new QFilter("employee", "in", employeeIds);
        return DISMISS_BILL_REPOSITORY.query("id,billno,appointstatus,dposition,djob,dstandardposition,employee,applykind,dismisstenure", new QFilter[]{statusFilter, positionFilter});
    }

    public void updateData(DynamicObject[] dataEntities) {
        DISMISS_BILL_REPOSITORY.updateDatas(dataEntities);
    }

    public Object[] updateBatch(List<DynamicObject> dynamicObjectList) {
        DynamicObject[] dynamicObjects = new DynamicObject[dynamicObjectList.size()];
        DynamicObject[] dismissDynamics = dynamicObjectList.toArray(dynamicObjects);
        return DISMISS_BILL_REPOSITORY.update(dismissDynamics);
    }

    public DynamicObject[] queryDismissBillsByStatus(String selectProperties, List<String> statusList, Long personId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter applyKindFilter = new QFilter("applykind", "=", (Object)ApplyKindEnum.DISMISS.getNumber());
        QFilter personIdFilter = new QFilter("person.id", "=", (Object)personId);
        filters.add(applyKindFilter);
        filters.add(personIdFilter);
        if (!CollectionUtils.isEmpty(statusList)) {
            QFilter statusFilter = new QFilter("appointstatus", "in", statusList);
            filters.add(statusFilter);
        }
        DynamicObject[] dismissBills = DISMISS_BILL_REPOSITORY.query(selectProperties, filters.toArray(new QFilter[0]));
        return dismissBills;
    }
}

