/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.examine.enums;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.tdc.cadm.bussiness.util.MultiLangEnumBridge;
import kd.tdc.cadm.common.enums.StatusTypeEnum;

public enum ExamCoopStatusEnum {
    DISCARD("40", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u5df2\u5e9f\u5f03", "ExamCoopStatusEnum_0", "tdc-cadm-business")),
    NOT_START("0", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u672a\u542f\u52a8", "ExamCoopStatusEnum_4", "tdc-cadm-business")),
    TO_BE_HANDLED("10", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u5f85\u5904\u7406", "ExamCoopStatusEnum_1", "tdc-cadm-business")),
    COMPLETED("20", StatusTypeEnum.COMPLETED, new MultiLangEnumBridge("\u5df2\u5b8c\u6210", "ExamCoopStatusEnum_2", "tdc-cadm-business")),
    TERMINATED("30", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u5df2\u7ec8\u6b62", "ExamCoopStatusEnum_3", "tdc-cadm-business"));

    private final String number;
    private final StatusTypeEnum statusType;
    private final MultiLangEnumBridge bridge;
    private static final Map<String, ExamCoopStatusEnum> COOP_STATUS_ENUM_MAP;

    private ExamCoopStatusEnum(String number, StatusTypeEnum statusType, MultiLangEnumBridge bridge) {
        this.number = number;
        this.statusType = statusType;
        this.bridge = bridge;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public StatusTypeEnum getStatusType() {
        return this.statusType;
    }

    public static ExamCoopStatusEnum getEnumByVal(String number) {
        return COOP_STATUS_ENUM_MAP.get(number);
    }

    static {
        COOP_STATUS_ENUM_MAP = Maps.newHashMapWithExpectedSize((int)ExamCoopStatusEnum.values().length);
        for (ExamCoopStatusEnum item : ExamCoopStatusEnum.values()) {
            COOP_STATUS_ENUM_MAP.put(item.getNumber(), item);
        }
    }
}

