/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.examine.enums;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.tdc.cadm.bussiness.util.MultiLangEnumBridge;
import kd.tdc.cadm.common.enums.StatusTypeEnum;

public enum ExamineStatusEnum {
    DEL("-1", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u5df2\u5220\u9664", "ExamineStatusEnum_5", "tdc-cadm-business")),
    NOT_TRIGGER("0", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u672a\u89e6\u53d1", "ExamineStatusEnum_0", "tdc-cadm-business")),
    TO_BE_EXAMINE("10", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u5f85\u8003\u5bdf", "ExamineStatusEnum_1", "tdc-cadm-business")),
    IN_EXAMINE("20", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u8003\u5bdf\u4e2d", "ExamineStatusEnum_2", "tdc-cadm-business")),
    COMPLETE("30", StatusTypeEnum.COMPLETED, new MultiLangEnumBridge("\u8003\u5bdf\u5b8c\u6210", "ExamineStatusEnum_3", "tdc-cadm-business")),
    TERMINATED("40", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u5df2\u7ec8\u6b62", "ExamineStatusEnum_4", "tdc-cadm-business"));

    private final String number;
    private final StatusTypeEnum statusType;
    private final MultiLangEnumBridge bridge;
    private static final Map<String, ExamineStatusEnum> EXAMINE_STATUS_ENUM_MAP;

    private ExamineStatusEnum(String number, StatusTypeEnum statusType, MultiLangEnumBridge bridge) {
        this.number = number;
        this.statusType = statusType;
        this.bridge = bridge;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public StatusTypeEnum getStatusType() {
        return this.statusType;
    }

    public static ExamineStatusEnum getEnumByVal(String number) {
        return EXAMINE_STATUS_ENUM_MAP.get(number);
    }

    public static boolean canBeRejected(String number) {
        return ExamineStatusEnum.TO_BE_EXAMINE.number.equals(number) || ExamineStatusEnum.IN_EXAMINE.number.equals(number);
    }

    static {
        EXAMINE_STATUS_ENUM_MAP = Maps.newHashMapWithExpectedSize((int)ExamineStatusEnum.values().length);
        for (ExamineStatusEnum item : ExamineStatusEnum.values()) {
            EXAMINE_STATUS_ENUM_MAP.put(item.getNumber(), item);
        }
    }

    private static class Constants {
        public static final String TDC_CADM_BUSINESS = "tdc-cadm-business";

        private Constants() {
        }
    }
}

