/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.examine.service;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.domain.examine.entityservice.ExamPlanEntityService;
import kd.tdc.cadm.bussiness.domain.examine.entityservice.ExamResultPlanEntityService;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamCoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamineStatusEnum;
import kd.tdc.cadm.bussiness.domain.examine.service.ExamineCoopDomainService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.service.ActivityBillCommonDomainService;
import kd.tdc.cadm.bussiness.domain.nominate.service.IActivityBillCommonService;
import kd.tdc.cadm.bussiness.util.PermissionUtil;
import kd.tdc.cadm.bussiness.util.UrlBuilder;

public class ExamineBillDomainService
implements IActivityBillCommonService {
    private static final Log LOG = LogFactory.getLog(ExamineBillDomainService.class);
    private static final HRBaseServiceHelper EXAMINE_BILL_REPOSITORY = new HRBaseServiceHelper("cadm_examinebill");
    private static final ActivityBillCommonDomainService BILL_COMMON_DOMAIN_SERVICE = ServiceFactory.getService(ActivityBillCommonDomainService.class);
    private static final ExamineCoopDomainService EXAMINE_COOP_SERVICE = ServiceFactory.getService(ExamineCoopDomainService.class);
    private static final ExamPlanEntityService EXAM_PLAN_ENTITY_SERVICE = ServiceFactory.getService(ExamPlanEntityService.class);
    private static final ExamResultPlanEntityService EXAM_RESULT_PLAN_ENTITY_SERVICE = ServiceFactory.getService(ExamResultPlanEntityService.class);

    @Override
    public DynamicObject initAfterSubmitNominateBill(DynamicObject nominateBill, long matchActivityId, List<Long> handlers, int sla) {
        long nominateId = nominateBill.getLong("id");
        QFilter nominateFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter matchActvFilter = new QFilter("matchactv", "=", (Object)matchActivityId);
        QFilter nonDelFilter = new QFilter("examinestatus", "!=", (Object)ExamineStatusEnum.DEL.getNumber());
        LOG.info("init# query examine start");
        DynamicObject examine = EXAMINE_BILL_REPOSITORY.queryOne("examinestatus,nominatebill,matchactv,billno,createtime,org,creator,person,handler,billstatus,auditstatus,sla", new QFilter[]{nominateFilter, matchActvFilter, nonDelFilter});
        if (Objects.isNull(examine)) {
            examine = EXAMINE_BILL_REPOSITORY.generateEmptyDynamicObject();
        }
        examine.set("examinestatus", (Object)ExamineStatusEnum.NOT_TRIGGER.getNumber());
        examine.set("nominatebill", (Object)nominateId);
        examine.set("matchactv", (Object)matchActivityId);
        examine.set("billno", (Object)nominateBill.getString("billno"));
        examine.set("createtime", (Object)new Date());
        examine.set("org", (Object)nominateBill.getLong("org.id"));
        examine.set("creator", (Object)RequestContext.get().getCurrUserId());
        examine.set("billstatus", (Object)"A");
        examine.set("auditstatus", (Object)"A");
        examine.set("sla", (Object)sla);
        examine.set("person", (Object)nominateBill.getLong("person.id"));
        BILL_COMMON_DOMAIN_SERVICE.setActivityBillHandler(examine, handlers);
        EXAMINE_BILL_REPOSITORY.save(new DynamicObject[]{examine});
        LOG.info("init# save examine end");
        return examine;
    }

    @Override
    public DynamicObject triggerBill(Long nominateId, Long activityId, Long instanceId, List<Long> approverIds) {
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter actvIdFilter = new QFilter("matchactv", "=", (Object)activityId);
        QFilter notDelFilter = new QFilter("examinestatus", "!=", (Object)ExamineStatusEnum.DEL.getNumber());
        LOG.info("trigger# query examine start");
        DynamicObject examine = EXAMINE_BILL_REPOSITORY.queryOne("billno,auditstatus,billstatus,examinestatus,createtime,handler,instanceid,deadline,sla", new QFilter[]{nominateIdFilter, actvIdFilter, notDelFilter});
        LOG.info("trigger# query examine end");
        if (Objects.isNull(examine)) {
            LOG.error("trigger# non examine to be trigger,  nominateId is {}, activityId is {}", (Object)nominateId, (Object)activityId);
            return null;
        }
        boolean isExistsCoopNotDiscard = EXAMINE_COOP_SERVICE.isExistsCoopNotDiscard(examine.getLong("id"));
        if (isExistsCoopNotDiscard) {
            examine.set("examinestatus", (Object)ExamineStatusEnum.IN_EXAMINE.getNumber());
        } else {
            examine.set("examinestatus", (Object)ExamineStatusEnum.TO_BE_EXAMINE.getNumber());
        }
        examine.set("auditstatus", (Object)"A");
        examine.set("billstatus", (Object)"A");
        Date nowDate = new Date();
        examine.set("createtime", (Object)nowDate);
        int sla = examine.getInt("sla");
        if (sla != 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(nowDate);
            cal.add(10, sla);
            examine.set("deadline", (Object)cal.getTime());
        }
        BILL_COMMON_DOMAIN_SERVICE.setActivityBillHandler(examine, approverIds);
        examine.set("instanceid", (Object)instanceId);
        EXAMINE_BILL_REPOSITORY.save(new DynamicObject[]{examine});
        LOG.info("trigger# save examine end");
        return examine;
    }

    @Override
    public DynamicObject updatedToNotTrigger(Long nominateId) {
        QFilter[] filters = new QFilter[]{new QFilter("nominatebill", "=", (Object)nominateId)};
        DynamicObject nextBill = EXAMINE_BILL_REPOSITORY.queryOne("examinestatus, id", filters);
        if (!HRObjectUtils.isEmpty((Object)nextBill)) {
            nextBill.set("examinestatus", (Object)ExamineStatusEnum.NOT_TRIGGER.getNumber());
            EXAMINE_BILL_REPOSITORY.saveOne(nextBill);
        }
        return nextBill;
    }

    @Override
    public Tuple<Boolean, String> judgeEnableUnSubmit(Long nominateId) {
        String status;
        QFilter[] filters = new QFilter[]{new QFilter("nominatebill", "=", (Object)nominateId)};
        DynamicObject nextBill = EXAMINE_BILL_REPOSITORY.queryOriginalOne("id,examinestatus", filters);
        String string = status = HRObjectUtils.isEmpty((Object)nextBill) ? "" : nextBill.getString("examinestatus");
        if (!HRStringUtils.equals((String)status, (String)ExamineStatusEnum.TO_BE_EXAMINE.getNumber())) {
            return Tuple.create((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64a4\u9500\u8003\u5bdf\u72b6\u6001\u4e3a\u201c\u5f85\u8003\u5bdf\u201d\u7684\u6570\u636e\u3002", (String)"ExamineBillDomainService_0", (String)"tdc-cadm-business", (Object[])new Object[0]));
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)"");
    }

    public void rejectBill(DynamicObject[] examineBills) {
        Arrays.stream(examineBills).forEach(bill -> bill.set("examinestatus", (Object)ExamineStatusEnum.NOT_TRIGGER.getNumber()));
        EXAMINE_BILL_REPOSITORY.update(examineBills);
    }

    public DynamicObject[] queryOriginalOneByNominateId(String selectProperties, long nominateId) {
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter notDelFilter = new QFilter("examinestatus", "!=", (Object)ExamineStatusEnum.DEL.getNumber());
        return EXAMINE_BILL_REPOSITORY.queryOriginalArray(selectProperties, new QFilter[]{nominateIdFilter, notDelFilter});
    }

    public DynamicObject queryExamPlanByExamPlanId(String selectProperties, Long id) {
        return EXAM_PLAN_ENTITY_SERVICE.queryExamPlanById(selectProperties, id);
    }

    public DynamicObject[] queryExamPlanEntryById(String selectProperties, Long id) {
        return EXAM_PLAN_ENTITY_SERVICE.queryExamPlanEntryById(selectProperties, id);
    }

    public void updateExamCoopRatio(Long examineId, DynamicObject[] examCoops) {
        long handlerNum = Stream.of(examCoops).filter(examCoop -> examCoop.get("handler") != null).count() * 100L;
        BigDecimal ratio = BigDecimal.ZERO;
        if (handlerNum != 0L) {
            ratio = new BigDecimal(handlerNum).divide(new BigDecimal(examCoops.length), 1, 4);
        }
        String ratioStr = ratio.toString() + "%";
        DynamicObject examineBill = EXAMINE_BILL_REPOSITORY.queryOne("examcoopratio", (Object)examineId);
        examineBill.set("examcoopratio", (Object)ratioStr.replace(".0", ""));
        EXAMINE_BILL_REPOSITORY.updateDataOne(examineBill);
    }

    public DynamicObject queryExamResultPlanByExamResultPlanId(String selectProperties, Long examResultPlanId) {
        return EXAM_RESULT_PLAN_ENTITY_SERVICE.queryExamResultPlanById(selectProperties, examResultPlanId);
    }

    @Override
    public Tuple<DynamicObject, Boolean> updateAfterUnSubmitNominate(Long nominateId, Long activityId) {
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter actvIdFilter = new QFilter("matchactv", "=", (Object)activityId);
        QFilter notDeleteFilter = new QFilter("examinestatus", "!=", (Object)ExamineStatusEnum.DEL.getNumber());
        LOG.info("trigger# query examine start");
        DynamicObject examine = EXAMINE_BILL_REPOSITORY.queryOne("billno,examinestatus,instanceid,handler", new QFilter[]{nominateIdFilter, actvIdFilter, notDeleteFilter});
        Boolean needSendMsg = Boolean.FALSE;
        if (examine != null && !ExamineStatusEnum.NOT_TRIGGER.getNumber().equals(examine.getString("examinestatus"))) {
            needSendMsg = Boolean.TRUE;
            examine.set("examinestatus", (Object)ExamineStatusEnum.DEL.getNumber());
            EXAMINE_BILL_REPOSITORY.updateDataOne(examine);
        }
        return Tuple.create((Object)examine, (Object)needSendMsg);
    }

    @Override
    public List<DynamicObject> fireTerminateActivity(List<Long> appointBillIds) {
        ArrayList<DynamicObject> terminateSuccessActivityBills = new ArrayList<DynamicObject>(10);
        QFilter nominateIdQFilters = new QFilter("nominatebill", "in", appointBillIds);
        Object[] examineBills = EXAMINE_BILL_REPOSITORY.query("id,billstatus,auditstatus,examinestatus,modifier,modifytime,nominatebill,handler,instanceid", new QFilter[]{nominateIdQFilters});
        ArrayList canTerminatedStatusList = Lists.newArrayList((Object[])new String[]{ExamineStatusEnum.TO_BE_EXAMINE.getNumber(), ExamineStatusEnum.IN_EXAMINE.getNumber()});
        if (!HRArrayUtils.isEmpty((Object[])examineBills)) {
            Date date = new Date();
            long currUserId = RequestContext.get().getCurrUserId();
            for (Object examineBill : examineBills) {
                String examineStatus = examineBill.getString("examinestatus");
                if (!canTerminatedStatusList.contains(examineStatus)) continue;
                examineBill.set("billstatus", (Object)"F");
                examineBill.set("auditstatus", (Object)"F");
                examineBill.set("examinestatus", (Object)ExamineStatusEnum.TERMINATED.getNumber());
                examineBill.set("modifytime", (Object)date);
                examineBill.set("modifier", (Object)currUserId);
                Long examineBillId = examineBill.getLong("id");
                List<Long> handlerIds = BILL_COMMON_DOMAIN_SERVICE.getActivityHandlerIds((DynamicObject)examineBill, "handler");
                if (CollectionUtils.isEmpty(handlerIds)) continue;
                String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_examinebill").setParameter("formPkId", String.valueOf(examineBillId)).builder();
                BosMessageService.sendTemplateMessage(contentUrl, handlerIds, examineBill.getLong("nominatebill.id"), "cadm_examinebill", "cadm_stop", examineBillId);
                terminateSuccessActivityBills.add((DynamicObject)examineBill);
            }
            EXAMINE_BILL_REPOSITORY.update((DynamicObject[])examineBills);
            List<Long> examineIds = Stream.of(examineBills).map(dynObj -> dynObj.getLong("id")).collect(Collectors.toList());
            EXAMINE_COOP_SERVICE.terminationUnHandledExamCoop(examineIds, ExamCoopStatusEnum.TERMINATED, "cadm_stopexam");
        }
        return terminateSuccessActivityBills;
    }

    @Override
    public DynamicObject queryActHandlerByNominateId(Long nominateId) {
        QFilter nominateQFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter notDelFilter = new QFilter("examinestatus", "!=", (Object)ExamineStatusEnum.DEL.getNumber());
        return EXAMINE_BILL_REPOSITORY.queryOne("handler", new QFilter[]{nominateQFilter, notDelFilter});
    }

    public DynamicObject[] queryExamineBillById(String selectProperties, List<Object> pkIds) {
        QFilter idFilter = new QFilter("id", "in", pkIds);
        return EXAMINE_BILL_REPOSITORY.query(selectProperties, new QFilter[]{idFilter});
    }

    public DynamicObject queryOne(String selectProperties, Object pkId) {
        return EXAMINE_BILL_REPOSITORY.queryOne(selectProperties, pkId);
    }

    public DynamicObject queryOriginalOneById(String selectProperties, Object pkId) {
        return EXAMINE_BILL_REPOSITORY.queryOriginalOne(selectProperties, pkId);
    }

    public void updateData(DynamicObject[] examineBills) {
        EXAMINE_BILL_REPOSITORY.updateDatas(examineBills);
    }

    public DynamicObject[] queryByPermission(String selectProperties, long userId, List<String> statusList, String permItemId) {
        List<QFilter> qFilters = PermissionUtil.getPermissionQFilter("cadm_examinebill", userId, permItemId);
        if (!CollectionUtils.isEmpty(statusList)) {
            QFilter qFilter = new QFilter("examinestatus", "in", statusList);
            qFilters.add(qFilter);
        }
        QFilter userFilter = new QFilter("handler.fbasedataid_id", "in", (Object)userId);
        qFilters.add(userFilter);
        QFilter appointStatusQFilter = new QFilter("nominatebill.appointstatus", "!=", (Object)AppointStatusEnum.WAIT_APPOINT.getVal());
        qFilters.add(appointStatusQFilter);
        return EXAMINE_BILL_REPOSITORY.queryOriginalArray(selectProperties, qFilters.toArray(new QFilter[0]));
    }
}

