/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.examine.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamCoopStatusEnum;
import kd.tdc.cadm.bussiness.util.UrlBuilder;

public class ExamineCoopDomainService {
    private static final HRBaseServiceHelper EXAMINE_COOP_REPOSITORY = new HRBaseServiceHelper("cadm_examinecooperate");

    public DynamicObject[] queryByExamineId(String selectProperties, Long examineId) {
        QFilter examineFilter = new QFilter("examinebillid", "=", (Object)examineId);
        QFilter coopStatusFilter = new QFilter("coopstatus", "!=", (Object)ExamCoopStatusEnum.DISCARD.getNumber());
        return EXAMINE_COOP_REPOSITORY.query(selectProperties, new QFilter[]{examineFilter, coopStatusFilter}, "id desc");
    }

    public DynamicObject[] queryExamineCoopByArrangeRecordId(String selectProperties, Long arrangeRecordId) {
        QFilter examineFilter = new QFilter("examarrrecordid", "=", (Object)arrangeRecordId);
        QFilter isLatestFilter = new QFilter("islatest", "=", (Object)true);
        return EXAMINE_COOP_REPOSITORY.query(selectProperties, new QFilter[]{examineFilter, isLatestFilter}, "id desc");
    }

    public DynamicObject queryExamCoopById(String selectProperties, Long id) {
        return EXAMINE_COOP_REPOSITORY.queryOne(selectProperties, (Object)id);
    }

    public DynamicObject queryExamCoopById(Long id) {
        return EXAMINE_COOP_REPOSITORY.queryOne((Object)id);
    }

    public void updateExamCoop(DynamicObject examCoop) {
        EXAMINE_COOP_REPOSITORY.updateDataOne(examCoop);
    }

    public List<DynamicObject> initData(DynamicObject examineBill, DynamicObject examPlan, Map<String, List<Long>> handlerMap, Map<String, List<Long>> intervieweeMap, long examineArrangeRecordId) {
        long examineId = examineBill.getLong("id");
        DynamicObjectCollection examPlanEntry = examPlan.getDynamicObjectCollection("examplanentry");
        ArrayList<DynamicObject> examCoops = new ArrayList<DynamicObject>(examPlanEntry.size());
        Date currDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject examPlanEntryRow : examPlanEntry) {
            String id = examPlanEntryRow.getString("id");
            List<Long> handlerIds = handlerMap.get(id);
            if (CollectionUtils.isEmpty(handlerIds)) {
                handlerIds = new ArrayList<Long>();
            }
            DynamicObject examCoop = EXAMINE_COOP_REPOSITORY.generateEmptyDynamicObject();
            DynamicObjectCollection handlerCol = examCoop.getDynamicObjectCollection("coophandler");
            handlerCol.clear();
            for (Long handlerId : handlerIds) {
                DynamicObject item = handlerCol.addNew();
                item.set("fbasedataid", (Object)handlerId);
            }
            String itemGroupName = examPlanEntryRow.getString("itemgroup.name");
            List<Long> intervieweeUserIds = intervieweeMap.get(itemGroupName);
            DynamicObjectCollection intervieweeCol = examCoop.getDynamicObjectCollection("interviewee");
            intervieweeCol.clear();
            if (!CollectionUtils.isEmpty(intervieweeUserIds)) {
                for (Long intervieweeId : intervieweeUserIds) {
                    DynamicObject item = intervieweeCol.addNew();
                    item.set("fbasedataid", (Object)intervieweeId);
                }
            }
            examCoop.set("coophandler", (Object)handlerCol);
            examCoop.set("interviewee", (Object)intervieweeCol);
            examCoop.set("person", (Object)examineBill.getDynamicObject("person").getLong("id"));
            examCoop.set("nominatebill", (Object)examineBill.getDynamicObject("nominatebill").getLong("id"));
            examCoop.set("billno", (Object)examineBill.getString("billno"));
            examCoop.set("examinebillid", (Object)examineId);
            examCoop.set("coopstatus", (Object)ExamCoopStatusEnum.NOT_START.getNumber());
            examCoop.set("createtime", (Object)currDate);
            examCoop.set("creator", (Object)currUserId);
            examCoop.set("itemgroup", (Object)examPlanEntryRow.getDynamicObject("itemgroup").getLong("sourcevid"));
            examCoop.set("isurge", (Object)Character.valueOf('0'));
            examCoop.set("examplan", (Object)examPlan.getLong("id"));
            examCoop.set("examresultplan", (Object)examPlan.getDynamicObject("examresultplan").getLong("sourcevid"));
            String planExamWay = examPlanEntryRow.getString("planexamway");
            examCoop.set("coopexamway", (Object)planExamWay);
            examCoop.set("examarrrecordid", (Object)examineArrangeRecordId);
            examCoop.set("islatest", (Object)true);
            DynamicObjectCollection itemremarkentryCollection = examPlanEntryRow.getDynamicObjectCollection("itemremarkentry");
            HashMap<Long, String> itemRemarkMap = new HashMap<Long, String>(16);
            for (DynamicObject itemRemark : itemremarkentryCollection) {
                long examItemId = itemRemark.getLong("examitem.sourcevid");
                String remark = itemRemark.getString("itemremark");
                itemRemarkMap.put(examItemId, remark);
            }
            examCoop.set("examsla", (Object)examPlanEntryRow.getBigDecimal("examsla"));
            DynamicObjectCollection planExamItems = examPlanEntryRow.getDynamicObjectCollection("planexamitem");
            if (!CollectionUtils.isEmpty((Collection)planExamItems)) {
                DynamicObjectCollection emptyExamPlanEntry = EXAMINE_COOP_REPOSITORY.generateEmptyEntryCollection(examCoop, "entryentity");
                for (DynamicObject planExamItem : planExamItems) {
                    DynamicObject emptyExamPlanEntryRow = emptyExamPlanEntry.addNew();
                    long examItemVid = planExamItem.getDynamicObject("fbasedataid").getLong("sourcevid");
                    emptyExamPlanEntryRow.set("examitem", (Object)examItemVid);
                    String remarkStr = (String)itemRemarkMap.get(examItemVid);
                    if (!HRStringUtils.isNotEmpty((String)remarkStr)) continue;
                    emptyExamPlanEntryRow.set("itemremark", (Object)remarkStr);
                }
                examCoop.set("entryentity", (Object)emptyExamPlanEntry);
            }
            examCoops.add(examCoop);
        }
        EXAMINE_COOP_REPOSITORY.save(examCoops.toArray(new DynamicObject[0]));
        return examCoops;
    }

    public DynamicObject urge(Long examCoopId) {
        DynamicObject examCoop = this.queryExamCoopById("isurge,urgetime,nominatebill,coophandler", examCoopId);
        examCoop.set("isurge", (Object)Boolean.TRUE);
        examCoop.set("urgetime", (Object)new Date());
        EXAMINE_COOP_REPOSITORY.updateDataOne(examCoop);
        return examCoop;
    }

    public void terminationUnHandledExamCoop(List<Long> examineIds, ExamCoopStatusEnum coopStatusEnum, String msgTempNumber) {
        QFilter examineIdFilter = new QFilter("examinebillid", "in", examineIds);
        QFilter coopStatusFilter = coopStatusEnum == ExamCoopStatusEnum.TERMINATED ? new QFilter("coopstatus", "=", (Object)ExamCoopStatusEnum.TO_BE_HANDLED.getNumber()) : new QFilter("coopstatus", "not in", (Object)Lists.newArrayList((Object[])new String[]{ExamCoopStatusEnum.DISCARD.getNumber(), ExamCoopStatusEnum.NOT_START.getNumber()}));
        Object[] examCoops = EXAMINE_COOP_REPOSITORY.query("id,nominatebill,coophandler,coopstatus,modifier,modifytime", new QFilter[]{examineIdFilter, coopStatusFilter});
        if (!HRArrayUtils.isEmpty((Object[])examCoops)) {
            Date currDate = new Date();
            long currUserId = RequestContext.get().getCurrUserId();
            DynamicObjectCollection examColl = new DynamicObjectCollection();
            for (Object examCoop : examCoops) {
                boolean isDiscard;
                boolean bl = isDiscard = coopStatusEnum == ExamCoopStatusEnum.DISCARD;
                if (!isDiscard && !ExamCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(examCoop.getString("coopstatus"))) continue;
                List<Long> userIds = examCoop.getDynamicObjectCollection("coophandler").stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toList());
                Long nominateId = examCoop.getLong("nominatebill.id");
                Long expedCoopId = examCoop.getLong("id");
                String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_examinecooperate").setParameter("formPkId", String.valueOf(expedCoopId)).builder();
                BosMessageService.sendTemplateMessage(contentUrl, userIds, nominateId, "cadm_examinecooperate", msgTempNumber, expedCoopId);
                examCoop.set("coopstatus", (Object)coopStatusEnum.getNumber());
                examCoop.set("modifier", (Object)currUserId);
                examCoop.set("modifytime", (Object)currDate);
                examColl.add(examCoop);
            }
            if (!examColl.isEmpty()) {
                EXAMINE_COOP_REPOSITORY.update((DynamicObject[])examColl.toArray((Object[])new DynamicObject[0]));
            }
        }
    }

    public boolean isExistsCoopNotDiscard(long examId) {
        QFilter idQFilter = new QFilter("examinebillid", "=", (Object)examId);
        QFilter statusQFilter = new QFilter("coopstatus", "!=", (Object)ExamCoopStatusEnum.DISCARD.getNumber());
        return EXAMINE_COOP_REPOSITORY.isExists(new QFilter[]{idQFilter, statusQFilter});
    }

    public DynamicObject[] queryExamCoopByArrangeRecordId(Long recordId) {
        String selectProperties = "starttime,coopstatus,examplan,coopresult,coopcomment,examsla,isurge,createtime,cooptaketime,itemgroup,entryentity.examitem,entryentity.score,handler.id";
        QFilter recordFilter = new QFilter("examarrrecordid", "=", (Object)recordId);
        QFilter isLatestFilter = new QFilter("islatest", "=", (Object)true);
        DynamicObject[] rlt = EXAMINE_COOP_REPOSITORY.query(selectProperties, new QFilter[]{recordFilter, isLatestFilter});
        return rlt;
    }

    public DynamicObject startCoop(String coopType, Long examCoopId) {
        DynamicObject coopRlt = null;
        DynamicObject examCoop = this.queryExamCoopById(examCoopId);
        Date currDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        if ("start_coop".equals(coopType)) {
            examCoop.set("starttime", (Object)currDate);
            examCoop.set("islatest", (Object)true);
            examCoop.set("coopstatus", (Object)ExamCoopStatusEnum.TO_BE_HANDLED.getNumber());
            coopRlt = examCoop;
        }
        if ("restart_coop".equals(coopType)) {
            examCoop.set("coopstatus", (Object)ExamCoopStatusEnum.DISCARD.getNumber());
            examCoop.set("islatest", (Object)false);
            CloneUtils cloneUtils = new CloneUtils(false, true);
            DynamicObject newExamCoop = (DynamicObject)cloneUtils.clone((IDataEntityBase)examCoop);
            newExamCoop.set("creator", (Object)currUserId);
            newExamCoop.set("createtime", (Object)currDate);
            newExamCoop.set("coopstatus", (Object)ExamCoopStatusEnum.TO_BE_HANDLED.getNumber());
            newExamCoop.set("handler", null);
            newExamCoop.set("handletime", null);
            newExamCoop.set("coopresult", (Object)" ");
            newExamCoop.set("coopcomment", (Object)" ");
            newExamCoop.set("starttime", (Object)currDate);
            newExamCoop.set("islatest", (Object)true);
            DynamicObjectCollection newEntryEntity = newExamCoop.getDynamicObjectCollection("entryentity");
            newEntryEntity.forEach(p -> p.set("score", null));
            EXAMINE_COOP_REPOSITORY.saveOne(newExamCoop);
            coopRlt = newExamCoop;
        }
        examCoop.set("modifier", (Object)currUserId);
        examCoop.set("modifytime", (Object)currDate);
        EXAMINE_COOP_REPOSITORY.updateDataOne(examCoop);
        return coopRlt;
    }
}

