/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.exped.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.domain.examine.entityservice.ExamPlanEntityService;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamCoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.exped.enums.ExpedCoopStatusEnum;

public class ExpedCoopDomainService {
    private static final HRBaseServiceHelper EXPED_COOP_HELPER = new HRBaseServiceHelper("cadm_expedcooperate");
    private static final ExamPlanEntityService EXAM_PLAN_ENTITY_SERVICE = ServiceFactory.getService(ExamPlanEntityService.class);

    public DynamicObject queryExpedCoopById(String selectProperties, Long id) {
        return EXPED_COOP_HELPER.queryOne(selectProperties, (Object)id);
    }

    public DynamicObject queryExpedCoopById(Long id) {
        return EXPED_COOP_HELPER.queryOne((Object)id);
    }

    public List<DynamicObject> initData(DynamicObject expedBill, DynamicObject examPlan, Map<String, List<Long>> handlerMap, Map<String, List<Long>> intervieweeMap, long expedArrangeRecordId) {
        long expedId = expedBill.getLong("id");
        DynamicObjectCollection examPlanEntry = examPlan.getDynamicObjectCollection("examplanentry");
        ArrayList<DynamicObject> expedCoops = new ArrayList<DynamicObject>(examPlanEntry.size());
        Date currDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject examPlanEntryRow : examPlanEntry) {
            DynamicObject expedCoopDy = EXPED_COOP_HELPER.generateEmptyDynamicObject();
            expedCoopDy.set("person", expedBill.get("person"));
            expedCoopDy.set("tenure", expedBill.get("tenure"));
            expedCoopDy.set("billno", (Object)expedBill.getString("billno"));
            expedCoopDy.set("expedbill", (Object)expedId);
            expedCoopDy.set("coopstatus", (Object)ExpedCoopStatusEnum.NOT_START.getNumber());
            expedCoopDy.set("createtime", (Object)currDate);
            expedCoopDy.set("creator", (Object)currUserId);
            String id = examPlanEntryRow.getString("id");
            List<Long> handlerIds = handlerMap.get(id);
            if (CollectionUtils.isEmpty(handlerIds)) {
                handlerIds = new ArrayList<Long>();
            }
            DynamicObjectCollection handlerCol = expedCoopDy.getDynamicObjectCollection("coophandler");
            handlerCol.clear();
            for (Long handlerId : handlerIds) {
                DynamicObject item = handlerCol.addNew();
                item.set("fbasedataid", (Object)handlerId);
            }
            String itemGroupName = examPlanEntryRow.getString("itemgroup.name");
            List<Long> intervieweeUserIds = intervieweeMap.get(itemGroupName);
            DynamicObjectCollection intervieweeCol = expedCoopDy.getDynamicObjectCollection("interviewee");
            intervieweeCol.clear();
            if (!CollectionUtils.isEmpty(intervieweeUserIds)) {
                for (Long intervieweeId : intervieweeUserIds) {
                    DynamicObject item = intervieweeCol.addNew();
                    item.set("fbasedataid", (Object)intervieweeId);
                }
            }
            expedCoopDy.set("expedarrrecordid", (Object)expedArrangeRecordId);
            expedCoopDy.set("islatest", (Object)true);
            DynamicObjectCollection itemremarkentryCollection = examPlanEntryRow.getDynamicObjectCollection("itemremarkentry");
            HashMap<Long, String> itemRemarkMap = new HashMap<Long, String>(16);
            for (DynamicObject itemRemark : itemremarkentryCollection) {
                long examItemId = itemRemark.getLong("examitem.sourcevid");
                String remark = itemRemark.getString("itemremark");
                itemRemarkMap.put(examItemId, remark);
            }
            expedCoopDy.set("interviewee", (Object)intervieweeCol);
            expedCoopDy.set("coophandler", (Object)handlerCol);
            expedCoopDy.set("itemgroup", (Object)examPlanEntryRow.getDynamicObject("itemgroup").getLong("sourcevid"));
            expedCoopDy.set("expedplan", (Object)examPlan.getLong("id"));
            expedCoopDy.set("examresultplan", (Object)examPlan.getDynamicObject("examresultplan").getLong("sourcevid"));
            String planExamWay = examPlanEntryRow.getString("planexamway");
            expedCoopDy.set("expedway", (Object)planExamWay);
            expedCoopDy.set("cooptaketime", (Object)examPlanEntryRow.getBigDecimal("examsla"));
            DynamicObjectCollection planExamItems = examPlanEntryRow.getDynamicObjectCollection("planexamitem");
            if (!planExamItems.isEmpty()) {
                DynamicObjectCollection emptyExamPlanEntry = EXPED_COOP_HELPER.generateEmptyEntryCollection(expedCoopDy, "entryentity");
                for (DynamicObject planExamItem : planExamItems) {
                    DynamicObject emptyExamPlanEntryRow = emptyExamPlanEntry.addNew();
                    long examItemVid = planExamItem.getDynamicObject("fbasedataid").getLong("sourcevid");
                    emptyExamPlanEntryRow.set("examitem", (Object)examItemVid);
                    String remarkStr = (String)itemRemarkMap.get(examItemVid);
                    if (!HRStringUtils.isNotEmpty((String)remarkStr)) continue;
                    emptyExamPlanEntryRow.set("itemremark", (Object)remarkStr);
                }
                expedCoopDy.set("entryentity", (Object)emptyExamPlanEntry);
            }
            expedCoops.add(expedCoopDy);
        }
        EXPED_COOP_HELPER.save(expedCoops.toArray(new DynamicObject[0]));
        return expedCoops;
    }

    public DynamicObject urge(Long examCoopId) {
        DynamicObject expedCoopBill = this.queryExpedCoopById("urgetime,coophandler", examCoopId);
        expedCoopBill.set("urgetime", (Object)new Date());
        EXPED_COOP_HELPER.updateDataOne(expedCoopBill);
        return expedCoopBill;
    }

    public DynamicObject[] queryExpedCoopByArrangeRecordId(String selectProperties, Long arrangeRecordId) {
        QFilter recordFilter = new QFilter("expedarrrecordid", "=", (Object)arrangeRecordId);
        QFilter isLatestFilter = new QFilter("islatest", "=", (Object)true);
        DynamicObject[] rlt = EXPED_COOP_HELPER.query(selectProperties, new QFilter[]{recordFilter, isLatestFilter}, "id desc");
        return rlt;
    }

    public DynamicObject startCoop(String coopType, Long examCoopId) {
        DynamicObject coopRlt = null;
        DynamicObject expedCoop = this.queryExpedCoopById(examCoopId);
        Date currDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        if ("start_coop".equals(coopType)) {
            expedCoop.set("starttime", (Object)currDate);
            expedCoop.set("islatest", (Object)true);
            expedCoop.set("coopstatus", (Object)ExpedCoopStatusEnum.TO_BE_HANDLED.getNumber());
            coopRlt = expedCoop;
        }
        if ("restart_coop".equals(coopType)) {
            expedCoop.set("coopstatus", (Object)ExpedCoopStatusEnum.ABANDONED.getNumber());
            expedCoop.set("islatest", (Object)false);
            CloneUtils cloneUtils = new CloneUtils(false, true);
            DynamicObject newExamCoop = (DynamicObject)cloneUtils.clone((IDataEntityBase)expedCoop);
            newExamCoop.set("creator", (Object)currUserId);
            newExamCoop.set("createtime", (Object)currDate);
            newExamCoop.set("coopstatus", (Object)ExamCoopStatusEnum.TO_BE_HANDLED.getNumber());
            newExamCoop.set("handler", null);
            newExamCoop.set("handletime", null);
            newExamCoop.set("coopresult", (Object)" ");
            newExamCoop.set("coopcomment", (Object)" ");
            newExamCoop.set("starttime", (Object)currDate);
            newExamCoop.set("islatest", (Object)true);
            DynamicObjectCollection newEntryEntity = newExamCoop.getDynamicObjectCollection("entryentity");
            newEntryEntity.forEach(p -> p.set("score", null));
            EXPED_COOP_HELPER.saveOne(newExamCoop);
            coopRlt = newExamCoop;
        }
        expedCoop.set("modifier", (Object)currUserId);
        expedCoop.set("modifytime", (Object)currDate);
        EXPED_COOP_HELPER.updateDataOne(expedCoop);
        return coopRlt;
    }

    public DynamicObject queryExamPlanByExamPlanId(String selectProperties, long examPlanId) {
        return EXAM_PLAN_ENTITY_SERVICE.queryExamPlanById(selectProperties, examPlanId);
    }

    public DynamicObject[] queryExamPlanEntryById(String selectProperties, long examPlanId) {
        return EXAM_PLAN_ENTITY_SERVICE.queryExamPlanEntryById(selectProperties, examPlanId);
    }

    public void updateExpedCoop(DynamicObject examCoop) {
        EXPED_COOP_HELPER.updateDataOne(examCoop);
    }
}

