/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.issue.enums;

import java.util.Arrays;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.util.MultiLangEnumBridge;
import kd.tdc.cadm.common.enums.StatusTypeEnum;

public enum IssueStatusEnum {
    DEL("-1", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u5df2\u5220\u9664", "IssueStatusEnum_4", "tdc-cadm-business")),
    UN_TRIGGER("10", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u672a\u89e6\u53d1", "IssueStatusEnum_0", "tdc-cadm-business")),
    TOBE_ISSUE("20", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u5f85\u7b7e\u53d1", "IssueStatusEnum_1", "tdc-cadm-business")),
    HAS_ISSUED("30", StatusTypeEnum.COMPLETED, new MultiLangEnumBridge("\u7b7e\u53d1\u5b8c\u6210", "IssueStatusEnum_2", "tdc-cadm-business")),
    TERMINATED("40", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u5df2\u7ec8\u6b62", "IssueStatusEnum_3", "tdc-cadm-business"));

    private final String number;
    private final StatusTypeEnum statusType;
    private final MultiLangEnumBridge bridge;

    private IssueStatusEnum(String number, StatusTypeEnum statusType, MultiLangEnumBridge bridge) {
        this.number = number;
        this.statusType = statusType;
        this.bridge = bridge;
    }

    public String getNumber() {
        return this.number;
    }

    public String getStatusName() {
        return this.bridge.loadKDString();
    }

    public StatusTypeEnum getStatusType() {
        return this.statusType;
    }

    public static IssueStatusEnum getEnumByStatus(String status) {
        return Arrays.stream(IssueStatusEnum.values()).filter(element -> HRStringUtils.equals((String)element.getNumber(), (String)status)).findFirst().orElse(null);
    }

    public static boolean canBeRejected(String number) {
        return IssueStatusEnum.TOBE_ISSUE.number.equals(number);
    }

    private static class Constants {
        public static final String TDC_CADM_BUSINESS = "tdc-cadm-business";

        private Constants() {
        }
    }
}

