/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.issue.service;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.domain.issue.enums.IssueStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.service.ActivityBillCommonDomainService;
import kd.tdc.cadm.bussiness.domain.nominate.service.IActivityBillCommonService;
import kd.tdc.cadm.bussiness.util.PermissionUtil;
import kd.tdc.cadm.bussiness.util.UrlBuilder;

public class IssueBillDomainService
implements IActivityBillCommonService {
    private static final Log LOGGER = LogFactory.getLog(IssueBillDomainService.class);
    private static final HRBaseServiceHelper ISSUE_BILL_REPOSITORY = new HRBaseServiceHelper("cadm_appointissue");
    private static final ActivityBillCommonDomainService BILL_COMMON_DOMAIN_SERVICE = ServiceFactory.getService(ActivityBillCommonDomainService.class);

    @Override
    public DynamicObject initAfterSubmitNominateBill(DynamicObject nominateBill, long matchActivityId, List<Long> handlers, int sla) {
        long nominateId = nominateBill.getLong("id");
        QFilter nominateFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter matchActvFilter = new QFilter("matchactv", "=", (Object)matchActivityId);
        QFilter nonDelFilter = new QFilter("issuestatus", "!=", (Object)IssueStatusEnum.DEL.getNumber());
        DynamicObject issueBill = ISSUE_BILL_REPOSITORY.queryOne("issuestatus,nominatebill,matchactv,billno,createtime,org,creator,person,handler,billstatus,auditstatus,sla", new QFilter[]{nominateFilter, matchActvFilter, nonDelFilter});
        if (Objects.isNull(issueBill)) {
            issueBill = ISSUE_BILL_REPOSITORY.generateEmptyDynamicObject();
            LOGGER.info(MessageFormat.format("IssueBillServiceImpl.initIssueBill(): query issue bill fail, bill is null, the params is nominateId[{0}],matchActvId[{1}]", nominateId, matchActivityId));
        }
        issueBill.set("billstatus", (Object)"A");
        issueBill.set("auditstatus", (Object)"A");
        issueBill.set("issuestatus", (Object)IssueStatusEnum.UN_TRIGGER.getNumber());
        issueBill.set("issuestatus", (Object)IssueStatusEnum.UN_TRIGGER.getNumber());
        issueBill.set("nominatebill", (Object)nominateId);
        issueBill.set("matchactv", (Object)matchActivityId);
        issueBill.set("billno", (Object)nominateBill.getString("billno"));
        issueBill.set("createtime", (Object)new Date());
        issueBill.set("org", (Object)nominateBill.getLong("org.id"));
        issueBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        issueBill.set("sla", (Object)sla);
        issueBill.set("person", (Object)nominateBill.getLong("person.id"));
        BILL_COMMON_DOMAIN_SERVICE.setActivityBillHandler(issueBill, handlers);
        ISSUE_BILL_REPOSITORY.save(new DynamicObject[]{issueBill});
        LOGGER.info("IssueBillServiceImpl.initIssueBill(): save issue bill finish");
        return issueBill;
    }

    @Override
    public DynamicObject triggerBill(Long nominateId, Long activityId, Long instanceId, List<Long> approverIds) {
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter actvIdFilter = new QFilter("matchactv", "=", (Object)activityId);
        QFilter notDelFilter = new QFilter("issuestatus", "!=", (Object)IssueStatusEnum.DEL.getNumber());
        DynamicObject issueBill = ISSUE_BILL_REPOSITORY.queryOne("billno,issuestatus,createtime,handler,billstatus,auditstatus,instanceid,deadline,sla", new QFilter[]{nominateIdFilter, actvIdFilter, notDelFilter});
        if (Objects.isNull(issueBill)) {
            LOGGER.error(MessageFormat.format("IssueBillServiceImpl.trigger(): trigger issue bill fail, issue bill is null, nominateId is {0}, activityId is {1}", nominateId, activityId));
            return issueBill;
        }
        LOGGER.info(MessageFormat.format("IssueBillServiceImpl.trigger(): query issue bill finish, billno is {0}", issueBill.getString("billno")));
        issueBill.set("billstatus", (Object)"A");
        issueBill.set("auditstatus", (Object)"A");
        issueBill.set("issuestatus", (Object)IssueStatusEnum.TOBE_ISSUE.getNumber());
        Date nowDate = new Date();
        issueBill.set("createtime", (Object)nowDate);
        int sla = issueBill.getInt("sla");
        if (sla != 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(nowDate);
            cal.add(10, sla);
            issueBill.set("deadline", (Object)cal.getTime());
        }
        BILL_COMMON_DOMAIN_SERVICE.setActivityBillHandler(issueBill, approverIds);
        issueBill.set("instanceid", (Object)instanceId);
        ISSUE_BILL_REPOSITORY.save(new DynamicObject[]{issueBill});
        LOGGER.info("IssueBillServiceImpl.trigger(): save issue bill finish");
        return issueBill;
    }

    @Override
    public DynamicObject updatedToNotTrigger(Long nominateId) {
        QFilter[] filters = new QFilter[]{new QFilter("nominatebill", "=", (Object)nominateId)};
        DynamicObject nextBill = ISSUE_BILL_REPOSITORY.queryOne("issuestatus, id", filters);
        if (!HRObjectUtils.isEmpty((Object)nextBill)) {
            nextBill.set("issuestatus", (Object)IssueStatusEnum.UN_TRIGGER.getNumber());
            ISSUE_BILL_REPOSITORY.saveOne(nextBill);
        }
        return nextBill;
    }

    @Override
    public Tuple<Boolean, String> judgeEnableUnSubmit(Long nominateId) {
        String status;
        QFilter[] filters = new QFilter[]{new QFilter("nominatebill", "=", (Object)nominateId)};
        DynamicObject nextBill = ISSUE_BILL_REPOSITORY.queryOriginalOne("id,issuestatus", filters);
        String string = status = HRObjectUtils.isEmpty((Object)nextBill) ? "" : nextBill.getString("issuestatus");
        if (!HRStringUtils.equals((String)status, (String)IssueStatusEnum.TOBE_ISSUE.getNumber())) {
            return Tuple.create((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64a4\u9500\u7b7e\u53d1\u72b6\u6001\u4e3a\u201c\u5f85\u7b7e\u53d1\u201d\u7684\u6570\u636e\u3002", (String)"IssueBillDomainService_0", (String)"tdc-cadm-business", (Object[])new Object[0]));
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)"");
    }

    public void rejectBill(DynamicObject[] issueBills) {
        Arrays.stream(issueBills).forEach(bill -> bill.set("issuestatus", (Object)IssueStatusEnum.UN_TRIGGER.getNumber()));
        ISSUE_BILL_REPOSITORY.update(issueBills);
    }

    public DynamicObject[] queryIssueBillById(String selectProperties, List<Object> pkIds) {
        QFilter idFilter = new QFilter("id", "in", pkIds);
        return ISSUE_BILL_REPOSITORY.query(selectProperties, new QFilter[]{idFilter});
    }

    public DynamicObject queryOne(String selectProperties, Object pkId) {
        return ISSUE_BILL_REPOSITORY.queryOne(selectProperties, pkId);
    }

    public DynamicObject[] queryOriginalIssueBillById(String selectProperties, List<Long> pkIds) {
        QFilter idFilter = new QFilter("id", "in", pkIds);
        return ISSUE_BILL_REPOSITORY.queryOriginalArray(selectProperties, new QFilter[]{idFilter});
    }

    public DynamicObject queryOneByNominateId(String selectProperties, long nominateId) {
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter notDelFilter = new QFilter("issuestatus", "!=", (Object)IssueStatusEnum.DEL.getNumber());
        return ISSUE_BILL_REPOSITORY.queryOne(selectProperties, new QFilter[]{nominateIdFilter, notDelFilter});
    }

    @Override
    public Tuple<DynamicObject, Boolean> updateAfterUnSubmitNominate(Long nominateId, Long activityId) {
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter matchActvIdFilter = new QFilter("matchactv", "=", (Object)activityId);
        QFilter notDeleteFilter = new QFilter("issuestatus", "!=", (Object)IssueStatusEnum.DEL.getNumber());
        DynamicObject issueBill = ISSUE_BILL_REPOSITORY.queryOne("billno,issuestatus,instanceid,handler", new QFilter[]{nominateIdFilter, matchActvIdFilter, notDeleteFilter});
        Boolean needSendMsg = Boolean.FALSE;
        if (issueBill != null && !IssueStatusEnum.UN_TRIGGER.getNumber().equals(issueBill.getString("issuestatus"))) {
            needSendMsg = Boolean.TRUE;
            issueBill.set("issuestatus", (Object)IssueStatusEnum.DEL.getNumber());
            ISSUE_BILL_REPOSITORY.updateDataOne(issueBill);
        }
        return Tuple.create((Object)issueBill, (Object)needSendMsg);
    }

    @Override
    public List<DynamicObject> fireTerminateActivity(List<Long> appointBillIds) {
        ArrayList<DynamicObject> terminateSuccessActivityBills = new ArrayList<DynamicObject>(10);
        QFilter nominateIdQFilters = new QFilter("nominatebill", "in", appointBillIds);
        Object[] issueBills = ISSUE_BILL_REPOSITORY.query("id,billstatus,auditstatus,issuestatus,modifier,modifytime,nominatebill,handler,instanceid", new QFilter[]{nominateIdQFilters});
        ArrayList canTerminatedStatusList = Lists.newArrayList((Object[])new String[]{IssueStatusEnum.TOBE_ISSUE.getNumber()});
        if (!HRArrayUtils.isEmpty((Object[])issueBills)) {
            Date date = new Date();
            long currUserId = RequestContext.get().getCurrUserId();
            Arrays.stream(issueBills).forEach(issueBill -> {
                String issueStatus = issueBill.getString("issuestatus");
                if (!canTerminatedStatusList.contains(issueStatus)) {
                    return;
                }
                issueBill.set("billstatus", (Object)"F");
                issueBill.set("auditstatus", (Object)"F");
                issueBill.set("issuestatus", (Object)IssueStatusEnum.TERMINATED.getNumber());
                issueBill.set("modifytime", (Object)date);
                issueBill.set("modifier", (Object)currUserId);
                Long issueBillId = issueBill.getLong("id");
                List<Long> handlerIds = BILL_COMMON_DOMAIN_SERVICE.getActivityHandlerIds((DynamicObject)issueBill, "handler");
                if (CollectionUtils.isEmpty(handlerIds)) {
                    return;
                }
                String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_appointissue").setParameter("formPkId", String.valueOf(issueBillId)).builder();
                BosMessageService.sendTemplateMessage(contentUrl, handlerIds, issueBill.getLong("nominatebill.id"), "cadm_appointissue", "cadm_stop", issueBillId);
                terminateSuccessActivityBills.add((DynamicObject)issueBill);
            });
            ISSUE_BILL_REPOSITORY.update((DynamicObject[])issueBills);
        }
        return terminateSuccessActivityBills;
    }

    @Override
    public DynamicObject queryActHandlerByNominateId(Long nominateId) {
        return this.queryOneByNominateId("handler", nominateId);
    }

    public DynamicObject getEffectiveIssueBillByNominateId(Long nominateId) {
        QFilter nominateQFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter statusFilter = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.HAS_ISSUED.getNumber());
        String selectProperties = "id,appnoticedoc,issuetime,issuebatchnum";
        return ISSUE_BILL_REPOSITORY.queryOne(selectProperties, new QFilter[]{nominateQFilter, statusFilter});
    }

    public DynamicObject[] getByIssueBatchNum(String selectProperties, String batchNum) {
        return ISSUE_BILL_REPOSITORY.query(selectProperties, new QFilter[]{new QFilter("issuebatchnum", "=", (Object)batchNum)});
    }

    public void update(DynamicObject[] dynamicObjects) {
        ISSUE_BILL_REPOSITORY.updateDatas(dynamicObjects);
    }

    public DynamicObject[] queryByPermission(String selectProperties, long userId, List<String> statusList, String permItemId) {
        List<QFilter> qFilters = PermissionUtil.getPermissionQFilter("cadm_appointissue", userId, permItemId);
        if (!CollectionUtils.isEmpty(statusList)) {
            QFilter qFilter = new QFilter("issuestatus", "in", statusList);
            qFilters.add(qFilter);
        }
        QFilter userFilter = new QFilter("handler.fbasedataid_id", "in", (Object)userId);
        qFilters.add(userFilter);
        QFilter appointStatusQFilter = new QFilter("nominatebill.appointstatus", "!=", (Object)AppointStatusEnum.WAIT_APPOINT.getVal());
        qFilters.add(appointStatusQFilter);
        return ISSUE_BILL_REPOSITORY.queryOriginalArray(selectProperties, qFilters.toArray(new QFilter[0]));
    }
}

