/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.nominate.enums;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.tdc.cadm.bussiness.util.MultiLangEnumBridge;
import kd.tdc.cadm.common.enums.StatusTypeEnum;

public enum AppointStatusEnum {
    WAIT_APPOINT("0", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u5f85\u4efb\u514d", "AppointStatusEnum_0", "tdc-cadm-business")),
    ING_APPOINT("1", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u4efb\u514d\u6d41\u7a0b\u4e2d", "AppointStatusEnum_1", "tdc-cadm-business")),
    SUCCESS_APPOINT("2", StatusTypeEnum.COMPLETED, new MultiLangEnumBridge("\u4efb\u514d\u5b8c\u6210", "AppointStatusEnum_2", "tdc-cadm-business")),
    TERMINATE_APPOINT("3", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u4efb\u514d\u7ec8\u6b62", "AppointStatusEnum_3", "tdc-cadm-business"));

    private final String val;
    private final StatusTypeEnum statusType;
    private final MultiLangEnumBridge bridge;
    private static final Map<String, AppointStatusEnum> APPOINT_STATUS_ENUM_MAP;

    private AppointStatusEnum(String val, StatusTypeEnum statusType, MultiLangEnumBridge bridge) {
        this.val = val;
        this.statusType = statusType;
        this.bridge = bridge;
    }

    public String getVal() {
        return this.val;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public StatusTypeEnum getStatusType() {
        return this.statusType;
    }

    public static AppointStatusEnum getEnumByVal(String val) {
        return APPOINT_STATUS_ENUM_MAP.get(val);
    }

    static {
        APPOINT_STATUS_ENUM_MAP = Maps.newHashMapWithExpectedSize((int)AppointStatusEnum.values().length);
        for (AppointStatusEnum item : AppointStatusEnum.values()) {
            APPOINT_STATUS_ENUM_MAP.put(item.getVal(), item);
        }
    }

    private static class Constants {
        public static final String TDC_CADM_BUSINESS = "tdc-cadm-business";

        private Constants() {
        }
    }
}

