/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.nominate.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyKindEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyTypeEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.NominateStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.service.IActivityBillCommonService;
import kd.tdc.cadm.bussiness.util.PermissionUtil;

public class NominateBillDomainService {
    private static final Log LOGGER = LogFactory.getLog(NominateBillDomainService.class);
    private static final HRBaseServiceHelper NOMINATE_BILL_REPOSITORY = new HRBaseServiceHelper("cadm_nominatebill");
    private static final HRBaseServiceHelper WF_HIPROCINST_REPOSITORY = new HRBaseServiceHelper("wf_hiprocinst");

    public Tuple<Boolean, Tuple<String, String>> judgeEnableUnSubmit(Long nominateId) {
        DynamicObject bill = NOMINATE_BILL_REPOSITORY.queryOne("actvplanhis, billno, person, applytype, nominatestatus, appointstatus", (Object)nominateId);
        if (bill == null) {
            return Tuple.create((Object)Boolean.FALSE, null);
        }
        String billno = bill.getString("billno");
        String applyType = bill.getString("applytype");
        if (HRStringUtils.equals((String)applyType, (String)ApplyTypeEnum.FAST.getVal())) {
            String msg = ResManager.loadKDString((String)"\u5feb\u901f\u63d0\u540d\u5355\u4e0d\u80fd\u64a4\u9500", (String)"NominateBillDomainService_0", (String)"tdc-cadm-business", (Object[])new Object[0]);
            return Tuple.create((Object)Boolean.FALSE, (Object)Tuple.create((Object)billno, (Object)msg));
        }
        String nominateStatus = bill.getString("nominatestatus");
        String appointStatus = bill.getString("appointstatus");
        if (!NominateStatusEnum.SUCCESS_NOMINATE.getVal().equals(nominateStatus) || !AppointStatusEnum.ING_APPOINT.getVal().equals(appointStatus)) {
            return Tuple.create((Object)Boolean.FALSE, (Object)Tuple.create((Object)billno, (Object)ResManager.loadKDString((String)"\u53ea\u53ef\u64a4\u9500\u4efb\u547d\u6d41\u7a0b\u4e2d\uff0c\u63d0\u540d\u5b8c\u6210\u4e14\u4e0b\u4e00\u73af\u8282\u672a\u63d0\u4ea4\u7684\u5355\u636e\u3002", (String)"NominateBillDomainService_1", (String)"tdc-cadm-business", (Object[])new Object[0])));
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)Tuple.create((Object)billno, (Object)""));
    }

    public void beRejected(List<Long> nominateIds) {
        DynamicObject[] bills;
        QFilter idFilter = new QFilter("id", "in", nominateIds);
        for (DynamicObject bill : bills = NOMINATE_BILL_REPOSITORY.query("billno,billstatus,auditstatus,appointstatus,nominatestatus", new QFilter[]{idFilter})) {
            bill.set("appointstatus", (Object)AppointStatusEnum.WAIT_APPOINT.getVal());
            bill.set("nominatestatus", (Object)NominateStatusEnum.RESUBMIT_NOMINATE.getVal());
            bill.set("auditstatus", (Object)"A");
            bill.set("billstatus", (Object)"A");
        }
        NOMINATE_BILL_REPOSITORY.update(bills);
    }

    public DynamicObject completeAppoint(long nominateBillId) {
        String selectProperties = "bpositionhis,bjobhis,bstandardpositionhis,badminorghis,bcompanyhis,appointstatus,nominatestatus,person,employee,acompany,aadminorg,aposition,appointdate,appointtype,isprimappoint,ajob,appointreason,prepositivedate,cadrecat,planenddate,apptreasongroup,appointdate,planenddate,dposition,dadminorg,dcompany,applykind,billno,appointenddate,atenure,dismisstenure,empposrel,positiontype,apostype,dpostype,appointfinishedtime,astandardposition,empposrel,djob,dstandardposition,appointeffectstatus,dismisseffectstatus";
        DynamicObject nominate = NOMINATE_BILL_REPOSITORY.queryOne(selectProperties, (Object)nominateBillId);
        nominate.set("appointstatus", (Object)AppointStatusEnum.SUCCESS_APPOINT.getVal());
        nominate.set("nominatestatus", (Object)NominateStatusEnum.SUCCESS_NOMINATE.getVal());
        nominate.set("appointfinishedtime", (Object)new Date());
        this.setFieldValueToSourceVid(nominate, "acompany", "aposition", "aadminorg", "ajob", "dposition", "dadminorg", "dcompany", "bpositionhis", "bjobhis", "bstandardpositionhis", "badminorghis", "bcompanyhis", "astandardposition", "djob", "dstandardposition");
        NOMINATE_BILL_REPOSITORY.updateOne(nominate);
        return NOMINATE_BILL_REPOSITORY.queryOne(selectProperties, (Object)nominateBillId);
    }

    public void setFieldValueToSourceVid(DynamicObject nominate, String ... fieldKeys) {
        for (String fieldKey : fieldKeys) {
            DynamicObject dynObj = nominate.getDynamicObject(fieldKey);
            if (dynObj == null) continue;
            nominate.set(fieldKey + "_id", (Object)dynObj.getLong("sourcevid"));
        }
    }

    public DynamicObject initPlanActivity(DynamicObject nominateBill, String actEntityFormId, long matchActivityId, List<Long> handlers, int sla) {
        IActivityBillCommonService activityService = (IActivityBillCommonService)ServiceFactory.getService(actEntityFormId);
        return activityService.initAfterSubmitNominateBill(nominateBill, matchActivityId, handlers, sla);
    }

    public DynamicObject queryNominateBillOriginalOne(String selectedProperties, long pkId) {
        return NOMINATE_BILL_REPOSITORY.queryOriginalOne(selectedProperties, (Object)pkId);
    }

    public DynamicObject queryNominateBillById(long pkId) {
        return NOMINATE_BILL_REPOSITORY.queryOne((Object)pkId);
    }

    public DynamicObject queryNominateBillById(String selectedProperties, long pkId) {
        return NOMINATE_BILL_REPOSITORY.queryOne(selectedProperties, (Object)pkId);
    }

    public boolean isExistBillById(long pkId) {
        return NOMINATE_BILL_REPOSITORY.isExists((Object)pkId);
    }

    public DynamicObject[] queryNominateByBrewId(String selectedProperties, Long brewId) {
        QFilter brewFilter = new QFilter("brewingbill", "=", (Object)brewId);
        return NOMINATE_BILL_REPOSITORY.query(selectedProperties, new QFilter[]{brewFilter});
    }

    public DynamicObject[] queryNominateByEmployee(String selectProperties, Long employeeId) {
        QFilter statusFilter = new QFilter("appointstatus", "=", (Object)AppointStatusEnum.ING_APPOINT.getVal());
        QFilter employeeFilter = new QFilter("employee", "=", (Object)employeeId);
        return NOMINATE_BILL_REPOSITORY.query(selectProperties, new QFilter[]{statusFilter, employeeFilter});
    }

    public DynamicObject[] queryNominateBillsByIds(String selectProperties, List<Long> pkIds) {
        return NOMINATE_BILL_REPOSITORY.query(selectProperties, new QFilter[]{new QFilter("id", "in", pkIds)});
    }

    public DynamicObject[] queryOriginalNominateBillsByIds(String selectProperties, List<Long> pkIds) {
        return NOMINATE_BILL_REPOSITORY.queryOriginalArray(selectProperties, new QFilter[]{new QFilter("id", "in", pkIds)});
    }

    public void updateData(DynamicObject[] dataEntities) {
        NOMINATE_BILL_REPOSITORY.updateDatas(dataEntities);
    }

    public DynamicObject[] queryAllWaitEffectBills(String selectProperties) {
        QFilter waitEffectFilter = new QFilter("dismisseffectstatus", "=", (Object)"0");
        waitEffectFilter.or(new QFilter("appointeffectstatus", "=", (Object)"0"));
        QFilter continueFilter = new QFilter("appointtype", "=", (Object)1472625044948646912L);
        QFilter completeFilter = new QFilter("appointstatus", "=", (Object)AppointStatusEnum.SUCCESS_APPOINT.getVal());
        return NOMINATE_BILL_REPOSITORY.query(selectProperties, new QFilter[]{waitEffectFilter, continueFilter, completeFilter});
    }

    public DynamicObject[] query(String selectProperties, QFilter[] qFilters) {
        return NOMINATE_BILL_REPOSITORY.query(selectProperties, qFilters);
    }

    public DynamicObject[] queryNominateByPermission(String selectProperties, long userId, List<String> statusList, String permItemId) {
        List<QFilter> qFilters = PermissionUtil.getPermissionQFilter("cadm_nominatebill", userId, permItemId);
        if (!CollectionUtils.isEmpty(statusList)) {
            QFilter qFilter = new QFilter("appointstatus", "in", statusList);
            qFilters.add(qFilter);
        }
        QFilter applyKindFilter = new QFilter("applykind", "=", (Object)ApplyKindEnum.APPOINT.getNumber());
        qFilters.add(applyKindFilter);
        return NOMINATE_BILL_REPOSITORY.queryOriginalArray(selectProperties, qFilters.toArray(new QFilter[0]));
    }

    public List<Map<String, Object>> getNominateRecord(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            throw new RuntimeException("params is empty.");
        }
        if (params.get("employeeId") == null) {
            throw new RuntimeException("employeeId is empty.");
        }
        long employeeId = Long.parseLong(params.get("employeeId").toString());
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        QFilter applyKindFilter = new QFilter("applykind", "=", (Object)ApplyKindEnum.APPOINT.getNumber());
        QFilter employeeIdFilter = new QFilter("employee", "=", (Object)employeeId);
        QFilter appointStatusFilter = new QFilter("appointstatus", "in", Arrays.asList(AppointStatusEnum.SUCCESS_APPOINT.getVal(), AppointStatusEnum.TERMINATE_APPOINT.getVal()));
        String selectProperties = "id,appointfinishedtime,terminatedate,positiontype,aposition.id,aposition.name,astandardposition.id,astandardposition.name,ajob.id,ajob.name,aadminorg.id,aadminorg.name,isprimappoint,appointtype.id,appointtype.name,nominateper.id,nominateper.name,nominatedate,appointreason,appointstatus,terminationidea,acompany.id,acompany.name,apostype.id,apostype.name";
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.addAll(Arrays.asList(applyKindFilter, employeeIdFilter, appointStatusFilter));
        Object startDateObj = params.get("startDate");
        Object endDateObj = params.get("endDate");
        DynamicObject[] nominateBills = NOMINATE_BILL_REPOSITORY.queryOriginalArray(selectProperties, qFilters.toArray(new QFilter[0]));
        if (nominateBills.length == 0) {
            return result;
        }
        if (startDateObj != null || endDateObj != null) {
            Date startDate = null;
            Date endDate = null;
            if (startDateObj != null) {
                if (!(startDateObj instanceof Date)) {
                    throw new RuntimeException("startDate format is incorrect. Please enter the correct date.");
                }
                startDate = (Date)startDateObj;
            }
            if (endDateObj != null) {
                if (!(endDateObj instanceof Date)) {
                    throw new RuntimeException("endDate format is incorrect. Please enter the correct date.");
                }
                endDate = (Date)endDateObj;
            }
            Date finalStartDate = startDate;
            Date finalEndDate = endDate;
            nominateBills = (DynamicObject[])Arrays.stream(nominateBills).filter(dynamicObject -> {
                Date finishedTime;
                String appointStatus = dynamicObject.getString("appointstatus");
                Date appointFinishedTime = dynamicObject.getDate("appointfinishedtime");
                Date terminateDate = dynamicObject.getDate("terminatedate");
                if (AppointStatusEnum.SUCCESS_APPOINT.getVal().equals(appointStatus) && appointFinishedTime == null) {
                    return false;
                }
                if (AppointStatusEnum.TERMINATE_APPOINT.getVal().equals(appointStatus) && terminateDate == null) {
                    return false;
                }
                Date date = finishedTime = AppointStatusEnum.SUCCESS_APPOINT.getVal().equals(appointStatus) ? appointFinishedTime : terminateDate;
                if (startDateObj != null && finalStartDate.compareTo(finishedTime) > 0) {
                    return false;
                }
                return endDateObj == null || finalEndDate.compareTo(finishedTime) >= 0;
            }).toArray(DynamicObject[]::new);
        }
        List propertyList = Arrays.stream(selectProperties.split(",")).collect(Collectors.toList());
        for (DynamicObject nominateBill : nominateBills) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            for (String property : propertyList) {
                if (property.equals("appointfinishedtime") || property.equals("terminatedate")) continue;
                map.put(property.replace(".", "_"), nominateBill.get(property));
            }
            String appointStatus = nominateBill.getString("appointstatus");
            if (AppointStatusEnum.SUCCESS_APPOINT.getVal().equals(appointStatus)) {
                map.put("finishedtime", nominateBill.get("appointfinishedtime"));
            } else {
                map.put("finishedtime", nominateBill.get("terminatedate"));
            }
            result.add(map);
        }
        result = result.stream().sorted(Comparator.comparing(p -> (Date)p.get("nominatedate"), Comparator.nullsLast(Date::compareTo))).collect(Collectors.toList());
        return result;
    }

    public void updateAppointFinishedTime() {
        QFilter appointStatusFilter = new QFilter("appointstatus", "=", (Object)AppointStatusEnum.SUCCESS_APPOINT.getVal());
        QFilter timeFilter = new QFilter("appointfinishedtime", "=", null);
        DynamicObject[] nominateBills = NOMINATE_BILL_REPOSITORY.query("id,appointfinishedtime", new QFilter[]{appointStatusFilter, timeFilter});
        List nominateIds = Arrays.stream(nominateBills).map(p -> p.getString("id")).collect(Collectors.toList());
        if (nominateIds.size() > 0) {
            QFilter businessKeyFilter = new QFilter("businesskey", "in", nominateIds);
            QFilter endTypeFilter = new QFilter("endtype", "=", (Object)"10");
            DynamicObject[] endTimes = WF_HIPROCINST_REPOSITORY.query("businesskey,endtime", new QFilter[]{businessKeyFilter, endTypeFilter});
            Map<Long, Date> endTimeMap = Arrays.stream(endTimes).filter(p -> StringUtils.isNotBlank((CharSequence)p.getString("businesskey")) && p.get("endtime") != null).collect(Collectors.toMap(item -> Long.valueOf(item.get("businesskey").toString()), item -> (Date)item.get("endtime"), (v1, v2) -> v1));
            Arrays.stream(nominateBills).forEach(nominateBill -> nominateBill.set("appointfinishedtime", endTimeMap.get(nominateBill.getLong("id"))));
            NOMINATE_BILL_REPOSITORY.update(nominateBills);
        }
        appointStatusFilter = new QFilter("appointstatus", "=", (Object)AppointStatusEnum.TERMINATE_APPOINT.getVal());
        nominateBills = NOMINATE_BILL_REPOSITORY.query("id,terminatedate,appointfinishedtime", new QFilter[]{appointStatusFilter, timeFilter});
        if (nominateBills.length > 0) {
            Arrays.stream(nominateBills).forEach(nominateBill -> nominateBill.set("appointfinishedtime", nominateBill.get("terminatedate")));
            NOMINATE_BILL_REPOSITORY.update(nominateBills);
        }
    }

    public DynamicObject[] queryTerminationNominateByBrewIds(String selectProperties, List<Long> brewIds) {
        QFilter brewIdsFilter = new QFilter("brewingbill", "in", brewIds);
        QFilter applyKindFilter = new QFilter("applykind", "=", (Object)ApplyKindEnum.APPOINT.getNumber());
        QFilter appointStatusFilter = new QFilter("appointstatus", "in", Arrays.asList(AppointStatusEnum.SUCCESS_APPOINT.getVal(), AppointStatusEnum.TERMINATE_APPOINT.getVal()));
        DynamicObject[] nominateBills = NOMINATE_BILL_REPOSITORY.queryOriginalArray(selectProperties, new QFilter[]{applyKindFilter, brewIdsFilter, appointStatusFilter});
        return nominateBills;
    }

    public DynamicObject[] queryNominateBillsByStatus(String selectProperties, List<String> statusList, Long personId) {
        QFilter personIdFilter = new QFilter("person.id", "=", (Object)personId);
        QFilter statusFilter = new QFilter("appointstatus", "in", statusList);
        QFilter applyKindFilter = new QFilter("applykind", "=", (Object)ApplyKindEnum.APPOINT.getNumber());
        DynamicObject[] nominateBills = NOMINATE_BILL_REPOSITORY.query(selectProperties, new QFilter[]{applyKindFilter, personIdFilter, statusFilter});
        return nominateBills;
    }

    public DynamicObject[] queryNominateBillsByPersonId(String selectProperties, Long personId) {
        QFilter personIdFilter = new QFilter("person.id", "=", (Object)personId);
        DynamicObject[] nominateBills = NOMINATE_BILL_REPOSITORY.query(selectProperties, new QFilter[]{personIdFilter});
        return nominateBills;
    }
}

