/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.publicity.enums;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.util.MultiLangEnumBridge;
import kd.tdc.cadm.common.enums.StatusTypeEnum;

public enum PublicityStatusEnum {
    DEL("-1", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u5df2\u5220\u9664", "PublicityStatusEnum_8", "tdc-cadm-business")),
    NOT_TRIGGER("0", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u672a\u89e6\u53d1", "PublicityStatusEnum_0", "tdc-cadm-business")),
    BE_PUBLIC("10", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u5f85\u516c\u793a", "PublicityStatusEnum_1", "tdc-cadm-business")),
    RE_PUBLICIZED("15", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u5f85\u91cd\u65b0\u516c\u793a", "PublicityStatusEnum_4", "tdc-cadm-business")),
    BE_EFFECTIVE("20", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u5f85\u8fdb\u5165\u516c\u793a\u671f", "PublicityStatusEnum_2", "tdc-cadm-business")),
    IN_PUBLIC("30", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u516c\u793a\u4e2d", "PublicityStatusEnum_3", "tdc-cadm-business")),
    BE_SUBMIT("50", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u5f85\u63d0\u4ea4\u516c\u793a\u7ed3\u679c", "PublicityStatusEnum_5", "tdc-cadm-business")),
    COMPLETED("60", StatusTypeEnum.COMPLETED, new MultiLangEnumBridge("\u516c\u793a\u5b8c\u6210", "PublicityStatusEnum_9", "tdc-cadm-business")),
    TERMINATED("70", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u5df2\u7ec8\u6b62", "PublicityStatusEnum_7", "tdc-cadm-business"));

    private final String pubStatus;
    private final StatusTypeEnum statusType;
    private final MultiLangEnumBridge bridge;
    private static final List<String> VIEW_STATUS;

    private PublicityStatusEnum(String pubStatus, StatusTypeEnum statusType, MultiLangEnumBridge bridge) {
        this.pubStatus = pubStatus;
        this.statusType = statusType;
        this.bridge = bridge;
    }

    public static PublicityStatusEnum getEnumByPubStatus(String pubStatus) {
        return Arrays.stream(PublicityStatusEnum.values()).filter(element -> HRStringUtils.equals((String)element.getPubStatus(), (String)pubStatus)).findFirst().orElse(null);
    }

    public String getPubStatus() {
        return this.pubStatus;
    }

    public String getDesc() {
        return this.bridge.loadKDString();
    }

    public StatusTypeEnum getStatusType() {
        return this.statusType;
    }

    public static boolean isViewStatus(String pubStatus) {
        return VIEW_STATUS.contains(pubStatus);
    }

    public static boolean canBeWithdraw(String pubStatus) {
        return PublicityStatusEnum.BE_EFFECTIVE.pubStatus.equals(pubStatus) || PublicityStatusEnum.IN_PUBLIC.pubStatus.equals(pubStatus);
    }

    public static boolean canBeRejected(String pubStatus) {
        return PublicityStatusEnum.BE_PUBLIC.pubStatus.equals(pubStatus) || PublicityStatusEnum.RE_PUBLICIZED.pubStatus.equals(pubStatus) || PublicityStatusEnum.BE_EFFECTIVE.pubStatus.equals(pubStatus);
    }

    public static boolean canBePublicity(String pubStatus) {
        return PublicityStatusEnum.BE_PUBLIC.pubStatus.equals(pubStatus) || PublicityStatusEnum.RE_PUBLICIZED.pubStatus.equals(pubStatus);
    }

    public static boolean canSubmit(String pubStatus) {
        return PublicityStatusEnum.BE_SUBMIT.pubStatus.equals(pubStatus);
    }

    public static boolean canSave(String pubStatus) {
        return PublicityStatusEnum.BE_PUBLIC.pubStatus.equals(pubStatus) || PublicityStatusEnum.RE_PUBLICIZED.pubStatus.equals(pubStatus) || PublicityStatusEnum.BE_SUBMIT.pubStatus.equals(pubStatus);
    }

    static {
        VIEW_STATUS = Lists.newArrayList((Object[])new String[]{PublicityStatusEnum.BE_EFFECTIVE.pubStatus, PublicityStatusEnum.IN_PUBLIC.pubStatus, PublicityStatusEnum.COMPLETED.pubStatus, PublicityStatusEnum.TERMINATED.pubStatus});
    }

    private static class Constants {
        public static final String TDC_CADM_BUSINESS = "tdc-cadm-business";

        private Constants() {
        }
    }
}

