/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.publicity.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.service.ActivityBillCommonDomainService;
import kd.tdc.cadm.bussiness.domain.nominate.service.IActivityBillCommonService;
import kd.tdc.cadm.bussiness.domain.publicity.enums.PublicityStatusEnum;
import kd.tdc.cadm.bussiness.util.PermissionUtil;
import kd.tdc.cadm.bussiness.util.UrlBuilder;

public class PublicityBillDomainService
implements IActivityBillCommonService {
    private static final Log LOG = LogFactory.getLog(PublicityBillDomainService.class);
    private static final HRBaseServiceHelper PUBLICITY_BILL_REPOSITORY = new HRBaseServiceHelper("cadm_publicity");
    private final ActivityBillCommonDomainService BILL_COMMON_DOMAIN_SERVICE = ServiceFactory.getService(ActivityBillCommonDomainService.class);

    @Override
    public DynamicObject initAfterSubmitNominateBill(DynamicObject nominateBill, long matchActivityId, List<Long> handlers, int sla) {
        QFilter nonDelFilter;
        QFilter matchActFilter;
        long nominateId = nominateBill.getLong("id");
        QFilter nominateFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        DynamicObject publicityBill = PUBLICITY_BILL_REPOSITORY.queryOne("id,handler,nominatebill,matchactv,billno,person,org,creator,pubstatus,sla", new QFilter[]{nominateFilter, matchActFilter = new QFilter("matchactv", "=", (Object)matchActivityId), nonDelFilter = new QFilter("pubstatus", "!=", (Object)PublicityStatusEnum.DEL.getPubStatus())});
        if (HRObjectUtils.isEmpty((Object)publicityBill)) {
            publicityBill = PUBLICITY_BILL_REPOSITORY.generateEmptyDynamicObject();
        }
        publicityBill.set("pubstatus", (Object)PublicityStatusEnum.NOT_TRIGGER.getPubStatus());
        publicityBill.set("nominatebill", (Object)nominateId);
        publicityBill.set("billno", nominateBill.get("billno"));
        publicityBill.set("person", nominateBill.get("person"));
        publicityBill.set("matchactv", (Object)matchActivityId);
        publicityBill.set("org", nominateBill.get("org"));
        publicityBill.set("creator", (Object)(RequestContext.get().getCurrUserId() == 0L ? 1L : RequestContext.get().getCurrUserId()));
        publicityBill.set("sla", (Object)sla);
        this.BILL_COMMON_DOMAIN_SERVICE.setActivityBillHandler(publicityBill, handlers);
        PUBLICITY_BILL_REPOSITORY.saveOne(publicityBill);
        return publicityBill;
    }

    @Override
    public DynamicObject triggerBill(Long nominateId, Long activityId, Long instanceId, List<Long> approverIds) {
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter actIdFilter = new QFilter("matchactv", "=", (Object)activityId);
        QFilter notDelFilter = new QFilter("pubstatus", "!=", (Object)PublicityStatusEnum.DEL.getPubStatus());
        DynamicObject publicityBill = PUBLICITY_BILL_REPOSITORY.queryOne("id,billno,billstatus,auditstatus,pubstatus,createtime,handler,instanceid,deadline,sla", new QFilter[]{nominateIdFilter, actIdFilter, notDelFilter});
        if (HRObjectUtils.isEmpty((Object)publicityBill)) {
            LOG.error("trigger# non publicityBill to be trigger,  nominateId is {}, activityId is {}", (Object)nominateId, (Object)activityId);
            return publicityBill;
        }
        publicityBill.set("billstatus", (Object)"A");
        publicityBill.set("auditstatus", (Object)"A");
        publicityBill.set("pubstatus", (Object)PublicityStatusEnum.BE_PUBLIC.getPubStatus());
        Date nowDate = new Date();
        publicityBill.set("createtime", (Object)nowDate);
        int sla = publicityBill.getInt("sla");
        if (sla != 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(nowDate);
            cal.add(10, sla);
            publicityBill.set("deadline", (Object)cal.getTime());
        }
        this.BILL_COMMON_DOMAIN_SERVICE.setActivityBillHandler(publicityBill, approverIds);
        publicityBill.set("instanceid", (Object)instanceId);
        PUBLICITY_BILL_REPOSITORY.updateDataOne(publicityBill);
        return publicityBill;
    }

    @Override
    public DynamicObject updatedToNotTrigger(Long nominateId) {
        QFilter[] filters = new QFilter[]{new QFilter("nominatebill", "=", (Object)nominateId)};
        DynamicObject nextBill = PUBLICITY_BILL_REPOSITORY.queryOne("pubstatus, id", filters);
        if (!HRObjectUtils.isEmpty((Object)nextBill)) {
            nextBill.set("pubstatus", (Object)PublicityStatusEnum.NOT_TRIGGER.getPubStatus());
            PUBLICITY_BILL_REPOSITORY.saveOne(nextBill);
        }
        return nextBill;
    }

    @Override
    public Tuple<Boolean, String> judgeEnableUnSubmit(Long nominateId) {
        String status;
        QFilter[] filters = new QFilter[]{new QFilter("nominatebill", "=", (Object)nominateId)};
        DynamicObject nextBill = PUBLICITY_BILL_REPOSITORY.queryOriginalOne("id,pubstatus", filters);
        String string = status = HRObjectUtils.isEmpty((Object)nextBill) ? "" : nextBill.getString("pubstatus");
        if (!HRStringUtils.equals((String)status, (String)PublicityStatusEnum.BE_PUBLIC.getPubStatus())) {
            return Tuple.create((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64a4\u9500\u516c\u793a\u72b6\u6001\u4e3a\u201c\u5f85\u516c\u793a\u201d\u7684\u6570\u636e\u3002", (String)"PublicityBillDomainService_0", (String)"tdc-cadm-business", (Object[])new Object[0]));
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)"");
    }

    public DynamicObject queryOriginalOneById(String selectProperties, Object pkId) {
        return PUBLICITY_BILL_REPOSITORY.queryOriginalOne(selectProperties, pkId);
    }

    public DynamicObject[] queryOriginalById(String selectProperties, Object pkId) {
        QFilter idFilter = new QFilter("id", "in", pkId);
        return PUBLICITY_BILL_REPOSITORY.queryOriginalArray(selectProperties, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryPublicityBillById(String selectProperties, List<Object> pkIds) {
        QFilter idFilter = new QFilter("id", "in", pkIds);
        return PUBLICITY_BILL_REPOSITORY.query(selectProperties, new QFilter[]{idFilter});
    }

    public DynamicObject queryPublicityBillByAppointId(String selectProperties, Long appointId) {
        QFilter nominateFilter = new QFilter("nominatebill", "=", (Object)appointId);
        QFilter notDelFilter = new QFilter("pubstatus", "!=", (Object)PublicityStatusEnum.DEL.getPubStatus());
        return PUBLICITY_BILL_REPOSITORY.queryOne(selectProperties, new QFilter[]{nominateFilter, notDelFilter});
    }

    public DynamicObject[] queryByPubBatchNum(String selectProperties, String pubBatchNum) {
        QFilter numFilter = new QFilter("pubbatchnum", "=", (Object)pubBatchNum);
        return PUBLICITY_BILL_REPOSITORY.query(selectProperties, new QFilter[]{numFilter});
    }

    public void updatePublicityBillByStatus(DynamicObject publicityBill, String publicityStatus) {
        String batchNum = CodeRuleServiceHelper.getNumber((String)"cadm_publicity", (DynamicObject)publicityBill, (String)String.valueOf(RequestContext.get().getOrgId()));
        String fileNum = CodeRuleServiceHelper.getNumber((String)"cadm_publicitybasebill", (DynamicObject)publicityBill, (String)String.valueOf(RequestContext.get().getOrgId()));
        publicityBill.set("pubbatchnum", (Object)batchNum);
        publicityBill.set("pubfilenum", (Object)fileNum);
        publicityBill.set("modifytime", (Object)new Date());
        publicityBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
        publicityBill.set("pubstatus", (Object)publicityStatus);
        PUBLICITY_BILL_REPOSITORY.updateOne(publicityBill);
    }

    public void update(DynamicObject[] publicityBills) {
        PUBLICITY_BILL_REPOSITORY.updateDatas(publicityBills);
    }

    public Set<String> doPublicAfterConfirmOp(Map<String, Object> infoMap, List<Long> pkIds) {
        Object startDate = infoMap.get("pubstartdate");
        Object endDate = infoMap.get("pubenddate");
        Object pubFileId = infoMap.get("pubfile");
        Object pubStatus = infoMap.get("pubstatus");
        Object pubInstruction = infoMap.get("pubinstruction");
        DynamicObject[] pubBills = PUBLICITY_BILL_REPOSITORY.query("id,pubfilenum,pubbatchnum,pubstatus,pubenddate,pubstartdate,pubinstruction,pubfile,modifier,modifytime,billno", new QFilter[]{new QFilter("id", "in", pkIds)});
        HashSet canPubStatusList = Sets.newHashSet((Object[])new String[]{PublicityStatusEnum.BE_PUBLIC.getPubStatus(), PublicityStatusEnum.RE_PUBLICIZED.getPubStatus(), PublicityStatusEnum.BE_SUBMIT.getPubStatus()});
        List<DynamicObject> canPubBillList = Arrays.stream(pubBills).filter(pubBill -> canPubStatusList.contains(pubBill.getString("pubstatus"))).collect(Collectors.toList());
        Set<String> failedBillNos = Arrays.stream(pubBills).filter(pubBill -> !canPubStatusList.contains(pubBill.getString("pubstatus"))).map(pubBill -> pubBill.getString("billno")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(canPubBillList)) {
            String batchNum = CodeRuleServiceHelper.getNumber((String)"cadm_publicity", (DynamicObject)((DynamicObject)canPubBillList.get(0)), (String)String.valueOf(RequestContext.get().getOrgId()));
            String fileNum = CodeRuleServiceHelper.getNumber((String)"cadm_publicitybasebill", (DynamicObject)((DynamicObject)canPubBillList.get(0)), (String)String.valueOf(RequestContext.get().getOrgId()));
            canPubBillList.forEach(pubBill -> {
                pubBill.set("pubstartdate", startDate);
                pubBill.set("pubenddate", endDate);
                pubBill.set("pubfile", pubFileId);
                pubBill.set("pubstatus", pubStatus);
                pubBill.set("pubinstruction", pubInstruction);
                pubBill.set("pubfilenum", (Object)fileNum);
                pubBill.set("pubbatchnum", (Object)batchNum);
                pubBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
                pubBill.set("modifytime", (Object)new Date());
            });
            PUBLICITY_BILL_REPOSITORY.update(canPubBillList.toArray(new DynamicObject[0]));
        }
        return failedBillNos;
    }

    @Override
    public Tuple<DynamicObject, Boolean> updateAfterUnSubmitNominate(Long nominateId, Long activityId) {
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter actIdFilter = new QFilter("matchactv", "=", (Object)activityId);
        QFilter notDeleteFilter = new QFilter("pubstatus", "!=", (Object)PublicityStatusEnum.DEL.getPubStatus());
        DynamicObject publicityBill = PUBLICITY_BILL_REPOSITORY.queryOne("id,billno,pubstatus,instanceid,handler", new QFilter[]{nominateIdFilter, actIdFilter, notDeleteFilter});
        Boolean needSendMsg = Boolean.FALSE;
        if (publicityBill != null && !PublicityStatusEnum.NOT_TRIGGER.getPubStatus().equals(publicityBill.getString("pubstatus"))) {
            needSendMsg = Boolean.TRUE;
            publicityBill.set("pubstatus", (Object)PublicityStatusEnum.DEL.getPubStatus());
            PUBLICITY_BILL_REPOSITORY.updateDataOne(publicityBill);
        }
        return Tuple.create((Object)publicityBill, (Object)needSendMsg);
    }

    @Override
    public List<DynamicObject> fireTerminateActivity(List<Long> appointBillIds) {
        ArrayList<DynamicObject> terminateSuccessActivityBills = new ArrayList<DynamicObject>(10);
        QFilter nominateIdQFilters = new QFilter("nominatebill", "in", appointBillIds);
        Object[] publicityBills = PUBLICITY_BILL_REPOSITORY.query("id,billstatus,auditstatus,pubstatus,modifier,modifytime,nominatebill,handler,instanceid", new QFilter[]{nominateIdQFilters});
        ArrayList canTerminatedStatusList = Lists.newArrayList((Object[])new String[]{PublicityStatusEnum.BE_PUBLIC.getPubStatus(), PublicityStatusEnum.BE_EFFECTIVE.getPubStatus(), PublicityStatusEnum.RE_PUBLICIZED.getPubStatus(), PublicityStatusEnum.BE_SUBMIT.getPubStatus(), PublicityStatusEnum.IN_PUBLIC.getPubStatus()});
        if (!HRArrayUtils.isEmpty((Object[])publicityBills)) {
            Date date = new Date();
            long currUserId = RequestContext.get().getCurrUserId();
            Arrays.stream(publicityBills).forEach(publicityBill -> {
                String pubStatus = publicityBill.getString("pubstatus");
                if (!canTerminatedStatusList.contains(pubStatus)) {
                    return;
                }
                publicityBill.set("billstatus", (Object)"F");
                publicityBill.set("auditstatus", (Object)"F");
                publicityBill.set("pubstatus", (Object)PublicityStatusEnum.TERMINATED.getPubStatus());
                publicityBill.set("modifytime", (Object)date);
                publicityBill.set("modifier", (Object)currUserId);
                Long publicityBillId = publicityBill.getLong("id");
                List<Long> handlerIds = this.BILL_COMMON_DOMAIN_SERVICE.getActivityHandlerIds((DynamicObject)publicityBill, "handler");
                if (CollectionUtils.isEmpty(handlerIds)) {
                    return;
                }
                String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_publicity").setParameter("formPkId", String.valueOf(publicityBillId)).builder();
                BosMessageService.sendTemplateMessage(contentUrl, handlerIds, publicityBill.getLong("nominatebill.id"), "cadm_publicity", "cadm_stop", publicityBillId);
                terminateSuccessActivityBills.add((DynamicObject)publicityBill);
            });
            PUBLICITY_BILL_REPOSITORY.update((DynamicObject[])publicityBills);
        }
        return terminateSuccessActivityBills;
    }

    @Override
    public DynamicObject queryActHandlerByNominateId(Long nominateId) {
        return this.queryPublicityBillByAppointId("handler", nominateId);
    }

    public DynamicObject[] queryByPubStatus(String selectProperties, String pubStatus) {
        return PUBLICITY_BILL_REPOSITORY.query(selectProperties, new QFilter[]{new QFilter("pubstatus", "=", (Object)pubStatus)});
    }

    public DynamicObject getEffectivePublicityBillByNominateId(Long nominateId) {
        QFilter nominateQFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter statusFilter = new QFilter("pubstatus", "=", (Object)PublicityStatusEnum.COMPLETED.getPubStatus());
        String selectProperties = "id,pubfile,pubstartdate,pubenddate,pubbatchnum";
        return PUBLICITY_BILL_REPOSITORY.queryOne(selectProperties, new QFilter[]{nominateQFilter, statusFilter});
    }

    public DynamicObject[] getByPubBatchNumList(String selectProperties, List<String> batchNumList) {
        ArrayList statusList = Lists.newArrayList((Object[])new String[]{PublicityStatusEnum.BE_EFFECTIVE.getPubStatus(), PublicityStatusEnum.IN_PUBLIC.getPubStatus()});
        QFilter statusFilter = new QFilter("pubstatus", "in", (Object)statusList);
        QFilter batchNumFilter = new QFilter("pubbatchnum", "in", batchNumList);
        return PUBLICITY_BILL_REPOSITORY.query(selectProperties, new QFilter[]{statusFilter, batchNumFilter});
    }

    public DynamicObject[] getAllByPubBatchNumList(String selectProperties, List<String> batchNumList) {
        QFilter batchNumFilter = new QFilter("pubbatchnum", "in", batchNumList);
        return PUBLICITY_BILL_REPOSITORY.query(selectProperties, new QFilter[]{batchNumFilter});
    }

    public DynamicObject[] queryByPermission(String selectProperties, long userId, List<String> statusList, String permItemId) {
        List<QFilter> qFilters = PermissionUtil.getPermissionQFilter("cadm_publicity", userId, permItemId);
        if (!CollectionUtils.isEmpty(statusList)) {
            QFilter qFilter = new QFilter("pubstatus", "in", statusList);
            qFilters.add(qFilter);
        }
        QFilter userFilter = new QFilter("handler.fbasedataid_id", "in", (Object)userId);
        qFilters.add(userFilter);
        QFilter appointStatusQFilter = new QFilter("nominatebill.appointstatus", "!=", (Object)AppointStatusEnum.WAIT_APPOINT.getVal());
        qFilters.add(appointStatusQFilter);
        return PUBLICITY_BILL_REPOSITORY.queryOriginalArray(selectProperties, qFilters.toArray(new QFilter[0]));
    }
}

