/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.release.enums;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.tdc.cadm.bussiness.util.MultiLangEnumBridge;
import kd.tdc.cadm.common.enums.StatusTypeEnum;

public enum ReleaseStatusEnum {
    DEL("-1", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u5df2\u5220\u9664", "ReleaseStatusEnum_6", "tdc-cadm-business")),
    NOT_TRIGGER("0", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u672a\u89e6\u53d1", "ReleaseStatusEnum_0", "tdc-cadm-business")),
    BE_RELEASE("1", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u5f85\u53d1\u5e03", "ReleaseStatusEnum_1", "tdc-cadm-business")),
    BE_EFFECTIVE("2", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u5f85\u53d1\u5e03\u751f\u6548", "ReleaseStatusEnum_2", "tdc-cadm-business")),
    COMPLETED("3", StatusTypeEnum.COMPLETED, new MultiLangEnumBridge("\u53d1\u5e03\u5b8c\u6210", "ReleaseStatusEnum_3", "tdc-cadm-business")),
    RE_PUBLICIZED("4", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u5f85\u91cd\u65b0\u53d1\u5e03", "ReleaseStatusEnum_4", "tdc-cadm-business")),
    TERMINATED("5", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u5df2\u7ec8\u6b62", "ReleaseStatusEnum_5", "tdc-cadm-business"));

    private final String num;
    private final StatusTypeEnum statusType;
    private final MultiLangEnumBridge bridge;
    private static final Map<String, ReleaseStatusEnum> RELEASE_STATUS_ENUM_MAP;

    public String getNum() {
        return this.num;
    }

    private ReleaseStatusEnum(String num, StatusTypeEnum statusType, MultiLangEnumBridge bridge) {
        this.num = num;
        this.statusType = statusType;
        this.bridge = bridge;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public StatusTypeEnum getStatusType() {
        return this.statusType;
    }

    public static ReleaseStatusEnum getEnumByVal(String val) {
        return RELEASE_STATUS_ENUM_MAP.get(val);
    }

    public static boolean canBeWithdraw(String num) {
        return ReleaseStatusEnum.BE_EFFECTIVE.num.equals(num);
    }

    public static boolean canBeRejected(String num) {
        return ReleaseStatusEnum.BE_RELEASE.num.equals(num) || ReleaseStatusEnum.RE_PUBLICIZED.num.equals(num) || ReleaseStatusEnum.BE_EFFECTIVE.num.equals(num);
    }

    public static boolean canBeRelease(String num) {
        return ReleaseStatusEnum.BE_RELEASE.num.equals(num) || ReleaseStatusEnum.RE_PUBLICIZED.num.equals(num);
    }

    static {
        RELEASE_STATUS_ENUM_MAP = Maps.newHashMapWithExpectedSize((int)ReleaseStatusEnum.values().length);
        for (ReleaseStatusEnum item : ReleaseStatusEnum.values()) {
            RELEASE_STATUS_ENUM_MAP.put(item.getNum(), item);
        }
    }
}

