/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.release.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.service.ActivityBillCommonDomainService;
import kd.tdc.cadm.bussiness.domain.nominate.service.IActivityBillCommonService;
import kd.tdc.cadm.bussiness.domain.release.ReleaseValidateHelper;
import kd.tdc.cadm.bussiness.domain.release.enums.ReleaseStatusEnum;
import kd.tdc.cadm.bussiness.util.PermissionUtil;
import kd.tdc.cadm.bussiness.util.UrlBuilder;

public class ReleaseBillDomainService
implements IActivityBillCommonService {
    private static final Log LOGGER = LogFactory.getLog(ReleaseBillDomainService.class);
    private static final HRBaseServiceHelper RELEASE_BILL_REPOSITORY = new HRBaseServiceHelper("cadm_appointrelease");
    private final ActivityBillCommonDomainService BILL_COMMON_DOMAIN_SERVICE = ServiceFactory.getService(ActivityBillCommonDomainService.class);

    @Override
    public DynamicObject initAfterSubmitNominateBill(DynamicObject nominateBill, long matchActivityId, List<Long> handlers, int sla) {
        QFilter nonDelFilter;
        QFilter actvIdFilter;
        if (HRObjectUtils.isEmpty((Object)nominateBill)) {
            LOGGER.info("nominatebill is null");
            return null;
        }
        long nominateId = nominateBill.getLong("id");
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        DynamicObject releaseBill = RELEASE_BILL_REPOSITORY.queryOne("releasestatus,nominatebill,matchactv,billno,createtime,org,creator,person,handler,sla", new QFilter[]{nominateIdFilter, actvIdFilter = new QFilter("matchactv", "=", (Object)matchActivityId), nonDelFilter = new QFilter("releasestatus", "!=", (Object)ReleaseStatusEnum.DEL.getNum())});
        if (Objects.isNull(releaseBill)) {
            releaseBill = RELEASE_BILL_REPOSITORY.generateEmptyDynamicObject();
        }
        releaseBill.set("billno", (Object)nominateBill.getString("billno"));
        releaseBill.set("nominatebill", nominateBill.getPkValue());
        releaseBill.set("releasestatus", (Object)ReleaseStatusEnum.NOT_TRIGGER.getNum());
        releaseBill.set("matchactv", (Object)matchActivityId);
        releaseBill.set("billno", (Object)nominateBill.getString("billno"));
        releaseBill.set("org", nominateBill.get("org"));
        releaseBill.set("creator", (Object)(RequestContext.get().getCurrUserId() == 0L ? 1L : RequestContext.get().getCurrUserId()));
        releaseBill.set("sla", (Object)sla);
        releaseBill.set("person", (Object)nominateBill.getLong("person.id"));
        this.BILL_COMMON_DOMAIN_SERVICE.setActivityBillHandler(releaseBill, handlers);
        RELEASE_BILL_REPOSITORY.saveOne(releaseBill);
        return releaseBill;
    }

    @Override
    public DynamicObject triggerBill(Long nominateId, Long activityId, Long instanceId, List<Long> approverIds) {
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter actvIdFilter = new QFilter("matchactv", "=", (Object)activityId);
        QFilter notDelFilter = new QFilter("releasestatus", "!=", (Object)ReleaseStatusEnum.DEL.getNum());
        DynamicObject release = RELEASE_BILL_REPOSITORY.queryOne("billno,billstatus,auditstatus,releasestatus,createtime,handler,instanceid,deadline,sla", new QFilter[]{nominateIdFilter, actvIdFilter, notDelFilter});
        if (Objects.isNull(release)) {
            LOGGER.error("trigger# non release to be trigger,  nominateId is {}, activityId is {}", (Object)nominateId, (Object)activityId);
            return release;
        }
        release.set("billstatus", (Object)"A");
        release.set("auditstatus", (Object)"A");
        release.set("releasestatus", (Object)ReleaseStatusEnum.BE_RELEASE.getNum());
        Date nowDate = new Date();
        release.set("createtime", (Object)new Date());
        int sla = release.getInt("sla");
        if (sla != 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(nowDate);
            cal.add(10, sla);
            release.set("deadline", (Object)cal.getTime());
        }
        this.BILL_COMMON_DOMAIN_SERVICE.setActivityBillHandler(release, approverIds);
        release.set("instanceid", (Object)instanceId);
        RELEASE_BILL_REPOSITORY.updateOne(release);
        return release;
    }

    @Override
    public DynamicObject updatedToNotTrigger(Long nominateId) {
        QFilter[] filters = new QFilter[]{new QFilter("nominatebill", "=", (Object)nominateId)};
        DynamicObject nextBill = RELEASE_BILL_REPOSITORY.queryOne("releasestatus, id", filters);
        if (!HRObjectUtils.isEmpty((Object)nextBill)) {
            nextBill.set("releasestatus", (Object)ReleaseStatusEnum.NOT_TRIGGER.getNum());
            RELEASE_BILL_REPOSITORY.saveOne(nextBill);
        }
        return nextBill;
    }

    @Override
    public Tuple<Boolean, String> judgeEnableUnSubmit(Long nominateId) {
        String status;
        QFilter[] filters = new QFilter[]{new QFilter("nominatebill", "=", (Object)nominateId)};
        DynamicObject nextBill = RELEASE_BILL_REPOSITORY.queryOriginalOne("id,releasestatus", filters);
        String string = status = HRObjectUtils.isEmpty((Object)nextBill) ? "" : nextBill.getString("releasestatus");
        if (!HRStringUtils.equals((String)status, (String)ReleaseStatusEnum.BE_RELEASE.getNum())) {
            return Tuple.create((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64a4\u9500\u53d1\u5e03\u72b6\u6001\u4e3a\u201c\u5f85\u53d1\u5e03\u201d\u7684\u6570\u636e\u3002", (String)"ReleaseBillDomainService_0", (String)"tdc-cadm-business", (Object[])new Object[0]));
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)"");
    }

    public DynamicObject[] queryOriginalReleaseBillById(String selectProperties, List<Long> pkIds) {
        QFilter idFilter = new QFilter("id", "in", pkIds);
        return RELEASE_BILL_REPOSITORY.queryOriginalArray(selectProperties, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryReleaseBillById(String selectProperties, List<Object> pkIds) {
        QFilter idFilter = new QFilter("id", "in", pkIds);
        return RELEASE_BILL_REPOSITORY.query(selectProperties, new QFilter[]{idFilter});
    }

    public List<DynamicObject> doReleaseForBatchBill(DynamicObject[] releaseBills, Map<String, Object> returnData) {
        ArrayList canToNexList = Lists.newArrayList();
        Arrays.stream(releaseBills).forEach(dynamicObject -> {
            dynamicObject.set("releasestatus", (Object)ReleaseStatusEnum.COMPLETED.getNum());
            Date releaseDate = (Date)returnData.get("releasetime");
            if (ReleaseValidateHelper.releaseDateBeforeEqualCurrDate(releaseDate)) {
                canToNexList.add(dynamicObject);
                dynamicObject.set("releasestatus", (Object)ReleaseStatusEnum.COMPLETED.getNum());
                Date newRelsDate = ReleaseValidateHelper.dateConvert(new Date());
                if (newRelsDate != null) {
                    dynamicObject.set("relsdealtime", (Object)newRelsDate);
                }
            }
            if (ReleaseValidateHelper.releaseDateAfterCurrDate(releaseDate)) {
                dynamicObject.set("releasestatus", (Object)ReleaseStatusEnum.BE_EFFECTIVE.getNum());
            }
            dynamicObject.set("relsbatchnum", returnData.get("relsbatchnum"));
            dynamicObject.set("relsfilenum", returnData.get("relsfilenum"));
            dynamicObject.set("releasetime", returnData.get("releasetime"));
            dynamicObject.set("modifytime", (Object)new Date());
            dynamicObject.set("signer", returnData.get("signer.id"));
            dynamicObject.set("signdate", returnData.get("signdate"));
            dynamicObject.set("relsprinttpl", returnData.get("relsprinttpl.id"));
            dynamicObject.set("billstatus", (Object)"B");
            dynamicObject.set("subhandler", (Object)UserServiceHelper.getCurrentUser((String)"number"));
        });
        RELEASE_BILL_REPOSITORY.update(releaseBills);
        return canToNexList;
    }

    public boolean doReleaseForSingleBill(DynamicObject releaseBill) {
        Date newRelsDate;
        boolean ifToNext = Boolean.TRUE;
        Date releaseDate = releaseBill.getDate("releasetime");
        if (ReleaseValidateHelper.releaseDateBeforeEqualCurrDate(releaseDate)) {
            releaseBill.set("releasestatus", (Object)ReleaseStatusEnum.COMPLETED.getNum());
        }
        if (ReleaseValidateHelper.releaseDateAfterCurrDate(releaseDate)) {
            releaseBill.set("releasestatus", (Object)ReleaseStatusEnum.BE_EFFECTIVE.getNum());
            ifToNext = Boolean.FALSE;
        }
        if ((newRelsDate = ReleaseValidateHelper.dateConvert(new Date())) != null) {
            releaseBill.set("relsdealtime", (Object)newRelsDate);
        }
        releaseBill.set("subhandler", (Object)UserServiceHelper.getCurrentUser((String)"number"));
        CodeRuleServiceHelper.getNumber((String)"cadm_appointrelease", (DynamicObject)releaseBill, (String)String.valueOf(RequestContext.get().getOrgId()));
        CodeRuleServiceHelper.getNumber((String)"cadm_releasebasebill", (DynamicObject)releaseBill, (String)String.valueOf(RequestContext.get().getOrgId()));
        releaseBill.set("billstatus", (Object)"B");
        return ifToNext;
    }

    public DynamicObject[] queryByPubBatchNum(String selectProperties, String pubBatchNum) {
        QFilter numFilter = new QFilter("relsbatchnum", "=", (Object)pubBatchNum);
        return RELEASE_BILL_REPOSITORY.query(selectProperties, new QFilter[]{numFilter});
    }

    @Override
    public Tuple<DynamicObject, Boolean> updateAfterUnSubmitNominate(Long nominateId, Long activityId) {
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter matchActvIdFilter = new QFilter("matchactv", "=", (Object)activityId);
        QFilter notDeleteFilter = new QFilter("releasestatus", "!=", (Object)ReleaseStatusEnum.DEL.getNum());
        DynamicObject release = RELEASE_BILL_REPOSITORY.queryOne("billno,releasestatus,instanceid,handler", new QFilter[]{nominateIdFilter, matchActvIdFilter, notDeleteFilter});
        Boolean needSendMsg = Boolean.FALSE;
        if (release != null && !ReleaseStatusEnum.NOT_TRIGGER.getNum().equals(release.getString("releasestatus"))) {
            needSendMsg = Boolean.TRUE;
            release.set("releasestatus", (Object)ReleaseStatusEnum.DEL.getNum());
            RELEASE_BILL_REPOSITORY.updateDataOne(release);
        }
        return Tuple.create((Object)release, (Object)needSendMsg);
    }

    @Override
    public List<DynamicObject> fireTerminateActivity(List<Long> appointBillIds) {
        ArrayList<DynamicObject> terminateSuccessActivityBills = new ArrayList<DynamicObject>(10);
        QFilter nominateIdQFilters = new QFilter("nominatebill", "in", appointBillIds);
        Object[] releaseBills = RELEASE_BILL_REPOSITORY.query("id,billstatus,auditstatus,releasestatus,modifier,nominatebill,modifytime,handler,instanceid", new QFilter[]{nominateIdQFilters});
        ArrayList canTerminatedStatusList = Lists.newArrayList((Object[])new String[]{ReleaseStatusEnum.BE_RELEASE.getNum(), ReleaseStatusEnum.BE_EFFECTIVE.getNum(), ReleaseStatusEnum.RE_PUBLICIZED.getNum()});
        if (!HRArrayUtils.isEmpty((Object[])releaseBills)) {
            Date date = new Date();
            long currUserId = RequestContext.get().getCurrUserId();
            Arrays.stream(releaseBills).forEach(releaseBill -> {
                String releaseStatus = releaseBill.getString("releasestatus");
                if (!canTerminatedStatusList.contains(releaseStatus)) {
                    return;
                }
                releaseBill.set("billstatus", (Object)"F");
                releaseBill.set("auditstatus", (Object)"F");
                List<Long> handlerIds = this.BILL_COMMON_DOMAIN_SERVICE.getActivityHandlerIds((DynamicObject)releaseBill, "handler");
                releaseBill.set("releasestatus", (Object)ReleaseStatusEnum.TERMINATED.getNum());
                releaseBill.set("modifytime", (Object)date);
                releaseBill.set("modifier", (Object)currUserId);
                Long releaseBillId = releaseBill.getLong("id");
                if (CollectionUtils.isEmpty(handlerIds)) {
                    return;
                }
                String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_appointrelease").setParameter("formPkId", String.valueOf(releaseBillId)).builder();
                BosMessageService.sendTemplateMessage(contentUrl, handlerIds, releaseBill.getLong("nominatebill.id"), "cadm_appointrelease", "cadm_stop", releaseBillId);
                terminateSuccessActivityBills.add((DynamicObject)releaseBill);
            });
            RELEASE_BILL_REPOSITORY.update((DynamicObject[])releaseBills);
        }
        return terminateSuccessActivityBills;
    }

    @Override
    public DynamicObject queryActHandlerByNominateId(Long nominateId) {
        QFilter nominateQFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter notDelFilter = new QFilter("releasestatus", "!=", (Object)ReleaseStatusEnum.DEL.getNum());
        return RELEASE_BILL_REPOSITORY.queryOne("handler", new QFilter[]{nominateQFilter, notDelFilter});
    }

    public void initIssueFile(DynamicObject[] issueBills) {
        Map<Long, DynamicObject> issueBillMap = Arrays.stream(issueBills).collect(Collectors.toMap(issueBill -> issueBill.getLong("nominatebill.id"), issueBill -> issueBill, (v1, v2) -> v1));
        Set<Long> nominateIds = issueBillMap.keySet();
        DynamicObject[] releaseBills = RELEASE_BILL_REPOSITORY.query("id,signer,signdate,relsprinttpl,nominatebill,modifier,modifytime", new QFilter[]{new QFilter("nominatebill", "in", nominateIds), new QFilter("releasestatus", "=", (Object)ReleaseStatusEnum.NOT_TRIGGER.getNum())});
        Date currDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        Arrays.stream(releaseBills).forEach(releaseBill -> {
            DynamicObject issueBill = (DynamicObject)issueBillMap.get(releaseBill.getLong("nominatebill.id"));
            releaseBill.set("signer", issueBill.get("issuehandler"));
            releaseBill.set("signdate", issueBill.get("issuetime"));
            releaseBill.set("relsprinttpl", issueBill.get("appnoticedoc"));
            releaseBill.set("modifier", (Object)currUserId);
            releaseBill.set("modifytime", (Object)currDate);
        });
        RELEASE_BILL_REPOSITORY.updateDatas(releaseBills);
    }

    public void update(DynamicObject[] releaseBills) {
        RELEASE_BILL_REPOSITORY.updateDatas(releaseBills);
    }

    public DynamicObject getEffectiveReleaseBillByNominateId(Long nominateId) {
        QFilter nominateQFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter statusFilter = new QFilter("releasestatus", "=", (Object)ReleaseStatusEnum.COMPLETED.getNum());
        String selectProperties = "id,relsprinttpl,releasetime,relsbatchnum,relsfilenum";
        return RELEASE_BILL_REPOSITORY.queryOne(selectProperties, new QFilter[]{nominateQFilter, statusFilter});
    }

    public DynamicObject[] queryByPermission(String selectProperties, long userId, List<String> statusList, String permItemId) {
        List<QFilter> qFilters = PermissionUtil.getPermissionQFilter("cadm_appointrelease", userId, permItemId);
        if (!CollectionUtils.isEmpty(statusList)) {
            QFilter qFilter = new QFilter("releasestatus", "in", statusList);
            qFilters.add(qFilter);
        }
        QFilter userFilter = new QFilter("handler.fbasedataid_id", "in", (Object)userId);
        qFilters.add(userFilter);
        QFilter appointStatusQFilter = new QFilter("nominatebill.appointstatus", "!=", (Object)AppointStatusEnum.WAIT_APPOINT.getVal());
        qFilters.add(appointStatusQFilter);
        return RELEASE_BILL_REPOSITORY.queryOriginalArray(selectProperties, qFilters.toArray(new QFilter[0]));
    }
}

