/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.review.enmus;

import java.util.Arrays;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.util.MultiLangEnumBridge;
import kd.tdc.cadm.common.enums.StatusTypeEnum;

public enum ReviewStatusEnum {
    DEL("-1", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u5df2\u5220\u9664", "ReviewStatusEnum_6", "tdc-cadm-business")),
    NOT_TRIGGER("0", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u672a\u89e6\u53d1", "ReviewStatusEnum_0", "tdc-cadm-business")),
    BE_REVIEW("1", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u5f85\u8bc4\u8bae", "ReviewStatusEnum_1", "tdc-cadm-business")),
    IN_REVIEW("2", StatusTypeEnum.UNDERWAY, new MultiLangEnumBridge("\u8bc4\u8bae\u4e2d", "ReviewStatusEnum_2", "tdc-cadm-business")),
    RESULT_SUBMITTED("4", StatusTypeEnum.COMPLETED, new MultiLangEnumBridge("\u8bc4\u8bae\u5b8c\u6210", "ReviewStatusEnum_4", "tdc-cadm-business")),
    TERMINATED("5", StatusTypeEnum.INVALID, new MultiLangEnumBridge("\u5df2\u7ec8\u6b62", "ReviewStatusEnum_7", "tdc-cadm-business"));

    private final String reviewStatus;
    private final StatusTypeEnum statusType;
    private final MultiLangEnumBridge bridge;

    private ReviewStatusEnum(String reviewStatus, StatusTypeEnum statusType, MultiLangEnumBridge bridge) {
        this.reviewStatus = reviewStatus;
        this.statusType = statusType;
        this.bridge = bridge;
    }

    public String getReviewStatus() {
        return this.reviewStatus;
    }

    public String getDesc() {
        return this.bridge.loadKDString();
    }

    public StatusTypeEnum getStatusType() {
        return this.statusType;
    }

    public static ReviewStatusEnum getEnumByReviewStatus(String reviewStatus) {
        return Arrays.stream(ReviewStatusEnum.values()).filter(element -> HRStringUtils.equals((String)element.getReviewStatus(), (String)reviewStatus)).findFirst().orElse(null);
    }

    public static boolean canBeRejected(String number) {
        return ReviewStatusEnum.BE_REVIEW.reviewStatus.equals(number);
    }

    public static boolean canReview(String number) {
        return ReviewStatusEnum.BE_REVIEW.reviewStatus.equals(number) || ReviewStatusEnum.IN_REVIEW.reviewStatus.equals(number);
    }

    private static class Constants {
        public static final String TDC_CADM_BUSINESS = "tdc-cadm-business";

        private Constants() {
        }
    }
}

