/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.review.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.service.ActivityBillCommonDomainService;
import kd.tdc.cadm.bussiness.domain.nominate.service.IActivityBillCommonService;
import kd.tdc.cadm.bussiness.domain.review.enmus.CoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.review.enmus.ReviewStatusEnum;
import kd.tdc.cadm.bussiness.domain.review.entityservice.ReviewHelpBillEntityService;
import kd.tdc.cadm.bussiness.util.PermissionUtil;
import kd.tdc.cadm.bussiness.util.UrlBuilder;

public class ReviewBillDomainService
implements IActivityBillCommonService {
    private static final Log LOG = LogFactory.getLog(ReviewBillDomainService.class);
    private static final HRBaseServiceHelper REVIEW_BILL_REPOSITORY = new HRBaseServiceHelper("cadm_reviewbill");
    private static final ActivityBillCommonDomainService BILL_COMMON_DOMAIN_SERVICE = ServiceFactory.getService(ActivityBillCommonDomainService.class);
    private static final ReviewHelpBillEntityService REVIEW_HELP_BILL_ENTITY_SERVICE = ServiceFactory.getService(ReviewHelpBillEntityService.class);

    @Override
    public DynamicObject initAfterSubmitNominateBill(DynamicObject nominateBill, long matchActivityId, List<Long> handlers, int sla) {
        QFilter nonDelFilter;
        QFilter matchActFilter;
        long nominateId = nominateBill.getLong("id");
        QFilter nominateFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        DynamicObject reviewBill = REVIEW_BILL_REPOSITORY.queryOne("id,handler,reviewstatus,nominatebill,matchactv,billno,person,org,creator,sla", new QFilter[]{nominateFilter, matchActFilter = new QFilter("matchactv", "=", (Object)matchActivityId), nonDelFilter = new QFilter("reviewstatus", "not in", (Object)ReviewStatusEnum.DEL.getReviewStatus())});
        if (HRObjectUtils.isEmpty((Object)reviewBill)) {
            reviewBill = REVIEW_BILL_REPOSITORY.generateEmptyDynamicObject();
        }
        reviewBill.set("reviewstatus", (Object)ReviewStatusEnum.NOT_TRIGGER.getReviewStatus());
        reviewBill.set("nominatebill", (Object)nominateId);
        reviewBill.set("matchactv", (Object)matchActivityId);
        reviewBill.set("billno", nominateBill.get("billno"));
        reviewBill.set("person", nominateBill.get("person"));
        reviewBill.set("org", nominateBill.get("org"));
        reviewBill.set("creator", (Object)(RequestContext.get().getCurrUserId() == 0L ? 1L : RequestContext.get().getCurrUserId()));
        reviewBill.set("sla", (Object)sla);
        BILL_COMMON_DOMAIN_SERVICE.setActivityBillHandler(reviewBill, handlers);
        REVIEW_BILL_REPOSITORY.saveOne(reviewBill);
        return reviewBill;
    }

    @Override
    public DynamicObject triggerBill(Long nominateId, Long activityId, Long instanceId, List<Long> approverIds) {
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter actIdFilter = new QFilter("matchactv", "=", (Object)activityId);
        QFilter notDelFilter = new QFilter("reviewstatus", "!=", (Object)ReviewStatusEnum.DEL.getReviewStatus());
        DynamicObject reviewBill = REVIEW_BILL_REPOSITORY.queryOne("id,billno,billstatus,auditstatus,reviewstatus,createtime,handler,instanceid,deadline,sla", new QFilter[]{nominateIdFilter, actIdFilter, notDelFilter});
        if (HRObjectUtils.isEmpty((Object)reviewBill)) {
            LOG.error("trigger# non reviewBill to be trigger,  nominateId is {}, activityId is {}", (Object)nominateId, (Object)activityId);
            return reviewBill;
        }
        reviewBill.set("billstatus", (Object)"A");
        reviewBill.set("auditstatus", (Object)"A");
        reviewBill.set("reviewstatus", (Object)ReviewStatusEnum.BE_REVIEW.getReviewStatus());
        Date nowDate = new Date();
        reviewBill.set("createtime", (Object)nowDate);
        int sla = reviewBill.getInt("sla");
        if (sla != 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(nowDate);
            cal.add(10, sla);
            reviewBill.set("deadline", (Object)cal.getTime());
        }
        BILL_COMMON_DOMAIN_SERVICE.setActivityBillHandler(reviewBill, approverIds);
        reviewBill.set("instanceid", (Object)instanceId);
        REVIEW_BILL_REPOSITORY.updateDataOne(reviewBill);
        return reviewBill;
    }

    @Override
    public DynamicObject updatedToNotTrigger(Long nominateId) {
        QFilter[] filters = new QFilter[]{new QFilter("nominatebill", "=", (Object)nominateId)};
        DynamicObject nextBill = REVIEW_BILL_REPOSITORY.queryOne("reviewstatus, id", filters);
        if (!HRObjectUtils.isEmpty((Object)nextBill)) {
            nextBill.set("reviewstatus", (Object)ReviewStatusEnum.NOT_TRIGGER.getReviewStatus());
            REVIEW_BILL_REPOSITORY.saveOne(nextBill);
        }
        return nextBill;
    }

    @Override
    public Tuple<Boolean, String> judgeEnableUnSubmit(Long nominateId) {
        String status;
        QFilter[] filters = new QFilter[]{new QFilter("nominatebill", "=", (Object)nominateId)};
        DynamicObject nextBill = REVIEW_BILL_REPOSITORY.queryOriginalOne("id,reviewstatus", filters);
        String string = status = HRObjectUtils.isEmpty((Object)nextBill) ? "" : nextBill.getString("reviewstatus");
        if (!HRStringUtils.equals((String)status, (String)ReviewStatusEnum.BE_REVIEW.getReviewStatus())) {
            return Tuple.create((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64a4\u9500\u8bc4\u8bae\u72b6\u6001\u4e3a\u201c\u5f85\u8bc4\u8bae\u201d\u7684\u6570\u636e\u3002", (String)"ReviewBillDomainService_0", (String)"tdc-cadm-business", (Object[])new Object[0]));
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)"");
    }

    public void updateReviewStatusAndRate(Long reviewId) {
        DynamicObject review = REVIEW_BILL_REPOSITORY.queryOne("reviewstatus,coopcomprate,reviewpassrate,cooperateentry.coopstatus,cooperateentry.revresult,coopershowentry.coopstatusshow", (Object)reviewId);
        if (HRObjectUtils.isEmpty((Object)review)) {
            return;
        }
        DynamicObjectCollection cooperateentry = review.getDynamicObjectCollection("cooperateentry");
        int submitCooperate = 0;
        int totalNum = 0;
        for (DynamicObject entry : cooperateentry) {
            if (HRStringUtils.equals((String)entry.getString("coopstatus"), (String)CoopStatusEnum.DISCARD.getVal())) continue;
            ++totalNum;
            if (!HRStringUtils.equals((String)entry.getString("coopstatus"), (String)CoopStatusEnum.PROCESSED.getVal())) continue;
            ++submitCooperate;
        }
        int coopcomprateInt = totalNum == 0 ? 0 : (int)((float)submitCooperate / (float)totalNum * 100.0f);
        String coopcomprate = coopcomprateInt + "%";
        review.set("coopcomprate", (Object)coopcomprate);
        boolean judgeReviewStatus = HRStringUtils.equals((String)review.getString("reviewstatus"), (String)ReviewStatusEnum.BE_REVIEW.getReviewStatus());
        if (judgeReviewStatus) {
            review.set("reviewstatus", (Object)ReviewStatusEnum.IN_REVIEW.getReviewStatus());
        }
        REVIEW_BILL_REPOSITORY.updateDataOne(review);
    }

    public void isExistsByReviewId(Long reviewBillId) {
        REVIEW_HELP_BILL_ENTITY_SERVICE.isExistsByReviewId(reviewBillId);
    }

    public DynamicObject[] queryOriginalReviewBillById(String selectProperties, List<Long> pkIds) {
        QFilter idFilter = new QFilter("id", "in", pkIds);
        return REVIEW_BILL_REPOSITORY.queryOriginalArray(selectProperties, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryReviewBillById(String selectProperties, List<Long> pkIds) {
        QFilter idFilter = new QFilter("id", "in", pkIds);
        return REVIEW_BILL_REPOSITORY.query(selectProperties, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryReviewBillByIdAndStatus(List<ReviewStatusEnum> reviewStatusEnumList, List<Long> pkIds) {
        QFilter idFilter = new QFilter("id", "in", pkIds);
        QFilter statusFilter = new QFilter("reviewstatus", "in", reviewStatusEnumList.stream().map(ReviewStatusEnum::getReviewStatus).collect(Collectors.toList()));
        return REVIEW_BILL_REPOSITORY.query("id", new QFilter[]{idFilter, statusFilter});
    }

    public DynamicObject[] queryOriginalReviewHelpBillById(String selectProperties, List<Long> pkIds) {
        return REVIEW_HELP_BILL_ENTITY_SERVICE.queryOriginalReviewHelpBillById(selectProperties, pkIds);
    }

    public DynamicObject queryOne(String selectProperties, Object pkId) {
        return REVIEW_BILL_REPOSITORY.queryOne(selectProperties, pkId);
    }

    public DynamicObject queryOneByNominateId(String selectProperties, long nominateId) {
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter notDelFilter = new QFilter("reviewstatus", "!=", (Object)ReviewStatusEnum.DEL.getReviewStatus());
        return REVIEW_BILL_REPOSITORY.queryOne(selectProperties, new QFilter[]{nominateIdFilter, notDelFilter});
    }

    public void updateReviewStatus(Long reviewBillId) {
        REVIEW_HELP_BILL_ENTITY_SERVICE.updateReviewStatus(reviewBillId);
    }

    public void updateSendMsgTime(Long entryId) {
        REVIEW_HELP_BILL_ENTITY_SERVICE.updateSendMsgTime(entryId);
    }

    @Override
    public Tuple<DynamicObject, Boolean> updateAfterUnSubmitNominate(Long nominateId, Long activityId) {
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter actIdFilter = new QFilter("matchactv", "=", (Object)activityId);
        QFilter notDeleteFilter = new QFilter("reviewstatus", "!=", (Object)ReviewStatusEnum.DEL.getReviewStatus());
        DynamicObject reviewBill = REVIEW_BILL_REPOSITORY.queryOne("id,billno,reviewstatus,instanceid,handler", new QFilter[]{nominateIdFilter, actIdFilter, notDeleteFilter});
        Boolean needSendMsg = Boolean.FALSE;
        if (reviewBill != null && !ReviewStatusEnum.NOT_TRIGGER.getReviewStatus().equals(reviewBill.getString("reviewstatus"))) {
            needSendMsg = Boolean.TRUE;
            reviewBill.set("reviewstatus", (Object)ReviewStatusEnum.DEL.getReviewStatus());
            REVIEW_BILL_REPOSITORY.updateDataOne(reviewBill);
        }
        return Tuple.create((Object)reviewBill, (Object)needSendMsg);
    }

    @Override
    public List<DynamicObject> fireTerminateActivity(List<Long> appointBillIds) {
        ArrayList<DynamicObject> terminateSuccessActivityBills = new ArrayList<DynamicObject>(10);
        QFilter nominateIdQFilters = new QFilter("nominatebill", "in", appointBillIds);
        Object[] reviewBills = REVIEW_BILL_REPOSITORY.query("id,billstatus,auditstatus,reviewstatus,modifier,modifytime,nominatebill,handler,instanceid", new QFilter[]{nominateIdQFilters});
        ArrayList canTerminatedStatusList = Lists.newArrayList((Object[])new String[]{ReviewStatusEnum.BE_REVIEW.getReviewStatus(), ReviewStatusEnum.IN_REVIEW.getReviewStatus()});
        if (!HRArrayUtils.isEmpty((Object[])reviewBills)) {
            Date date = new Date();
            long currUserId = RequestContext.get().getCurrUserId();
            Arrays.stream(reviewBills).forEach(reviewBill -> {
                String reviewStatus = reviewBill.getString("reviewstatus");
                if (!canTerminatedStatusList.contains(reviewStatus)) {
                    return;
                }
                reviewBill.set("billstatus", (Object)"F");
                reviewBill.set("auditstatus", (Object)"F");
                reviewBill.set("reviewstatus", (Object)ReviewStatusEnum.TERMINATED.getReviewStatus());
                reviewBill.set("modifytime", (Object)date);
                reviewBill.set("modifier", (Object)currUserId);
                Long reviewBillId = reviewBill.getLong("id");
                List<Long> handlerIds = BILL_COMMON_DOMAIN_SERVICE.getActivityHandlerIds((DynamicObject)reviewBill, "handler");
                long nominateId = reviewBill.getLong("nominatebill.id");
                if (CollectionUtils.isEmpty(handlerIds)) {
                    return;
                }
                String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_reviewbill").setParameter("formPkId", String.valueOf(reviewBillId)).builder();
                BosMessageService.sendTemplateMessage(contentUrl, handlerIds, nominateId, "cadm_reviewbill", "cadm_stop", reviewBillId);
                terminateSuccessActivityBills.add((DynamicObject)reviewBill);
            });
            List<Long> reviewIds = Arrays.stream(reviewBills).map(value -> value.getLong("id")).collect(Collectors.toList());
            this.terminateUnHandledReviewCoop(reviewIds, CoopStatusEnum.TERMINATE, "cadm_pyzz");
            REVIEW_BILL_REPOSITORY.update((DynamicObject[])reviewBills);
        }
        return terminateSuccessActivityBills;
    }

    @Override
    public DynamicObject queryActHandlerByNominateId(Long nominateId) {
        return this.queryOneByNominateId("handler", nominateId);
    }

    public void terminateUnHandledReviewCoop(List<Long> reviewIds, CoopStatusEnum coopStatusEnum, String msgTempNumber) {
        QFilter examineIdFilter = new QFilter("review", "in", reviewIds);
        QFilter coopStatusFilter = coopStatusEnum == CoopStatusEnum.TERMINATE ? new QFilter("coopstatus", "=", (Object)CoopStatusEnum.WAIT.getVal()) : new QFilter("coopstatus", "!=", (Object)CoopStatusEnum.DISCARD.getVal());
        Object[] reviewBills = REVIEW_HELP_BILL_ENTITY_SERVICE.query("id,nominatebill,cooperater,coopstatus,modifier,modifytime", new QFilter[]{examineIdFilter, coopStatusFilter});
        if (!HRArrayUtils.isEmpty((Object[])reviewBills)) {
            Date currDate = new Date();
            long currUserId = RequestContext.get().getCurrUserId();
            DynamicObjectCollection reviewColl = new DynamicObjectCollection();
            for (Object reviewBill : reviewBills) {
                boolean isDiscard;
                boolean bl = isDiscard = coopStatusEnum == CoopStatusEnum.DISCARD;
                if (!isDiscard && !CoopStatusEnum.WAIT.getVal().equals(reviewBill.getString("coopstatus"))) continue;
                ArrayList userIds = Lists.newArrayList((Object[])new Long[]{reviewBill.getLong("cooperater.id")});
                Long nominateId = reviewBill.getLong("nominatebill.id");
                Long expedCoopId = reviewBill.getLong("id");
                String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_reviewhelpbill").setParameter("formPkId", String.valueOf(expedCoopId)).builder();
                BosMessageService.sendTemplateMessage(contentUrl, userIds, nominateId, "cadm_reviewhelpbill", msgTempNumber, expedCoopId);
                reviewBill.set("coopstatus", (Object)coopStatusEnum.getVal());
                reviewBill.set("modifier", (Object)currUserId);
                reviewBill.set("modifytime", (Object)currDate);
                reviewColl.add(reviewBill);
            }
            if (!reviewColl.isEmpty()) {
                REVIEW_HELP_BILL_ENTITY_SERVICE.update((DynamicObject[])reviewColl.toArray((Object[])new DynamicObject[0]));
            }
        }
    }

    public void update(DynamicObject[] reviewBills) {
        REVIEW_BILL_REPOSITORY.update(reviewBills);
    }

    public DynamicObject getCompleteOneByNominateId(String selectProperties, long nominateId) {
        QFilter nominateIdFilter = new QFilter("nominatebill", "=", (Object)nominateId);
        QFilter completeFilter = new QFilter("reviewstatus", "=", (Object)ReviewStatusEnum.RESULT_SUBMITTED.getReviewStatus());
        return REVIEW_BILL_REPOSITORY.queryOne(selectProperties, new QFilter[]{nominateIdFilter, completeFilter});
    }

    public DynamicObject[] queryByPermission(String selectProperties, long userId, List<String> statusList, String permItemId) {
        List<QFilter> qFilters = PermissionUtil.getPermissionQFilter("cadm_reviewbill", userId, permItemId);
        if (!CollectionUtils.isEmpty(statusList)) {
            QFilter qFilter = new QFilter("reviewstatus", "in", statusList);
            qFilters.add(qFilter);
        }
        QFilter userFilter = new QFilter("handler.fbasedataid_id", "in", (Object)userId);
        qFilters.add(userFilter);
        QFilter appointStatusQFilter = new QFilter("nominatebill.appointstatus", "!=", (Object)AppointStatusEnum.WAIT_APPOINT.getVal());
        qFilters.add(appointStatusQFilter);
        return REVIEW_BILL_REPOSITORY.queryOriginalArray(selectProperties, qFilters.toArray(new QFilter[0]));
    }
}

