/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.domain.tenure.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tdc.cadm.bussiness.domain.tenure.enums.PositiveStatusEnum;
import kd.tdc.cadm.bussiness.domain.tenure.enums.TenureStatusEnum;
import kd.tdc.cadm.bussiness.util.PermissionUtil;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;

public class TenureDomainService {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("cadm_tenure");

    public DynamicObject query(long tenureId) {
        return SERVICE_HELPER.queryOne((Object)tenureId);
    }

    public DynamicObject[] query(String selectProperties, QFilter[] filters) {
        return SERVICE_HELPER.query(selectProperties, filters);
    }

    public DynamicObject[] queryTenureDataByIds(String selectProperties, List<Long> pkIds) {
        return SERVICE_HELPER.query(selectProperties, new QFilter[]{new QFilter("id", "in", pkIds)});
    }

    public void saveOne(DynamicObject dynamicObject) {
        SERVICE_HELPER.saveOne(dynamicObject);
    }

    public void save(DynamicObject[] data) {
        SERVICE_HELPER.save(data);
    }

    public DynamicObject[] queryBeEffectiveData() {
        QFilter tenureStatusQFilter = new QFilter("tenurestatus", "=", (Object)TenureStatusEnum.PROBATION.getNumber());
        QFilter posStatusQFilter = new QFilter("positivestatus", "=", (Object)PositiveStatusEnum.INEFFECTIVE.getNumber());
        return SERVICE_HELPER.query("id,tenurestatus,positivestatus,realpositivedate,modifier,modifytime", new QFilter[]{tenureStatusQFilter, posStatusQFilter});
    }

    public void updateData(DynamicObject[] beUpdateData) {
        SERVICE_HELPER.updateDatas(beUpdateData);
    }

    public DynamicObject[] queryNonLeaveDataByEmployee(String selectProperties, long employeeId) {
        return this.queryNonLeaveDataByEmployeeAndPosition(selectProperties, employeeId, 0L);
    }

    public DynamicObject[] queryNonLeaveDataByEmployeeAndPosition(String selectProperties, long employeeId, long positionId) {
        QFilter employeeFilter = new QFilter("employee", "=", (Object)employeeId);
        QFilter statusFilter = new QFilter("tenurestatus", "!=", (Object)TenureStatusEnum.LEAVE.getNumber());
        QFilter[] filters = new QFilter[]{employeeFilter, statusFilter};
        if (positionId != 0L) {
            QFilter positionFilter = new QFilter("position", "=", (Object)positionId);
            filters = new QFilter[]{employeeFilter, statusFilter, positionFilter};
        }
        return SERVICE_HELPER.query(selectProperties, filters);
    }

    public DynamicObject[] queryNonLeaveDataByEmployeeAndJobId(String selectProperties, long employeeId, long jobId) {
        QFilter employeeFilter = new QFilter("employee", "=", (Object)employeeId);
        QFilter statusFilter = new QFilter("tenurestatus", "!=", (Object)TenureStatusEnum.LEAVE.getNumber());
        QFilter[] filters = new QFilter[]{employeeFilter, statusFilter};
        if (jobId != 0L) {
            QFilter positionFilter = new QFilter("job", "=", (Object)jobId);
            filters = new QFilter[]{employeeFilter, statusFilter, positionFilter};
        }
        return SERVICE_HELPER.query(selectProperties, filters);
    }

    public DynamicObject[] queryNonLeaveDataByEmployeeAndStandardPositionId(String selectProperties, long employeeId, long standardPositionId) {
        QFilter employeeFilter = new QFilter("employee", "=", (Object)employeeId);
        QFilter statusFilter = new QFilter("tenurestatus", "!=", (Object)TenureStatusEnum.LEAVE.getNumber());
        QFilter[] filters = new QFilter[]{employeeFilter, statusFilter};
        if (standardPositionId != 0L) {
            QFilter positionFilter = new QFilter("standardpost", "=", (Object)standardPositionId);
            filters = new QFilter[]{employeeFilter, statusFilter, positionFilter};
        }
        return SERVICE_HELPER.query(selectProperties, filters);
    }

    public DynamicObject[] queryTenureData(QFilter[] filters, String orderBy) {
        return SERVICE_HELPER.query(filters, orderBy);
    }

    public DynamicObject[] queryEmployeeTenureData(String selectProperties, QFilter[] filters, String orderBy) {
        return SERVICE_HELPER.query(selectProperties, filters, orderBy);
    }

    public DynamicObject[] queryAllOriginalTenure() {
        return SERVICE_HELPER.queryOriginalArray("employee.id,person.id,cadrecat.id,tenurestatus,createtime", null, "createtime desc");
    }

    public DynamicObject[] queryByPermission(String selectProperties, long userId, List<String> statusList, String permItemId) {
        List<QFilter> qFilters = PermissionUtil.getPermissionQFilter("cadm_tenure", userId, permItemId);
        if (!CollectionUtils.isEmpty(statusList)) {
            QFilter qFilter = new QFilter("tenurestatus", "in", statusList);
            qFilters.add(qFilter);
        }
        return SERVICE_HELPER.queryOriginalArray(selectProperties, qFilters.toArray(new QFilter[0]));
    }

    public DynamicObject[] queryByPermissionAndQFilters(String selectProperties, long userId, List<QFilter> qFilterList, String permItemId) {
        List<QFilter> qFilters = PermissionUtil.getPermissionQFilter("cadm_tenure", userId, permItemId);
        if (!CollectionUtils.isEmpty(qFilterList)) {
            qFilters.addAll(qFilterList);
        }
        return SERVICE_HELPER.queryOriginalArray(selectProperties, qFilters.toArray(new QFilter[0]));
    }

    public DynamicObject[] queryOriginalTenuresByDepEmpIds(String selectProperties, List<Object> depEmpIds) {
        QFilter qFilter = new QFilter("depemp", "in", depEmpIds);
        return SERVICE_HELPER.queryOriginalArray(selectProperties, new QFilter[]{qFilter});
    }

    public DynamicObject generateEmptyDynamicObject() {
        return SERVICE_HELPER.generateEmptyDynamicObject();
    }

    public List<Map<String, Object>> getTenureRecord(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            throw new RuntimeException("params is empty.");
        }
        if (params.get("employeeId") == null) {
            throw new RuntimeException("employeeId is empty.");
        }
        long employeeId = Long.parseLong(params.get("employeeId").toString());
        ArrayList<Map<String, Object>> result = new ArrayList(10);
        QFilter employeeIdFilter = new QFilter("employee", "=", (Object)employeeId);
        String selectProperties = "id,company.id,company.name,adminorg.id,adminorg.name,apositiontype,position.id,position.name,standardpost.id,standardpost.name,job.id,job.name,isprimappoint,realstartdate,realenddate,tenurestatus,depemp.id";
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(employeeIdFilter);
        Object startDateObj = params.get("startDate");
        Object endDateObj = params.get("endDate");
        if (startDateObj != null) {
            if (!(startDateObj instanceof Date)) {
                throw new RuntimeException("startDate format is incorrect. Please enter the correct date.");
            }
            Date startDate = (Date)startDateObj;
            QFilter startDateFilter = new QFilter("realstartdate", ">=", (Object)startDate);
            qFilters.add(startDateFilter);
        }
        if (endDateObj != null) {
            if (!(endDateObj instanceof Date)) {
                throw new RuntimeException("endDate format is incorrect. Please enter the correct date.");
            }
            Date endDate = (Date)endDateObj;
            QFilter endDateFilter = new QFilter("realstartdate", "<=", (Object)endDate);
            qFilters.add(endDateFilter);
        }
        DynamicObject[] tenureBills = SERVICE_HELPER.queryOriginalArray(selectProperties, qFilters.toArray(new QFilter[0]));
        List depempIds = Arrays.stream(tenureBills).map(p -> p.getLong("depemp.id")).distinct().collect(Collectors.toList());
        List empOrgrelsList = ExternalService.listDataEmpOrgrels(depempIds);
        List posTypeIds = empOrgrelsList.stream().filter(p -> p.get("postype") != null).map(p -> Long.parseLong(String.valueOf(p.get("postype")))).distinct().collect(Collectors.toList());
        DynamicObject[] posType = ExternalService.queryPosTypeByIds((String)"id,name", posTypeIds);
        Map<Long, String> posTypeMap = Arrays.stream(posType).collect(Collectors.toMap(p -> p.getLong("id"), p -> p.getString("name"), (v1, v2) -> v1));
        List<String> propertyList = Arrays.stream(selectProperties.split(",")).collect(Collectors.toList());
        for (DynamicObject tenureBill : tenureBills) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            propertyList.forEach(property -> {
                String key = property.indexOf(".") != -1 ? property.replace(".", "_") : property;
                map.put(key, tenureBill.get(property));
            });
            map.put("apostype_id", 0L);
            map.put("apostype_name", "");
            long depempId = tenureBill.getLong("depemp.id");
            Optional<Map> depempOptional = empOrgrelsList.stream().filter(p -> p.get("depemp") != null && (Long)p.get("depemp") == depempId).findFirst();
            if (depempOptional.isPresent()) {
                Map depempMap = depempOptional.get();
                long posTypeId = depempMap.get("postype") == null ? 0L : Long.parseLong(String.valueOf(depempMap.get("postype")));
                String posTypeName = posTypeMap.get(posTypeId);
                map.put("apostype_id", posTypeId);
                map.put("apostype_name", posTypeName);
            }
            result.add(map);
        }
        result = result.stream().sorted(Comparator.comparing(p -> (Date)((Map)p).get("realstartdate"), Comparator.nullsLast(Date::compareTo)).reversed().thenComparing(q -> (Date)((Map)q).get("realenddate"), Comparator.nullsFirst(Comparator.reverseOrder()))).collect(Collectors.toList());
        return result;
    }
}

