/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.formservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.RateAp;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.domain.appointaudit.enums.AppointAuditStatusEnum;
import kd.tdc.cadm.bussiness.domain.examine.entity.ExamItemBo;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamineStatusEnum;
import kd.tdc.cadm.bussiness.domain.issue.enums.IssueStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyKindEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyTypeEnum;
import kd.tdc.cadm.bussiness.domain.publicity.enums.PublicityStatusEnum;
import kd.tdc.cadm.bussiness.domain.release.enums.ReleaseStatusEnum;
import kd.tdc.cadm.bussiness.domain.review.enmus.ReviewStatusEnum;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;
import org.apache.commons.lang.StringUtils;

public class CadmFormService {
    public static final String TERMINATION = "termination";
    public static final String IDS = "ids";
    public static final String ENTITY_ID = "ENTITY_ID";

    public void setPropertyNotDataChanged(IDataModel model, String ... propertyNames) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        Arrays.stream(propertyNames).forEach(propertyName -> {
            IDataEntityProperty property = (IDataEntityProperty)properties.get(propertyName);
            if (property != null) {
                this.removePropertyChanged(dataEntity, (String)propertyName);
            } else {
                List propertyList = dataEntity.getDataEntityType().getProperties().getCollectionProperties(false);
                if (CollectionUtils.isEmpty((Collection)propertyList)) {
                    return;
                }
                List<ICollectionProperty> entryPropertyList = propertyList.stream().filter(collectionProperty -> collectionProperty instanceof EntryProp).collect(Collectors.toList());
                entryPropertyList.forEach(entryProperty -> {
                    DynamicObjectCollection collection = (DynamicObjectCollection)entryProperty.getValueFast((Object)dataEntity);
                    if (CollectionUtils.isEmpty((Collection)collection)) {
                        return;
                    }
                    collection.forEach(rowDataEntity -> this.removePropertyChanged((DynamicObject)rowDataEntity, (String)propertyName));
                });
            }
        });
    }

    public void setEntryPropertyNotDataChangedByRow(IDataModel model, String entryName, int rowIndex, String ... propertyNames) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        Arrays.stream(propertyNames).forEach(propertyName -> {
            IDataEntityProperty property = (IDataEntityProperty)properties.get(propertyName);
            if (property != null) {
                this.removePropertyChanged(dataEntity, (String)propertyName);
            } else {
                List propertyList = dataEntity.getDataEntityType().getProperties().getCollectionProperties(false);
                if (CollectionUtils.isEmpty((Collection)propertyList)) {
                    return;
                }
                List<ICollectionProperty> entryPropertyList = propertyList.stream().filter(collectionProperty -> collectionProperty instanceof EntryProp).collect(Collectors.toList());
                entryPropertyList.forEach(entryProperty -> {
                    String name = entryProperty.getName();
                    if (!entryName.equals(name)) {
                        return;
                    }
                    DynamicObject item = (DynamicObject)((EntryProp)entryProperty).getItem(dataEntity, rowIndex);
                    if (null == item) {
                        return;
                    }
                    this.removePropertyChanged(item, (String)propertyName);
                });
            }
        });
    }

    private void removePropertyChanged(DynamicObject dataEntity, String propertyName) {
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)propertyName);
        if (property != null) {
            if (property instanceof BasedataProp) {
                property = (IDataEntityProperty)properties.get((Object)(propertyName + "_id"));
            } else if (property instanceof MulBasedataProp || property instanceof EntryProp) {
                if (property instanceof AttachmentProp) {
                    dataEntity.getDataEntityState().setBizChanged(property.getOrdinal(), false);
                }
                DynamicObjectCollection entryEntities = (DynamicObjectCollection)property.getValueFast((Object)dataEntity);
                entryEntities.forEach(entry -> {
                    entry.getDataEntityState().setBizChanged(false);
                    entry.getDataEntityState().setRemovedItems(Boolean.FALSE);
                });
                return;
            }
            dataEntity.getDataEntityState().setBizChanged(property.getOrdinal(), false);
        }
    }

    public void showBosDefaultOperationResult(String title, List<String> errorMsg, IFormView view) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bos_operationresult");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("title", (Object)title);
        formShowParameter.setCustomParam("errorMsg", errorMsg);
        formShowParameter.setShowTitle(false);
        view.showForm(formShowParameter);
    }

    public void showPersonInfoCard(IFormView view, String targetFlexName) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cadm_appointbaseinfo");
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.setCustomParam("depEmpId", (Object)dataEntity.getDynamicObject("nominatebill").getString("depemp.id"));
        formShowParameter.setCustomParam("personId", (Object)dataEntity.getString("person.id"));
        formShowParameter.setCustomParam("employee", (Object)dataEntity.getString("nominatebill.employee.id"));
        formShowParameter.getOpenStyle().setTargetKey(targetFlexName);
        view.showForm(formShowParameter);
    }

    public void showAppointInfoFlex(IFormView view, String targetFlexName, List<String> hideFlexList) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        DynamicObject dynamicObject = dataEntity.getDynamicObject("nominatebill");
        if (dynamicObject == null) {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        String applyKind = dynamicObject.getString("applykind");
        if (ApplyKindEnum.APPOINT.getNumber().equals(applyKind)) {
            showParameter.setFormId("cadm_nominatebill_inh");
        } else {
            showParameter.setFormId("cadm_dismissbill_inh");
        }
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setPkId(dataEntity.getDynamicObject("nominatebill").getPkValue());
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetFlexName);
        showParameter.setCustomParam("hiddenPage", hideFlexList);
        showParameter.setCustomParam("isOpen", (Object)Boolean.TRUE);
        view.showForm((FormShowParameter)showParameter);
    }

    public void showAppointInfoFlex(IFormView view, String targetFlexName) {
        this.showAppointInfoFlex(view, targetFlexName, new ArrayList<String>());
    }

    public void tenureShowAppointInfo(IFormView view, String targetFlex, DynamicObject appointDO) {
        String applyKind = appointDO.getString("applykind");
        BillShowParameter showParameter = new BillShowParameter();
        if (ApplyKindEnum.APPOINT.getNumber().equals(applyKind)) {
            showParameter.setFormId("cadm_nominatebill_inh");
        } else {
            showParameter.setFormId("cadm_dismissbill_inh");
        }
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetFlex);
        showParameter.setPkId(appointDO.getPkValue());
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("isOpen", (Object)Boolean.FALSE);
        view.showForm((FormShowParameter)showParameter);
    }

    public void billListShowHandler(PackageDataEvent eve) {
        this.billListShowHandler(eve, "handler");
    }

    public void billListShowHandler(PackageDataEvent eve, String fieldName) {
        DynamicObjectCollection handler;
        String peopleName = "";
        DynamicObject rowData = eve.getRowData();
        Object fieldValue = rowData.get(fieldName);
        if (fieldValue instanceof DynamicObjectCollection) {
            handler = (DynamicObjectCollection)fieldValue;
            ArrayList<String> names = new ArrayList<String>();
            for (DynamicObject item : handler) {
                DynamicObject per = item.getDynamicObject("fbasedataid");
                String number = per.getString("number");
                String name = per.getString("name");
                names.add(name + " " + number);
            }
            peopleName = StringUtils.join((Object[])names.toArray(), (String)";");
        }
        if (fieldValue instanceof DynamicObject) {
            handler = (DynamicObject)fieldValue;
            String number = handler.getString("number");
            String name = handler.getString("name");
            peopleName = name + " " + number;
        }
        eve.setFormatValue((Object)peopleName);
    }

    public void billListShowBrewList(PackageDataEvent eve, String listField) {
        DynamicObject rowData = eve.getRowData();
        DynamicObjectCollection listFieldCol = (DynamicObjectCollection)rowData.get(listField);
        ArrayList<String> names = new ArrayList<String>();
        for (DynamicObject item : listFieldCol) {
            String name;
            String number;
            DynamicObject per = item.getDynamicObject("fbasedataid");
            if ("brewcandidate".equals(listField)) {
                number = per.getString("person.number");
                name = per.getString("person.name");
            } else {
                number = per.getString("number");
                name = per.getString("name");
            }
            names.add(name + " " + number);
        }
        String peopleName = StringUtils.join((Object[])names.toArray(), (String)";");
        eve.setFormatValue((Object)peopleName);
    }

    public void showBillHead(IFormView view, String targetKey) {
        DynamicObject billDy = view.getModel().getDataEntity();
        Map<String, Object> customParams = this.buildCustomParams(billDy);
        this.showBillHead(view, targetKey, customParams);
    }

    public void showBillHead(IFormView view, String targetKey, Map<String, Object> customParams) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cadm_headbillinfo");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        view.showForm(showParameter);
    }

    private Map<String, Object> buildCustomParams(DynamicObject bill) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        String entityName = bill.getDataEntityType().getName();
        customParams.put("billno", bill.getString("billno"));
        customParams.put("appointtype", bill.getDynamicObject("nominatebill").getString("appointtype.name"));
        customParams.put("orgname", bill.getString("org.name"));
        customParams.put("billtypename", this.getBillName(entityName));
        Map<String, Object> billStatus = this.getBillStatus(bill, entityName);
        customParams.putAll(billStatus);
        DynamicObject subHandler = bill.getDynamicObject("subhandler");
        if (!Objects.isNull(subHandler)) {
            String handlerName = subHandler.getString("name");
            String handlerNumber = subHandler.getString("number");
            customParams.put("handlername", handlerName);
            customParams.put("handlernumber", handlerNumber);
        }
        customParams.put("handletime", this.getHandleTime(bill, entityName));
        String applyType = bill.getString("nominatebill.applytype");
        customParams.put("isfastapply", ApplyTypeEnum.FAST.getVal().equals(applyType));
        return customParams;
    }

    private Date getHandleTime(DynamicObject bill, String entityName) {
        switch (entityName) {
            case "cadm_reviewbill": {
                return bill.getDate("revdealtime");
            }
            case "cadm_publicity": {
                return bill.getDate("pubhandletime");
            }
            case "cadm_examinebill": {
                return bill.getDate("examinetime");
            }
            case "cadm_appointrelease": {
                return bill.getDate("relsdealtime");
            }
            case "cadm_appointaudit": {
                return bill.getDate("dealtime");
            }
            case "cadm_appointissue": {
                String issueStatus = bill.getString("issuestatus");
                if (IssueStatusEnum.TOBE_ISSUE.getNumber().equals(issueStatus)) {
                    return null;
                }
                return bill.getDate("issuetime");
            }
        }
        return new Date();
    }

    private Map<String, Object> getBillStatus(DynamicObject bill, String entityName) {
        HashMap<String, Object> billStatusMap = new HashMap<String, Object>(16);
        switch (entityName) {
            case "cadm_reviewbill": {
                ReviewStatusEnum reviewStatus = ReviewStatusEnum.getEnumByReviewStatus(bill.getString("reviewstatus"));
                billStatusMap.put("statusname", reviewStatus.getDesc());
                billStatusMap.put("statustype", reviewStatus.getStatusType());
                return billStatusMap;
            }
            case "cadm_publicity": {
                PublicityStatusEnum pubStatus = PublicityStatusEnum.getEnumByPubStatus(bill.getString("pubstatus"));
                billStatusMap.put("statusname", pubStatus.getDesc());
                billStatusMap.put("statustype", pubStatus.getStatusType());
                return billStatusMap;
            }
            case "cadm_examinebill": {
                ExamineStatusEnum examineStatus = ExamineStatusEnum.getEnumByVal(bill.getString("examinestatus"));
                billStatusMap.put("statusname", examineStatus.getName());
                billStatusMap.put("statustype", examineStatus.getStatusType());
                return billStatusMap;
            }
            case "cadm_appointrelease": {
                ReleaseStatusEnum releaseStatus = ReleaseStatusEnum.getEnumByVal(bill.getString("releasestatus"));
                billStatusMap.put("statusname", releaseStatus.getName());
                billStatusMap.put("statustype", releaseStatus.getStatusType());
                return billStatusMap;
            }
            case "cadm_appointissue": {
                IssueStatusEnum issueStatus = IssueStatusEnum.getEnumByStatus(bill.getString("issuestatus"));
                billStatusMap.put("statusname", issueStatus.getStatusName());
                billStatusMap.put("statustype", issueStatus.getStatusType());
                return billStatusMap;
            }
            case "cadm_appointaudit": {
                AppointAuditStatusEnum auditStatus = AppointAuditStatusEnum.getEnumByVal(bill.getString("appoauditstatus"));
                billStatusMap.put("statusname", auditStatus.getName());
                billStatusMap.put("statustype", auditStatus.getStatusType());
                return billStatusMap;
            }
        }
        return billStatusMap;
    }

    private String getBillName(String entityName) {
        HashMap billInfoNames = Maps.newHashMap();
        billInfoNames.put("cadm_publicity", ResManager.loadKDString((String)"\u516c\u793a", (String)"CadmFormService_0", (String)"tdc-cadm-business", (Object[])new Object[0]));
        billInfoNames.put("cadm_reviewbill", ResManager.loadKDString((String)"\u8bc4\u8bae\u8bb0\u5f55", (String)"CadmFormService_1", (String)"tdc-cadm-business", (Object[])new Object[0]));
        billInfoNames.put("cadm_examinebill", ResManager.loadKDString((String)"\u8003\u5bdf\u8bb0\u5f55", (String)"CadmFormService_2", (String)"tdc-cadm-business", (Object[])new Object[0]));
        billInfoNames.put("cadm_appointrelease", ResManager.loadKDString((String)"\u53d1\u5e03", (String)"CadmFormService_3", (String)"tdc-cadm-business", (Object[])new Object[0]));
        billInfoNames.put("cadm_appointaudit", ResManager.loadKDString((String)"\u8d44\u683c\u5ba1\u67e5", (String)"CadmFormService_4", (String)"tdc-cadm-business", (Object[])new Object[0]));
        billInfoNames.put("cadm_appointissue", ResManager.loadKDString((String)"\u7b7e\u53d1", (String)"CadmFormService_5", (String)"tdc-cadm-business", (Object[])new Object[0]));
        return (String)billInfoNames.get(entityName);
    }

    public String getActBillStatusDesc(String formId) {
        switch (formId) {
            case "cadm_examinebill": {
                return ResManager.loadKDString((String)"\u8003\u5bdf\u72b6\u6001", (String)"CadmFormService_6", (String)"tdc-cadm-business", (Object[])new Object[0]);
            }
            case "cadm_publicity": {
                return ResManager.loadKDString((String)"\u516c\u793a\u72b6\u6001", (String)"CadmFormService_7", (String)"tdc-cadm-business", (Object[])new Object[0]);
            }
            case "cadm_reviewbill": {
                return ResManager.loadKDString((String)"\u8bc4\u8bae\u72b6\u6001", (String)"CadmFormService_8", (String)"tdc-cadm-business", (Object[])new Object[0]);
            }
            case "cadm_appointrelease": {
                return ResManager.loadKDString((String)"\u53d1\u5e03\u72b6\u6001", (String)"CadmFormService_9", (String)"tdc-cadm-business", (Object[])new Object[0]);
            }
            case "cadm_appointissue": {
                return ResManager.loadKDString((String)"\u7b7e\u53d1\u72b6\u6001", (String)"CadmFormService_10", (String)"tdc-cadm-business", (Object[])new Object[0]);
            }
            case "cadm_appointaudit": {
                return ResManager.loadKDString((String)"\u5ba1\u67e5\u72b6\u6001", (String)"CadmFormService_11", (String)"tdc-cadm-business", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public String getStatusName(DynamicObject actBill) {
        String name;
        switch (name = actBill.getDataEntityType().getName()) {
            case "cadm_examinebill": {
                return ExamineStatusEnum.getEnumByVal(actBill.getString("examinestatus")).getName();
            }
            case "cadm_publicity": {
                return PublicityStatusEnum.getEnumByPubStatus(actBill.getString("pubstatus")).getDesc();
            }
            case "cadm_reviewbill": {
                return ReviewStatusEnum.getEnumByReviewStatus(actBill.getString("reviewstatus")).getDesc();
            }
            case "cadm_appointrelease": {
                return ReleaseStatusEnum.getEnumByVal(actBill.getString("releasestatus")).getName();
            }
            case "cadm_appointissue": {
                return IssueStatusEnum.getEnumByStatus(actBill.getString("issuestatus")).getStatusName();
            }
            case "cadm_appointaudit": {
                return AppointAuditStatusEnum.getEnumByVal(actBill.getString("appoauditstatus")).getName();
            }
        }
        return "";
    }

    public List<ExamItemBo> convertCoopBillToExamItemBos(DynamicObject coopBill) {
        if (coopBill == null) {
            return Lists.newArrayList();
        }
        DynamicObjectCollection entryEntity = coopBill.getDynamicObjectCollection("entryentity");
        ArrayList<ExamItemBo> examItemBoList = new ArrayList<ExamItemBo>(entryEntity.size());
        for (DynamicObject dynamicObject : entryEntity) {
            DynamicObject examItem = dynamicObject.getDynamicObject("examitem");
            String examItemId = examItem.getString("id");
            String examItemName = examItem.getString("name");
            String description = examItem.getString("description");
            BigDecimal score = dynamicObject.getBigDecimal("score");
            String itemRemark = dynamicObject.containsProperty("itemremark") ? dynamicObject.getString("itemremark") : "";
            ExamItemBo examItemBo = new ExamItemBo(examItemId, examItemName, description, itemRemark, score);
            examItemBoList.add(examItemBo);
        }
        return examItemBoList;
    }

    private Style createMarginTopStyle(String marginTop) {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop(marginTop);
        style.setMargin(margin);
        return style;
    }

    public RateAp createRateAp(String examItemId, String lock) {
        Style style = this.createMarginTopStyle("8px");
        RateAp rateAp = new RateAp();
        rateAp.setId("rateap-" + examItemId);
        rateAp.setKey("rateap-" + examItemId);
        rateAp.setAllowHalf(true);
        rateAp.setShowTextType(1);
        rateAp.setStyle(style);
        if (HRStringUtils.isNotEmpty((String)lock)) {
            rateAp.setLock(lock);
        }
        return rateAp;
    }

    public LabelAp createLabelAp(int index, ExamItemBo examItemBo) {
        Style style = this.createMarginTopStyle("16px");
        String examItemId = examItemBo.getExamItemId();
        String examItemName = examItemBo.getExamItemName();
        String description = examItemBo.getDescription();
        LabelAp labelAp = new LabelAp();
        String labelApId = "labelAp-" + examItemId;
        labelAp.setId(labelApId);
        labelAp.setKey(labelApId);
        labelAp.setName(new LocaleString(MessageFormat.format("{0}\u3001{1}\uff1a{2}", index, examItemName, description)));
        labelAp.setStyle(style);
        labelAp.setForeColor("#666666");
        return labelAp;
    }

    public LabelAp createRemarkLabelAp(ExamItemBo examItemBo) {
        Style style = this.createMarginTopStyle("8px");
        String examItemId = examItemBo.getExamItemId();
        String itemRemark = examItemBo.getItemRemark();
        LabelAp labelAp = new LabelAp();
        String labelApId = "labelAp-" + examItemId;
        labelAp.setId(labelApId);
        labelAp.setKey(labelApId);
        labelAp.setName(new LocaleString(MessageFormat.format("{0}", itemRemark)));
        labelAp.setStyle(style);
        labelAp.setForeColor("#666666");
        return labelAp;
    }

    public FlexPanelAp createFlexPanelAp(String key) {
        FlexPanelAp containerAp = new FlexPanelAp();
        containerAp.setKey(key);
        containerAp.setDirection("column");
        containerAp.setJustifyContent("flex-start");
        containerAp.setAlignItems("stretch");
        containerAp.setWrap(false);
        return containerAp;
    }

    public void setBrewBillRelatedField(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject brewBill = dataEntity.getDynamicObject("brewingbill");
        if (brewBill == null) {
            return;
        }
        DynamicObjectCollection entryEntity = brewBill.getDynamicObjectCollection("entryentity");
        long personId = dataEntity.getLong("person.id");
        for (DynamicObject entryRow : entryEntity) {
            long entryRowPersonId = entryRow.getLong("person.id");
            if (personId != entryRowPersonId) continue;
            String brewComment = entryRow.getString("brewcomment");
            model.setValue("brewcomment", (Object)brewComment);
            break;
        }
    }

    public void showPositionMatchPage(Long brewBillId, Long personId, Long employeeId, String positionType, long id, String targetKey, IFormView view) {
        if (brewBillId == null) {
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("brewbillid", String.valueOf(brewBillId));
        customParams.put("employeeid", String.valueOf(employeeId));
        customParams.put("personid", String.valueOf(personId));
        customParams.put("positiontype", positionType);
        customParams.put("candcardposition", id);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cadm_positionmatch");
        formShowParameter.getOpenStyle().setTargetKey(targetKey);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.setStatus(OperationStatus.VIEW);
        view.showForm(formShowParameter);
    }

    public String setTerminationReasonParam(AbstractFormPlugin plugin, List<Long> personIds) {
        Map checkMap = ExternalService.checkEmployeeStatusByPersonIds(personIds);
        if (checkMap != null && !checkMap.containsValue(Boolean.TRUE)) {
            LocaleString terminationReason = ResManager.getLocaleString((String)"\u5458\u5de5\u5df2\u79bb\u804c\uff0c\u7ec8\u6b62\u6d41\u7a0b", (String)"NominateApplicationService_2", (String)"tdc-cadm-business");
            String reason = String.valueOf(terminationReason);
            plugin.getView().getFormShowParameter().setCustomParam("customReason", (Object)reason);
            return reason;
        }
        return "";
    }

    public static class CadmListShowHandler
    extends ListDataProvider {
        private final AbstractFormPlugin plugin;
        private final String fieldName;

        public CadmListShowHandler(AbstractFormPlugin plugin, String fieldName) {
            this.plugin = plugin;
            this.fieldName = fieldName;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection pageData = super.getData(start, limit);
            if (pageData.isEmpty()) {
                return pageData;
            }
            HashSet handledUserSet = new HashSet(16);
            if (!((DynamicObject)pageData.get(0)).getDataEntityType().getProperties().containsKey((Object)this.fieldName)) {
                return pageData;
            }
            pageData.forEach(row -> {
                DynamicObjectCollection coopHandler = row.getDynamicObjectCollection(this.fieldName);
                coopHandler.forEach(handler -> {
                    DynamicObject user = handler.getDynamicObject("fbasedataid");
                    if (handledUserSet.contains(user)) {
                        return;
                    }
                    String userName = user.getString("name");
                    String userNumber = user.getString("number");
                    user.set("name", (Object)(userName + " " + userNumber));
                    handledUserSet.add(user);
                });
            });
            return pageData;
        }
    }
}

