/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.initservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.AppointRecordService;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.initservice.CommonInitService;
import kd.tdc.cadm.bussiness.initservice.InitCommonBusinessService;
import kd.tdc.cadm.bussiness.util.DateUtil;
import kd.tdc.cadm.common.enums.PositionTypeEnum;

public class AppointResultInitService
extends CommonInitService {
    private static final AppointRecordService APPOINT_RECORD_SERVICE = ServiceFactory.getService(AppointRecordService.class);
    private static final InitCommonBusinessService INIT_COMMON_BUSINESS_SERVICE = ServiceFactory.getService(InitCommonBusinessService.class);

    @Override
    public void businessValidate(Map<String, Object> infoWithMap, Map<String, Object> infoWithDynamicObject) {
        List paramList = (List)SerializationUtils.deSerializeFromBase64((String)SerializationUtils.serializeToBase64((Object)infoWithDynamicObject.get("data")));
        Map idMappingMap = (Map)SerializationUtils.deSerializeFromBase64((String)SerializationUtils.serializeToBase64((Object)infoWithDynamicObject.get("idmapping")));
        this.dataValidate(paramList, idMappingMap);
    }

    @Override
    public void businessSave(Map<String, Object> infoWithMap, Map<String, Object> infoWithDynamicObject) {
        List paramList = (List)SerializationUtils.deSerializeFromBase64((String)SerializationUtils.serializeToBase64((Object)infoWithDynamicObject.get("data")));
        long currUserId = RequestContext.get().getCurrUserId();
        this.setInitDefalutValue(paramList);
        paramList.forEach(dynamicObject -> {
            dynamicObject.set("creator", (Object)currUserId);
            dynamicObject.set("bizstatus", (Object)"1");
            String positionType = dynamicObject.getString("positiontype");
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                DynamicObject position = dynamicObject.getDynamicObject("position");
                dynamicObject.set("position_id", position.get("sourcevid"));
            } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                DynamicObject job = dynamicObject.getDynamicObject("job");
                dynamicObject.set("job_id", job.get("sourcevid"));
            } else {
                DynamicObject standardPosition = dynamicObject.getDynamicObject("standardposition");
                dynamicObject.set("standardposition_id", standardPosition.get("sourcevid"));
            }
        });
        APPOINT_RECORD_SERVICE.save(paramList.toArray(new DynamicObject[0]));
    }

    private void dataValidate(List<DynamicObject> paramList, Map<Long, Set<Long>> idMappingMap) {
        String prePositionDateBefore = ResManager.loadKDString((String)"\u201c\u4efb\u671f\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u201d\u5e94\u65e9\u4e8e\u201c\u9884\u8f6c\u6b63\u65e5\u671f\u201d\u3002", (String)"AppointResultInitService_0", (String)"tdc-cadm-business", (Object[])new Object[0]);
        String endDateBefore = ResManager.loadKDString((String)"\u201c\u4efb\u671f\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u201d\u5e94\u65e9\u4e8e\u201c\u4efb\u671f\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"AppointResultInitService_1", (String)"tdc-cadm-business", (Object[])new Object[0]);
        String preGtEndDate = ResManager.loadKDString((String)"\u201c\u4efb\u671f\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201d\u5e94\u665a\u4e8e\u201c\u9884\u8f6c\u6b63\u65e5\u671f\u201d\u3002", (String)"AppointResultInitService_5", (String)"tdc-cadm-business", (Object[])new Object[0]);
        String positionNotManager = ResManager.loadKDString((String)"\u5f53\u524d\u5c97\u4f4d\u4e3a\u975e\u7ba1\u7406\u7c7b\u5c97\u4f4d\uff0c\u8bf7\u586b\u5165\u7ba1\u7406\u7c7b\u5c97\u4f4d\u3002", (String)"AppointResultInitService_2", (String)"tdc-cadm-business", (Object[])new Object[0]);
        String standardPositionNotManager = ResManager.loadKDString((String)"\u5f53\u524d\u6807\u51c6\u5c97\u4f4d\u4e3a\u975e\u7ba1\u7406\u7c7b\u6807\u51c6\u5c97\u4f4d\uff0c\u8bf7\u586b\u5165\u7ba1\u7406\u7c7b\u6807\u51c6\u5c97\u4f4d\u3002", (String)"AppointResultInitService_3", (String)"tdc-cadm-business", (Object[])new Object[0]);
        String jobNotManager = ResManager.loadKDString((String)"\u5f53\u524d\u804c\u4f4d\u4e3a\u975e\u7ba1\u7406\u7c7b\u804c\u4f4d\uff0c\u8bf7\u586b\u5165\u7ba1\u7406\u7c7b\u804c\u4f4d\u3002", (String)"AppointResultInitService_4", (String)"tdc-cadm-business", (Object[])new Object[0]);
        Map<String, List<DynamicObject>> groupByPositionType = paramList.stream().filter(dynamicObject -> dynamicObject.getString("positiontype") != null).collect(Collectors.groupingBy(dynamic -> dynamic.getString("positiontype")));
        List<Object> managerPositionId = this.getManagerPositionId(groupByPositionType);
        List<Object> managerStandardPositionId = this.getManagerStandardPositionId(groupByPositionType);
        List<Object> managerJobId = this.getManagerJobId(groupByPositionType);
        HashMap errorMessageMap = Maps.newHashMapWithExpectedSize((int)paramList.size());
        paramList.forEach(dynamicObject -> {
            long id = dynamicObject.getLong("id");
            ArrayList errorMessageList = Lists.newArrayList();
            Set midIdSet = (Set)idMappingMap.get(id);
            Long midId = (Long)midIdSet.iterator().next();
            String key = midId + "," + id;
            errorMessageMap.put(key, errorMessageList);
            String positionError = INIT_COMMON_BUSINESS_SERVICE.validatePositionInfo((DynamicObject)dynamicObject);
            if (HRStringUtils.isNotEmpty((String)positionError)) {
                errorMessageList.add(positionError);
            }
            String positionType = dynamicObject.getString("positiontype");
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                DynamicObject position = dynamicObject.getDynamicObject("position");
                if (null != position && !managerPositionId.contains(position.get("id"))) {
                    errorMessageList.add(positionNotManager);
                }
            } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                DynamicObject job = dynamicObject.getDynamicObject("job");
                if (null != job && !managerJobId.contains(job.get("id"))) {
                    errorMessageList.add(jobNotManager);
                }
            } else {
                DynamicObject standardPosition = dynamicObject.getDynamicObject("standardposition");
                if (null != standardPosition && !managerStandardPositionId.contains(standardPosition.get("id"))) {
                    errorMessageList.add(standardPositionNotManager);
                }
            }
            Date appointDate = dynamicObject.getDate("appointdate");
            Date prePositiveDate = dynamicObject.getDate("prepositivedate");
            Date planEndDate = dynamicObject.getDate("planenddate");
            if (null == prePositiveDate && null == planEndDate) {
                return;
            }
            if (null != prePositiveDate && DateUtil.dayAfter(appointDate, prePositiveDate)) {
                errorMessageList.add(prePositionDateBefore);
            }
            if (null != planEndDate && DateUtil.dayAfter(appointDate, planEndDate)) {
                errorMessageList.add(endDateBefore);
            }
            if (null != planEndDate && DateUtil.dayAfter(prePositiveDate, planEndDate)) {
                errorMessageList.add(preGtEndDate);
            }
        });
        this.addMessage(errorMessageMap);
    }

    private List<Object> getManagerStandardPositionId(Map<String, List<DynamicObject>> groupByPositionType) {
        List<DynamicObject> standardPositionList = groupByPositionType.get(PositionTypeEnum.STANDER_POSITION.getNumber());
        List<Object> managerStandardPositionIdList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(standardPositionList)) {
            List<Object> standardPositionIdList = standardPositionList.stream().filter(dynamicObject -> dynamicObject.getDynamicObject("standardposition") != null).map(dynamicObject -> dynamicObject.getDynamicObject("standardposition").get("id")).collect(Collectors.toList());
            managerStandardPositionIdList = ExternalDataService.queryManageStandardPosition(standardPositionIdList);
        }
        return managerStandardPositionIdList;
    }

    private List<Object> getManagerPositionId(Map<String, List<DynamicObject>> groupByPositionType) {
        List<DynamicObject> positionList = groupByPositionType.get(PositionTypeEnum.POSITION.getNumber());
        List<Object> managerStandardPositionIdList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(positionList)) {
            List<Object> standardPositionIdList = positionList.stream().filter(dynamicObject -> dynamicObject.getDynamicObject("position") != null).map(dynamicObject -> dynamicObject.getDynamicObject("position").get("id")).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = ExternalDataService.queryManagePosition(standardPositionIdList);
            if (null == dynamicObjects || dynamicObjects.length == 0) {
                return managerStandardPositionIdList;
            }
            managerStandardPositionIdList = Arrays.stream(dynamicObjects).map(dynamic -> dynamic.get("id")).collect(Collectors.toList());
        }
        return managerStandardPositionIdList;
    }

    private List<Object> getManagerJobId(Map<String, List<DynamicObject>> groupByPositionType) {
        List<DynamicObject> jobList = groupByPositionType.get(PositionTypeEnum.JOB.getNumber());
        List<Object> managerJobIdList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(jobList)) {
            List<Object> jobIdList = jobList.stream().filter(dynamicObject -> dynamicObject.getDynamicObject("job") != null).map(dynamicObject -> dynamicObject.getDynamicObject("job").get("id")).collect(Collectors.toList());
            managerJobIdList = ExternalDataService.queryManageJob(jobIdList);
        }
        return managerJobIdList;
    }
}

