/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.taskService;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.AppointRecordService;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.external.TalentService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.domain.tenure.enums.PositiveStatusEnum;
import kd.tdc.cadm.bussiness.domain.tenure.enums.TenureStatusEnum;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.common.enums.PositionTypeEnum;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;

public class TenureInitService {
    private final Log LOG = LogFactory.getLog(TenureInitService.class);
    private static final TalentService TALENT_SERVICE = ServiceFactory.getService(TalentService.class);
    private static final TenureApplicationService TENURE_APPLICATION_SERVICE = ServiceFactory.getService(TenureApplicationService.class);
    private static final AppointRecordService APPOINT_RECORD_SERVICE = ServiceFactory.getService(AppointRecordService.class);
    private final ExternalService EXTERNAL_SERVICE = new ExternalService();
    private static final ExecutorService EXECUTOR_SERVICE = ThreadPools.newCachedExecutorService((String)"TenureInitServicePool", (int)5, (int)20);
    private static final int MAX_EXECUTE_SIZE = 1000;
    private static final long TDC_BUSINESS_FIELD = 106010L;

    public void init() {
        this.startPageInit();
    }

    private void startPageInit() {
        ArrayList resultList = Lists.newArrayList();
        List<Long> employeeList = this.getEmployeeListFromTalent();
        if (CollectionUtils.isEmpty(employeeList)) {
            this.LOG.error(" tenure init fail by talent employee is empty!!!");
            return;
        }
        ArrayList futureResultList = Lists.newArrayList();
        int employSize = employeeList.size();
        if (employSize > 1000) {
            int num = (employSize + 1000 - 1) / 1000;
            for (int i = 0; i < num; ++i) {
                int fromIndex = i * 1000;
                int toIndex = Math.min((i + 1) * 1000, employSize);
                List<Long> currentEmployeeList = employeeList.subList(fromIndex, toIndex);
                CompletableFuture<List> futureResult = CompletableFuture.supplyAsync(() -> this.dealTenureInitTask(currentEmployeeList), EXECUTOR_SERVICE);
                futureResultList.add(futureResult);
            }
            futureResultList.forEach(future -> {
                List result = (List)future.join();
                if (CollectionUtils.isEmpty((Collection)result)) {
                    return;
                }
                resultList.addAll(result);
            });
        } else {
            List<DynamicObject> result = this.dealTenureInitTask(employeeList);
            if (!CollectionUtils.isEmpty(result)) {
                resultList.addAll(result);
            }
        }
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return;
        }
        TENURE_APPLICATION_SERVICE.batchSave(resultList.toArray(new DynamicObject[0]));
    }

    private List<DynamicObject> dealTenureInitTask(List<Long> employeeList) {
        List<Map<String, Object>> inUsingEmpPosList = this.getInUsingEmpPos(employeeList);
        if (CollectionUtils.isEmpty(inUsingEmpPosList)) {
            return Lists.newArrayList();
        }
        if (CollectionUtils.isEmpty(inUsingEmpPosList = ExternalDataService.filterManagerEmpPos(inUsingEmpPosList))) {
            return Lists.newArrayList();
        }
        List<Object> depEmpList = inUsingEmpPosList.stream().filter(map -> map.get("depemp_id") != null).map(map -> map.get("depemp_id")).collect(Collectors.toList());
        List<Map<String, Object>> tenureList = this.getTenureListByDepEmpIds(depEmpList);
        Map<Object, List<Map>> depEmpTenureMap = tenureList.stream().filter(map -> map.get("depemp") != null).collect(Collectors.groupingBy(map -> map.get("depemp")));
        ArrayList canUseEmpPosList = Lists.newArrayList();
        inUsingEmpPosList.forEach(empPosMap -> {
            if (null == empPosMap.get("depemp_id")) {
                return;
            }
            Object depEmpId = empPosMap.get("depemp_id");
            List maps = (List)depEmpTenureMap.get(depEmpId);
            if (!CollectionUtils.isEmpty((Collection)maps)) {
                return;
            }
            canUseEmpPosList.add(empPosMap);
        });
        if (CollectionUtils.isEmpty((Collection)canUseEmpPosList)) {
            this.LOG.info("dealTenureInitTask all empPos have tenure,no need create");
            return Lists.newArrayList();
        }
        List<Map<String, Object>> appointRecordList = this.getAppointRecordByEmployees(employeeList);
        Map<String, List<Map>> groupEmployeeInfoMap = appointRecordList.stream().collect(Collectors.groupingBy(record -> {
            Object positionType = record.get("positiontype");
            return "" + record.get("employee_id") + positionType + this.appendKey(positionType, "standardposition_id", (Map<String, Object>)record);
        }));
        Set adminOrgIdSet = canUseEmpPosList.stream().filter(map -> map.get("adminorg_id") != null).map(map -> map.get("adminorg_id")).collect(Collectors.toSet());
        List<Map<String, Long>> hrBuList = this.getHrBuByBusinessType(Lists.newArrayList(adminOrgIdSet));
        Map<Object, Object> adminOrgIdMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(hrBuList)) {
            adminOrgIdMap = hrBuList.stream().collect(Collectors.groupingBy(hrBu -> (Long)hrBu.get("adminOrgId")));
        }
        HashMap finalAdminOrgIdMap = adminOrgIdMap;
        Date now = new Date();
        ArrayList resultList = Lists.newArrayList();
        DynamicObject[] empJobDy = this.EXTERNAL_SERVICE.queryEmpJobLevelByEmpIds((Set)Sets.newHashSet(employeeList));
        HashMap jobLevelMap = null == empJobDy || empJobDy.length == 0 ? Maps.newHashMap() : Arrays.stream(empJobDy).collect(Collectors.toMap(value -> value.getLong("employee"), value -> value, (v1, v2) -> v1));
        canUseEmpPosList.forEach(empPosMap -> {
            Object positionType = empPosMap.get("apositiontype");
            String key = "" + empPosMap.get("employee_id") + positionType + this.appendKey(positionType, "stdposition_id", (Map<String, Object>)empPosMap);
            Map<String, Object> appointRecord = this.getAppointRecord(groupEmployeeInfoMap, key);
            DynamicObject tenure = this.buildTenure((Map<String, Object>)empPosMap, appointRecord, jobLevelMap, finalAdminOrgIdMap, now);
            resultList.add(tenure);
        });
        this.updateRelationToPulled(canUseEmpPosList, now);
        return resultList;
    }

    private void updateRelationToPulled(List<Map<String, Object>> canUseEmpPosList, Date now) {
        try {
            List<Object> empPosIdList = canUseEmpPosList.stream().map(map -> map.get("id")).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = APPOINT_RECORD_SERVICE.queryRelationByEmpPosIds(empPosIdList);
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                Arrays.stream(dynamicObjects).forEach(dynamicObject -> {
                    dynamicObject.set("ispull", (Object)"1");
                    dynamicObject.set("pulltime", (Object)now);
                });
                APPOINT_RECORD_SERVICE.updateRelation(dynamicObjects);
            }
        }
        catch (Exception e) {
            this.LOG.error("update relation to pulled fail ", (Throwable)e);
        }
    }

    private DynamicObject buildTenure(Map<String, Object> empPosMap, Map<String, Object> appointRecord, Map<Long, DynamicObject> jobLevelMap, Map<Long, List<Map<String, Long>>> adminOrgIdMap, Date now) {
        DynamicObject empJobDy;
        long adminOrgId;
        DynamicObject tenureDy = TENURE_APPLICATION_SERVICE.newEmptyDynamic();
        tenureDy.set("modifier", (Object)1);
        tenureDy.set("modifytime", (Object)now);
        tenureDy.set("creator", (Object)1);
        tenureDy.set("createtime", (Object)now);
        tenureDy.set("expedstatus", (Object)" ");
        Date startDate = (Date)empPosMap.get("startdate");
        Date endDate = (Date)empPosMap.get("enddate");
        tenureDy.set("realstartdate", (Object)startDate);
        if (null != endDate && HRDateTimeUtils.getYear((Date)endDate) < 2099) {
            tenureDy.set("realenddate", (Object)endDate);
        }
        tenureDy.set("apositiontype", empPosMap.get("apositiontype"));
        if (appointRecord == null) {
            if (HRDateTimeUtils.dayAfter((Date)now, (Date)endDate)) {
                tenureDy.set("tenurestatus", (Object)TenureStatusEnum.LEAVE.getNumber());
            } else if (((Boolean)empPosMap.get("isexistprobation")).booleanValue()) {
                Date endProbationDate = (Date)empPosMap.get("endprobation");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(endProbationDate);
                calendar.add(7, 1);
                Date prePositiveDate = calendar.getTime();
                this.setTenureDate(now, tenureDy, prePositiveDate);
            } else {
                tenureDy.set("tenurestatus", (Object)TenureStatusEnum.ASSUME.getNumber());
            }
        } else {
            long appointType;
            Date prePositiveDate;
            Date date = prePositiveDate = appointRecord.get("prepositivedate") == null ? null : (Date)appointRecord.get("prepositivedate");
            if (HRDateTimeUtils.dayAfter((Date)now, (Date)endDate)) {
                tenureDy.set("tenurestatus", (Object)TenureStatusEnum.LEAVE.getNumber());
            } else if (Objects.isNull(prePositiveDate)) {
                tenureDy.set("tenurestatus", (Object)TenureStatusEnum.ASSUME.getNumber());
            } else {
                this.setTenureDate(now, tenureDy, prePositiveDate);
            }
            tenureDy.set("appoint", appointRecord.get("appointid_id"));
            Date appointDate = appointRecord.get("appointdate") == null ? null : (Date)appointRecord.get("appointdate");
            tenureDy.set("planstartdate", (Object)appointDate);
            tenureDy.set("cadrecat", appointRecord.get("cadrecat_id"));
            tenureDy.set("planenddate", appointRecord.get("planenddate"));
            long l = appointType = appointRecord.get("appointtype") == null ? 0L : (Long)appointRecord.get("appointtype");
            if (1472625044948646912L == appointType) {
                tenureDy.set("realstartdate", (Object)appointDate);
            }
        }
        long l = adminOrgId = empPosMap.get("adminorg_id") == null ? 0L : (Long)empPosMap.get("adminorg_id");
        if (adminOrgIdMap.get(adminOrgId) != null && adminOrgIdMap.get(adminOrgId).get(0) != null) {
            Long buId = adminOrgIdMap.get(adminOrgId).get(0).get("hrBuId");
            tenureDy.set("org", (Object)buId);
        }
        tenureDy.set("affiliateadminorg", (Object)adminOrgId);
        tenureDy.set("company", empPosMap.get("company_id"));
        tenureDy.set("adminorg", (Object)adminOrgId);
        tenureDy.set("empgroup", (Object)1050L);
        Long employeeId = (Long)empPosMap.get("employee_id");
        tenureDy.set("employee", (Object)employeeId);
        tenureDy.set("cmpemp", empPosMap.get("cmpemp_id"));
        tenureDy.set("depemp", empPosMap.get("depemp_id"));
        tenureDy.set("person", empPosMap.get("person_id"));
        tenureDy.set("isprimappoint", empPosMap.get("isprimary"));
        if (null != empPosMap.get("position_id")) {
            tenureDy.set("position", empPosMap.get("position_id"));
        }
        if (null != empPosMap.get("job_id")) {
            tenureDy.set("job", empPosMap.get("job_id"));
        }
        if (null != empPosMap.get("stdposition_id")) {
            tenureDy.set("standardpost", empPosMap.get("stdposition_id"));
        }
        if (null != jobLevelMap && !HRObjectUtils.isEmpty((Object)(empJobDy = jobLevelMap.get(employeeId)))) {
            tenureDy.set("jobgrade", (Object)empJobDy.getLong("joblevel"));
        }
        return tenureDy;
    }

    public List<Map<String, Long>> getHrBuByBusinessType(List<Object> orgIdList) {
        List resultList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(orgIdList)) {
            return resultList;
        }
        long startTime = System.currentTimeMillis();
        HashMap orgId2BusinessType = Maps.newHashMap();
        HashSet businessFieldSet = Sets.newHashSet();
        businessFieldSet.add(106010L);
        orgIdList.forEach(orgId -> orgId2BusinessType.put((Long)orgId, businessFieldSet));
        Long businessObjectId = 1010L;
        resultList = (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrBuByBusinessType", (Object[])new Object[]{orgId2BusinessType, businessObjectId});
        this.LOG.info("IHRCSStrategyService-->getHrBuByBusinessTypeinputorgId2BusinessType:{},businessObjectId:{},outputlist:{}", new Object[]{orgId2BusinessType, businessObjectId, orgIdList, resultList});
        this.LOG.info("IHRCSStrategyService-->getHrBuByBusinessTypecosttime:{}", (Object)(System.currentTimeMillis() - startTime));
        return resultList;
    }

    private void setTenureDate(Date currDate, DynamicObject tenureDy, Date prePositiveDate) {
        if (HRDateTimeUtils.dayAfter((Date)prePositiveDate, (Date)currDate)) {
            tenureDy.set("positivestatus", (Object)PositiveStatusEnum.TODO.getNumber());
        }
        tenureDy.set("tenurestatus", (Object)(HRDateTimeUtils.dayAfter((Date)prePositiveDate, (Date)currDate) ? TenureStatusEnum.PROBATION.getNumber() : TenureStatusEnum.ASSUME.getNumber()));
        tenureDy.set("prepositivedate", (Object)prePositiveDate);
    }

    private Map<String, Object> getAppointRecord(Map<String, List<Map<String, Object>>> groupEmployeeInfoMap, String key) {
        List<Map<String, Object>> appointRecordMapList = groupEmployeeInfoMap.get(key);
        if (!CollectionUtils.isEmpty(appointRecordMapList)) {
            appointRecordMapList = appointRecordMapList.stream().sorted(Comparator.comparing(appointRecord -> (Date)appointRecord.get("createtime"), Comparator.reverseOrder())).collect(Collectors.toList());
            return appointRecordMapList.get(0);
        }
        return Maps.newHashMap();
    }

    private String appendKey(Object positionType, String stdPositionKey, Map<String, Object> map) {
        Object currentJob = PositionTypeEnum.POSITION.getNumber().equals(positionType) ? map.get("position_id") : (PositionTypeEnum.JOB.getNumber().equals(positionType) ? map.get("job_id") : (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType) ? map.get(stdPositionKey) : ""));
        return "" + currentJob;
    }

    private List<Map<String, Object>> getAppointRecordByEmployees(List<Long> employeeList) {
        DynamicObject[] dynamicObjects = APPOINT_RECORD_SERVICE.queryEffectiveAppointRecordByEmployee(employeeList);
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            return Lists.newArrayList();
        }
        HashMap idMappingBoId = Maps.newHashMap();
        Arrays.stream(dynamicObjects).forEach(dynamicObject -> {
            DynamicObject standardPosition;
            String positionType = dynamicObject.getString("positiontype");
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                DynamicObject position = dynamicObject.getDynamicObject("position");
                if (null != position) {
                    idMappingBoId.put(position.get("id"), position.getLong("boid"));
                }
            } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                DynamicObject job = dynamicObject.getDynamicObject("job");
                if (null != job) {
                    idMappingBoId.put(job.get("id"), job.getLong("boid"));
                }
            } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType) && null != (standardPosition = dynamicObject.getDynamicObject("standardposition"))) {
                idMappingBoId.put(standardPosition.get("id"), standardPosition.getLong("boid"));
            }
        });
        List<Map<String, Object>> result = CastUtils.castDynamicToMap(dynamicObjects);
        result.forEach(map -> {
            Object positionType = map.get("positiontype");
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                map.put("position_id", idMappingBoId.get(map.get("position_id")));
            } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                map.put("job_id", idMappingBoId.get(map.get("job_id")));
            } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                map.put("standardposition_id", idMappingBoId.get(map.get("standardposition_id")));
            }
        });
        return result;
    }

    private List<Map<String, Object>> getTenureListByDepEmpIds(List<Object> depEmpList) {
        String selectProperties = "modifier,modifytime,creator,createtime,expedstatus,realstartdate,realenddate,apositiontype,tenurestatus,positivestatus,prepositivedate,appoint,planstartdate,cadrecat,planenddate,org,affiliateadminorg,company,adminorg, empgroup,employee,cmpemp,depemp,person,isprimappoint,position,job,standardpost,jobgrade";
        DynamicObject[] dynamicObjects = TENURE_APPLICATION_SERVICE.queryOriginalTenuresByDepEmpIds(selectProperties, depEmpList);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return Lists.newArrayList();
        }
        return CastUtils.castDynamicToMap(dynamicObjects);
    }

    private List<Long> getEmployeeListFromTalent() {
        Set<Long> allEmployeesFromTalent = TALENT_SERVICE.getAllEmployeesFromTalent();
        if (CollectionUtils.isEmpty(allEmployeesFromTalent)) {
            this.LOG.error("get allEmployeesFromTalent is empty!!!");
            return Lists.newArrayList();
        }
        return Lists.newArrayList(allEmployeesFromTalent);
    }

    private List<Map<String, Object>> getInUsingEmpPos(List<Long> employeeIds) {
        String selectProperties = "person,cmpemp,depemp,employee,isexistprobation,endprobation,company,adminorg,apositiontype,position,job,stdposition,isprimary,startdate,enddate";
        QFilter qFilter = new QFilter("employee", "in", employeeIds);
        qFilter.and("iscurrentversion", "=", (Object)"1").and("datastatus", "=", (Object)"1").and("businessstatus", "=", (Object)"1");
        return ExternalDataService.getHrpiCommonInfoByFilter(selectProperties, qFilter, "hrpi_empposorgrel");
    }
}

