/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.util.HRObjectUtils;

public class CastUtils {
    public static <T> List<T> castList(Object obj, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        if (obj instanceof List) {
            for (Object o : (List)obj) {
                result.add(clazz.cast(o));
            }
        }
        return result;
    }

    public static <T> Map<T, Object> castMap(Object obj, Class<T> keyClazz) {
        HashMap maps = new HashMap(16);
        if (obj instanceof Map) {
            Map map = (Map)obj;
            map.forEach((key, val) -> maps.put(keyClazz.cast(key), val));
        }
        return maps;
    }

    public static <T> Set<T> castSet(Object obj, Class<T> clazz) {
        HashSet<T> set = new HashSet<T>();
        if (obj instanceof Set) {
            for (Object o : (Set)obj) {
                set.add(clazz.cast(o));
            }
        }
        return set;
    }

    public static List<Map<String, Object>> castDynamicToMap(DynamicObject[] dynamicObjects) {
        List<DynamicObject> dynamicObjectList = Arrays.asList(dynamicObjects);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(dynamicObjectList.size());
        IDataEntityType dataEntityType = dynamicObjectList.get(0).getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        dynamicObjectList.forEach(dynamicObject -> {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(properties.size());
            for (IDataEntityProperty property : properties) {
                Object propObj = dynamicObject.get(property);
                Object mapValue = propObj instanceof ILocaleString ? ((ILocaleString)propObj).getLocaleValue() : propObj;
                resultMap.put(property.getName(), propObj instanceof DynamicObject ? CastUtils.getBaseDataValue((DynamicObject)propObj) : mapValue);
            }
            resultList.add(resultMap);
        });
        return resultList;
    }

    private static Object getBaseDataValue(DynamicObject baseDataDy) {
        return baseDataDy.getDataEntityType().getProperties().get((Object)"name") == null ? baseDataDy.get("id") : (baseDataDy.get("name") instanceof ILocaleString ? baseDataDy.getLocaleString("name").getLocaleValue() : baseDataDy.get("name"));
    }

    public static Object setDefaultValueIfNullObject(Object obj, Class clz) {
        if (!HRObjectUtils.isEmpty((Object)obj)) {
            return obj;
        }
        if (clz.equals(String.class)) {
            return "";
        }
        if (clz.equals(Long.class)) {
            return 0L;
        }
        if (clz.equals(Integer.class)) {
            return 0;
        }
        if (clz.equals(BigDecimal.class)) {
            return BigDecimal.ZERO;
        }
        if (clz.equals(Boolean.class)) {
            return Boolean.FALSE;
        }
        throw new KDBizException(new ErrorCode("", "class type is not founded for obj to set default value"), new Object[0]);
    }
}

