/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.util;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tdc.cadm.common.bo.TimePeriodBo;

public class DateUtil {
    private static final Log LOG = LogFactory.getLog(DateUtil.class);
    private static final String YYYY_MM_DD = "yyyy-MM-dd";

    public static boolean ifEqualsOneDate(Date dateOne, Date dateTwo) {
        dateOne = DateUtil.toDate(dateOne);
        dateTwo = DateUtil.toDate(dateTwo);
        return dateOne.getTime() == dateTwo.getTime();
    }

    public static boolean dayAfter(Date before, Date after) {
        if (null == before || null == after) {
            return true;
        }
        return DateUtil.toDate(before).after(DateUtil.toDate(after));
    }

    private static Date getExtremumDate(Boolean maxOrMin, Date ... dates) {
        ArrayList dates1 = Lists.newArrayList();
        for (Date date : dates) {
            if (date == null) continue;
            dates1.add(date);
        }
        if (dates1.size() == 0) {
            return null;
        }
        if (maxOrMin.booleanValue()) {
            return (Date)Collections.max(dates1);
        }
        return (Date)Collections.min(dates1);
    }

    public static Map<Date, Date> getTimePeriodsUnion(Boolean mixedOrUnion, List<TimePeriodBo> periods) {
        periods.sort(Comparator.comparing(TimePeriodBo::getBeginTime));
        TreeMap<Date, Date> dateMap = new TreeMap<Date, Date>();
        for (TimePeriodBo period : periods) {
            Date startTime = period.getBeginTime();
            Date endTime = period.getEndTime();
            if (dateMap.size() == 0) {
                dateMap.put(startTime, endTime);
            }
            TreeMap<Date, Date> tempMap = new TreeMap<Date, Date>();
            Iterator iterator = dateMap.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean mixed2;
                Map.Entry entry = iterator.next();
                Date start = (Date)entry.getKey();
                Date end = (Date)entry.getValue();
                boolean mixed1 = startTime.compareTo(end) < 0 && endTime.compareTo(start) > 0;
                boolean bl = mixed2 = start.compareTo(endTime) < 0 && end.compareTo(startTime) > 0;
                if (mixed1 || mixed2) {
                    iterator.remove();
                    if (mixedOrUnion.booleanValue()) {
                        tempMap.put(DateUtil.getExtremumDate(true, startTime, start), DateUtil.getExtremumDate(false, endTime, end));
                        continue;
                    }
                    tempMap.put(DateUtil.getExtremumDate(false, startTime, start), DateUtil.getExtremumDate(true, endTime, end));
                    continue;
                }
                if (iterator.hasNext()) continue;
                tempMap.put(startTime, endTime);
            }
            dateMap.putAll(tempMap);
        }
        return dateMap;
    }

    public static BigDecimal getTotalYear(Map<Date, Date> timePeriodsUnion) {
        AtomicLong days = new AtomicLong(0L);
        timePeriodsUnion.forEach((beginTime, endTime) -> {
            Instant instant = beginTime.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            Instant endInstant = endTime.toInstant();
            ZoneId endZoneId = ZoneId.systemDefault();
            LocalDateTime startLocalDate = instant.atZone(zoneId).toLocalDateTime();
            LocalDateTime endLocalDate = endInstant.atZone(endZoneId).toLocalDateTime();
            days.addAndGet(DateUtil.getDateRange(startLocalDate, endLocalDate));
        });
        BigDecimal bigDecimal = new BigDecimal(days.get());
        return bigDecimal.divide(new BigDecimal(365), 1, RoundingMode.HALF_UP);
    }

    private static Long getDateRange(LocalDateTime startLocalDate, LocalDateTime endLocalDate) {
        Duration between = Duration.between(startLocalDate, endLocalDate);
        return between.toDays();
    }

    private static Date toDate(Date date) {
        String format = HRDateTimeUtils.format((Date)date, (String)YYYY_MM_DD);
        try {
            date = HRDateTimeUtils.parseDate((String)format, (String)YYYY_MM_DD);
        }
        catch (ParseException e) {
            LOG.error(" toDate simpleDateFormat error ", (Throwable)e);
            throw new RuntimeException(e);
        }
        return date;
    }

    public static boolean isToday(Date time) {
        String now;
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
        String param = sdf.format(time);
        return param.equals(now = sdf.format(new Date()));
    }
}

