/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.bussiness.util;

import java.util.Map;

public class UrlBuilder {
    private static final char PARAMETER_PREFIX_SEGMENT = '&';
    private static final char PARAMETER_SUFFIX_SEGMENT = '=';
    private static final String PREFIX_FORM_ID = "/?formId=";
    private final StringBuilder urlStrBuilder;

    public UrlBuilder(String domainContextUrl, String formId) {
        this.urlStrBuilder = new StringBuilder(domainContextUrl.trim());
        this.urlStrBuilder.append(PREFIX_FORM_ID);
        this.urlStrBuilder.append(formId.trim());
    }

    public UrlBuilder setParameter(String parameterKey, String parameterValue) {
        this.urlStrBuilder.append('&');
        this.urlStrBuilder.append(parameterKey.trim());
        this.urlStrBuilder.append('=');
        this.urlStrBuilder.append(parameterValue.trim());
        return this;
    }

    public UrlBuilder setParameter(Map<String, String> params) {
        if (params.isEmpty()) {
            return this;
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            this.urlStrBuilder.append('&');
            this.urlStrBuilder.append(entry.getKey().trim());
            this.urlStrBuilder.append('=');
            this.urlStrBuilder.append(entry.getValue().trim());
        }
        return this;
    }

    public String builder() {
        return this.urlStrBuilder.toString();
    }
}

