/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.common.bo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.tdc.oatr.common.constants.enums.MapAxisValueTypeEnum;
import kd.tdc.oatr.common.constants.enums.MapValidateResultCode;

public class DimValidateResultInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String dimId;
    private long mapId;
    private String axis;
    private MapAxisValueTypeEnum valueType;
    private MapValidateResultCode validateResultCode;
    private boolean isSuccess;

    public String getDimId() {
        return this.dimId;
    }

    public long getMapId() {
        return this.mapId;
    }

    public String getAxis() {
        return this.axis;
    }

    public MapAxisValueTypeEnum getValueType() {
        return this.valueType;
    }

    public MapValidateResultCode getValidateResultCode() {
        return this.validateResultCode;
    }

    public void setDimId(String dimId) {
        this.dimId = dimId;
    }

    public void setMapId(long mapId) {
        this.mapId = mapId;
    }

    public void setAxis(String axis) {
        this.axis = axis;
    }

    public void setValueType(MapAxisValueTypeEnum valueType) {
        this.valueType = valueType;
    }

    public void setValidateResultCode(MapValidateResultCode validateResultCode) {
        this.validateResultCode = validateResultCode;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(boolean success) {
        this.isSuccess = success;
    }

    public static List<DimValidateResultInfo> convertByValidateResult(Map<Long, Map<String, Object>> validateResult) {
        ArrayList<DimValidateResultInfo> dimValidateResultInfoList = new ArrayList<DimValidateResultInfo>(validateResult.size() << 2);
        validateResult.forEach((mapId, dimInfo) -> {
            DimValidateResultInfo xDimInfo = new DimValidateResultInfo();
            xDimInfo.setMapId((long)mapId);
            xDimInfo.setDimId(String.valueOf(dimInfo.get("xDimId")));
            xDimInfo.setAxis("x");
            xDimInfo.setValueType(MapAxisValueTypeEnum.getByCode(String.valueOf(dimInfo.get("xDimValueType"))));
            xDimInfo.setValidateResultCode(MapValidateResultCode.getByCode(String.valueOf(dimInfo.get("xDimResultCode"))));
            xDimInfo.setSuccess((Boolean)dimInfo.get("xDimValidSuccess"));
            dimValidateResultInfoList.add(xDimInfo);
            DimValidateResultInfo yDimInfo = new DimValidateResultInfo();
            yDimInfo.setMapId((long)mapId);
            yDimInfo.setDimId(String.valueOf(dimInfo.get("yDimId")));
            yDimInfo.setAxis("y");
            yDimInfo.setValueType(MapAxisValueTypeEnum.getByCode(String.valueOf(dimInfo.get("yDimValueType"))));
            yDimInfo.setValidateResultCode(MapValidateResultCode.getByCode(String.valueOf(dimInfo.get("yDimResultCode"))));
            yDimInfo.setSuccess((Boolean)dimInfo.get("yDimValidSuccess"));
            dimValidateResultInfoList.add(yDimInfo);
        });
        return dimValidateResultInfoList;
    }
}

